/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class NetworkOutputStream
extends FilterOutputStream {
    boolean closed = false;

    public NetworkOutputStream(OutputStream output) {
        super(output);
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkNotClosed();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkNotClosed();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        this.out.write(b, off, len);
    }

    protected synchronized void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("NetworkOutputStream closed");
        }
    }
}

