/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import junit.framework.TestCase;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.spec.RepeatedSecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class AEADTest
extends SimpleTest {
    private byte[] K2 = Hex.decode("91945D3F4DCBEE0BF45EF52255F095A4");
    private byte[] N2 = Hex.decode("BECAF043B0A23D843194BA972C66DEBD");
    private byte[] A2 = Hex.decode("FA3BFD4806EB53FA");
    private byte[] P2 = Hex.decode("F7FB");
    private byte[] C2 = Hex.decode("19DD5C4C9331049D0BDAB0277408F67967E5");
    private byte[] C2_short = Hex.decode("19DD5C4C9331049D0BDA");
    private byte[] KGCM = Hex.decode("00000000000000000000000000000000");
    private byte[] NGCM = Hex.decode("000000000000000000000000");
    private byte[] CGCM = Hex.decode("58e2fccefa7e3061367f1d57a4e7455a");

    @Override
    public String getName() {
        return "AEAD";
    }

    @Override
    public void performTest() throws Exception {
        boolean aeadAvailable = false;
        try {
            this.getClass().getClassLoader().loadClass("javax.crypto.spec.GCMParameterSpec");
            aeadAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.testAEADParameterSpec(this.K2, this.N2, this.A2, this.P2, this.C2);
        if (aeadAvailable) {
            this.checkCipherWithAD(this.K2, this.N2, this.A2, this.P2, this.C2_short);
            this.testGCMParameterSpec(this.K2, this.N2, this.A2, this.P2, this.C2);
            this.testGCMParameterSpecWithRepeatKey(this.K2, this.N2, this.A2, this.P2, this.C2);
            this.testGCMGeneric(this.KGCM, this.NGCM, new byte[0], new byte[0], this.CGCM);
            this.testGCMParameterSpecWithMultipleUpdates(this.K2, this.N2, this.A2, this.P2, this.C2);
            this.testRepeatedGCMWithSpec(this.KGCM, this.NGCM, this.A2, this.P2, Hex.decode("f4732d84342623f65b7d63c3c335dd44b87d"));
        } else {
            System.err.println("GCM AEADTests disabled due to JDK");
        }
        this.testTampering(aeadAvailable);
    }

    private void testTampering(boolean aeadAvailable) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        block2: {
            Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(new byte[eax.getBlockSize()], eax.getAlgorithm());
            IvParameterSpec iv = new IvParameterSpec(new byte[eax.getBlockSize()]);
            eax.init(1, (Key)key, iv);
            byte[] ciphertext = eax.doFinal(new byte[100]);
            ciphertext[0] = (byte)(ciphertext[0] + 1);
            try {
                eax.init(2, (Key)key, iv);
                eax.doFinal(ciphertext);
                this.fail("Tampered ciphertext should be invalid");
            }
            catch (BadPaddingException e) {
                if (!aeadAvailable || e.getClass().getName().equals("javax.crypto.AEADBadTagException")) break block2;
                this.fail("Tampered AEAD ciphertext should fail with AEADBadTagException when available.");
            }
        }
    }

    private void checkCipherWithAD(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        IvParameterSpec iv = new IvParameterSpec(N);
        eax.init(1, (Key)key, iv);
        eax.updateAAD(A);
        byte[] c = eax.doFinal(P);
        if (!this.areEqual(C2, c)) {
            this.fail("JCE encrypt with additional data failed.");
        }
        eax.init(2, (Key)key, iv);
        eax.updateAAD(A);
        byte[] p = eax.doFinal(C2);
        if (!this.areEqual(P, p)) {
            this.fail("JCE decrypt with additional data failed.");
        }
    }

    private void testAEADParameterSpec(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws Exception {
        Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        AEADParameterSpec spec = new AEADParameterSpec(N, 128, A);
        eax.init(1, (Key)key, spec);
        byte[] c = eax.doFinal(P);
        if (!Arrays.areEqual(C2, c)) {
            TestCase.fail((String)"JCE encrypt with additional data and AEADParameterSpec failed.");
        }
        if (!Arrays.areEqual(C2, c = eax.doFinal(P))) {
            TestCase.fail((String)"JCE encrypt with additional data and AEADParameterSpec failed after do final");
        }
        eax.init(2, (Key)key, spec);
        byte[] p = eax.doFinal(C2);
        if (!Arrays.areEqual(P, p)) {
            TestCase.fail((String)"JCE decrypt with additional data and AEADParameterSpec failed.");
        }
        AlgorithmParameters algParams = eax.getParameters();
        byte[] encParams = algParams.getEncoded();
        GCMParameters gcmParameters = GCMParameters.getInstance(encParams);
        if (!Arrays.areEqual(spec.getIV(), gcmParameters.getNonce()) || spec.getMacSizeInBits() != gcmParameters.getIcvLen() * 8) {
            TestCase.fail((String)"parameters mismatch");
        }
        AEADParameterSpec cSpec = algParams.getParameterSpec(AEADParameterSpec.class);
        if (!Arrays.areEqual(spec.getIV(), cSpec.getNonce()) || spec.getMacSizeInBits() != cSpec.getMacSizeInBits() || cSpec.getAssociatedData() != null) {
            TestCase.fail((String)"parameters mismatch");
        }
        AlgorithmParameters aeadParams = AlgorithmParameters.getInstance("GCM", "BC");
        aeadParams.init(spec);
        cSpec = aeadParams.getParameterSpec(AEADParameterSpec.class);
        if (!Arrays.areEqual(spec.getIV(), cSpec.getNonce()) || spec.getMacSizeInBits() != cSpec.getMacSizeInBits() || cSpec.getAssociatedData() != null) {
            TestCase.fail((String)"parameters mismatch");
        }
    }

    private void testGCMParameterSpec(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException, IOException {
        Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, N);
        eax.init(1, (Key)key, spec);
        eax.updateAAD(A);
        byte[] c = eax.doFinal(P);
        if (!this.areEqual(C2, c)) {
            this.fail("JCE encrypt with additional data and GCMParameterSpec failed.");
        }
        eax.init(2, (Key)key, spec);
        eax.updateAAD(A);
        byte[] p = eax.doFinal(C2);
        if (!this.areEqual(P, p)) {
            this.fail("JCE decrypt with additional data and GCMParameterSpec failed.");
        }
        AlgorithmParameters algParams = eax.getParameters();
        byte[] encParams = algParams.getEncoded();
        GCMParameters gcmParameters = GCMParameters.getInstance(encParams);
        if (!Arrays.areEqual(spec.getIV(), gcmParameters.getNonce()) || spec.getTLen() != gcmParameters.getIcvLen() * 8) {
            this.fail("parameters mismatch");
        }
    }

    private void testGCMParameterSpecWithMultipleUpdates(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws Exception {
        Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        SecureRandom random = new SecureRandom();
        GCMParameterSpec spec = new GCMParameterSpec(128, N);
        int i = 900;
        while (i != 1024) {
            byte[] message = new byte[i];
            random.nextBytes(message);
            eax.init(1, (Key)key, spec);
            byte[] out = new byte[eax.getOutputSize(i)];
            int offSet = 0;
            int count = 0;
            while (count < i / 21) {
                offSet += eax.update(message, count * 21, 21, out, offSet);
                ++count;
            }
            offSet += eax.doFinal(message, count * 21, i - count * 21, out, offSet);
            byte[] dec = new byte[i];
            int len = offSet;
            eax.init(2, (Key)key, spec);
            offSet = 0;
            count = 0;
            while (count < len / 10) {
                offSet += eax.update(out, count * 10, 10, dec, offSet);
                ++count;
            }
            offSet += eax.doFinal(out, count * 10, len - count * 10, dec, offSet);
            if (!Arrays.areEqual(message, dec) || offSet != message.length) {
                this.fail("message mismatch");
            }
            ++i;
        }
    }

    private void testGCMParameterSpecWithRepeatKey(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException, IOException {
        Cipher eax = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, N);
        eax.init(1, (Key)key, spec);
        eax.updateAAD(A);
        byte[] c = eax.doFinal(P);
        if (!this.areEqual(C2, c)) {
            this.fail("JCE encrypt with additional data and RepeatedSecretKeySpec failed.");
        }
        eax.init(2, (Key)new RepeatedSecretKeySpec("AES"), spec);
        eax.updateAAD(A);
        byte[] p = eax.doFinal(C2);
        if (!this.areEqual(P, p)) {
            this.fail("JCE decrypt with additional data and RepeatedSecretKeySpec failed.");
        }
        AlgorithmParameters algParams = eax.getParameters();
        byte[] encParams = algParams.getEncoded();
        GCMParameters gcmParameters = GCMParameters.getInstance(encParams);
        if (!Arrays.areEqual(spec.getIV(), gcmParameters.getNonce()) || spec.getTLen() != gcmParameters.getIcvLen() * 8) {
            this.fail("parameters mismatch");
        }
    }

    private void testGCMGeneric(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException, IOException, InvalidParameterSpecException {
        GCMParameterSpec gcmSpec;
        Cipher eax = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, N);
        eax.init(1, (Key)key, spec);
        eax.updateAAD(A);
        byte[] c = eax.doFinal(P);
        if (!this.areEqual(C2, c)) {
            this.fail("JCE encrypt with additional data and GCMParameterSpec failed.");
        }
        eax = Cipher.getInstance("GCM", "BC");
        eax.init(2, (Key)key, spec);
        eax.updateAAD(A);
        byte[] p = eax.doFinal(C2);
        if (!this.areEqual(P, p)) {
            this.fail("JCE decrypt with additional data and GCMParameterSpec failed.");
        }
        AlgorithmParameters algParams = eax.getParameters();
        byte[] encParams = algParams.getEncoded();
        GCMParameters gcmParameters = GCMParameters.getInstance(encParams);
        if (!Arrays.areEqual(spec.getIV(), gcmParameters.getNonce()) || spec.getTLen() != gcmParameters.getIcvLen() * 8) {
            this.fail("parameters mismatch");
        }
        if (!Arrays.areEqual((gcmSpec = algParams.getParameterSpec(GCMParameterSpec.class)).getIV(), gcmParameters.getNonce()) || gcmSpec.getTLen() != gcmParameters.getIcvLen() * 8) {
            this.fail("spec parameters mismatch");
        }
        if (!Arrays.areEqual(eax.getIV(), gcmParameters.getNonce())) {
            this.fail("iv mismatch");
        }
    }

    private void testRepeatedGCMWithSpec(byte[] K, byte[] N, byte[] A, byte[] P, byte[] C2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException, IOException {
        Cipher eax = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, N);
        eax.init(1, (Key)key, spec);
        eax.updateAAD(A);
        byte[] c = eax.doFinal(P);
        if (!this.areEqual(C2, c)) {
            this.fail("JCE encrypt with additional data and RepeatedSecretKeySpec failed.");
        }
        eax = Cipher.getInstance("GCM", "BC");
        eax.init(2, (Key)key, spec);
        eax.updateAAD(A);
        byte[] p = eax.doFinal(C2);
        if (!this.areEqual(P, p)) {
            this.fail("JCE decrypt with additional data and GCMParameterSpec failed.");
        }
        try {
            eax.init(1, (Key)new RepeatedSecretKeySpec("AES"), spec);
            this.fail("no exception");
        }
        catch (InvalidKeyException e) {
            this.isTrue("wrong message", "cannot reuse nonce for GCM encryption".equals(e.getMessage()));
        }
        try {
            eax.init(1, (Key)new RepeatedSecretKeySpec("AES"), new IvParameterSpec(spec.getIV()));
            this.fail("no exception");
        }
        catch (InvalidKeyException e) {
            this.isTrue("wrong message", "cannot reuse nonce for GCM encryption".equals(e.getMessage()));
        }
        try {
            eax.init(1, (Key)new SecretKeySpec(K, "AES"), new IvParameterSpec(spec.getIV()));
            this.fail("no exception");
        }
        catch (InvalidKeyException e) {
            this.isTrue("wrong message", "cannot reuse nonce for GCM encryption".equals(e.getMessage()));
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        AEADTest.runTest(new AEADTest());
    }
}

