/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nsri.NSRIObjectIdentifiers;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.BaseBlockCipherTest;
import org.bouncycastle.util.encoders.Hex;

public class ARIATest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "d718fbd6ab644c739da95f3be6451778", "192", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "26449c1805dbe7aa25a468ce263a9e79", "256", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "f92bd7c79fb72e2f2b8f80c1972d24fc"};

    public ARIATest() {
        super("ARIA");
    }

    private void test(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "ARIA");
        Cipher in = Cipher.getInstance("ARIA/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("ARIA/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("ARIA failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("ARIA failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("ARIA failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("ARIA failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("ARIA failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("ARIA failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    private void eaxTest() throws Exception {
        byte[] K = Hex.decode("233952DEE4D5ED5F9B9C6D6FF80FF478");
        byte[] N = Hex.decode("62EC67F9C3A4A407FCB2A8C49031A8B3");
        byte[] P = Hex.decode("68656c6c6f20776f726c642121");
        byte[] C2 = Hex.decode("85fe63d6cfb872d2420e65425c074dfad6fe752e03");
        SecretKeySpec key = new SecretKeySpec(K, "ARIA");
        Cipher in = Cipher.getInstance("ARIA/EAX/NoPadding", "BC");
        Cipher out = Cipher.getInstance("ARIA/EAX/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in EAX: " + Hex.toHexString(enc));
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in EAX");
        }
        try {
            in = Cipher.getInstance("ARIA/EAX/PKCS5Padding", "BC");
            this.fail("bad padding missed in EAX");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    private void ccmTest() throws Exception {
        byte[] K = Hex.decode("404142434445464748494a4b4c4d4e4f");
        byte[] N = Hex.decode("10111213141516");
        byte[] P = Hex.decode("68656c6c6f20776f726c642121");
        byte[] C2 = Hex.decode("0af625ff69cd9dbe65fae181d654717eb7a0263bcd");
        SecretKeySpec key = new SecretKeySpec(K, "ARIA");
        Cipher in = Cipher.getInstance("ARIA/CCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("ARIA/CCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in CCM: " + Hex.toHexString(enc));
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in CCM");
        }
        try {
            in = Cipher.getInstance("ARIA/CCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in CCM");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    private void gcmTest() throws Exception {
        byte[] K = Hex.decode("feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308");
        byte[] P = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255");
        byte[] N = Hex.decode("cafebabefacedbaddecaf888");
        String T = "c8f245c8619ca9ba7d6d9545e7f48214";
        byte[] C2 = Hex.decode("c3aa0e01a4f8b5dfdb25d0f1c78c275e516114080e2be7a7f7bffd4504b19a8552f80ad5b55f3d911725489629996d398d5ed6f077e22924c5b8ebe20a219693" + T);
        SecretKeySpec key = new SecretKeySpec(K, "ARIA");
        Cipher in = Cipher.getInstance("ARIA/GCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("ARIA/GCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in GCM: " + Hex.toHexString(enc));
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in GCM");
        }
        try {
            in = Cipher.getInstance("ARIA/GCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in GCM");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    private void ocbTest() throws Exception {
        byte[] K = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] P = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] N = Hex.decode("000102030405060708090A0B");
        String T = "0027ce4f3aaeec75";
        byte[] C2 = Hex.decode("7bcae9eac9f1f54704a630e309099a87f53a1c1559de1b3b" + T);
        SecretKeySpec key = new SecretKeySpec(K, "ARIA");
        Cipher in = Cipher.getInstance("ARIA/OCB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("ARIA/OCB/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in OCB: " + Hex.toHexString(enc));
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in OCB");
        }
        try {
            in = Cipher.getInstance("ARIA/OCB/PKCS5Padding", "BC");
            this.fail("bad padding missed in OCB");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    @Override
    public void performTest() throws Exception {
        int i = 0;
        while (i != cipherTests.length) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
            i += 4;
        }
        byte[] kek1 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] in1 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] out1 = Hex.decode("a93f148d4909d85f1aae656909879275ae597b3acf9d60db");
        this.wrapTest(1, "ARIAWrap", kek1, in1, out1);
        byte[] kek2 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] in2 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] out2 = Hex.decode("9b2d3cac0acf9d4bde7c1bdb0313fbef931f025acc77bf57d3d1cabc88b514d0");
        this.wrapTest(2, "ARIARFC3211WRAP", kek2, kek2, new FixedSecureRandom(Hex.decode("9688df2af1b7b1ac9688df2a")), in2, out2);
        byte[] kek3 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] in3 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] out3 = Hex.decode("ac0e22699a036ced63adeb75f4946f82dc98ad8af43b24d5");
        this.wrapTest(3, "ARIAWrapPad", kek3, in3, out3);
        String[] oids = new String[]{NSRIObjectIdentifiers.id_aria128_ecb.getId(), NSRIObjectIdentifiers.id_aria128_cbc.getId(), NSRIObjectIdentifiers.id_aria128_ofb.getId(), NSRIObjectIdentifiers.id_aria128_cfb.getId(), NSRIObjectIdentifiers.id_aria192_ecb.getId(), NSRIObjectIdentifiers.id_aria192_cbc.getId(), NSRIObjectIdentifiers.id_aria192_ofb.getId(), NSRIObjectIdentifiers.id_aria192_cfb.getId(), NSRIObjectIdentifiers.id_aria256_ecb.getId(), NSRIObjectIdentifiers.id_aria256_cbc.getId(), NSRIObjectIdentifiers.id_aria256_ofb.getId(), NSRIObjectIdentifiers.id_aria256_cfb.getId()};
        String[] names = new String[]{"ARIA/ECB/PKCS7Padding", "ARIA/CBC/PKCS7Padding", "ARIA/OFB/NoPadding", "ARIA/CFB/NoPadding", "ARIA/ECB/PKCS7Padding", "ARIA/CBC/PKCS7Padding", "ARIA/OFB/NoPadding", "ARIA/CFB/NoPadding", "ARIA/ECB/PKCS7Padding", "ARIA/CBC/PKCS7Padding", "ARIA/OFB/NoPadding", "ARIA/CFB/NoPadding"};
        this.oidTest(oids, names, 4);
        String[] wrapOids = new String[]{NSRIObjectIdentifiers.id_aria128_kw.getId(), NSRIObjectIdentifiers.id_aria192_kw.getId(), NSRIObjectIdentifiers.id_aria256_kw.getId()};
        this.wrapOidTest(wrapOids, "ARIAWrap");
        wrapOids = new String[]{NSRIObjectIdentifiers.id_aria128_kwp.getId(), NSRIObjectIdentifiers.id_aria192_kwp.getId(), NSRIObjectIdentifiers.id_aria256_kwp.getId()};
        this.wrapOidTest(wrapOids, "ARIAWrapPad");
        this.eaxTest();
        this.ccmTest();
        this.gcmTest();
        this.ocbTest();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        ARIATest.runTest(new ARIATest());
    }
}

