/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST3412Test
extends SimpleTest {
    @Override
    public String getName() {
        return "GOST3412";
    }

    public void testECB(byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "GOST3412-2015");
        Cipher in = Cipher.getInstance("GOST3412-2015/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("GOST3412-2015/ECB/NoPadding", "BC");
        out.init(1, key);
        in.init(2, key);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        int i = 0;
        while (i != input.length / 2) {
            cOut.write(input[i]);
            ++i;
        }
        cOut.write(input, input.length / 2, input.length - input.length / 2);
        cOut.close();
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("GOST3412-2015 failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        DataInputStream dIn = new DataInputStream(cIn);
        bytes = new byte[input.length];
        int i2 = 0;
        while (i2 != input.length / 2) {
            bytes[i2] = (byte)dIn.read();
            ++i2;
        }
        dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        if (!this.areEqual(bytes, input)) {
            this.fail("GOST3412-2015 failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    public void testCFB(byte[] keyBytes, byte[] iv, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "GOST3412-2015");
        Cipher in = Cipher.getInstance("GOST3412-2015/CFB8/NoPadding", "BC");
        Cipher out = Cipher.getInstance("GOST3412-2015/CFB8/NoPadding", "BC");
        out.init(1, (Key)key, new IvParameterSpec(iv));
        in.init(2, (Key)key, new IvParameterSpec(iv));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        int i = 0;
        while (i != input.length / 2) {
            cOut.write(input[i]);
            ++i;
        }
        cOut.write(input, input.length / 2, input.length - input.length / 2);
        cOut.close();
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("GOST3412-2015 failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        DataInputStream dIn = new DataInputStream(cIn);
        bytes = new byte[input.length];
        int i2 = 0;
        while (i2 != input.length / 2) {
            bytes[i2] = (byte)dIn.read();
            ++i2;
        }
        dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        if (!this.areEqual(bytes, input)) {
            this.fail("GOST3412-2015 failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    @Override
    public void performTest() throws Exception {
        this.testECB(Hex.decode("8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef"), Hex.decode("1122334455667700ffeeddccbbaa9988"), Hex.decode("7f679d90bebc24305a468d42b9d4edcd"));
        this.testCFB(Hex.decode("8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef"), Hex.decode("1234567890abcef0a1b2c3d4e5f0011223344556677889901213141516171819"), Hex.decode("1122334455667700ffeeddccbbaa998800112233445566778899aabbcceeff0a112233445566778899aabbcceeff0a002233445566778899aabbcceeff0a0011"), Hex.decode("819b19c5867e61f1cf1b16f664f66e46ed8fcb82b1110b1e7ec03bfa6611f2eabd7a32363691cbdc3bbe403bc80552d822c2cdf483981cd71d5595453d7f057d"));
        byte[][] inputs = new byte[][]{Hex.decode("1122334455667700ffeeddccbbaa9988"), Hex.decode("00112233445566778899aabbcceeff0a"), Hex.decode("112233445566778899aabbcceeff0a00"), Hex.decode("2233445566778899aabbcceeff0a0011")};
        Mac mac = Mac.getInstance("GOST3412MAC", "BC");
        mac.init(new SecretKeySpec(Hex.decode("8899aabbccddeeff0011223344556677fedcba98765432100123456789abcdef"), "GOST3412MAC"));
        int i = 0;
        while (i != inputs.length) {
            mac.update(inputs[i]);
            ++i;
        }
        if (!Arrays.areEqual(Hex.decode("336f4d296059fbe34ddeb35b37749c67"), mac.doFinal())) {
            this.fail("mac test failed.");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        GOST3412Test.runTest(new GOST3412Test());
    }
}

