/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceFujisakiCipher;
import org.bouncycastle.util.test.SimpleTest;

public class McElieceFujisakiCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    @Override
    public String getName() {
        return "McElieceFujisaki";
    }

    @Override
    public void performTest() throws InvalidCipherTextException {
        int numPassesKPG = 1;
        int numPassesEncDec = 10;
        Random rand = new Random();
        int j = 0;
        while (j < numPassesKPG) {
            McElieceCCA2Parameters params = new McElieceCCA2Parameters();
            McElieceCCA2KeyPairGenerator mcElieceCCA2KeyGen = new McElieceCCA2KeyPairGenerator();
            McElieceCCA2KeyGenerationParameters genParam = new McElieceCCA2KeyGenerationParameters(this.keyRandom, params);
            mcElieceCCA2KeyGen.init(genParam);
            AsymmetricCipherKeyPair pair = mcElieceCCA2KeyGen.generateKeyPair();
            ParametersWithRandom param = new ParametersWithRandom(pair.getPublic(), this.keyRandom);
            SHA256Digest msgDigest = new SHA256Digest();
            McElieceFujisakiCipher mcElieceFujisakiDigestCipher = new McElieceFujisakiCipher();
            int k = 1;
            while (k <= numPassesEncDec) {
                System.out.println("############### test: " + k);
                mcElieceFujisakiDigestCipher.init(true, param);
                int mLength = (rand.nextInt() & 0x1F) + 1;
                byte[] mBytes = new byte[mLength];
                rand.nextBytes(mBytes);
                msgDigest.update(mBytes, 0, mBytes.length);
                byte[] hash = new byte[msgDigest.getDigestSize()];
                msgDigest.doFinal(hash, 0);
                byte[] enc = mcElieceFujisakiDigestCipher.messageEncrypt(hash);
                mcElieceFujisakiDigestCipher.init(false, pair.getPrivate());
                byte[] constructedmessage = mcElieceFujisakiDigestCipher.messageDecrypt(enc);
                boolean verified = true;
                int i = 0;
                while (i < hash.length) {
                    verified = verified && hash[i] == constructedmessage[i];
                    ++i;
                }
                if (!verified) {
                    this.fail("en/decryption fails");
                } else {
                    System.out.println("test okay");
                    System.out.println();
                }
                ++k;
            }
            ++j;
        }
    }

    public static void main(String[] args) {
        McElieceFujisakiCipherTest.runTest(new McElieceFujisakiCipherTest());
    }
}

