/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64;
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    static {
        int[] nArray = new int[384];
        nArray[64] = 1;
        nArray[65] = 1;
        nArray[66] = 1;
        nArray[67] = 1;
        nArray[68] = 1;
        nArray[69] = 1;
        nArray[70] = 1;
        nArray[71] = 1;
        nArray[72] = 1;
        nArray[73] = 1;
        nArray[74] = 1;
        nArray[75] = 1;
        nArray[76] = 1;
        nArray[77] = 1;
        nArray[78] = 1;
        nArray[79] = 1;
        nArray[80] = 1;
        nArray[81] = 1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[86] = 1;
        nArray[87] = 1;
        nArray[88] = 1;
        nArray[89] = 1;
        nArray[90] = 1;
        nArray[91] = 1;
        nArray[92] = 1;
        nArray[93] = 1;
        nArray[94] = 1;
        nArray[95] = 1;
        nArray[96] = 1;
        nArray[97] = 1;
        nArray[98] = 1;
        nArray[99] = 1;
        nArray[100] = 1;
        nArray[101] = 1;
        nArray[102] = 1;
        nArray[103] = 1;
        nArray[104] = 1;
        nArray[105] = 1;
        nArray[106] = 1;
        nArray[107] = 1;
        nArray[108] = 1;
        nArray[109] = 1;
        nArray[110] = 1;
        nArray[111] = 1;
        nArray[112] = 1;
        nArray[113] = 1;
        nArray[114] = 1;
        nArray[115] = 1;
        nArray[116] = 1;
        nArray[117] = 1;
        nArray[118] = 1;
        nArray[119] = 1;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        nArray[123] = 1;
        nArray[124] = 1;
        nArray[125] = 1;
        nArray[126] = 1;
        nArray[127] = 1;
        nArray[128] = 2;
        nArray[129] = 2;
        nArray[130] = 2;
        nArray[131] = 2;
        nArray[132] = 2;
        nArray[133] = 2;
        nArray[134] = 2;
        nArray[135] = 2;
        nArray[136] = 2;
        nArray[137] = 2;
        nArray[138] = 2;
        nArray[139] = 2;
        nArray[140] = 2;
        nArray[141] = 2;
        nArray[142] = 2;
        nArray[143] = 2;
        nArray[144] = 2;
        nArray[145] = 2;
        nArray[146] = 2;
        nArray[147] = 2;
        nArray[148] = 2;
        nArray[149] = 2;
        nArray[150] = 2;
        nArray[151] = 2;
        nArray[152] = 2;
        nArray[153] = 2;
        nArray[154] = 2;
        nArray[155] = 2;
        nArray[156] = 2;
        nArray[157] = 2;
        nArray[158] = 2;
        nArray[159] = 2;
        nArray[160] = 2;
        nArray[161] = 2;
        nArray[162] = 2;
        nArray[163] = 2;
        nArray[164] = 2;
        nArray[165] = 2;
        nArray[166] = 2;
        nArray[167] = 2;
        nArray[168] = 2;
        nArray[169] = 2;
        nArray[170] = 2;
        nArray[171] = 2;
        nArray[172] = 2;
        nArray[173] = 2;
        nArray[174] = 2;
        nArray[175] = 2;
        nArray[176] = 2;
        nArray[177] = 2;
        nArray[178] = 2;
        nArray[179] = 2;
        nArray[180] = 2;
        nArray[181] = 2;
        nArray[182] = 2;
        nArray[183] = 2;
        nArray[184] = 2;
        nArray[185] = 2;
        nArray[186] = 2;
        nArray[187] = 2;
        nArray[188] = 2;
        nArray[189] = 2;
        nArray[190] = 2;
        nArray[191] = 2;
        nArray[192] = 3;
        nArray[193] = 3;
        nArray[194] = 3;
        nArray[195] = 3;
        nArray[196] = 3;
        nArray[197] = 3;
        nArray[198] = 3;
        nArray[199] = 3;
        nArray[200] = 3;
        nArray[201] = 3;
        nArray[202] = 3;
        nArray[203] = 3;
        nArray[204] = 3;
        nArray[205] = 3;
        nArray[206] = 3;
        nArray[207] = 3;
        nArray[208] = 3;
        nArray[209] = 3;
        nArray[210] = 3;
        nArray[211] = 3;
        nArray[212] = 3;
        nArray[213] = 3;
        nArray[214] = 3;
        nArray[215] = 3;
        nArray[216] = 3;
        nArray[217] = 3;
        nArray[218] = 3;
        nArray[219] = 3;
        nArray[220] = 3;
        nArray[221] = 3;
        nArray[222] = 3;
        nArray[223] = 3;
        nArray[224] = 3;
        nArray[225] = 3;
        nArray[226] = 3;
        nArray[227] = 3;
        nArray[228] = 3;
        nArray[229] = 3;
        nArray[230] = 3;
        nArray[231] = 3;
        nArray[232] = 3;
        nArray[233] = 3;
        nArray[234] = 3;
        nArray[235] = 3;
        nArray[236] = 3;
        nArray[237] = 3;
        nArray[238] = 3;
        nArray[239] = 3;
        nArray[240] = 3;
        nArray[241] = 3;
        nArray[242] = 3;
        nArray[243] = 3;
        nArray[244] = 3;
        nArray[245] = 3;
        nArray[246] = 3;
        nArray[247] = 3;
        nArray[248] = 3;
        nArray[249] = 3;
        nArray[250] = 3;
        nArray[251] = 3;
        nArray[252] = 3;
        nArray[253] = 3;
        nArray[254] = 3;
        nArray[255] = 3;
        nArray[256] = 4;
        nArray[257] = 4;
        nArray[258] = 4;
        nArray[259] = 4;
        nArray[260] = 4;
        nArray[261] = 4;
        nArray[262] = 4;
        nArray[263] = 4;
        nArray[264] = 4;
        nArray[265] = 4;
        nArray[266] = 4;
        nArray[267] = 4;
        nArray[268] = 4;
        nArray[269] = 4;
        nArray[270] = 4;
        nArray[271] = 4;
        nArray[272] = 4;
        nArray[273] = 4;
        nArray[274] = 4;
        nArray[275] = 4;
        nArray[276] = 4;
        nArray[277] = 4;
        nArray[278] = 4;
        nArray[279] = 4;
        nArray[280] = 4;
        nArray[281] = 4;
        nArray[282] = 4;
        nArray[283] = 4;
        nArray[284] = 4;
        nArray[285] = 4;
        nArray[286] = 4;
        nArray[287] = 4;
        nArray[288] = 4;
        nArray[289] = 4;
        nArray[290] = 4;
        nArray[291] = 4;
        nArray[292] = 4;
        nArray[293] = 4;
        nArray[294] = 4;
        nArray[295] = 4;
        nArray[296] = 4;
        nArray[297] = 4;
        nArray[298] = 4;
        nArray[299] = 4;
        nArray[300] = 4;
        nArray[301] = 4;
        nArray[302] = 4;
        nArray[303] = 4;
        nArray[304] = 4;
        nArray[305] = 4;
        nArray[306] = 4;
        nArray[307] = 4;
        nArray[308] = 4;
        nArray[309] = 4;
        nArray[310] = 4;
        nArray[311] = 4;
        nArray[312] = 4;
        nArray[313] = 4;
        nArray[314] = 4;
        nArray[315] = 4;
        nArray[316] = 4;
        nArray[317] = 4;
        nArray[318] = 4;
        nArray[319] = 4;
        nArray[320] = 5;
        nArray[321] = 5;
        nArray[322] = 5;
        nArray[323] = 5;
        nArray[324] = 5;
        nArray[325] = 5;
        nArray[326] = 5;
        nArray[327] = 5;
        nArray[328] = 5;
        nArray[329] = 5;
        nArray[330] = 5;
        nArray[331] = 5;
        nArray[332] = 5;
        nArray[333] = 5;
        nArray[334] = 5;
        nArray[335] = 5;
        nArray[336] = 5;
        nArray[337] = 5;
        nArray[338] = 5;
        nArray[339] = 5;
        nArray[340] = 5;
        nArray[341] = 5;
        nArray[342] = 5;
        nArray[343] = 5;
        nArray[344] = 5;
        nArray[345] = 5;
        nArray[346] = 5;
        nArray[347] = 5;
        nArray[348] = 5;
        nArray[349] = 5;
        nArray[350] = 5;
        nArray[351] = 5;
        nArray[352] = 5;
        nArray[353] = 5;
        nArray[354] = 5;
        nArray[355] = 5;
        nArray[356] = 5;
        nArray[357] = 5;
        nArray[358] = 5;
        nArray[359] = 5;
        nArray[360] = 5;
        nArray[361] = 5;
        nArray[362] = 5;
        nArray[363] = 5;
        nArray[364] = 5;
        nArray[365] = 5;
        nArray[366] = 5;
        nArray[367] = 5;
        nArray[368] = 5;
        nArray[369] = 5;
        nArray[370] = 5;
        nArray[371] = 5;
        nArray[372] = 5;
        nArray[373] = 5;
        nArray[374] = 5;
        nArray[375] = 5;
        nArray[376] = 5;
        nArray[377] = 5;
        nArray[378] = 5;
        nArray[379] = 5;
        nArray[380] = 5;
        nArray[381] = 5;
        nArray[382] = 5;
        nArray[383] = 5;
        mIBY64 = nArray;
    }

    public GF2nONBElement(GF2nONBField gf2n, SecureRandom rand) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            int j = 0;
            while (j < this.mLength - 1) {
                this.mPol[j] = rand.nextLong();
                ++j;
            }
            long last = rand.nextLong();
            this.mPol[this.mLength - 1] = last >>> 64 - this.mBit;
        } else {
            this.mPol[0] = rand.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gf2n, byte[] e) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(e);
    }

    public GF2nONBElement(GF2nONBField gf2n, BigInteger val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(val);
    }

    private GF2nONBElement(GF2nONBField gf2n, long[] val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = val;
    }

    public GF2nONBElement(GF2nONBElement gf2n) {
        this.mField = gf2n.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gf2n.getElement());
    }

    @Override
    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gf2n) {
        long[] polynomial = new long[gf2n.getONBLength()];
        return new GF2nONBElement(gf2n, polynomial);
    }

    public static GF2nONBElement ONE(GF2nONBField gf2n) {
        int mLength = gf2n.getONBLength();
        long[] polynomial = new long[mLength];
        int i = 0;
        while (i < mLength - 1) {
            polynomial[i] = -1L;
            ++i;
        }
        polynomial[mLength - 1] = mMaxmask[gf2n.getONBBit() - 1];
        return new GF2nONBElement(gf2n, polynomial);
    }

    @Override
    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    @Override
    void assignOne() {
        int i = 0;
        while (i < this.mLength - 1) {
            this.mPol[i] = -1L;
            ++i;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(BigInteger val) {
        this.assign(val.toByteArray());
    }

    private void assign(long[] val) {
        System.arraycopy(val, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] val) {
        this.mPol = new long[this.mLength];
        int j = 0;
        while (j < val.length) {
            int n = j >>> 3;
            this.mPol[n] = this.mPol[n] | ((long)val[val.length - 1 - j] & 0xFFL) << ((j & 7) << 3);
            ++j;
        }
    }

    @Override
    public boolean isZero() {
        boolean result = true;
        int i = 0;
        while (i < this.mLength && result) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == 0L;
            ++i;
        }
        return result;
    }

    @Override
    public boolean isOne() {
        boolean result = true;
        int i = 0;
        while (i < this.mLength - 1 && result) {
            result = result && (this.mPol[i] & 0xFFFFFFFFFFFFFFFFL) == -1L;
            ++i;
        }
        if (result) {
            result = result && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement otherElem = (GF2nONBElement)other;
        int i = 0;
        while (i < this.mLength) {
            if (this.mPol[i] != otherElem.mPol[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.mPol.hashCode();
    }

    @Override
    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    @Override
    boolean testBit(int index) {
        if (index < 0 || index > this.mDegree) {
            return false;
        }
        long test = this.mPol[index >>> 6] & mBitmask[index & 0x3F];
        return test != 0L;
    }

    private long[] getElement() {
        long[] result = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, result, 0, this.mPol.length);
        return result;
    }

    private long[] getElementReverseOrder() {
        long[] result = new long[this.mPol.length];
        int i = 0;
        while (i < this.mDegree) {
            if (this.testBit(this.mDegree - i - 1)) {
                int n = i >>> 6;
                result[n] = result[n] | mBitmask[i & 0x3F];
            }
            ++i;
        }
        return result;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    @Override
    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.addToThis(addend);
        return result;
    }

    @Override
    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)addend).mField)) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < this.mLength) {
            int n = i;
            this.mPol[n] = this.mPol[n] ^ ((GF2nONBElement)addend).mPol[i];
            ++i;
        }
    }

    @Override
    public GF2nElement increase() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.increaseThis();
        return result;
    }

    @Override
    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    @Override
    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    @Override
    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
        } else {
            long[] a = this.mPol;
            long[] b = ((GF2nONBElement)factor).mPol;
            long[] c = new long[this.mLength];
            int[][] m = ((GF2nONBField)this.mField).mMult;
            int degf = this.mLength - 1;
            int degb = this.mBit - 1;
            boolean s = false;
            long TWOTOMAXLONGM1 = mBitmask[63];
            long TWOTODEGB = mBitmask[degb];
            int k = 0;
            while (k < this.mDegree) {
                boolean old;
                int bita;
                int fielda;
                s = false;
                int i = 0;
                while (i < this.mDegree) {
                    fielda = mIBY64[i];
                    bita = i & 0x3F;
                    int fieldb = mIBY64[m[i][0]];
                    int bitb = m[i][0] & 0x3F;
                    if ((a[fielda] & mBitmask[bita]) != 0L) {
                        if ((b[fieldb] & mBitmask[bitb]) != 0L) {
                            s ^= true;
                        }
                        if (m[i][1] != -1 && (b[fieldb = mIBY64[m[i][1]]] & mBitmask[bitb = m[i][1] & 0x3F]) != 0L) {
                            s ^= true;
                        }
                    }
                    ++i;
                }
                fielda = mIBY64[k];
                bita = k & 0x3F;
                if (s) {
                    int n = fielda;
                    c[n] = c[n] ^ mBitmask[bita];
                }
                if (this.mLength > 1) {
                    boolean now;
                    old = (a[degf] & 1L) == 1L;
                    i = degf - 1;
                    while (i >= 0) {
                        now = (a[i] & 1L) != 0L;
                        a[i] = a[i] >>> 1;
                        if (old) {
                            int n = i;
                            a[n] = a[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                        --i;
                    }
                    a[degf] = a[degf] >>> 1;
                    if (old) {
                        int n = degf;
                        a[n] = a[n] ^ TWOTODEGB;
                    }
                    old = (b[degf] & 1L) == 1L;
                    i = degf - 1;
                    while (i >= 0) {
                        now = (b[i] & 1L) != 0L;
                        b[i] = b[i] >>> 1;
                        if (old) {
                            int n = i;
                            b[n] = b[n] ^ TWOTOMAXLONGM1;
                        }
                        old = now;
                        --i;
                    }
                    b[degf] = b[degf] >>> 1;
                    if (old) {
                        int n = degf;
                        b[n] = b[n] ^ TWOTODEGB;
                    }
                } else {
                    old = (a[0] & 1L) == 1L;
                    a[0] = a[0] >>> 1;
                    if (old) {
                        a[0] = a[0] ^ TWOTODEGB;
                    }
                    old = (b[0] & 1L) == 1L;
                    b[0] = b[0] >>> 1;
                    if (old) {
                        b[0] = b[0] ^ TWOTODEGB;
                    }
                }
                ++k;
            }
            this.assign(c);
        }
    }

    @Override
    public GF2nElement square() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareThis();
        return result;
    }

    @Override
    public void squareThis() {
        boolean now;
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[f] & mBitmask[b]) != 0L;
        int i = 0;
        while (i < f) {
            now = (pol[i] & TWOTOMAXLONGM1) != 0L;
            pol[i] = pol[i] << 1;
            if (old) {
                int n = i;
                pol[n] = pol[n] ^ 1L;
            }
            old = now;
            ++i;
        }
        now = (pol[f] & mBitmask[b]) != 0L;
        pol[f] = pol[f] << 1;
        if (old) {
            int n = f;
            pol[n] = pol[n] ^ 1L;
        }
        if (now) {
            int n = f;
            pol[n] = pol[n] ^ mBitmask[b + 1];
        }
        this.assign(pol);
    }

    @Override
    public GFElement invert() throws ArithmeticException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.invertThis();
        return result;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int r2 = 31;
        boolean found = false;
        while (!found && r2 >= 0) {
            if (((long)(this.mDegree - 1) & mBitmask[r2]) != 0L) {
                found = true;
            }
            --r2;
        }
        GF2nElement m = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement n = new GF2nONBElement(this);
        int k = 1;
        int i = ++r2 - 1;
        while (i >= 0) {
            m = (GF2nElement)((GF2nElement)n).clone();
            int j = 1;
            while (j <= k) {
                m.squareThis();
                ++j;
            }
            n.multiplyThisBy(m);
            k <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[i]) != 0L) {
                ((GF2nElement)n).squareThis();
                n.multiplyThisBy(this);
                ++k;
            }
            --i;
        }
        ((GF2nElement)n).squareThis();
    }

    @Override
    public GF2nElement squareRoot() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareRootThis();
        return result;
    }

    @Override
    public void squareRootThis() {
        long[] pol = this.getElement();
        int f = this.mLength - 1;
        int b = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[0] & 1L) != 0L;
        int i = f;
        while (i >= 0) {
            boolean now = (pol[i] & 1L) != 0L;
            pol[i] = pol[i] >>> 1;
            if (old) {
                if (i == f) {
                    int n = i;
                    pol[n] = pol[n] ^ mBitmask[b];
                } else {
                    int n = i;
                    pol[n] = pol[n] ^ TWOTOMAXLONGM1;
                }
            }
            old = now;
            --i;
        }
        this.assign(pol);
    }

    @Override
    public int trace() {
        int j;
        int result = 0;
        int max = this.mLength - 1;
        int i = 0;
        while (i < max) {
            j = 0;
            while (j < 64) {
                if ((this.mPol[i] & mBitmask[j]) != 0L) {
                    result ^= 1;
                }
                ++j;
            }
            ++i;
        }
        int b = this.mBit;
        j = 0;
        while (j < b) {
            if ((this.mPol[max] & mBitmask[j]) != 0L) {
                result ^= 1;
            }
            ++j;
        }
        return result;
    }

    @Override
    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long TWOTOMAXLONGM1 = mBitmask[63];
        long ZERO = 0L;
        long ONE = 1L;
        long[] p = new long[this.mLength];
        long z = 0L;
        int j = 1;
        int i = 0;
        while (i < this.mLength - 1) {
            j = 1;
            while (j < 64) {
                if (!((mBitmask[j] & this.mPol[i]) != ZERO && (z & mBitmask[j - 1]) != ZERO || (this.mPol[i] & mBitmask[j]) == ZERO && (z & mBitmask[j - 1]) == ZERO)) {
                    z ^= mBitmask[j];
                }
                ++j;
            }
            p[i] = z;
            z = (TWOTOMAXLONGM1 & z) != ZERO && (ONE & this.mPol[i + 1]) == ONE || (TWOTOMAXLONGM1 & z) == ZERO && (ONE & this.mPol[i + 1]) == ZERO ? ZERO : ONE;
            ++i;
        }
        int b = this.mDegree & 0x3F;
        long LASTLONG = this.mPol[this.mLength - 1];
        j = 1;
        while (j < b) {
            if (!((mBitmask[j] & LASTLONG) != ZERO && (mBitmask[j - 1] & z) != ZERO || (mBitmask[j] & LASTLONG) == ZERO && (mBitmask[j - 1] & z) == ZERO)) {
                z ^= mBitmask[j];
            }
            ++j;
        }
        p[this.mLength - 1] = z;
        return new GF2nONBElement((GF2nONBField)this.mField, p);
    }

    @Override
    public String toString() {
        return this.toString(16);
    }

    @Override
    public String toString(int radix) {
        String s;
        block5: {
            long[] a;
            block4: {
                s = "";
                a = this.getElement();
                int b = this.mBit;
                if (radix != 2) break block4;
                int j = b - 1;
                while (j >= 0) {
                    s = (a[a.length - 1] & 1L << j) == 0L ? String.valueOf(s) + "0" : String.valueOf(s) + "1";
                    --j;
                }
                int i = a.length - 2;
                while (i >= 0) {
                    int j2 = 63;
                    while (j2 >= 0) {
                        s = (a[i] & mBitmask[j2]) == 0L ? String.valueOf(s) + "0" : String.valueOf(s) + "1";
                        --j2;
                    }
                    --i;
                }
                break block5;
            }
            if (radix != 16) break block5;
            char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            int i = a.length - 1;
            while (i >= 0) {
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 60) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 56) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 52) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 48) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 44) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 40) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 36) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 32) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 28) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 24) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 20) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 16) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 12) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 8) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)(a[i] >>> 4) & 0xF];
                s = String.valueOf(s) + HEX_CHARS[(int)a[i] & 0xF];
                s = String.valueOf(s) + " ";
                --i;
            }
        }
        return s;
    }

    @Override
    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        int k = (this.mDegree - 1 >> 3) + 1;
        byte[] result = new byte[k];
        int i = 0;
        while (i < k) {
            result[k - i - 1] = (byte)((this.mPol[i >>> 3] & 255L << ((i & 7) << 3)) >>> ((i & 7) << 3));
            ++i;
        }
        return result;
    }
}

