﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
        public struct IDCardData
        {
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
            public string Name; //姓名   
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
            public string Sex;   //性别
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
            public string Nation; //名族
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 18)]
            public string Born; //出生日期
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 72)]
            public string Address; //住址
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 38)]
            public string IDCardNo; //身份证号
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
            public string GrantDept; //发证机关
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 18)]
            public string UserLifeBegin; // 有效开始日期
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 18)]
            public string UserLifeEnd;  // 有效截止日期
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 38)]
            public string reserved; // 保留
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 255)]
            public string PhotoFileName; // 照片路径
        }
        /************************端口类API *************************/
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_GetCOMBaud", CharSet = CharSet.Ansi)]
        public static extern int Syn_GetCOMBaud(int iComID, ref uint puiBaud);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_SetCOMBaud", CharSet = CharSet.Ansi)]
        public static extern int Syn_SetCOMBaud(int iComID, uint uiCurrBaud, uint uiSetBaud);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_OpenPort", CharSet = CharSet.Ansi)]
        public static extern int Syn_OpenPort(int iPortID);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_ClosePort", CharSet = CharSet.Ansi)]
        public static extern int Syn_ClosePort(int iPortID);

        /************************ SAM类API *************************/
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_GetSAMStatus", CharSet = CharSet.Ansi)]
        public static extern int Syn_GetSAMStatus(int iPortID, int iIfOpen);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_ResetSAM", CharSet = CharSet.Ansi)]
        public static extern int Syn_ResetSAM(int iPortID, int iIfOpen);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_GetSAMID", CharSet = CharSet.Ansi)]
        public static extern int Syn_GetSAMID(int iPortID, ref byte pucSAMID, int iIfOpen);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_GetSAMIDToStr", CharSet = CharSet.Ansi)]
        public static extern int Syn_GetSAMIDToStr(int iPortID, ref byte pcSAMID, int iIfOpen);
        /********************身份证卡类API *************************/
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_StartFindIDCard", CharSet = CharSet.Ansi)]
        public static extern int Syn_StartFindIDCard(int iPortID, ref byte pucManaInfo, int iIfOpen);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_SelectIDCard", CharSet = CharSet.Ansi)]
        public static extern int Syn_SelectIDCard(int iPortID, ref byte pucManaMsg, int iIfOpen);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_ReadMsg", CharSet = CharSet.Ansi)]
        public static extern int Syn_ReadMsg(int iPortID, int iIfOpen, ref IDCardData pIDCardData);
        /********************附加类API *****************************/
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_SendSound", CharSet = CharSet.Ansi)]
        public static extern int Syn_SendSound(int iCmdNo);
        [DllImport("Syn_IDCardRead.dll", EntryPoint = "Syn_DelPhotoFile", CharSet = CharSet.Ansi)]
        public static extern void Syn_DelPhotoFile();

        int iPort;
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            String sText;
            iPort = 0;
            for (iPort = 1001; iPort < 1017;iPort++ )
            {
                if (Syn_OpenPort(iPort) == 0)
                {
                    if (Syn_GetSAMStatus(iPort,0)==0)
                    {
                        Syn_ClosePort(iPort);
                        sText = "读卡器连接在" + iPort+"USB端口上";
                        listBox1.Items.Add(sText);
                        return;
                    }
                }
                Syn_ClosePort(iPort);
            }
            for (iPort = 1; iPort < 17;iPort++ )
            {
                if (Syn_OpenPort(iPort) == 0)
                {
                    if (Syn_GetSAMStatus(iPort,0)==0)
                    {
                        Syn_ClosePort(iPort);
                        sText = "读卡器连接在串口" + iPort +"上";
                        listBox1.Items.Add(sText);
                        return;
                    }
                }
                Syn_ClosePort(iPort);
            }
            sText = "没有连接读卡器";
            listBox1.Items.Add(sText);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            byte[] cSAMID = new byte[128];
            String sText;
            if (iPort == 0)
            {
                sText="没有连接读卡器";
                listBox1.Items.Add(sText);
                return;
            }
            if (Syn_OpenPort(iPort)!=0)
            {
                sText="打开端口错误";
                listBox1.Items.Add(sText);
                return;
            }
            if (Syn_GetSAMIDToStr(iPort,ref cSAMID[0],0)==0)
            {
                ASCIIEncoding encoding = new ASCIIEncoding( ); 
                string constructedString = encoding.GetString(cSAMID);
                sText = "安全模块ID:" +  constructedString ;
                listBox1.Items.Add(sText);
            }
            else
            {
                sText = "获得安全模块ID错误";
                listBox1.Items.Add(sText);
            }
            Syn_ClosePort(iPort);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            String sText;
            byte[] pucIIN = new byte[4];
            byte[] pucSN = new byte[8];
            IDCardData CardMsg = new IDCardData();
            if (pictureBox1.Image != null)
            {
                pictureBox1.Image.Dispose();
                pictureBox1.Image = null;
            }
            int nRet = Syn_OpenPort(iPort);
            if (nRet == 0)
            {
                nRet = Syn_GetSAMStatus(iPort, 0);
                nRet = Syn_StartFindIDCard(iPort, ref pucIIN[0], 0);
                nRet = Syn_SelectIDCard(iPort, ref pucSN[0], 0);
                if (Syn_ReadMsg(iPort, 0, ref CardMsg) == 0)
                {
                    listBox1.Items.Add("姓名：" + CardMsg.Name);
                    listBox1.Items.Add("性别：" + CardMsg.Sex);
                    listBox1.Items.Add("民族：" + CardMsg.Nation );
                    listBox1.Items.Add("出生日期：" + CardMsg.Born);
                    listBox1.Items.Add("住址：" + CardMsg.Address);
                    listBox1.Items.Add("身份证号：" + CardMsg.IDCardNo);
                    listBox1.Items.Add("发证机关：" + CardMsg.GrantDept);
                    listBox1.Items.Add("有效期："+ CardMsg.UserLifeBegin + "-" + CardMsg.UserLifeEnd);
                    listBox1.Items.Add("照片文件名：" + CardMsg.PhotoFileName);

                    pictureBox1.Image = Image.FromFile(CardMsg.PhotoFileName);
                }
                else
                {
                    sText = "读二代证信息错误!";
                    listBox1.Items.Add(sText);
                }
            }
            else
            {
                sText = "打开端口错误";
                listBox1.Items.Add(sText);
            }
            Syn_ClosePort(iPort);
        }
    }
}