<?php 
  include_once "./audiostreamerlib.php"; 

  //  AudioStreamer, www.audiostreamer.org
  //  Copyright (C) <2013>  <Lieven Rottiers>
  //
  //  This program is free software: you can redistribute it and/or modify
  //  it under the terms of the GNU General Public License as published by
  //  the Free Software Foundation, either version 3 of the License, or
  //  (at your option) any later version.
  //
  //  This program is distributed in the hope that it will be useful,
  //  but WITHOUT ANY WARRANTY; without even the implied warranty of
  //  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  //  GNU General Public License for more details.
  //
  //  You should have received a copy of the GNU General Public License
  //  along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
?>

<!DOCTYPE html>
<html>
<head>
<title>AudioStreamer</title>

<link rel="stylesheet" type="text/css" href="./app/css/AudioStreamer.css">  
<style type="text/css" id="themeswitch"></style>
<link rel="shortcut icon" href="./favicon.ico" />
  
<script type="text/javascript" src="./app/js/jquery-1.7.1.min.js"></script> 
<script type="text/javascript" src="./app/js/jquery-ui-1.8.10.custom.min.js"></script> 
<script type="text/javascript" src="./app/js/jquery.jplayer.min.js"></script>
<script type="text/javascript" src="./app/js/jquery.scrollTo-min.js"></script>
<script type="text/javascript" src="./app/js/jquery.ui.touch-punch.min.js"></script>
<script type="text/javascript" src="./app/js/AudioStreamer.js"></script>
  
<script type="text/javascript"> 
$(function(){
  $('.drag').draggable({ 
    snap: true, 
    stack: '.drag',
    handle: 'div.handler',
    start: function(event, ui) {$('.iframe-style').css({visibility:"hidden"});},
    stop: function(event, ui) {$('.iframe-style').css({visibility:"visible"});}
  });
  $('.drag').resizable({ 
    handles: ('n,e,s,w,ne,nw,se,sw'),
    start: function(event, ui) {$('.iframe-style').css({visibility:"hidden"});},
    stop: function(event, ui) {$('.iframe-style').css({visibility:"visible"});resizeImage($("#api4 img").attr("id"));}
  });
  $( "#playlistSortable" ).sortable({
    placeholder: "ui-state-highlight"
  });
});

$(document).ready(function(){
  $("#jquery_jplayer_1").jPlayer({
    ended: function (event) {
      playNext();
    },
    swfPath: "./app/js",
    supplied: "mp3",
    solution: "html,flash"
  });

  $("#jquery_jplayer_1").jPlayer("volume", 1);

  $("#jp_interface_1 .jp-previous").click(function() {
    playPrev();
  });

  $("#jp_interface_1 .jp-next").click(function() {
    playNext();
  });
  
  getTree();
  getAlbums();
  getSearch();
  showTree();
  recallDesktop();
	manageDesktops(0,0);
	manageUsers(0);
	manageSettings(0);
	aboutAudioStreamer(0);
});
</script>
</head>
<body>

  <div id="content">
    <div id="drag1" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 9; position: absolute; top: 1px; left: 534px; width: 556px; height: 45px; ">
      <div class="handler"><img src="./app/img/grab.gif">Settings - <?php echo $_SESSION["username"]; ?></div>
      <div id="api1" class="api"><div class="top-spacer"></div>
<?php
  //"save desktops (as)" only visible for admin(s)
  if ($_SESSION["ind_desktop"] == '1') {
    echo '<a href="javascript:saveDesktop();"><div title="save desktop" class="desktop-save"></div></a>';
    echo '<a href="javascript:saveDesktopAs();"><div title="save desktop as ..." class="desktop-save-as"></div></a>';
  }
?>
        <a href="javascript:manageDesktops();"><div title="manage desktops" class="desktop-manage"></div></a>
<?php
  //users and settings only visible for admin(s)
  if ($_SESSION["ind_admin"] == '1') {
    echo '<a href="javascript:manageUsers();"><div title="manage users" class="users"></div></a>';
    echo '<a href="javascript:manageSettings();"><div title="manage settings" class="settings"></div></a>';
  }
?>
				<a href="javascript:logout();"><div title="logout" class="logout"></div></a>
        <a href="javascript:aboutAudioStreamer();"><div title="about AudioStreamer" class="about-AudioStreamer"></div></a>
      </div>
    </div>
    <div id="drag2" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 4; position: absolute; top: 48px; left: 680px; width: 409px; height: 50px; ">
      <div class="handler"><img src="./app/img/grab.gif">Album - Song view</div>
      <div id="api2" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag3" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 5; position: absolute; top: 148px; left: 680px; width: 409px; height: 424px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        <a href="javascript:showTree()" id="api3-link">&nbsp;Folders&nbsp;</a>
        <a href="javascript:showAlbums()" id="api7-link">&nbsp;Albums&nbsp;</a>
        <a href="javascript:search()" id="api14-link">&nbsp;<img src="./app/img/icons/searchbar.gif" title="search">&nbsp;</a>
        <input type="text" id="scrollfield" name="scrollfield" placeholder="scroll to" onKeyUp="scrollFocus()" onClick="$('#scrollfield').select()" value="">
      </div>
      <div id="api3" class="api"><div class="top-spacer"></div></div>
      <div id="api7" class="api"><div class="top-spacer"></div></div>
      <div id="api14" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag4" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 5; position: absolute; top: 10px; left: 0px; width: 250px; height: 300px; ">
      <div class="handler"><img src="./app/img/grab.gif">Now Playing</div>
      <div id="api4" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag5" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 5; position: absolute; top: 30px; left: 250px; width: 409px; height: 300px; ">
       <div class="handler"><img src="./app/img/grab.gif">
         Playlist
         <div class="radio-playlist" onClick="radioPlaylist();">&nbsp;radio&nbsp;</div>
         <div class="clear-playlist" onClick="clearPlaylist();">&nbsp;clear&nbsp;</div>
      </div>
      <div id="api5" class="api"><div class="top-spacer"></div>
        <ul id="playlistSortable"></ul>
      </div>
    </div> 
    <div id="drag6" class="drag ui-widget ui-widget-content ui-corner-all" style="z-index: 5; position: absolute; top: 300px; left: 250px; width: 409px; height: 200px; ">
      <div class="handler"><img src="./app/img/grab.gif">Player</div>
      <div id="api6" class="api"><div class="top-spacer"></div>
        <div id="jquery_jplayer_1" class="jp-jplayer"></div>
        <div class="jp-audio">
          <div id="jp_interface_1" class="jp-interface">
            <table border="0" cellpadding="0" cellspacing="0"><tr>
              <td><div class="jp-previous"></div></td>
              <td><div class="jp-play"></div><div class="jp-pause"></div></td>
              <td><div class="jp-next"></div></td>
              <td style="width:100%">
                <div class="jp-progress"><div class="jp-current-time"></div><div class="jp-duration"></div>
                  <div class="jp-seek-bar">
                    <div class="jp-play-bar"></div>
                  </div>
                </div>
                <div class="jp-progress-title"></div>
              </td>
              <td><div class="jp-mute"></div><div class="jp-unmute"></div></td>
              <td>
                <div class="jp-volume-bar">
                  <div class="jp-volume-bar-value"></div>
                </div>
              </td>
            <tr></table>        
          </div>
        </div>
      </div>
    </div>     
    <div id="drag8" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 100px; left: 100px; width: 250px; height: 300px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        Song details
        <div class="close-popup" title="close" onClick="$('#drag8').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api8" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag9" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 100px; left: 300px; width: 250px; height: 300px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        (re)Create music database
        <div class="close-popup" title="close" onClick="$('#drag9').css({'visibility' : 'hidden'}).find('iframe').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api9" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag10" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 100px; left: 300px; width: 250px; height: 300px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        About AudioStreamer
        <div class="close-popup" title="close" onClick="$('#drag10').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api10" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag11" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 100px; left: 250px; width: 550px; height: 400px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        Manage users
        <div class="close-popup" title="close" onClick="$('#drag11').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api11" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag13" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 100px; left: 250px; width: 550px; height: 400px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        Manage settings
        <div class="close-popup" title="close" onClick="$('#drag13').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api13" class="api"><div class="top-spacer"></div></div>
    </div> 
    <div id="drag12" class="drag ui-widget ui-widget-content ui-corner-all" style="visibility: hidden; z-index: 9999; position: absolute; top: 80px; left: 200px; width: 550px; height: 400px; ">
      <div class="handler"><img src="./app/img/grab.gif">
        Manage desktops
        <div class="close-popup" title="close" onClick="$('#drag12').css({'visibility' : 'hidden'});"></div>
      </div>
      <div id="api12" class="api"><div class="top-spacer"></div></div>
    </div> 
    
    <div id="largeAlbumCover" class="cover-album"></div>
              
  </div>     
</body>
</html>