<?php
  include_once "./audiostreamerlib.php";

  //  AudioStreamer, www.audiostreamer.org
  //  Copyright (C) <2013>  <Lieven Rottiers>
  //
  //  This program is free software: you can redistribute it and/or modify
  //  it under the terms of the GNU General Public License as published by
  //  the Free Software Foundation, either version 3 of the License, or
  //  (at your option) any later version.
  //
  //  This program is distributed in the hope that it will be useful,
  //  but WITHOUT ANY WARRANTY; without even the implied warranty of
  //  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  //  GNU General Public License for more details.
  //
  //  You should have received a copy of the GNU General Public License
  //  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  $output = '';
  $pmode = $_GET["pmode"];
  
  try {
    $dbh = new PDO("sqlite:".$sdb);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING); 
    
    if ($pmode == "R") {
      //Retrieve
      
      $output = $output. '<br><br>
        <div id="themes">
        Themes
				<div class="description">
				If you know something about html and css then you can create your own theme.
				<br>Copy a theme record, change the name and change the reference to the css file
				(the css file is found in the AudioStreamer directory under "./app/css").
				<br>AudioStreamer links to the fixed "audiostreamer.css" file and you can overwrite the properties through the theme-css.
				<br>Just copy an existing theme-css file (eg green.css) and start modifying.
				<br>Enjoy...
				</div>
        <br>
        <div><a href="javascript:manageSettings();"><div title="refresh" class="refresh"></div></a></div>
        <table class="theme">';
     
      $sql = "select id, name, css
        from theme
        order by name, css";
      
      //headers
      $output = $output.'<tr><th width="1px"></th><th style="display:none">id</th><th>name</th><th>css</th><th width="1px"></th><th width="1px"></th></tr>';

      //rows
      foreach ($dbh->query($sql) as $row) {
    
        //create input on id
        $input_id = '<input type="text" name="id" updId="id" disabled style="width: 50px" value="'.$row['id'].'" />';

        //create input on name
        $input_name = '<input type="text" name="name" updId="name" value="'.$row['name'].'" />';
        
        //create input on css
        $input_css = '<input type="text" name="css" updId="css" value="'.$row['css'].'" />';

        //create rows
        $output = $output.
          '<tr>'.
            '<td title="delete" class="theme-delete" onClick="themeDelete(this)"></td>'.
            '<td style="display:none">'.$input_id.'</td>'.
            '<td>'.$input_name.'</td>'.
            '<td>'.$input_css.'</td>'.
            '<td title="copy" class="theme-copy" onClick="themeCopy(this)"></td>'.
            '<td title="save" class="theme-update" onClick="themeUpdate(this)"></td>'.
          '</tr>';
      }   
      
      $output = $output.'</table></div><br>';
      
      //add script to handle the changed class
      $output = $output.
        '<script type="text/javascript">'.
        '$(function(){'.
        '  $("[updId]").change(function() {'.
        '        $(this).parent().addClass("changed"); '.
        '  });'.
        '});'.
        '</script>';

    }
    else if ($pmode == "U") {
      //Update
      $dbh->beginTransaction();
      
      $sql =  
        "update theme 
         set name = '".str_replace("'", "''", $_GET["name"])."',
             css = '".str_replace("'", "''", $_GET["css"])."'
         where id = ".$_GET["id"]."
        ;";
      $dbh->exec($sql);      
      
      $dbh->commit();

			//$output = $output. 'Update successfull';
			$output = $output. 'SUCCESS';
    }
    else if ($pmode == "C") {
      //Create or Copy
      $dbh->beginTransaction();
      
      $sql =  
        "insert into theme(name, css)
         select name||(select seq + 1 from sqlite_sequence where name='theme'), css
         from theme
        where id = ".$_GET["id"].";";
      $dbh->exec($sql);      

      $dbh->commit();

      //$output = $output. 'Copy successfull';
      $output = $output. 'SUCCESS';
    }
    else if ($pmode == "D") {
      //Delete
      $dbh->beginTransaction();

      //set reference to deleted theme to null in table desktop      
      $sql =  
        "update desktop
				 set theme = null
         where theme = ".$_GET["id"];
      $dbh->exec($sql);      
      $sql =  
        "delete from theme
         where id = ".$_GET["id"];
      $dbh->exec($sql);      

      //check to see if at least 1 theme stays
      $sql = "select count(1) as total from theme";
      foreach ($dbh->query($sql) as $row) {
        if ($row['total'] == 0) {
          $output = $output. 'There must exist at least one theme.';          
        }
        else {
          $dbh->commit();

          //$output = $output. 'Delete successfull';
          $output = $output. 'SUCCESS';
        }
      }
    }

    //close connection
    $dbh = null;
  }
  catch(PDOException $e)
  {
    $output = $output.'<br/>'.$e->getMessage();
  }  
  
  echo $output;
  ?>