#include "myIDirectInput.h"
#include "myIDirectInputDevice.h"

struct EnumDevicesCallBackContext
{
	LPDIENUMDEVICESCALLBACK originalCallback;
	LPVOID originalRef;
};

myIDirectInput::myIDirectInput(IDirectInput8A *wrappedObject)
{
	realIDirectInput = wrappedObject;
}

/*** IUnknown methods ***/
HRESULT myIDirectInput::QueryInterface(REFIID riid, void** ppvObj)
{
	return realIDirectInput->QueryInterface(riid, ppvObj);
}

ULONG myIDirectInput::AddRef()
{
	return realIDirectInput->AddRef();
}

ULONG myIDirectInput::Release()
{
	ULONG result = realIDirectInput->Release();
	if(result <= 0)
	{
		delete this;
	}
	return result;
}

HRESULT myIDirectInput::CreateDevice(
	REFGUID rguid,
	LPDIRECTINPUTDEVICE8A * lplpDirectInputDevice,
	LPUNKNOWN pUnkOuter)
{
	HRESULT hres = realIDirectInput->CreateDevice(rguid, lplpDirectInputDevice, pUnkOuter);
	//*lplpDirectInputDevice = (LPDIRECTINPUTDEVICE8A)new myIDirectInputDevice(*lplpDirectInputDevice);
	return hres;
}

BOOL CALLBACK EnumDevicesCallback(const DIDEVICEINSTANCEA* pdidoi,
	VOID* pContext)
{
	EnumDevicesCallBackContext* context = (EnumDevicesCallBackContext*)pContext;
	DIDEVICEINSTANCEA instance = *pdidoi;

	// Xbox 360 Wireless Receiver for Windows Product GUID:
	// 02A1045E-0000-0000-0000-504944564944
	instance.guidProduct.Data1 = 0x02a1045EL;
	instance.guidProduct.Data2 = 0x0;
	instance.guidProduct.Data3 = 0x0;
	instance.guidProduct.Data4[0] = 0x0;
	instance.guidProduct.Data4[1] = 0x0;
	instance.guidProduct.Data4[2] = 0x50;
	instance.guidProduct.Data4[3] = 0x49;
	instance.guidProduct.Data4[4] = 0x44;
	instance.guidProduct.Data4[5] = 0x56;
	instance.guidProduct.Data4[6] = 0x49;
	instance.guidProduct.Data4[7] = 0x44;

	BOOL ret = 0;
	ret = context->originalCallback(&instance, context->originalRef);

	return ret;
}

HRESULT myIDirectInput::EnumDevices(DWORD dwDevType,
	LPDIENUMDEVICESCALLBACK lpCallback,
	LPVOID pvRef,
	DWORD dwFlags)
{
	EnumDevicesCallBackContext context;
	context.originalCallback = lpCallback;
	context.originalRef = pvRef;
	return realIDirectInput->EnumDevices(dwDevType, &EnumDevicesCallback, &context, dwFlags);
}

HRESULT myIDirectInput::GetDeviceStatus(REFGUID rguidInstance)
{
	return realIDirectInput->GetDeviceStatus(rguidInstance);
}

HRESULT myIDirectInput::RunControlPanel(HWND hwndOwner,
	DWORD dwFlags)
{
	return realIDirectInput->RunControlPanel(hwndOwner, dwFlags);
}

HRESULT myIDirectInput::Initialize(HINSTANCE hinst,
	DWORD dwVersion)
{
	return realIDirectInput->Initialize(hinst, dwVersion);
}

HRESULT myIDirectInput::FindDevice(REFGUID rguidClass,
	LPCTSTR ptszName,
	LPGUID pguidInstance)
{
	return realIDirectInput->FindDevice(rguidClass, ptszName, pguidInstance);
}

HRESULT myIDirectInput::EnumDevicesBySemantics(LPCTSTR ptszUserName,
	LPDIACTIONFORMAT lpdiActionFormat,
	LPDIENUMDEVICESBYSEMANTICSCB lpCallback,
	LPVOID pvRef,
	DWORD dwFlags)
{
	return realIDirectInput->EnumDevicesBySemantics(ptszUserName, lpdiActionFormat, lpCallback, pvRef, dwFlags);
}

HRESULT myIDirectInput::ConfigureDevices(LPDICONFIGUREDEVICESCALLBACK lpdiCallback,
	LPDICONFIGUREDEVICESPARAMS lpdiCDParams,
	DWORD dwFlags,
	LPVOID pvRefData)
{
	return realIDirectInput->ConfigureDevices(lpdiCallback, lpdiCDParams, dwFlags, pvRefData);
}

