#include "myIDirectInputDevice.h"
#include <sstream>

struct EnumObjectsCallBackContext
{
	LPDIENUMDEVICEOBJECTSCALLBACK originalCallback;
	LPVOID originalRef;
};

myIDirectInputDevice::myIDirectInputDevice(IDirectInputDevice8A *wrappedObject)
{
	realIDirectInputDevive = wrappedObject;
}

/*** IUnknown methods ***/
HRESULT myIDirectInputDevice::QueryInterface(REFIID riid, void** ppvObj)
{
	return realIDirectInputDevive->QueryInterface(riid, ppvObj);
}

ULONG myIDirectInputDevice::AddRef()
{
	return realIDirectInputDevive->AddRef();
}

ULONG myIDirectInputDevice::Release()
{
	ULONG result = realIDirectInputDevive->Release();
	if (result <= 0)
	{
		delete this;
	}
	return result;
}

HRESULT myIDirectInputDevice::GetCapabilities(LPDIDEVCAPS lpDIDevCaps)
{
	return realIDirectInputDevive->GetCapabilities(lpDIDevCaps);
}

BOOL CALLBACK EnumObjectsCallback(const DIDEVICEOBJECTINSTANCE* pdidoi,
	VOID* pContext)
{
	EnumObjectsCallBackContext* context = (EnumObjectsCallBackContext*)pContext;
	return context->originalCallback(pdidoi, context->originalRef);
}

HRESULT myIDirectInputDevice::EnumObjects(LPDIENUMDEVICEOBJECTSCALLBACK lpCallback,
	LPVOID pvRef,
	DWORD dwFlags)
{
	EnumObjectsCallBackContext context;
	context.originalCallback = lpCallback;
	context.originalRef = pvRef;
	return realIDirectInputDevive->EnumObjects(EnumObjectsCallback, &context, dwFlags);
}

HRESULT myIDirectInputDevice::GetProperty(REFGUID rguidProp,
	LPDIPROPHEADER pdiph)
{
	return realIDirectInputDevive->GetProperty(rguidProp, pdiph);
}

HRESULT myIDirectInputDevice::SetProperty(REFGUID rguidProp,
	LPCDIPROPHEADER pdiph)
{
	return realIDirectInputDevive->SetProperty(rguidProp, pdiph);
}

HRESULT myIDirectInputDevice::Acquire()
{
	return realIDirectInputDevive->Acquire();
}

HRESULT myIDirectInputDevice::Unacquire()
{
	return realIDirectInputDevive->Unacquire();
}

HRESULT myIDirectInputDevice::GetDeviceState(DWORD cbData,
	LPVOID lpvData)
{
	return realIDirectInputDevive->GetDeviceState(cbData, lpvData);
}

HRESULT myIDirectInputDevice::GetDeviceData(DWORD cbObjectData,
	LPDIDEVICEOBJECTDATA rgdod,
	LPDWORD pdwInOut,
	DWORD dwFlags)
{
	return realIDirectInputDevive->GetDeviceData(cbObjectData, rgdod, pdwInOut, dwFlags);
}

HRESULT myIDirectInputDevice::SetDataFormat(LPCDIDATAFORMAT lpdf)
{
	HRESULT hres = realIDirectInputDevive->SetDataFormat(lpdf);
	return hres;
}

HRESULT myIDirectInputDevice::SetEventNotification(HANDLE hEvent)
{
	return realIDirectInputDevive->SetEventNotification(hEvent);
}

HRESULT myIDirectInputDevice::SetCooperativeLevel(HWND hwnd,
	DWORD dwFlags)
{
	return realIDirectInputDevive->SetCooperativeLevel(hwnd, dwFlags);
}

HRESULT myIDirectInputDevice::GetObjectInfo(LPDIDEVICEOBJECTINSTANCE pdidoi,
	DWORD dwObj,
	DWORD dwHow)
{
	return realIDirectInputDevive->GetObjectInfo(pdidoi, dwObj, dwHow);
}

HRESULT myIDirectInputDevice::GetDeviceInfo(LPDIDEVICEINSTANCE pdidi)
{
	return realIDirectInputDevive->GetDeviceInfo(pdidi);
}

HRESULT myIDirectInputDevice::RunControlPanel(HWND hwndOwner,
	DWORD dwFlags)
{
	return realIDirectInputDevive->RunControlPanel(hwndOwner, dwFlags);
}

HRESULT myIDirectInputDevice::Initialize(HINSTANCE hinst,
	DWORD dwVersion,
	REFGUID rguid)
{
	return realIDirectInputDevive->Initialize(hinst, dwVersion, rguid);
}

HRESULT myIDirectInputDevice::CreateEffect(REFGUID rguid,
	LPCDIEFFECT lpeff,
	LPDIRECTINPUTEFFECT * ppdeff,
	LPUNKNOWN punkOuter)
{
	return realIDirectInputDevive->CreateEffect(rguid, lpeff, ppdeff, punkOuter);
}

HRESULT myIDirectInputDevice::EnumEffects(LPDIENUMEFFECTSCALLBACK lpCallback,
	LPVOID pvRef,
	DWORD dwEffType)
{
	return realIDirectInputDevive->EnumEffects(lpCallback, pvRef, dwEffType);
}

HRESULT myIDirectInputDevice::GetEffectInfo(LPDIEFFECTINFO pdei,
         REFGUID rguid)
{
	return realIDirectInputDevive->GetEffectInfo(pdei, rguid);
}

HRESULT myIDirectInputDevice::GetForceFeedbackState(LPDWORD pdwOut)
{
	return realIDirectInputDevive->GetForceFeedbackState(pdwOut);
}

HRESULT myIDirectInputDevice::SendForceFeedbackCommand(DWORD dwFlags)
{
	return realIDirectInputDevive->SendForceFeedbackCommand(dwFlags);
}

HRESULT myIDirectInputDevice::EnumCreatedEffectObjects(LPDIENUMCREATEDEFFECTOBJECTSCALLBACK lpCallback,
	LPVOID pvRef,
	DWORD fl)
{
	return realIDirectInputDevive->EnumCreatedEffectObjects(lpCallback, pvRef, fl);
}

HRESULT myIDirectInputDevice::Escape(LPDIEFFESCAPE pesc)
{
	return realIDirectInputDevive->Escape(pesc);
}

HRESULT myIDirectInputDevice::Poll()
{
	return realIDirectInputDevive->Poll();
}

HRESULT myIDirectInputDevice::SendDeviceData(DWORD cbObjectData,
	LPCDIDEVICEOBJECTDATA rgdod,
	LPDWORD pdwInOut,
	DWORD fl)
{
	return realIDirectInputDevive->SendDeviceData(cbObjectData, rgdod, pdwInOut, fl);
}

HRESULT myIDirectInputDevice::EnumEffectsInFile(LPCSTR lpszFileName,
	LPDIENUMEFFECTSINFILECALLBACK pec,
	LPVOID pvRef,
	DWORD dwFlags)
{
	return realIDirectInputDevive->EnumEffectsInFile(lpszFileName, pec, pvRef, dwFlags);
}

HRESULT myIDirectInputDevice::WriteEffectToFile(LPCSTR lpszFileName,
	DWORD dwEntries,
	LPDIFILEEFFECT rgDiFileEft,
	DWORD dwFlags)
{
	return realIDirectInputDevive->WriteEffectToFile(lpszFileName, dwEntries, rgDiFileEft, dwFlags);
}

HRESULT myIDirectInputDevice::BuildActionMap(LPDIACTIONFORMAT lpdiaf,
	LPCTSTR lpszUserName,
	DWORD dwFlags)
{
	return realIDirectInputDevive->BuildActionMap(lpdiaf, lpszUserName, dwFlags);
}

HRESULT myIDirectInputDevice::SetActionMap(LPDIACTIONFORMAT lpdiActionFormat,
	LPCTSTR lptszUserName,
	DWORD dwFlags)
{
	return realIDirectInputDevive->SetActionMap(lpdiActionFormat, lptszUserName, dwFlags);
}

HRESULT myIDirectInputDevice::GetImageInfo(LPDIDEVICEIMAGEINFOHEADER lpdiDevImageInfoHeader)
{
	return realIDirectInputDevive->GetImageInfo(lpdiDevImageInfoHeader);
}
