
function show_order_bill(json)
{
	$("#order_detail").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	data = json.data;
	if(!data || data.length == 0)
	{
		return;
	}
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}

		var td = "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["name"] + "</td>"
				+ "<td>" + data[i]["spec"] + "</td>"
				+ "<td>" + data[i]["amount"] + "</td>"
				+ "<td>" + data[i]["unit"] + "</td>"
				+ "<td>" + data[i]["price"] + "</td>"
				+ "<td>" + data[i]["hj"] + "</td>"
				+ "<td>" + data[i]["stock_amount"] + "</td>"
				+ "<td>" + data[i]["notes"] + "</td>"
				+ "</tr>";
		$('#order_detail').append(tr+td);
	}
}

function get_order_bill_json(order_id) 
{
	var token = get_token();
    var json = {
        "service": "web_order/get_order_bill",
		"token": token,
		"params":
		{
			"order_id": order_id,
		}
    };
    return json;
}

function get_order_bill(order_id) 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_order_bill_json(order_id)),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_order_bill(json);
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

function get_order_auth_json(order_id) 
{
	var token = get_token();
	var user_name = get_user_name();
    var json = {
        "service": "web_order/auth_order",
		"token": token,
		"params":
		{
			"order_id": order_id,
			"auditor": user_name
		}
    };
    return json;
}

function do_order_auth(order_id) 
{
	if(!confirm("Ҫ󽫲޸"))
	{
		return;
	}
	var user_name = get_user_name();
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_order_auth_json(order_id)),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			$("#"+order_id).html("");	
			$("#A_"+order_id).text(user_name);
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

function show_order(json)
{
	$("#customers").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	data = json.data;
	if(!data || data.length == 0)
	{
		return;
	}
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}
		var id = data[i]["id"];
		var cust_name = data[i]["cust_name"];
		var status = "<span id='" + id + "'><a href='#' onclick='do_order_auth(" + id + ")'></a></span>";
		if(data[i]["status"] > 0)
		{
			status = "";
		}
		
		var order_time = data[i]["order_time"]; //µʱ
		var give_time = data[i]["give_time"]; //ʱ
		
		
		var warn = "";
		var percent = data[i]["progress"];
		var cur_percent = get_cur_percent(get_date(order_time), get_date(give_time));
		var dif_str = "";
		if(cur_percent <=0 || cur_percent > 100) //ûʼѾ
		{
			if(cur_percent > 100 && percent < 99.5) //û
			{
				warn = " class='warn' ";
			}
		}
		else
		{
			var left_days = get_days(get_cur_date(), give_time); //ʣʱ
			dif = cur_percent - percent;
			if(dif >=20 || left_days <=3) //10%
			{
				warn = " class='warn_info' "; //
			}
		}
		
		var td = "<td>" + (i+1) + "</td>"
				+ "<td><a href='#' onclick=\"show_dlg(" + id + ",'" + cust_name + "')\">" + data[i]["num"] + "</a>" + "</td>"
				+ "<td>" + cust_name + "</td>"
				+ "<td>" + data[i]["order_money"] + "</td>"
				+ "<td>" + order_time + "</td>"
				+ "<td>" + date_part(give_time) + "</td>"
				+ "<td" + warn + ">" + percent.toFixed(1) + "%</td>"
				+ "<td><span id='A_" + id + "'>" + data[i]["sellor"] + "</td>"
				+ "<td>" + status + "</td>"
				+ "<td>" + data[i]["memo"] + "</td>"
				+ "</tr>";
		$('#customers').append(tr+td);
	}
}

function get_sch_order_json() 
{
	var token = get_token();
//	var val=$('input[name="ord_status"]:checked').val();
	var val=get_opt_val("ord_status");
	var service = "web_order/get_order_list";
	var end_time = $("#e_day").val() + " 23:59:59"; //ʱ
	if(val == "0")
	{
		service = "web_order/get_order_list_unauth";
	}
    var json = {
        "service": service,
		"token": token,
		"params":
		{
			"begin_time": $("#s_day").val(),
			"end_time": end_time
		}
    };
    return json;
}

function search_order() 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_sch_order_json()),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_order(json);
			
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}

/*
function show_rpt(json)
{
	$("#customers").find("tr:not(:first)").remove();
	if (!json)
	{
		return;
	}	
	data = json.data;
	if(!data || data.length == 0)
	{
		return;
	}
	g_token = json.token;
	for (var i = 0; i < data.length; i++) 
	{
		var tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}

		var td = "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["name"] + "</td>"
				+ "<td>" + data[i]["spec"] + "</td>"
				+ "<td>" + data[i]["unit"] + "</td>"
				+ "<td>" + data[i]["m1"] + "</td>"
				+ "<td>" + data[i]["m2"] + "</td>"
				+ "<td>" + data[i]["m3"] + "</td>"
				+ "<td>" + data[i]["m4"] + "</td>"
				+ "<td>" + data[i]["m5"] + "</td>"
				+ "<td>" + data[i]["m6"] + "</td>"
				+ "<td>" + data[i]["m7"] + "</td>"
				+ "<td>" + data[i]["m8"] + "</td>"
				+ "<td>" + data[i]["m9"] + "</td>"
				+ "<td>" + data[i]["m10"] + "</td>"
				+ "<td>" + data[i]["m11"] + "</td>"
				+ "<td>" + data[i]["m12"] + "</td>"
				+ "<td>" + data[i]["t_amount"] + "</td>"
				+ "</tr>";
		$('#customers').append(tr+td);
	}
	sum_cols("customers", 5, 13);
}
*/

function show_rpt(json)
{
	var opt=get_opt_val("ord_grp");	
	if (!json)
	{
		return;
	}	
	data = json.data;
	g_token = json.token;
	
	$("#customers").empty();
	
	var tr = "", sum_fld = "", sum_title="", chart_title="";
	if(opt == "0")
	{
		chart_title = "۶ͳ";
		sum_fld = "t_je";
		sum_title = "ϼƽ";
		tr = "<tr>"
			+"<th width='70px'></th>"
			+"<th width='80px'>ͻ</th>"
			+"<th width='180px'>ͻ</th>";
	}
	else
	{
		chart_title = "ͳ";
		sum_title = "ϼ";
		sum_fld = "t_amount";
		tr = "<tr>"
			+"<th width='70px'></th>"
			+"<th width='100px'>Ʒ</th>"
			+"<th width='150px'>Ʒ</th>"
			+"<th width='180px'>ͺ</th>"
			+"<th width='70px'>λ</th>";
	}
	tr += 
		 "<th width='60px'>1</th>"
		+"<th width='60px'>2</th>"
		+"<th width='60px'>3</th>"
		+"<th width='60px'>4</th>"
		+"<th width='60px'>5</th>"
		+"<th width='60px'>6</th>"
		+"<th width='60px'>7</th>"
		+"<th width='60px'>8</th>"
		+"<th width='60px'>9</th>"
		+"<th width='60px'>10</th>"
		+"<th width='60px'>11</th>"
		+"<th width='60px'>12</th>"
		+"<th width='80px'>" + sum_title + "</th>"
		+"</tr>";
	
	$('#customers').append(tr);
	if(!data || data.length == 0)
	{
		$('#customers').append("<tr><td colspan='18' align='center'>û</td></tr>");
		rpt_chart("rpt_chart", chart_title, new Array(0,0,0,0,0,0,0,0,0,0,0,0));
		return;
	}
	
	for (var i = 0; i < data.length; i++) 
	{
		tr = "<tr>";
		if (i % 2 == 0)
		{
			tr = "<tr class='alt'>";
		}
		if(opt == "0")
		{
			tr += "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["ent_name"] + "</td>";
		}
		else
		{
			tr += "<td>" + (i+1) + "</td>"
				+ "<td>" + data[i]["code"] + "</td>"
				+ "<td>" + data[i]["name"] + "</td>"
				+ "<td>" + data[i]["spec"] + "</td>"
				+ "<td>" + data[i]["unit"] + "</td>";
		}
				
		tr += "<td>" + data[i]["m1"] + "</td>"
			+ "<td>" + data[i]["m2"] + "</td>"
			+ "<td>" + data[i]["m3"] + "</td>"
			+ "<td>" + data[i]["m4"] + "</td>"
			+ "<td>" + data[i]["m5"] + "</td>"
			+ "<td>" + data[i]["m6"] + "</td>"
			+ "<td>" + data[i]["m7"] + "</td>"
			+ "<td>" + data[i]["m8"] + "</td>"
			+ "<td>" + data[i]["m9"] + "</td>"
			+ "<td>" + data[i]["m10"] + "</td>"
			+ "<td>" + data[i]["m11"] + "</td>"
			+ "<td>" + data[i]["m12"] + "</td>"
			+ "<td>" + data[i][sum_fld] + "</td>"
			+ "</tr>";
		$('#customers').append(tr);
	}
	var sum_data;
	if(opt == "0")
	{
		sum_data = sum_cols("customers", 3, 13);
	}
	else
	{
		sum_data = sum_cols("customers", 5, 13);
	}
	rpt_chart("rpt_chart", chart_title, sum_data);
}
function get_rpt_order_json() 
{
	var token = get_token();

	var ord_status = get_opt_val("ord_status");	
	var ord_grp = get_opt_val("ord_grp");	
	var year = $("#rpt_year").val();
	
	var service = "web_order/rpt_order_year";
	if(ord_status == "1")
	{
		service = "web_order/rtp_order_year_give"; //ѽ
		if(ord_grp == "0")//ͻͳ
		{
			service = "web_order/rpt_order_cust_give";
		}		
	}
	else
	{
		service = "web_order/rpt_order_year";
		if(ord_grp == "0") //ͻͳ
		{
			service = "web_order/rpt_order_cust";
		}		
	}
    var json = {
        "service": service,
		"token": token,
		"params":
		{
			"year": year
		}
    };
    return json;
}

function rpt_order() 
{
	$.ajax(
	{
url : g_url,    <!-- url  :ַ -->  
type : 'post',<!--type :post/get --> 
		xhrFields: {
                withCredentials: true // withCredentials
            },
		async:false,
data : JSON.stringify(get_rpt_order_json()),
	
	success:function(data)
		{
			var json = eval('(' + data + ')');
			show_rpt(json);
			
	},
		error:function (request, status, error)
		{
//			alert(error);
	}
	});
}
