/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import com.googlecode.dex2jar.tools.JasminifierClassAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class Jar2Jasmin
extends BaseCmd {
    @BaseCmd.Opt(opt="d", longOpt="debug", hasArg=false, description="disassemble debug info")
    private boolean debugInfo = false;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output dir of .j files, default is $current_dir/[jar-name]-jar2jasmin/", argName="out-dir")
    private File output;
    @BaseCmd.Opt(opt="e", longOpt="encoding", description="encoding for .j files, default is UTF-8", argName="enc")
    private String encoding = "UTF-8";

    public static void main(String[] args) {
        new Jar2Jasmin().doMain(args);
    }

    public Jar2Jasmin() {
        super("d2j-jar2jasmin [options] <jar>", "Disassemble .class in jar file to jasmin file");
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File jar = new File(this.remainingArgs[0]);
        if (!jar.exists()) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = jar.isDirectory() ? new File(String.valueOf(jar.getName()) + "-jar2jasmin/") : new File(String.valueOf(FilenameUtils.getBaseName((String)jar.getName())) + "-jar2jasmin/");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("disassemble " + jar + " -> " + this.output);
        final int flags = this.debugInfo ? 0 : 2;
        final FileOut.OutHandler fo = FileOut.create((File)this.output, (boolean)false);
        try {
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    block6: {
                        if (isDir || !name.endsWith(".class")) {
                            return;
                        }
                        OutputStream os = null;
                        PrintWriter out = null;
                        try {
                            try {
                                InputStream is = current.get();
                                ClassReader r = new ClassReader(is);
                                os = fo.openOutput(String.valueOf(r.getClassName().replace('.', '/')) + ".j", nameObject);
                                out = new PrintWriter(new OutputStreamWriter(os, Jar2Jasmin.this.encoding));
                                r.accept((ClassVisitor)new JasminifierClassAdapter(out, null), flags | 8);
                            }
                            catch (IOException ioe) {
                                System.err.println("error in " + name);
                                ioe.printStackTrace(System.err);
                                IOUtils.closeQuietly(out);
                                IOUtils.closeQuietly(os);
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            IOUtils.closeQuietly(os);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)out);
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                }
            }).walk(jar);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fo);
        }
    }
}

