/*
 * Decompiled with CFR 0.152.
 */
package p.rn.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import p.rn.ClassInfo;

public class ScanLibVisitor
extends EmptyVisitor {
    private ClassInfo clz;
    private Map<String, ClassInfo> map = new HashMap<String, ClassInfo>();

    public Map<String, ClassInfo> getClassMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.clz = new ClassInfo();
        this.clz.access = access;
        this.clz.name = name;
        if (superName != null) {
            this.clz.parent.add(superName);
        }
        if (interfaces != null) {
            this.clz.parent.addAll(Arrays.asList(interfaces));
        }
        this.map.put(name, this.clz);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        ClassInfo.MemberInfo f = new ClassInfo.MemberInfo();
        List<ClassInfo.MemberInfo> fs = this.clz.members.get(name);
        if (fs == null) {
            fs = new ArrayList<ClassInfo.MemberInfo>();
            this.clz.members.put(name, fs);
        }
        f.name = name;
        f.desc = desc;
        f.access = access;
        f.value = value;
        fs.add(f);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name) || "<cinit>".equals(name)) {
            return null;
        }
        ClassInfo.MemberInfo m = new ClassInfo.MemberInfo();
        int index = desc.lastIndexOf(41);
        String key = String.valueOf(name) + desc.substring(0, index + 1);
        List<ClassInfo.MemberInfo> ms = this.clz.members.get(key);
        if (ms == null) {
            ms = new ArrayList<ClassInfo.MemberInfo>();
            this.clz.members.put(key, ms);
        }
        m.name = name;
        m.desc = desc;
        m.access = access;
        ms.add(m);
        return null;
    }
}

