/*
 * Decompiled with CFR 0.152.
 */
package apkencrypttool;

import apkencrypttool.ApkEncryptToolAboutBox;
import apkencrypttool.ApkEncryptToolApp;
import apkencrypttool.ApkEntUtils;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class ApkEncryptToolView
extends FrameView {
    private JTextField apkFile;
    private JButton decryptBtn;
    private JButton encryptBtn;
    private JButton jButton1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public ApkEncryptToolView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ApkEncryptToolView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ApkEncryptToolView.this.busyIconIndex = (ApkEncryptToolView.this.busyIconIndex + 1) % ApkEncryptToolView.this.busyIcons.length;
                ApkEncryptToolView.this.statusAnimationLabel.setIcon(ApkEncryptToolView.this.busyIcons[ApkEncryptToolView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ApkEncryptToolView.this.busyIconTimer.isRunning()) {
                        ApkEncryptToolView.this.statusAnimationLabel.setIcon(ApkEncryptToolView.this.busyIcons[0]);
                        ApkEncryptToolView.this.busyIconIndex = 0;
                        ApkEncryptToolView.this.busyIconTimer.start();
                    }
                    ApkEncryptToolView.this.progressBar.setVisible(true);
                    ApkEncryptToolView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ApkEncryptToolView.this.busyIconTimer.stop();
                    ApkEncryptToolView.this.statusAnimationLabel.setIcon(ApkEncryptToolView.this.idleIcon);
                    ApkEncryptToolView.this.progressBar.setVisible(false);
                    ApkEncryptToolView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ApkEncryptToolView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ApkEncryptToolView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ApkEncryptToolView.this.progressBar.setVisible(true);
                    ApkEncryptToolView.this.progressBar.setIndeterminate(false);
                    ApkEncryptToolView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ApkEncryptToolApp.getApplication().getMainFrame();
            this.aboutBox = new ApkEncryptToolAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ApkEncryptToolApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jButton1 = new JButton();
        this.apkFile = new JTextField();
        this.encryptBtn = new JButton();
        this.decryptBtn = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(ApkEncryptToolApp.class).getContext().getResourceMap(ApkEncryptToolView.class);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApkEncryptToolView.this.jButton1ActionPerformed(evt);
            }
        });
        this.apkFile.setText(resourceMap.getString("apkFile.text", new Object[0]));
        this.apkFile.setName("apkFile");
        this.encryptBtn.setText(resourceMap.getString("encryptBtn.text", new Object[0]));
        this.encryptBtn.setName("encryptBtn");
        this.encryptBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApkEncryptToolView.this.encryptBtnActionPerformed(evt);
            }
        });
        this.decryptBtn.setText(resourceMap.getString("decryptBtn.text", new Object[0]));
        this.decryptBtn.setName("decryptBtn");
        this.decryptBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApkEncryptToolView.this.decryptBtnActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.encryptBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.decryptBtn).addContainerGap(248, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.apkFile, -1, 280, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addGap(11, 11, 11)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.apkFile, -2, -1, -2)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encryptBtn).addComponent(this.decryptBtn)).addContainerGap(28, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(ApkEncryptToolApp.class).getContext().getActionMap(ApkEncryptToolView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setText(resourceMap.getString("aboutMenuItem.text", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 382, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 212, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".apk");
            }

            public String getDescription() {
                return "";
            }
        });
        jFileChooser.showOpenDialog(this.getComponent());
        File file = jFileChooser.getSelectedFile();
        if (null != file) {
            if (!file.getName().endsWith(".apk")) {
                this.showDialogMessage("\u9009\u62e9\u6587\u4ef6\u4e0d\u662fapk");
                return;
            }
            this.apkFile.setText(file.getAbsolutePath());
        }
    }

    private void encryptBtnActionPerformed(ActionEvent evt) {
        File apkFile = new File(this.apkFile.getText());
        if (!apkFile.exists()) {
            this.showDialogMessage("APK\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        if (!apkFile.getName().endsWith(".apk")) {
            this.showDialogMessage("\u6240\u9009\u6587\u4ef6\u4e0d\u662fapk\u6587\u4ef6");
            return;
        }
        try {
            String outFile = apkFile.getAbsolutePath().replace(".apk", "_encrypt.apk");
            new ApkEntUtils().ChangToEncryptedEntry(apkFile.getAbsolutePath(), outFile);
            this.showDialogMessage("\u52a0\u5bc6\u6210\u529f");
            Desktop.getDesktop().open(new File(outFile).getParentFile());
        }
        catch (IOException ex) {
            this.showDialogMessage(ex.getMessage());
        }
    }

    private void decryptBtnActionPerformed(ActionEvent evt) {
        File apkFile = new File(this.apkFile.getText());
        if (!apkFile.exists()) {
            this.showDialogMessage("APK\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        if (!apkFile.getName().endsWith(".apk")) {
            this.showDialogMessage("\u6240\u9009\u6587\u4ef6\u4e0d\u662fapk\u6587\u4ef6");
            return;
        }
        try {
            String outFile = apkFile.getAbsolutePath().replace(".apk", "_decrypt.apk");
            new ApkEntUtils().FixEncryptedEntry(apkFile.getAbsolutePath(), outFile);
            this.showDialogMessage("\u89e3\u5bc6\u6210\u529f");
            Desktop.getDesktop().open(new File(outFile).getParentFile());
        }
        catch (IOException ex) {
            this.showDialogMessage(ex.getMessage());
        }
    }

    public void showDialogMessage(String msg) {
        JOptionPane.showMessageDialog(new JFrame(), msg);
    }
}

