/*
 * Decompiled with CFR 0.152.
 */
package apkencrypttool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.zip.ZipError;

public class ApkEntUtils {
    public static final boolean isEntry = true;
    public static final String inFile = "C:\\Users\\Ryan\\Desktop\\src_zipalign.apk";
    public static final String outFile = "C:\\Users\\Ryan\\Desktop\\src_zipalign_entry.apk";
    private FileChannel ch;
    private FileChannel fc;

    public static void main(String[] args) throws IOException {
        new ApkEntUtils().ChangToEncryptedEntry(inFile, outFile);
    }

    public void FixEncryptedEntry(File inZip, File fixZip) throws IOException {
        this.changEntry(inZip, fixZip, true);
    }

    public void FixEncryptedEntry(String inZip, String fixZip) throws IOException {
        this.FixEncryptedEntry(new File(inZip), new File(fixZip));
    }

    public void ChangToEncryptedEntry(File inZip, File storeZip) throws IOException {
        this.changEntry(inZip, storeZip, false);
    }

    public void ChangToEncryptedEntry(String inZip, String storeZip) throws IOException {
        this.ChangToEncryptedEntry(new File(inZip), new File(storeZip));
    }

    private void changEntry(File inZip, File storeZip, boolean fix) throws IOException {
        int len;
        FileInputStream fis = new FileInputStream(inZip);
        FileOutputStream fos = new FileOutputStream(storeZip);
        byte[] buf = new byte[10240];
        while ((len = fis.read(buf)) != -1) {
            fos.write(buf, 0, len);
        }
        this.ch = fis.getChannel();
        this.fc = fos.getChannel();
        this.changEntry(fix);
        this.ch.close();
        this.fc.close();
        fis.close();
        fos.close();
    }

    private void changEntry(boolean fix) throws IOException {
        int pos;
        int clen;
        int elen;
        int nlen;
        byte[] cen;
        long cenpos;
        long locpos;
        END end = this.findEND();
        if (end.cenlen > end.endpos) {
            ApkEntUtils.zerror("invalid END header (bad central directory size)");
        }
        if ((locpos = (cenpos = end.endpos - end.cenlen) - end.cenoff) < 0L) {
            ApkEntUtils.zerror("invalid END header (bad central directory offset)");
        }
        if (this.readFullyAt(cen = new byte[(int)(end.cenlen + 22L)], 0, cen.length, cenpos) != end.cenlen + 22L) {
            ApkEntUtils.zerror("read CEN tables failed");
        }
        int limit = cen.length - 22;
        for (pos = 0; pos < limit; pos += 46 + nlen + elen + clen) {
            byte[] name;
            if (ZipConstants.CENSIG(cen, pos) != ZipConstants.CENSIG) {
                ApkEntUtils.zerror("invalid CEN header (bad signature)");
            }
            int method = ZipConstants.CENHOW(cen, pos);
            nlen = ZipConstants.CENNAM(cen, pos);
            elen = ZipConstants.CENEXT(cen, pos);
            clen = ZipConstants.CENCOM(cen, pos);
            if (fix) {
                if ((ZipConstants.CEN(cen, pos) & 1) != 0) {
                    name = Arrays.copyOfRange(cen, pos + 46, pos + 46 + nlen);
                    System.out.println("Found the encrypted entry : " + new String(name) + ", fix...");
                    int n = pos + 8;
                    cen[n] = (byte)(cen[n] & 0xFE);
                }
            } else if ((ZipConstants.CEN(cen, pos) & 1) == 0) {
                name = Arrays.copyOfRange(cen, pos + 46, pos + 46 + nlen);
                System.out.println("Chang the entry : " + new String(name) + ", Encrypted...");
                int n = pos + 8;
                cen[n] = (byte)(cen[n] | 1);
            }
            if (method != 0 && method != 8) {
                ApkEntUtils.zerror("invalid CEN header (unsupported compression method: " + method + ")");
            }
            if (pos + 46 + nlen <= limit) continue;
            ApkEntUtils.zerror("invalid CEN header (bad header size)");
        }
        this.writeFullyAt(cen, 0, cen.length, cenpos);
        if (pos + 22 != cen.length) {
            ApkEntUtils.zerror("invalid CEN header (bad header size)");
        }
    }

    final long readFullyAt(byte[] buf, int off, long len, long pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.position(off);
        bb.limit((int)((long)off + len));
        return this.readFullyAt(bb, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long readFullyAt(ByteBuffer bb, long pos) throws IOException {
        FileChannel fileChannel = this.ch;
        synchronized (fileChannel) {
            return this.ch.position(pos).read(bb);
        }
    }

    final long writeFullyAt(byte[] buf, int off, long len, long pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.position(off);
        bb.limit((int)((long)off + len));
        return this.writeFullyAt(bb, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long writeFullyAt(ByteBuffer bb, long pos) throws IOException {
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            return this.fc.position(pos).write(bb);
        }
    }

    private END findEND() throws IOException {
        byte[] buf = new byte[128];
        long ziplen = this.ch.size();
        long minHDR = ziplen - 65557L > 0L ? ziplen - 65557L : 0L;
        long minPos = minHDR - (long)(buf.length - 22);
        for (long pos = ziplen - (long)buf.length; pos >= minPos; pos -= (long)(buf.length - 22)) {
            int len;
            int off = 0;
            if (pos < 0L) {
                off = (int)(-pos);
                Arrays.fill(buf, 0, off, (byte)0);
            }
            if (this.readFullyAt(buf, off, len = buf.length - off, pos + (long)off) != (long)len) {
                ApkEntUtils.zerror("zip END header not found");
            }
            for (int i = buf.length - 22; i >= 0; --i) {
                if (buf[i + 0] != 80 || buf[i + 1] != 75 || buf[i + 2] != 5 || buf[i + 3] != 6 || pos + (long)i + 22L + (long)ZipConstants.ENDCOM(buf, i) != ziplen) continue;
                buf = Arrays.copyOfRange(buf, i, i + 22);
                END end = new END();
                end.endsub = ZipConstants.ENDSUB(buf);
                end.centot = ZipConstants.ENDTOT(buf);
                end.cenlen = ZipConstants.ENDSIZ(buf);
                end.cenoff = ZipConstants.ENDOFF(buf);
                end.comlen = ZipConstants.ENDCOM(buf);
                end.endpos = pos + (long)i;
                if (end.cenlen == 0xFFFFFFFFL || end.cenoff == 0xFFFFFFFFL || end.centot == 65535) {
                    byte[] loc64 = new byte[20];
                    if (this.readFullyAt(loc64, 0, loc64.length, end.endpos - 20L) != (long)loc64.length) {
                        return end;
                    }
                    byte[] end64buf = new byte[56];
                    long end64pos = ZipConstants.ZIP64_LOCOFF(loc64);
                    if (this.readFullyAt(end64buf, 0, end64buf.length, end64pos) != (long)end64buf.length) {
                        return end;
                    }
                    end.cenlen = ZipConstants.ZIP64_ENDSIZ(end64buf);
                    end.cenoff = ZipConstants.ZIP64_ENDOFF(end64buf);
                    end.centot = (int)ZipConstants.ZIP64_ENDTOT(end64buf);
                    end.endpos = end64pos;
                }
                return end;
            }
        }
        ApkEntUtils.zerror("zip END header not found");
        return null;
    }

    static void zerror(String msg) {
        throw new ZipError(msg);
    }

    static class ZipConstants {
        static final int METHOD_STORED = 0;
        static final int METHOD_DEFLATED = 8;
        static final int METHOD_DEFLATED64 = 9;
        static final int METHOD_BZIP2 = 12;
        static final int METHOD_LZMA = 14;
        static final int METHOD_LZ77 = 19;
        static final int METHOD_AES = 99;
        static final int FLAG_ENCRYPTED = 1;
        static final int FLAG_DATADESCR = 8;
        static final int FLAG_EFS = 2048;
        static long LOCSIG = 67324752L;
        static long EXTSIG = 134695760L;
        static long CENSIG = 33639248L;
        static long ENDSIG = 101010256L;
        static final int LOCHDR = 30;
        static final int EXTHDR = 16;
        static final int CENHDR = 46;
        static final int ENDHDR = 22;
        static final int LOCVER = 4;
        static final int LOC = 6;
        static final int LOCHOW = 8;
        static final int LOCTIM = 10;
        static final int LOCCRC = 14;
        static final int LOCSIZ = 18;
        static final int LOCLEN = 22;
        static final int LOCNAM = 26;
        static final int LOCEXT = 28;
        static final int EXTCRC = 4;
        static final int EXTSIZ = 8;
        static final int EXTLEN = 12;
        static final int CENVEM = 4;
        static final int CENVER = 6;
        static final int CEN = 8;
        static final int CENHOW = 10;
        static final int CENTIM = 12;
        static final int CENCRC = 16;
        static final int CENSIZ = 20;
        static final int CENLEN = 24;
        static final int CENNAM = 28;
        static final int CENEXT = 30;
        static final int CENCOM = 32;
        static final int CENDSK = 34;
        static final int CENATT = 36;
        static final int CENATX = 38;
        static final int CENOFF = 42;
        static final int ENDSUB = 8;
        static final int ENDTOT = 10;
        static final int ENDSIZ = 12;
        static final int ENDOFF = 16;
        static final int ENDCOM = 20;
        static final long ZIP64_ENDSIG = 101075792L;
        static final long ZIP64_LOCSIG = 117853008L;
        static final int ZIP64_ENDHDR = 56;
        static final int ZIP64_LOCHDR = 20;
        static final int ZIP64_EXTHDR = 24;
        static final int ZIP64_EXTID = 1;
        static final int ZIP64_MINVAL32 = 65535;
        static final long ZIP64_MINVAL = 0xFFFFFFFFL;
        static final int ZIP64_ENDLEN = 4;
        static final int ZIP64_ENDVEM = 12;
        static final int ZIP64_ENDVER = 14;
        static final int ZIP64_ENDNMD = 16;
        static final int ZIP64_ENDDSK = 20;
        static final int ZIP64_ENDTOD = 24;
        static final int ZIP64_ENDTOT = 32;
        static final int ZIP64_ENDSIZ = 40;
        static final int ZIP64_ENDOFF = 48;
        static final int ZIP64_ENDEXT = 56;
        static final int ZIP64_LOCDSK = 4;
        static final int ZIP64_LOCOFF = 8;
        static final int ZIP64_LOCTOT = 16;
        static final int ZIP64_EXTCRC = 4;
        static final int ZIP64_EXTSIZ = 8;
        static final int ZIP64_EXTLEN = 16;
        static final int EXTID_ZIP64 = 1;
        static final int EXTID_NTFS = 10;
        static final int EXTID_UNIX = 13;
        static final int EXTID_EFS = 23;
        static final int EXTID_EXTT = 21589;
        static final long END_MAXLEN = 65557L;
        static final int READBLOCKSZ = 128;

        ZipConstants() {
        }

        static final int CH(byte[] b, int n) {
            return b[n] & 0xFF;
        }

        static final int SH(byte[] b, int n) {
            return b[n] & 0xFF | (b[n + 1] & 0xFF) << 8;
        }

        static final long LG(byte[] b, int n) {
            return (long)(ZipConstants.SH(b, n) | ZipConstants.SH(b, n + 2) << 16) & 0xFFFFFFFFL;
        }

        static final long LL(byte[] b, int n) {
            return ZipConstants.LG(b, n) | ZipConstants.LG(b, n + 4) << 32;
        }

        static final long GETSIG(byte[] b) {
            return ZipConstants.LG(b, 0);
        }

        static final long LOCSIG(byte[] b) {
            return ZipConstants.LG(b, 0);
        }

        static final int LOCVER(byte[] b) {
            return ZipConstants.SH(b, 4);
        }

        static final int LOC(byte[] b) {
            return ZipConstants.SH(b, 6);
        }

        static final int LOCHOW(byte[] b) {
            return ZipConstants.SH(b, 8);
        }

        static final long LOCTIM(byte[] b) {
            return ZipConstants.LG(b, 10);
        }

        static final long LOCCRC(byte[] b) {
            return ZipConstants.LG(b, 14);
        }

        static final long LOCSIZ(byte[] b) {
            return ZipConstants.LG(b, 18);
        }

        static final long LOCLEN(byte[] b) {
            return ZipConstants.LG(b, 22);
        }

        static final int LOCNAM(byte[] b) {
            return ZipConstants.SH(b, 26);
        }

        static final int LOCEXT(byte[] b) {
            return ZipConstants.SH(b, 28);
        }

        static final long EXTCRC(byte[] b) {
            return ZipConstants.LG(b, 4);
        }

        static final long EXTSIZ(byte[] b) {
            return ZipConstants.LG(b, 8);
        }

        static final long EXTLEN(byte[] b) {
            return ZipConstants.LG(b, 12);
        }

        static final int ENDSUB(byte[] b) {
            return ZipConstants.SH(b, 8);
        }

        static final int ENDTOT(byte[] b) {
            return ZipConstants.SH(b, 10);
        }

        static final long ENDSIZ(byte[] b) {
            return ZipConstants.LG(b, 12);
        }

        static final long ENDOFF(byte[] b) {
            return ZipConstants.LG(b, 16);
        }

        static final int ENDCOM(byte[] b) {
            return ZipConstants.SH(b, 20);
        }

        static final int ENDCOM(byte[] b, int off) {
            return ZipConstants.SH(b, off + 20);
        }

        static final long ZIP64_ENDTOD(byte[] b) {
            return ZipConstants.LL(b, 24);
        }

        static final long ZIP64_ENDTOT(byte[] b) {
            return ZipConstants.LL(b, 32);
        }

        static final long ZIP64_ENDSIZ(byte[] b) {
            return ZipConstants.LL(b, 40);
        }

        static final long ZIP64_ENDOFF(byte[] b) {
            return ZipConstants.LL(b, 48);
        }

        static final long ZIP64_LOCOFF(byte[] b) {
            return ZipConstants.LL(b, 8);
        }

        static final long CENSIG(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 0);
        }

        static final int CENVEM(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 4);
        }

        static final int CENVER(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 6);
        }

        static final int CEN(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 8);
        }

        static final int CENHOW(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 10);
        }

        static final long CENTIM(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 12);
        }

        static final long CENCRC(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 16);
        }

        static final long CENSIZ(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 20);
        }

        static final long CENLEN(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 24);
        }

        static final int CENNAM(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 28);
        }

        static final int CENEXT(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 30);
        }

        static final int CENCOM(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 32);
        }

        static final int CENDSK(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 34);
        }

        static final int CENATT(byte[] b, int pos) {
            return ZipConstants.SH(b, pos + 36);
        }

        static final long CENATX(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 38);
        }

        static final long CENOFF(byte[] b, int pos) {
            return ZipConstants.LG(b, pos + 42);
        }
    }

    static class END {
        int disknum;
        int sdisknum;
        int endsub;
        int centot;
        long cenlen;
        long cenoff;
        int comlen;
        byte[] comment;
        int diskNum;
        long endpos;
        int disktot;

        END() {
        }

        public String toString() {
            return "disknum : " + this.disknum + "\n" + "sdisknum : " + this.sdisknum + "\n" + "endsub : " + this.endsub + "\n" + "centot : " + this.centot + "\n" + "cenlen : " + this.cenlen + "\n" + "cenoff : " + this.cenoff + "\n" + "comlen : " + this.comlen + "\n" + "diskNum : " + this.diskNum + "\n" + "endpos : " + this.endpos + "\n" + "disktot : " + this.disktot;
        }
    }
}

