--sp pangde
local taichen_skill={}
taichen_skill.name="taichen"
table.insert(sgs.ai_skills,taichen_skill)
taichen_skill.getTurnUseCard=function(self)
	if self.player:hasUsed("TaichenCard") then return end
	return sgs.Card_Parse("@TaichenCard=.")
end

sgs.ai_skill_use_func["TaichenCard"]=function(card,use,self)
	local target, card_str
	for _, friend in ipairs(self.friends_noself) do
		local judge_card = friend:getCards("j")
		local equip_card = friend:getCards("e")

		if judge_card and judge_card:length() > 0 and not (judge_card:length() == 1 and judge_card:at(0):objectName() == "lightning") then target = friend break end
		if equip_card and equip_card:length() > 1 and self:hasSkills(sgs.lose_equip_skill, friend) then target = friend break end
	end

	if not target then
		self:sort(self.enemies, "defense")
		for _, enemy in ipairs(self.enemies) do
			if enemy:getCards("he") and enemy:getCards("he"):length()>=2 then
				target = enemy
				break
			end
		end
	end

	if not target then return end

	local armor = self.player:getArmor()
	if armor then
		if armor:objectName() == "silver_lion" and self.player:isWounded() then card_str = "@TaichenCard=" .. armor:objectName():getId() end
	else
		local hand_card = self.player:getHandcards();
		local hand_armor = {}
		for _, card in sgs.qlist(hand_card) do
			if card:inherits("Armor") then table.insert(hand_armor, card) end
		end

		if #hand_armor > 0 then
			if self:hasSkills("bazhen|yizhong") then card_str = "@TaichenCard=" .. hand_armor:at(0):getId()
			else
				if #hand_armor > 1 then card_str = "@TaichenCard=" .. hand_armor:at(0):getId() end
			end
		else
			if self:isFriend(target) and self.player:getHp() > 2 then card_str = "@TaichenCard=."
			elseif self:isEnemy(target) and self.player:getHp() > 3 then card_str = "@TaichenCard=."
			end
		end
	end

	if card_str then
		if use.to then
			use.to:append(target)
		end
		use.card = sgs.Card_Parse(card_str)
	end
end

--shenlvbu2
sgs.ai_skill_invoke.xiuluo = function(self, data)
	local hand_card = self.player:getHandcards()
	local judge_list = self.player:getCards("j")
	for _, judge in sgs.qlist(judge_list) do
		for _, card in sgs.qlist(hand_card) do
			if card:getSuit() == judge:getSuit() then return true end
		end
	end

	return false
end

--gongsunzan
sgs.ai_skill_invoke.tianxian = function(self, data)
	local hand_card = self.player:getHandcards()
	local judge_list = self.player:getCards("j")
	for _, judge in sgs.qlist(judge_list) do
		for _, card in sgs.qlist(hand_card) do
			if card:getSuit() == judge:getSuit() then return true end
		end
	end

	return false
end

--wusangui
local touji_skill={}
touji_skill.name="touji"
table.insert(sgs.ai_skills,touji_skill)
touji_skill.getTurnUseCard=function(self,inclusive)
    local cards = self.player:getCards("he")
    cards=sgs.QList2Table(cards)

	local card

	self:sortByUseValue(cards,true)

	local has_weapon=false

	for _,acard in ipairs(cards)  do
	    if acard:inherits("Weapon") and not (acard:getSuit() == sgs.Card_Spade) then has_weapon=true end
	end

	for _,acard in ipairs(cards)  do
		if (acard:getSuit() == sgs.Card_Spade) and ((self:getUseValue(acard)<sgs.ai_use_value["Collateral"]) or inclusive) then
		    local shouldUse=true

		    if acard:inherits("Armor") then
                if not self.player:getArmor() then shouldUse=false
                elseif self:hasEquip(acard) then shouldUse=false
                end
            end

            if acard:inherits("Weapon") then
                if not self.player:getWeapon() then shouldUse=false
                elseif self:hasEquip(acard) and not has_weapon then shouldUse=false
                end
            end

		    if shouldUse then
			    card = acard
			    break
			end
		end
	end

    if not card then return end
	local number = card:getNumberString()
    local card_id = card:getEffectiveId()
	local card_str = ("collateral:touji[Spade:%s]=%d"):format(number, card_id)
	local collateral = sgs.Card_Parse(card_str)

    assert(collateral)

    return collateral
end
