package com.group_finity.mascot;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;

/**
 *
 * }XRbg̃XgǗA^C~OIuWFNg.
 * e}XRbg񓯊ɓƂ낢덢(EBhE𓊂鎞Ȃ)̂ŁÃNXŜ̃^C~O킹.
 * {@link #tick()} \bhA܂ŐV̊擾AꂩSẴ}XRbg𓮂B
 *
 * @author Yuki Yamada
 */
public class Manager {

	private static final Logger log = Logger.getLogger(Manager.class.getName());

	/**
	 * ^C}̎sԊu.
	 */
	public static final int TICK_INTERVAL = 40;

	/**
	 * }XRbg̈ꗗ.
	 */
	private final List<Mascot> mascots = new ArrayList<Mascot>();

	/**
	 * ǉ\̃}XRbg̃Xg.
	 * {@link ConcurrentModificationException} h߁A}XRbg̒ǉ {@link #tick()} Ƃɂɔf.
	 */
	private final Set<Mascot> added = new LinkedHashSet<Mascot>();

	/**
	 * ǉ\̃}XRbg̃Xg.
	 * {@link ConcurrentModificationException} h߁A}XRbg̍폜 {@link #tick()} Ƃɂɔf.
	 */
	private final Set<Mascot> removed = new LinkedHashSet<Mascot>();

	/**
	 * Ō̃}XRbg폜ɃvOIׂǂ.
	 * gCACR̍쐬ɎsȂǂ́A}XRbgȂȂvOIȂƁAvZXƎcĂ܂.
	 */
	private boolean exitOnLastRemoved;

	/**
	 * {@link #tick()}[vXbh.
	 */
	private transient Thread thread;

	public Manager() {

		//  Windows œ Java ̃oOC邽߂̏u
		// Z Thread.sleep pɂɌĂԂ Windows ̎v
		//  Thread.sleep ĂłƂ̖ł.
		new Thread() {
			{
				this.setDaemon(true);
				this.start();
			}

			@Override
			public void run() {
				while (true) {
					try {
						Thread.sleep(Integer.MAX_VALUE);
					} catch (final InterruptedException ex) {
					}
				}
			}
		};
	}

	/**
	 * XbhJn.
	 */
	public void start() {

		if ( thread!=null && thread.isAlive() ) {
			// XbhĂ
			return;
		}

		thread = new Thread() {
			@Override
			public void run() {

				// O̎
				long prev = System.nanoTime() / 1000000;
				try {
					for (;;) {
						for (;;) {
							// ݂̎
							// TICK_INTERVAL o܂Ń[v.
							final long cur = System.nanoTime() / 1000000;
							if (cur - prev >= TICK_INTERVAL) {
								if (cur > prev + TICK_INTERVAL * 2) {
									prev = cur;
								} else {
									prev += TICK_INTERVAL;
								}
								break;
							}
							Thread.sleep(1, 0);
						}

						// }XRbg𓮂.
						tick();
					}
				} catch (final InterruptedException e) {
					Thread.currentThread().interrupt();
				}
			}
		};
		thread.setDaemon(false);

		thread.start();
	}

	/**
	 * Xbh~.
	 */
	public void stop() {
		if ( thread==null || !thread.isAlive() ) {
			// ĂȂ
			return;
		}

		thread.interrupt();

		try {
			thread.join();
		} catch (InterruptedException e) {
			Thread.currentThread().interrupt();
		}
	}

	/**
	 * }XRbgt[i߂.
	 */
	private void tick() {

		// ܂XV
		NativeFactory.getInstance().getEnvironment().tick();

		synchronized (this.getMascots()) {

			// ǉׂ}XRbgǉ
			for (final Mascot mascot : this.getAdded()) {
				this.getMascots().add(mascot);
			}
			this.getAdded().clear();

			// 폜ׂ}XRbg폜
			for (final Mascot mascot : this.getRemoved()) {
				this.getMascots().remove(mascot);
			}
			this.getRemoved().clear();

			// }XRbg̎Ԃi߂
			for (final Mascot mascot : this.getMascots()) {
				mascot.tick();
			}

			// }XRbg̊GʒuŐVɂ.
			for (final Mascot mascot : this.getMascots()) {
				mascot.apply();
			}
		}

		if (isExitOnLastRemoved() && this.getMascots().size() == 0) {
			// exitOnLastRemoved  true Ń}XRbgCȂȂ̂ŏI.
			Main.getInstance().exit();
		}
	}

	/**
	 * }XRbgǉ.
	 * ǉ͎ {@link #tick()} ̃^C~Oōs.
	 * @param mascot ǉ}XRbg.
	 */
	public void add(final Mascot mascot) {
		synchronized (this.getAdded()) {
			this.getAdded().add(mascot);
			this.getRemoved().remove(mascot);
		}
		mascot.setManager(this);
	}

	/**
	 * }XRbg폜.
	 * 폜͎ {@link #tick()} ̃^C~Oōs.
	 * @param mascot 폜}XRbg.
	 */
	public void remove(final Mascot mascot) {
		synchronized (this.getAdded()) {
			this.getAdded().remove(mascot);
			this.getRemoved().add(mascot);
		}
		mascot.setManager(null);
	}

	/**
	 * SẴ}XRbg̍sݒ肷.
	 * @param configuration
	 * @param name
	 */
	public void setBehaviorAll(final Configuration configuration, final String name) {
		synchronized (this.getMascots()) {
			for (final Mascot mascot : this.getMascots()) {
				try {
					mascot.setBehavior(configuration.buildBehavior(name));
				} catch (final BehaviorInstantiationException e) {
					log.log(Level.SEVERE, "̍s̏Ɏs܂", e);
					mascot.dispose();
				} catch (final CantBeAliveException e) {
					log.log(Level.SEVERE, "邱ƂoȂ", e);
					mascot.dispose();
				}
			}
		}
	}

	/**
	 * CcđSč폜.
	 */
	public void remainOne() {
		synchronized (this.getMascots()) {
			for (int i = this.getMascots().size() - 1; i > 0; --i) {
				this.getMascots().get(i).dispose();
			}
		}
	}

	/**
	 * Sč폜.
	 */
	public void disposeAll() {
		synchronized (this.getMascots()) {
			for (int i = this.getMascots().size() - 1; i >= 0; --i) {
				this.getMascots().get(i).dispose();
			}
		}
	}

	/**
	 * }XRbǧݐ擾.
	 * @return }XRbǧݐ.
	 */
	public int getCount() {
		synchronized (this.getMascots()) {
			return this.getMascots().size();
		}
	}

	public void setExitOnLastRemoved(boolean exitOnLastRemoved) {
		this.exitOnLastRemoved = exitOnLastRemoved;
	}

	public boolean isExitOnLastRemoved() {
		return exitOnLastRemoved;
	}

	private List<Mascot> getMascots() {
		return this.mascots;
	}

	private Set<Mascot> getAdded() {
		return this.added;
	}

	private Set<Mascot> getRemoved() {
		return this.removed;
	}

}
