/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSHotCopier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotCopy(FSFS srcOwner, File dstPath) throws SVNException {
        FSWriteLock dbLogsLock = FSWriteLock.getDBLogsLock(srcOwner, false);
        File srcPath = srcOwner.getRepositoryRoot();
        FSWriteLock fSWriteLock = dbLogsLock;
        synchronized (fSWriteLock) {
            try {
                dbLogsLock.lock();
                this.createRepositoryLayout(srcPath, dstPath);
                File dstReposLocksDir = new File(dstPath, "locks");
                try {
                    this.createReposDir(dstReposLocksDir);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage().wrap("Creating lock dir");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                this.createDBLock(dstReposLocksDir);
                this.createDBLogsLock(dstReposLocksDir);
                File dstDBDir = new File(dstPath, "db");
                dstDBDir.mkdirs();
                SVNFileUtil.setSGID(dstDBDir);
                FSFS dstOwner = new FSFS(dstPath);
                String fsType = srcOwner.getFSType();
                this.hotCopy(srcOwner, dstOwner);
                this.writeFSType(dstOwner, fsType);
                SVNFileUtil.writeVersionFile(new File(dstPath, "format"), srcOwner.getReposFormat());
            }
            finally {
                dbLogsLock.unlock();
                FSWriteLock.release(dbLogsLock);
            }
        }
    }

    private void writeFSType(FSFS dstOwner, String fsType) throws SVNException {
        block5: {
            OutputStream fsTypeStream = null;
            try {
                try {
                    fsTypeStream = SVNFileUtil.openFileForWriting(dstOwner.getFSTypeFile());
                    fsType = String.valueOf(fsType) + '\n';
                    fsTypeStream.write(fsType.getBytes("US-ASCII"));
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(fsTypeStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(fsTypeStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(fsTypeStream);
        }
    }

    private void createRepositoryLayout(File srcPath, File dstPath) throws SVNException {
        File[] children = srcPath.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String childName = child.getName();
            if (!(childName.equals("db") || childName.equals("locks") || childName.equals("format"))) {
                File dstChildPath = new File(dstPath, childName);
                if (child.isDirectory()) {
                    this.createReposDir(dstChildPath);
                    this.createRepositoryLayout(child, dstChildPath);
                } else if (child.isFile()) {
                    SVNFileUtil.copyFile(child, dstChildPath, true);
                }
            }
            ++i;
        }
    }

    private void createReposDir(File dir) throws SVNException {
        if (dir.exists()) {
            File[] dstChildren = dir.listFiles();
            if (dstChildren.length > 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.DIR_NOT_EMPTY, "''{0}'' exists and is non-empty", dir);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        } else {
            dir.mkdirs();
        }
    }

    private void createDBLock(File dstPath) throws SVNException {
        try {
            SVNFileUtil.createFile(new File(dstPath, "db.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Creating db lock file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    private void createDBLogsLock(File dstPath) throws SVNException {
        try {
            SVNFileUtil.createFile(new File(dstPath, "db-logs.lock"), "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.", "US-ASCII");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Creating db logs lock file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    private void hotCopy(FSFS srcOwner, FSFS dstOwner) throws SVNException {
        File srcNodeOriginsDir;
        File srcLocksDir;
        int format = srcOwner.readDBFormat();
        FSRepositoryUtil.checkReposDBForma(format);
        SVNFileUtil.copyFile(srcOwner.getCurrentFile(), dstOwner.getCurrentFile(), true);
        SVNFileUtil.copyFile(srcOwner.getUUIDFile(), dstOwner.getUUIDFile(), true);
        long youngestRev = dstOwner.getYoungestRevision();
        File dstRevsDir = dstOwner.getDBRevsDir();
        dstRevsDir.mkdirs();
        long maxFilesPerDirectory = srcOwner.getMaxFilesPerDirectory();
        long rev = 0L;
        while (rev <= youngestRev) {
            File dstDir = dstRevsDir;
            if (maxFilesPerDirectory > 0L) {
                String shard = String.valueOf(rev / maxFilesPerDirectory);
                dstDir = new File(dstRevsDir, shard);
            }
            SVNFileUtil.copyFile(srcOwner.getRevisionFile(rev), new File(dstDir, String.valueOf(rev)), true);
            ++rev;
        }
        File dstRevPropsDir = dstOwner.getRevisionPropertiesRoot();
        long rev2 = 0L;
        while (rev2 <= youngestRev) {
            File dstDir = dstRevPropsDir;
            if (maxFilesPerDirectory > 0L) {
                String shard = String.valueOf(rev2 / maxFilesPerDirectory);
                dstDir = new File(dstRevPropsDir, shard);
            }
            SVNFileUtil.copyFile(srcOwner.getRevisionPropertiesFile(rev2), new File(dstDir, String.valueOf(rev2)), true);
            ++rev2;
        }
        dstOwner.getTransactionsParentDir().mkdirs();
        if (format >= 3) {
            dstOwner.getTransactionProtoRevsDir().mkdirs();
        }
        if ((srcLocksDir = srcOwner.getDBLocksDir()).exists()) {
            SVNFileUtil.copyDirectory(srcLocksDir, dstOwner.getDBLocksDir(), false, null);
        }
        if ((srcNodeOriginsDir = srcOwner.getNodeOriginsDir()).exists()) {
            SVNFileUtil.copyDirectory(srcNodeOriginsDir, dstOwner.getNodeOriginsDir(), false, null);
        }
        if (format >= 3) {
            SVNFileUtil.copyFile(srcOwner.getTransactionCurrentFile(), dstOwner.getTransactionCurrentFile(), true);
        }
        dstOwner.writeDBFormat(format, maxFilesPerDirectory, false);
    }
}

