/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

public class FSRepresentation {
    public static final String REP_DELTA = "DELTA";
    public static final String REP_PLAIN = "PLAIN";
    public static final String REP_TRAILER = "ENDREP";
    private long myRevision;
    private long myOffset;
    private long mySize;
    private long myExpandedSize;
    private String myHexDigest;
    private String myTxnId;

    public FSRepresentation(long revision, long offset, long size, long expandedSize, String hexDigest) {
        this.myRevision = revision;
        this.myOffset = offset;
        this.mySize = size;
        this.myExpandedSize = expandedSize;
        this.myHexDigest = hexDigest;
    }

    public FSRepresentation(FSRepresentation representation) {
        this.myRevision = representation.getRevision();
        this.myOffset = representation.getOffset();
        this.mySize = representation.getSize();
        this.myExpandedSize = representation.getExpandedSize();
        this.myHexDigest = representation.getHexDigest();
        this.myTxnId = representation.myTxnId;
    }

    public FSRepresentation() {
        this.myRevision = -1L;
        this.myOffset = -1L;
        this.mySize = -1L;
        this.myExpandedSize = -1L;
        this.myHexDigest = null;
    }

    public void setRevision(long rev) {
        this.myRevision = rev;
    }

    public void setOffset(long offset) {
        this.myOffset = offset;
    }

    public void setSize(long size) {
        this.mySize = size;
    }

    public void setExpandedSize(long expandedSize) {
        this.myExpandedSize = expandedSize;
    }

    public void setHexDigest(String hexDigest) {
        this.myHexDigest = hexDigest;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public long getSize() {
        return this.mySize;
    }

    public long getExpandedSize() {
        return this.myExpandedSize;
    }

    public String getHexDigest() {
        return this.myHexDigest;
    }

    public static boolean compareRepresentations(FSRepresentation r1, FSRepresentation r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != FSRepresentation.class) {
            return false;
        }
        FSRepresentation rep = (FSRepresentation)obj;
        return this.myRevision == rep.getRevision() && this.myOffset == rep.getOffset();
    }

    public String toString() {
        return String.valueOf(this.myRevision) + " " + this.myOffset + " " + this.mySize + " " + this.myExpandedSize + " " + this.myHexDigest;
    }

    public String getTxnId() {
        return this.myTxnId;
    }

    public void setTxnId(String txnId) {
        this.myTxnId = txnId;
    }

    public boolean isTxn() {
        return this.myTxnId != null;
    }
}

