/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHSession;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHConnector
implements ISVNConnector {
    private static final String SVNSERVE_COMMAND = "svnserve -t";
    private static final String SVNSERVE_COMMAND_WITH_USER_NAME = "svnserve -t --tunnel-user ";
    private Session mySession;
    private InputStream myInputStream;
    private OutputStream myOutputStream;
    private SVNSSHSession.SSHConnectionInfo myConnection;
    private boolean myIsUseSessionPing;
    private boolean myIsUseConnectionPing;

    public SVNSSHConnector() {
        this(true, true);
    }

    public SVNSSHConnector(boolean useConnectionPing, boolean useSessionPing) {
        this.myIsUseConnectionPing = useConnectionPing;
        this.myIsUseSessionPing = useSessionPing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(SVNRepositoryImpl repository) throws SVNException {
        ISVNAuthenticationManager authManager = repository.getAuthenticationManager();
        if (authManager == null) {
            SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", repository.getLocation());
            return;
        }
        String realm = String.valueOf(repository.getLocation().getProtocol()) + "://" + repository.getLocation().getHost();
        if (repository.getLocation().hasPort()) {
            realm = String.valueOf(realm) + ":" + repository.getLocation().getPort();
        }
        if (repository.getLocation().getUserInfo() != null && !"".equals(repository.getLocation().getUserInfo())) {
            realm = String.valueOf(repository.getLocation().getUserInfo()) + "@" + realm;
        }
        int reconnect = 1;
        while (true) {
            SVNErrorMessage err;
            SVNSSHAuthentication authentication = (SVNSSHAuthentication)authManager.getFirstAuthentication("svn.ssh", realm, repository.getLocation());
            SVNSSHSession.SSHConnectionInfo connection = null;
            SVNSSHSession.lock(Thread.currentThread());
            while (authentication != null) {
                try {
                    connection = SVNSSHSession.getConnection(repository.getLocation(), authentication, authManager.getConnectTimeout(repository), this.myIsUseConnectionPing);
                    if (connection == null) {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}''", repository.getLocation().setPath("", false));
                        SVNErrorManager.error(err2, SVNLogType.NETWORK);
                    }
                    authManager.acknowledgeAuthentication(true, "svn.ssh", realm, null, authentication);
                    break;
                }
                catch (SVNAuthenticationException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                    authManager.acknowledgeAuthentication(false, "svn.ssh", realm, e.getErrorMessage(), authentication);
                    authentication = (SVNSSHAuthentication)authManager.getNextAuthentication("svn.ssh", realm, repository.getLocation());
                    connection = null;
                }
            }
            if (authentication == null) {
                SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
            } else if (connection == null) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Can not establish connection to ''{0}''", realm), SVNLogType.NETWORK);
            }
            try {
                String userName;
                this.mySession = connection.openSession();
                SVNAuthentication author = authManager.getFirstAuthentication("svn.username", realm, repository.getLocation());
                if (author == null) {
                    SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
                }
                if ((userName = author.getUserName()) == null || "".equals(userName.trim())) {
                    userName = authentication.getUserName();
                }
                if (author.getUserName() == null || author.getUserName().equals(authentication.getUserName()) || "".equals(author.getUserName())) {
                    repository.setExternalUserName("");
                } else {
                    repository.setExternalUserName(author.getUserName());
                }
                author = new SVNUserNameAuthentication(userName, author.isStorageAllowed());
                authManager.acknowledgeAuthentication(true, "svn.username", realm, null, author);
                if ("".equals(repository.getExternalUserName())) {
                    this.mySession.execCommand(SVNSERVE_COMMAND);
                } else {
                    this.mySession.execCommand("svnserve -t --tunnel-user \"" + repository.getExternalUserName() + "\"");
                }
                this.myOutputStream = this.mySession.getStdin();
                this.myOutputStream = new BufferedOutputStream(this.myOutputStream, 16384);
                this.myInputStream = this.mySession.getStdout();
                this.myInputStream = new BufferedInputStream(this.myInputStream, 16384);
                new StreamGobbler(this.mySession.getStderr());
                this.myConnection = connection;
            }
            catch (SocketTimeoutException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "timed out waiting for server", null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (UnknownHostException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "Unknown host " + e.getMessage(), null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (ConnectException e) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "connection refused by the server", null, 0, e);
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            catch (IOException e) {
                if (--reconnect >= 0) {
                    connection.closeSession(this.mySession);
                    continue;
                }
                repository.getDebugLog().logFine(SVNLogType.NETWORK, e);
                this.close(repository);
                err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", new Object[]{repository.getLocation().setPath("", false), e.getMessage()});
                SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                continue;
            }
            break;
        }
        SVNSSHSession.unlock();
    }

    public void close(SVNRepositoryImpl repository) throws SVNException {
        SVNFileUtil.closeFile(this.myOutputStream);
        SVNFileUtil.closeFile(this.myInputStream);
        if (this.mySession != null) {
            SVNSSHSession.lock(Thread.currentThread());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, Thread.currentThread() + ": ABOUT TO CLOSE SESSION IN : " + this.myConnection);
            try {
                if (this.myConnection != null && this.myConnection.closeSession(this.mySession)) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, Thread.currentThread() + ": ABOUT TO CLOSE CONNECTION: " + this.myConnection);
                    SVNSSHSession.closeConnection(this.myConnection);
                    this.myConnection = null;
                }
            }
            finally {
                SVNSSHSession.unlock();
            }
        }
        this.mySession = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.mySession != null && !this.isStale();
    }

    public boolean isStale() {
        if (this.mySession == null) {
            return true;
        }
        if (this.myConnection == null || this.myConnection.isDisposed()) {
            return true;
        }
        if (!this.myIsUseSessionPing) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SKIPPING CHANNEL PING, IT HAS BEEN DISABLED");
            return false;
        }
        if (!this.myConnection.isSessionPingSupported()) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SKIPPING CHANNEL PING, IT IS NOT SUPPORTED");
            return false;
        }
        try {
            this.mySession.ping();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, Thread.currentThread() + ": DETECTED STALE SESSION : " + this.myConnection);
            return true;
        }
        return false;
    }
}

