/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNCharsetConvertor;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;

public class SVNCharsetInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private SVNCharsetConvertor myCharsetConvertor;
    private byte[] mySourceBuffer;
    private ByteBuffer myConvertedBuffer;
    private boolean myEndOfStream;

    public SVNCharsetInputStream(InputStream in, Charset inputCharset, Charset outputCharset) {
        super(in);
        this.myCharsetConvertor = new SVNCharsetConvertor(inputCharset.newDecoder(), outputCharset.newEncoder());
        this.mySourceBuffer = new byte[1024];
        this.myConvertedBuffer = ByteBuffer.allocate(1024);
        this.myEndOfStream = false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r < 0) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        available = this.myConvertedBuffer.position();
        if (!this.myEndOfStream || available != 0) ** GOTO lbl15
        return -1;
lbl-1000:
        // 1 sources

        {
            readed = this.fillBuffer();
            try {
                this.myConvertedBuffer = this.myCharsetConvertor.convertChunk(this.mySourceBuffer, 0, readed, this.myConvertedBuffer, this.myEndOfStream);
                if (!this.myEndOfStream) continue;
                this.myConvertedBuffer = this.myCharsetConvertor.flush(this.myConvertedBuffer);
                break;
            }
            catch (SVNException e) {
                throw new IOExceptionWrapper(e);
            }
            finally {
                available = this.myConvertedBuffer.position();
            }
lbl15:
            // 2 sources

            ** while (available < len)
        }
lbl16:
        // 2 sources

        this.myConvertedBuffer.flip();
        len = Math.min(this.myConvertedBuffer.remaining(), len);
        this.myConvertedBuffer = this.myConvertedBuffer.get(b, off, len);
        this.myConvertedBuffer = this.myConvertedBuffer.compact();
        return len;
    }

    private int fillBuffer() throws IOException {
        int readed = 0;
        while (readed < this.mySourceBuffer.length) {
            int r = this.in.read(this.mySourceBuffer, readed, this.mySourceBuffer.length - readed);
            if (r < 0) {
                this.myEndOfStream = true;
                break;
            }
            readed += r;
        }
        return readed;
    }
}

