/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEncodingUtil {
    private static final Map XML_UNESCAPE_MAP = new SVNHashMap();
    private static final byte[] uri_char_validity;

    static {
        XML_UNESCAPE_MAP.put("&amp;", "&");
        XML_UNESCAPE_MAP.put("&lt;", "<");
        XML_UNESCAPE_MAP.put("&gt;", ">");
        XML_UNESCAPE_MAP.put("&quot;", "\"");
        XML_UNESCAPE_MAP.put("&apos;", "'");
        XML_UNESCAPE_MAP.put("&#13;", "\r");
        XML_UNESCAPE_MAP.put("&#10;", "\n");
        XML_UNESCAPE_MAP.put("&#9;", "\t");
        byte[] byArray = new byte[256];
        byArray[33] = 1;
        byArray[36] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        byArray[40] = 1;
        byArray[41] = 1;
        byArray[42] = 1;
        byArray[43] = 1;
        byArray[44] = 1;
        byArray[45] = 1;
        byArray[46] = 1;
        byArray[47] = 1;
        byArray[48] = 1;
        byArray[49] = 1;
        byArray[50] = 1;
        byArray[51] = 1;
        byArray[52] = 1;
        byArray[53] = 1;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 1;
        byArray[61] = 1;
        byArray[64] = 1;
        byArray[65] = 1;
        byArray[66] = 1;
        byArray[67] = 1;
        byArray[68] = 1;
        byArray[69] = 1;
        byArray[70] = 1;
        byArray[71] = 1;
        byArray[72] = 1;
        byArray[73] = 1;
        byArray[74] = 1;
        byArray[75] = 1;
        byArray[76] = 1;
        byArray[77] = 1;
        byArray[78] = 1;
        byArray[79] = 1;
        byArray[80] = 1;
        byArray[81] = 1;
        byArray[82] = 1;
        byArray[83] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byArray[88] = 1;
        byArray[89] = 1;
        byArray[90] = 1;
        byArray[95] = 1;
        byArray[97] = 1;
        byArray[98] = 1;
        byArray[99] = 1;
        byArray[100] = 1;
        byArray[101] = 1;
        byArray[102] = 1;
        byArray[103] = 1;
        byArray[104] = 1;
        byArray[105] = 1;
        byArray[106] = 1;
        byArray[107] = 1;
        byArray[108] = 1;
        byArray[109] = 1;
        byArray[110] = 1;
        byArray[111] = 1;
        byArray[112] = 1;
        byArray[113] = 1;
        byArray[114] = 1;
        byArray[115] = 1;
        byArray[116] = 1;
        byArray[117] = 1;
        byArray[118] = 1;
        byArray[119] = 1;
        byArray[120] = 1;
        byArray[121] = 1;
        byArray[122] = 1;
        byArray[126] = 1;
        uri_char_validity = byArray;
    }

    public static String uriEncode(String src) {
        byte[] bytes;
        StringBuffer sb = null;
        try {
            bytes = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = src.getBytes();
        }
        int i = 0;
        while (i < bytes.length) {
            int index = bytes[i] & 0xFF;
            if (uri_char_validity[index] > 0) {
                if (sb != null) {
                    sb.append((char)bytes[i]);
                }
            } else {
                if (sb == null) {
                    sb = new StringBuffer();
                    try {
                        sb.append(new String(bytes, 0, i, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        sb.append(new String(bytes, 0, i));
                    }
                }
                sb.append("%");
                sb.append(Character.toUpperCase(Character.forDigit((index & 0xF0) >> 4, 16)));
                sb.append(Character.toUpperCase(Character.forDigit(index & 0xF, 16)));
            }
            ++i;
        }
        return sb == null ? src : sb.toString();
    }

    public static String autoURIEncode(String src) {
        byte[] bytes;
        StringBuffer sb = null;
        try {
            bytes = src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = src.getBytes();
        }
        int i = 0;
        while (i < bytes.length) {
            int index = bytes[i] & 0xFF;
            if (uri_char_validity[index] > 0) {
                if (sb != null) {
                    sb.append((char)bytes[i]);
                }
            } else if (index == 37 && i + 2 < bytes.length && SVNEncodingUtil.isHexDigit((char)bytes[i + 1]) && SVNEncodingUtil.isHexDigit((char)bytes[i + 2])) {
                if (sb != null) {
                    sb.append((char)bytes[i]);
                }
            } else {
                if (sb == null) {
                    sb = new StringBuffer();
                    try {
                        sb.append(new String(bytes, 0, i, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        sb.append(new String(bytes, 0, i));
                    }
                }
                sb.append("%");
                sb.append(Character.toUpperCase(Character.forDigit((index & 0xF0) >> 4, 16)));
                sb.append(Character.toUpperCase(Character.forDigit(index & 0xF, 16)));
            }
            ++i;
        }
        return sb == null ? src : sb.toString();
    }

    public static void assertURISafe(String path) throws SVNException {
        byte[] bytes;
        path = path == null ? "" : path;
        try {
            bytes = path.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' could not be encoded as UTF-8", path);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
            return;
        }
        if (bytes == null || bytes.length != path.length()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path", path);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        int i = 0;
        while (i < bytes.length) {
            if (uri_char_validity[bytes[i]] <= 0 && bytes[i] != 37) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path; character ''{1}'' is URI unsafe", new Object[]{path, String.valueOf((char)bytes[i])});
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            ++i;
        }
    }

    public static String uriDecode(String src) {
        boolean query = false;
        boolean decoded = false;
        int length = src.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        int i = 0;
        while (i < length) {
            int ch = src.charAt(i);
            if (ch == 63) {
                query = true;
            } else if (ch == 43 && query) {
                ch = 32;
            } else if (ch == 37 && i + 2 < length && SVNEncodingUtil.isHexDigit(src.charAt(i + 1)) && SVNEncodingUtil.isHexDigit(src.charAt(i + 2))) {
                ch = (byte)(SVNEncodingUtil.hexValue(src.charAt(i + 1)) * 16 + SVNEncodingUtil.hexValue(src.charAt(i + 2)));
                decoded = true;
                i += 2;
            }
            bos.write(ch);
            ++i;
        }
        if (!decoded) {
            return src;
        }
        try {
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return src;
        }
    }

    public static String xmlEncodeCDATA(String src) {
        StringBuffer sb = null;
        int i = 0;
        while (i < src.length()) {
            char ch = src.charAt(i);
            switch (ch) {
                case '&': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&gt;");
                    break;
                }
                case '\r': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#13;");
                    break;
                }
                default: {
                    if (sb == null) break;
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb != null ? sb.toString() : src;
    }

    public static String xmlEncodeAttr(String src) {
        StringBuffer sb = new StringBuffer(src.length());
        int i = 0;
        while (i < src.length()) {
            char ch = src.charAt(i);
            switch (ch) {
                case '&': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&quot;");
                    break;
                }
                case '\r': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#13;");
                    break;
                }
                case '\n': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#10;");
                    break;
                }
                case '\t': {
                    if (sb == null) {
                        sb = SVNEncodingUtil.createStringBuffer(src, i);
                    }
                    sb.append("&#9;");
                    break;
                }
                default: {
                    if (sb == null) break;
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb != null ? sb.toString() : src;
    }

    public static boolean isXMLSafe(String value) {
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch < ' ' && ch != '\n' && ch != '\r' && ch != '\t' && ch != '\b') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String xmlDecode(String value) {
        StringBuffer result = new StringBuffer(value.length());
        int l = value.length();
        int i = 0;
        while (i < l) {
            block7: {
                char ch;
                block6: {
                    ch = value.charAt(i);
                    if (ch != '&') break block6;
                    String replacement = null;
                    int j = i + 1;
                    while (j < i + 6 && j < l) {
                        if (value.charAt(j) == ';' && j - i > 1) {
                            String escape = value.substring(i, j + 1);
                            replacement = (String)XML_UNESCAPE_MAP.get(escape);
                            if (replacement == null) break;
                            result.append(replacement);
                            i = j;
                            break;
                        }
                        ++j;
                    }
                    if (replacement != null) break block7;
                }
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String fuzzyEscape(String str) {
        byte[] bytes = str.getBytes();
        StringBuffer result = SVNEncodingUtil.createStringBuffer(str, 0);
        int i = 0;
        while (i < bytes.length) {
            if (!SVNEncodingUtil.isASCIIControlChar((char)bytes[i]) || bytes[i] == 13 || bytes[i] == 10 || bytes[i] == 9) {
                result.append((char)bytes[i]);
            } else {
                result.append("?\\");
                int code = bytes[i] & 0xFF;
                if (code < 100) {
                    result.append('0');
                }
                result.append(code);
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isHexDigit(char ch) {
        return Character.isDigit(ch) || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    public static boolean isASCIIControlChar(char ch) {
        return ch >= '\u0000' && ch <= '\u001f' || ch == '\u007f';
    }

    private static int hexValue(char ch) {
        if (Character.isDigit(ch)) {
            return ch - 48;
        }
        ch = Character.toUpperCase(ch);
        return ch - 65 + 10;
    }

    private static StringBuffer createStringBuffer(String src, int length) {
        StringBuffer sb = new StringBuffer(src.length());
        sb.append(src.toCharArray(), 0, length);
        return sb;
    }
}

