/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class SVNLogInputStream
extends InputStream {
    private OutputStream myLog;
    private InputStream myIn;

    public SVNLogInputStream(InputStream in, ISVNDebugLog log) {
        this.myIn = in;
        this.myLog = log.createInputLogStream();
        if (this.myLog == null) {
            this.myLog = SVNFileUtil.DUMMY_OUT;
        }
    }

    public long skip(long n) throws IOException {
        return this.myIn.skip(n);
    }

    public void close() throws IOException {
        try {
            this.myIn.close();
        }
        finally {
            try {
                this.myLog.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.myIn.read(b, off, len);
        if (read > 0) {
            try {
                this.myLog.write(b, off, read);
            }
            catch (IOException iOException) {}
        }
        return read;
    }

    public int read() throws IOException {
        int read = this.myIn.read();
        try {
            if (read >= 0) {
                this.myLog.write(read & 0xFF);
            }
        }
        catch (IOException iOException) {}
        return read;
    }

    public void flushBuffer() {
        try {
            this.myLog.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

