/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class SVNLogOutputStream
extends OutputStream {
    private OutputStream myOut;
    private OutputStream myLog;

    public SVNLogOutputStream(OutputStream out, ISVNDebugLog log) {
        this.myOut = out;
        this.myLog = log.createOutputLogStream();
        if (this.myLog == null) {
            this.myLog = SVNFileUtil.DUMMY_OUT;
        }
    }

    public void close() throws IOException {
        try {
            this.myOut.close();
        }
        finally {
            try {
                this.myLog.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void flush() throws IOException {
        try {
            this.myOut.flush();
        }
        finally {
            try {
                this.myLog.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myOut.write(b, off, len);
        }
        finally {
            try {
                this.myLog.write(b, off, len);
            }
            catch (IOException iOException) {}
        }
    }

    public void write(int b) throws IOException {
        try {
            this.myOut.write(b);
        }
        finally {
            try {
                this.myLog.write(b);
            }
            catch (IOException iOException) {}
        }
    }

    public void flushBuffer() {
        try {
            this.myLog.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

