/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPathUtil {
    public static final Comparator PATH_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getClass() != String.class || o2.getClass() != String.class) {
                return o1.getClass() == o2.getClass() ? 0 : (o1.getClass() == String.class ? 1 : -1);
            }
            String p1 = (String)o1;
            String p2 = (String)o2;
            return p1.replace('/', '\u0000').compareTo(p2.replace('/', '\u0000'));
        }
    };

    public static boolean isCanonical(String path) {
        return path != null && path.equals(SVNPathUtil.canonicalizePath(path));
    }

    public static void checkPathIsValid(String path) throws SVNException {
        int i = 0;
        while (i < path.length()) {
            char ch = path.charAt(i);
            if (SVNEncodingUtil.isASCIIControlChar(ch)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character ''{0}'' in path ''{1}''", new String[]{"0x" + SVNFormatUtil.getHexNumberFromByte((byte)ch), path});
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            ++i;
        }
    }

    public static String getAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0 || "/".equals(path)) {
            return "/";
        }
        if (SVNPathUtil.isURL(path)) {
            return path;
        }
        path = path.endsWith("/") ? path.substring(0, path.length() - "/".length()) : path;
        return path.startsWith("/") ? path : "/" + path;
    }

    public static String validateFilePath(String path) {
        path = path.replace(File.separatorChar, '/');
        StringBuffer result = new StringBuffer();
        LinkedList<String> segments = new LinkedList<String>();
        Object tokens = new StringTokenizer(path, "/", false);
        while (((StringTokenizer)tokens).hasMoreTokens()) {
            String segment = ((StringTokenizer)tokens).nextToken();
            if ("..".equals(segment)) {
                if (!segments.isEmpty()) {
                    segments.remove(segments.size() - 1);
                    continue;
                }
                File root = new File(System.getProperty("user.dir"));
                while (root.getParentFile() != null) {
                    segments.add(0, root.getParentFile().getName());
                    root = root.getParentFile();
                }
                continue;
            }
            if (".".equals(segment) || segment.length() == 0) continue;
            segments.add(segment);
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result.append("/");
        }
        if (path.length() > 1 && path.charAt(1) == '/') {
            result.append("/");
        }
        tokens = segments.iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            result.append(token);
            if (!tokens.hasNext()) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static String canonicalizePath(String path) {
        if (path == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/' || path.charAt(i) == ':') break;
            ++i;
        }
        String scheme = null;
        int index = 0;
        if (i > 0 && i + 2 < path.length() && path.charAt(i) == ':' && path.charAt(i + 1) == '/' && path.charAt(i + 2) == '/') {
            scheme = path.substring(0, i + 3);
            result.append(scheme);
            index = i + 3;
        }
        if (index < path.length() && path.charAt(index) == '/') {
            result.append('/');
            if (SVNFileUtil.isWindows && scheme == null && ++index < path.length() && path.charAt(index) == '/') {
                result.append('/');
                ++index;
            }
        }
        int segmentCount = 0;
        while (index < path.length()) {
            int nextIndex = index;
            while (nextIndex < path.length() && path.charAt(nextIndex) != '/') {
                ++nextIndex;
            }
            int segmentLength = nextIndex - index;
            if (segmentLength != 0 && (segmentLength != 1 || path.charAt(index) != '.')) {
                if (nextIndex < path.length()) {
                    ++segmentLength;
                }
                result.append(path.substring(index, index + segmentLength));
                ++segmentCount;
            }
            if ((index = nextIndex) >= path.length()) continue;
            ++index;
        }
        if ((segmentCount > 0 || scheme != null) && result.charAt(result.length() - 1) == '/') {
            result = result.delete(result.length() - 1, result.length());
        }
        if (SVNFileUtil.isWindows && segmentCount < 2 && result.length() >= 2 && result.charAt(0) == '/' && result.charAt(1) == '/') {
            result = result.delete(0, 1);
        }
        return result.toString();
    }

    public static String canonicalizeAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        if ("".equals(path)) {
            return "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        StringBuffer canonicalizedPath = new StringBuffer();
        boolean skipSlashes = false;
        int i = 0;
        while (i < path.length()) {
            block7: {
                char ch;
                block8: {
                    block6: {
                        ch = path.charAt(i);
                        if (ch != '/') break block6;
                        if (skipSlashes) break block7;
                        skipSlashes = true;
                        break block8;
                    }
                    if (skipSlashes) {
                        skipSlashes = false;
                    }
                }
                canonicalizedPath.append(ch);
            }
            ++i;
        }
        if (canonicalizedPath.length() > 1 && canonicalizedPath.charAt(canonicalizedPath.length() - 1) == '/') {
            canonicalizedPath.deleteCharAt(canonicalizedPath.length() - 1);
        }
        return canonicalizedPath.toString();
    }

    public static String append(String f, String s) {
        char ch;
        f = f == null ? "" : f;
        s = s == null ? "" : s;
        int l1 = f.length();
        int l2 = s.length();
        char[] r = new char[l1 + l2 + 2];
        int index = 0;
        int i = 0;
        while (i < l1) {
            ch = f.charAt(i);
            if (i + 1 == l1 && ch == '/') break;
            r[index++] = ch;
            ++i;
        }
        i = 0;
        while (i < l2) {
            ch = s.charAt(i);
            if (i == 0 && ch != '/' && index > 0) {
                r[index++] = 47;
            }
            if (i + 1 == l2 && ch == '/') break;
            r[index++] = ch;
            ++i;
        }
        return new String(r, 0, index);
    }

    public static boolean isSinglePathComponent(String name) {
        if (name == null || "".equals(name) || "..".equals(name)) {
            return true;
        }
        return name.indexOf(47) == -1;
    }

    public static String head(String path) {
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                return path.substring(0, i);
            }
            ++i;
        }
        return path;
    }

    public static String removeHead(String path) {
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                int ind = i;
                while (ind < path.length()) {
                    if (path.charAt(ind) != '/') break;
                    ++ind;
                }
                return path.substring(ind);
            }
            ++i;
        }
        return "";
    }

    public static String tail(String path) {
        int index = path.length() - 1;
        if (index >= 0 && index < path.length() && path.charAt(index) == '/') {
            --index;
        }
        int i = index;
        while (i >= 0) {
            if (path.charAt(i) == '/') {
                return path.substring(i + 1, index + 1);
            }
            --i;
        }
        return path;
    }

    public static String removeTail(String path) {
        int index = path.length() - 1;
        while (index >= 0) {
            if (path.charAt(index) == '/') {
                return path.substring(0, index);
            }
            --index;
        }
        return "";
    }

    public static String getCommonPathAncestor(String path1, String path2) {
        if (path1 == null || path2 == null) {
            return null;
        }
        path1 = path1.replace(File.separatorChar, '/');
        path2 = path2.replace(File.separatorChar, '/');
        int index = 0;
        int separatorIndex = 0;
        while (index < path1.length() && index < path2.length()) {
            if (path1.charAt(index) != path2.charAt(index)) break;
            if (path1.charAt(index) == '/') {
                separatorIndex = index;
            }
            ++index;
        }
        if (index == path1.length() && index == path2.length()) {
            return path1;
        }
        if (index == path1.length() && path2.charAt(index) == '/') {
            return path1;
        }
        if (index == path2.length() && path1.charAt(index) == '/') {
            return path2;
        }
        return path1.substring(0, separatorIndex);
    }

    public static String condencePaths(String[] paths, Collection condencedPaths, boolean removeRedundantPaths) {
        String path;
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length == 1) {
            return paths[0];
        }
        String rootPath = paths[0];
        int i = 0;
        while (i < paths.length) {
            String url = paths[i];
            rootPath = SVNPathUtil.getCommonPathAncestor(rootPath, url);
            ++i;
        }
        if (condencedPaths != null && removeRedundantPaths) {
            i = 0;
            while (i < paths.length) {
                String path1 = paths[i];
                if (path1 != null) {
                    int j = 0;
                    while (j < paths.length) {
                        String common;
                        String path2;
                        if (i != j && (path2 = paths[j]) != null && !"".equals(common = SVNPathUtil.getCommonPathAncestor(path1, path2)) && common != null) {
                            if (common.equals(path1)) {
                                paths[j] = null;
                            } else if (common.equals(path2)) {
                                paths[i] = null;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < paths.length) {
                path = paths[j];
                if (path != null && path.equals(rootPath)) {
                    paths[j] = null;
                }
                ++j;
            }
        }
        if (condencedPaths != null) {
            i = 0;
            while (i < paths.length) {
                path = paths[i];
                if (path != null) {
                    if (rootPath != null && !"".equals(rootPath) && (path = path.substring(rootPath.length())).startsWith("/")) {
                        path = path.substring(1);
                    }
                    condencedPaths.add(path);
                }
                ++i;
            }
        }
        return rootPath;
    }

    public static int getSegmentsCount(String path) {
        int count = path.length() > 0 ? 1 : 0;
        int i = 1;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean isAncestor(String parentPath, String ancestorPath) {
        parentPath = parentPath == null ? "" : parentPath;
        String string = ancestorPath = ancestorPath == null ? "" : ancestorPath;
        if (parentPath.length() == 0) {
            return !ancestorPath.startsWith("/");
        }
        if (ancestorPath.startsWith(parentPath)) {
            if (parentPath.length() != ancestorPath.length() && !parentPath.endsWith("/") && ancestorPath.charAt(parentPath.length()) != '/') {
                if (parentPath.startsWith("file://") && ancestorPath.startsWith("file://")) {
                    String encodedSlash = SVNEncodingUtil.uriEncode("\\");
                    return parentPath.endsWith(encodedSlash) || ancestorPath.substring(parentPath.length()).startsWith(encodedSlash);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getPathAsChild(String path, String pathChild) {
        if (path == null || pathChild == null) {
            return null;
        }
        if (pathChild.compareTo(path) == 0) {
            return null;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        if (pathChild.startsWith(path)) {
            return pathChild.substring(path.length());
        }
        return null;
    }

    public static String getRelativePath(String parent, String child) {
        String relativePath = SVNPathUtil.getPathAsChild(parent = parent.replace(File.separatorChar, '/'), child = child.replace(File.separatorChar, '/'));
        return relativePath == null ? "" : relativePath;
    }

    public static boolean isURL(String pathOrUrl) {
        String string = pathOrUrl = pathOrUrl != null ? pathOrUrl.toLowerCase() : null;
        return pathOrUrl != null && (pathOrUrl.startsWith("http://") || pathOrUrl.startsWith("https://") || pathOrUrl.startsWith("svn://") || pathOrUrl.startsWith("svn+") && pathOrUrl.indexOf("://") > 4 || pathOrUrl.startsWith("file://"));
    }

    public static boolean isWithinBasePath(String basePath, String path) {
        return "".equals(basePath) || path.startsWith(basePath) && (path.length() == basePath.length() || path.charAt(basePath.length()) == '/');
    }
}

