/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNXMLUtil {
    public static final Map PREFIX_MAP = new SVNHashMap();
    public static final String DAV_NAMESPACE_PREFIX = "D";
    public static final String SVN_NAMESPACE_PREFIX = "S";
    public static final String SVN_DAV_PROPERTY_PREFIX = "SD";
    public static final String SVN_CUSTOM_PROPERTY_PREFIX = "SC";
    public static final String SVN_SVN_PROPERTY_PREFIX = "SS";
    public static final String SVN_APACHE_PROPERTY_PREFIX = "SA";
    private static final String FULL_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String DEFAULT_XML_HEADER = "<?xml version=\"1.0\"?>\n";
    public static final int XML_STYLE_NORMAL = 1;
    public static final int XML_STYLE_PROTECT_CDATA = 2;
    public static final int XML_STYLE_SELF_CLOSING = 4;
    public static final int XML_STYLE_ATTRIBUTE_BREAKS_LINE = 8;

    static {
        PREFIX_MAP.put("DAV:", DAV_NAMESPACE_PREFIX);
        PREFIX_MAP.put("svn:", SVN_NAMESPACE_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/dav/", SVN_DAV_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/svn/", SVN_SVN_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/custom/", SVN_CUSTOM_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://apache.org/dav/xmlns", SVN_APACHE_PROPERTY_PREFIX);
    }

    public static StringBuffer addXMLHeader(StringBuffer target, boolean addUTFAttribute) {
        target = target == null ? new StringBuffer() : target;
        target.append(addUTFAttribute ? FULL_XML_HEADER : DEFAULT_XML_HEADER);
        return target;
    }

    public static StringBuffer addXMLHeader(StringBuffer target) {
        return SVNXMLUtil.addXMLHeader(target, true);
    }

    public static StringBuffer openNamespaceDeclarationTag(String prefix, String header, Collection namespaces, Map prefixMap, Map attrs, StringBuffer target) {
        target = target == null ? new StringBuffer() : target;
        target.append("<");
        if (prefix != null) {
            target.append(prefix);
            target.append(":");
        }
        target.append(header);
        if (namespaces != null && !namespaces.isEmpty()) {
            ArrayList<String> usedNamespaces = new ArrayList<String>();
            for (Object item : namespaces) {
                String currentNamespace = null;
                if (item instanceof DAVElement) {
                    DAVElement currentElement = (DAVElement)item;
                    currentNamespace = currentElement.getNamespace();
                } else if (item instanceof String) {
                    currentNamespace = (String)item;
                }
                if (currentNamespace == null || currentNamespace.length() <= 0 || usedNamespaces.contains(currentNamespace)) continue;
                usedNamespaces.add(currentNamespace);
                target.append(" xmlns");
                if (prefixMap != null) {
                    target.append(":");
                    target.append(prefixMap.get(currentNamespace));
                }
                target.append("=\"");
                target.append(currentNamespace);
                target.append("\"");
            }
            usedNamespaces.clear();
        }
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry entry : attrs.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                target.append(" ");
                target.append(name);
                target.append("=\"");
                target.append(SVNEncodingUtil.xmlEncodeAttr(value));
                target.append("\"");
            }
        }
        target.append(">\n");
        return target;
    }

    public static StringBuffer openNamespaceDeclarationTag(String prefix, String header, Collection namespaces, Map prefixMap, StringBuffer target) {
        return SVNXMLUtil.openNamespaceDeclarationTag(prefix, header, namespaces, prefixMap, null, target);
    }

    public static StringBuffer addXMLFooter(String prefix, String header, StringBuffer target) {
        target = target == null ? new StringBuffer() : target;
        target.append("</");
        if (prefix != null) {
            target.append(prefix);
            target.append(":");
        }
        target.append(header);
        target.append(">");
        return target;
    }

    public static StringBuffer openCDataTag(String prefix, String tagName, String cdata, StringBuffer target) {
        if (cdata == null) {
            return target;
        }
        target = SVNXMLUtil.openXMLTag(prefix, tagName, 2, null, target);
        target.append(SVNEncodingUtil.xmlEncodeCDATA(cdata));
        target = SVNXMLUtil.closeXMLTag(prefix, tagName, target);
        return target;
    }

    public static StringBuffer openCDataTag(String tagName, String cdata, StringBuffer target) {
        return SVNXMLUtil.openCDataTag(null, tagName, cdata, target);
    }

    public static StringBuffer openCDataTag(String prefix, String tagName, String cdata, Map attributes, StringBuffer target) {
        if (cdata == null) {
            return target;
        }
        target = SVNXMLUtil.openXMLTag(prefix, tagName, 2, attributes, target);
        target.append(SVNEncodingUtil.xmlEncodeCDATA(cdata));
        target = SVNXMLUtil.closeXMLTag(prefix, tagName, target);
        return target;
    }

    public static StringBuffer openCDataTag(String prefix, String tagName, String cdata, String attr, String value, StringBuffer target) {
        SVNHashMap attributes = new SVNHashMap();
        attributes.put(attr, value);
        return SVNXMLUtil.openCDataTag(prefix, tagName, cdata, attributes, target);
    }

    public static StringBuffer openXMLTag(String prefix, String tagName, int style, String attr, String value, StringBuffer target) {
        SVNHashMap attributes = new SVNHashMap();
        attributes.put(attr, value);
        return SVNXMLUtil.openXMLTag(prefix, tagName, style, attributes, target);
    }

    public static StringBuffer openXMLTag(String prefix, String tagName, int style, Map attributes, StringBuffer target) {
        target = target == null ? new StringBuffer() : target;
        target.append("<");
        if (prefix != null) {
            target.append(prefix);
            target.append(":");
        }
        target.append(tagName);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry entry : attributes.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ((style & 8) != 0) {
                    target.append("\n  ");
                }
                target.append(" ");
                target.append(name);
                target.append("=\"");
                target.append(SVNEncodingUtil.xmlEncodeAttr(value));
                target.append("\"");
            }
            attributes.clear();
        }
        if ((style & 4) != 0) {
            target.append("/");
        }
        target.append(">");
        if ((style & 2) == 0) {
            target.append("\n");
        }
        return target;
    }

    public static StringBuffer closeXMLTag(String prefix, String tagName, StringBuffer target) {
        target = target == null ? new StringBuffer() : target;
        target.append("</");
        if (prefix != null) {
            target.append(prefix);
            target.append(":");
        }
        target.append(tagName);
        target.append(">\n");
        return target;
    }
}

