/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.TrustManager;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNSSLTrustManager;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPasswordCipher;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNAuthenticationManager
implements ISVNAuthenticationManager {
    private boolean myIsStoreAuth;
    private ISVNAuthenticationProvider[] myProviders;
    private File myConfigDirectory;
    private SVNAuthentication myPreviousAuthentication;
    private SVNErrorMessage myPreviousErrorMessage;
    private SVNCompositeConfigFile myServersFile;
    private ISVNAuthenticationStorage myRuntimeAuthStorage;
    private int myLastProviderIndex;
    private SVNCompositeConfigFile myConfigFile;
    private boolean myIsAuthenticationForced;
    private SVNAuthentication myLastLoadedAuth;
    private boolean myIsStoreSSLAuth;

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, boolean storeSSLAuth, String userName, String password) {
        this(configDirectory, storeAuth, storeSSLAuth, userName, password, null, null);
    }

    public DefaultSVNAuthenticationManager(File configDirectory, boolean storeAuth, boolean storeSSLAuth, String userName, String password, File privateKey, String passphrase) {
        password = password == null ? "" : password;
        this.myIsStoreAuth = storeAuth;
        this.myIsStoreSSLAuth = storeSSLAuth;
        this.myConfigDirectory = configDirectory;
        if (this.myConfigDirectory == null) {
            this.myConfigDirectory = SVNWCUtil.getDefaultConfigurationDirectory();
        }
        this.myProviders = new ISVNAuthenticationProvider[4];
        this.myProviders[0] = this.createDefaultAuthenticationProvider(userName, password, privateKey, passphrase, this.myIsStoreAuth);
        this.myProviders[1] = this.createRuntimeAuthenticationProvider();
        this.myProviders[2] = this.createCacheAuthenticationProvider(new File(this.myConfigDirectory, "auth"));
    }

    public void setSSLStorageEnabled(boolean sslStorage) {
        this.myIsStoreSSLAuth = sslStorage;
    }

    protected boolean isSSLStorageEnabled() {
        return this.myIsStoreSSLAuth;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        this.myProviders[3] = provider;
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        String proxyHost = (String)properties.get("http-proxy-host");
        if (proxyHost == null || "".equals(proxyHost.trim())) {
            proxyHost = System.getProperty("http.proxyHost");
            properties.put("http-proxy-port", System.getProperty("http.proxyPort"));
        }
        if (proxyHost == null || "".equals(proxyHost.trim())) {
            return null;
        }
        String proxyExceptions = (String)properties.get("http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches(exception, host)) continue;
                return null;
            }
        }
        String proxyPort = (String)properties.get("http-proxy-port");
        String proxyUser = (String)properties.get("http-proxy-username");
        String proxyPassword = (String)properties.get("http-proxy-password");
        return new SimpleProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public TrustManager getTrustManager(SVNURL url) throws SVNException {
        String host = url.getHost();
        Map properties = this.getHostProperties(host);
        boolean trustAll = !"no".equalsIgnoreCase((String)properties.get("ssl-trust-default-ca"));
        String sslAuthorityFiles = (String)properties.get("ssl-authority-files");
        ArrayList<File> trustStorages = new ArrayList<File>();
        if (sslAuthorityFiles != null) {
            StringTokenizer files = new StringTokenizer(sslAuthorityFiles, ",");
            while (files.hasMoreTokens()) {
                String fileName = files.nextToken();
                if (fileName == null || "".equals(fileName.trim())) continue;
                trustStorages.add(new File(fileName));
            }
        }
        File[] serverCertFiles = trustStorages.toArray(new File[trustStorages.size()]);
        File authDir = new File(this.myConfigDirectory, "auth/svn.ssl.server");
        return new DefaultSVNSSLTrustManager(authDir, url, serverCertFiles, trustAll, this);
    }

    private Map getHostProperties(String host) {
        Map globalProps = this.getServersFile().getProperties("global");
        String groupName = DefaultSVNAuthenticationManager.getGroupName(this.getServersFile().getProperties("groups"), host);
        if (groupName != null) {
            Map hostProps = this.getServersFile().getProperties(groupName);
            globalProps.putAll(hostProps);
        }
        return globalProps;
    }

    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        this.myPreviousAuthentication = null;
        this.myPreviousErrorMessage = null;
        this.myLastProviderIndex = 0;
        this.myLastLoadedAuth = null;
        int i = 0;
        while (i < this.myProviders.length) {
            if (this.myProviders[i] != null) {
                if (i > 0 && "svn.proxy".equals(kind) || "svn.ssl".equals(kind) && i == 4) {
                    return null;
                }
                SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, null, null, this.myIsStoreAuth);
                if (auth != null) {
                    if (i == 2) {
                        this.myLastLoadedAuth = auth;
                    }
                    this.myPreviousAuthentication = auth;
                    this.myLastProviderIndex = i;
                    return auth;
                }
                if (i == 3) {
                    SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
                }
            }
            ++i;
        }
        if ("svn.username".equals(kind)) {
            return new SVNUserNameAuthentication("", this.isAuthStorageEnabled());
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        int index;
        int i = index = Math.min(this.myLastProviderIndex + 1, 3);
        while (i < this.myProviders.length) {
            if (this.myProviders[i] != null && (i != 1 && i != 2 || !this.hasExplicitCredentials(kind))) {
                SVNAuthentication auth = this.myProviders[i].requestClientAuthentication(kind, url, realm, this.myPreviousErrorMessage, this.myPreviousAuthentication, this.myIsStoreAuth);
                if (auth != null) {
                    if (i == 2) {
                        this.myLastLoadedAuth = auth;
                    }
                    this.myPreviousAuthentication = auth;
                    this.myLastProviderIndex = i;
                    return auth;
                }
                if (i == 3) {
                    SVNErrorManager.cancel("authentication cancelled", SVNLogType.WC);
                }
            }
            ++i;
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        if (!accepted) {
            this.myPreviousErrorMessage = errorMessage;
            this.myPreviousAuthentication = authentication;
            this.myLastLoadedAuth = null;
            return;
        }
        if (this.myIsStoreAuth && authentication.isStorageAllowed() && this.myProviders[2] instanceof IPersistentAuthenticationProvider && (this.myLastLoadedAuth == null || this.myLastLoadedAuth != authentication)) {
            ((IPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveAuthentication(authentication, kind, realm);
        }
        this.myLastLoadedAuth = null;
        if (!this.hasExplicitCredentials(kind)) {
            ((CacheAuthenticationProvider)this.myProviders[1]).saveAuthentication(authentication, realm);
        }
    }

    public void acknowledgeTrustManager(TrustManager manager) {
    }

    private boolean hasExplicitCredentials(String kind) {
        if ("svn.simple".equals(kind) || "svn.username".equals(kind) || "svn.ssh".equals(kind)) {
            return this.myProviders[0] instanceof DumbAuthenticationProvider && ((DumbAuthenticationProvider)this.myProviders[0]).myUserName != null && !"".equals(((DumbAuthenticationProvider)this.myProviders[0]).myUserName);
        }
        return false;
    }

    protected SVNCompositeConfigFile getServersFile() {
        if (this.myServersFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "servers"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"));
            this.myServersFile = new SVNCompositeConfigFile(systemConfig, userConfig);
        }
        return this.myServersFile;
    }

    protected SVNCompositeConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "config"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
            this.myConfigFile = new SVNCompositeConfigFile(systemConfig, userConfig);
        }
        return this.myConfigFile;
    }

    public void setRuntimeStorage(ISVNAuthenticationStorage storage) {
        this.myRuntimeAuthStorage = storage;
    }

    protected ISVNAuthenticationStorage getRuntimeAuthStorage() {
        if (this.myRuntimeAuthStorage == null) {
            this.myRuntimeAuthStorage = new ISVNAuthenticationStorage(){
                private Map myData = new SVNHashMap();

                public void putData(String kind, String realm, Object data) {
                    this.myData.put(String.valueOf(kind) + "$" + realm, data);
                }

                public Object getData(String kind, String realm) {
                    return this.myData.get(String.valueOf(kind) + "$" + realm);
                }
            };
        }
        return this.myRuntimeAuthStorage;
    }

    protected boolean isAuthStorageEnabled() {
        return this.myIsStoreAuth;
    }

    protected boolean isStorePasswords() {
        String value = this.getConfigFile().getPropertyValue("auth", "store-passwords");
        if (value == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    protected ISVNAuthenticationProvider getAuthenticationProvider() {
        return this.myProviders[3];
    }

    protected int getDefaultSSHPortNumber() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            return -1;
        }
        String sshProgram = (String)tunnels.get("ssh");
        if (sshProgram == null) {
            return -1;
        }
        String port = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, sshProgram.toLowerCase().trim().startsWith("plink") ? "-p" : "-P");
        String string = port = port == null ? System.getProperty("svnkit.ssh2.port", System.getProperty("javasvn.ssh2.port")) : port;
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected SVNSSHAuthentication getDefaultSSHAuthentication() {
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        if (tunnels == null || !tunnels.containsKey("ssh")) {
            tunnels = new SVNHashMap();
        }
        String sshProgram = (String)tunnels.get("ssh");
        String userName = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-l");
        String password = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-pw");
        String keyFile = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, "-i");
        String port = DefaultSVNAuthenticationManager.getOptionValue(sshProgram, sshProgram != null && sshProgram.toLowerCase().trim().startsWith("plink") ? "-P" : "-p");
        String passphrase = null;
        userName = userName == null ? System.getProperty("svnkit.ssh2.username", System.getProperty("javasvn.ssh2.username")) : userName;
        keyFile = keyFile == null ? System.getProperty("svnkit.ssh2.key", System.getProperty("javasvn.ssh2.key")) : keyFile;
        passphrase = passphrase == null ? System.getProperty("svnkit.ssh2.passphrase", System.getProperty("javasvn.ssh2.passphrase")) : passphrase;
        password = password == null ? System.getProperty("svnkit.ssh2.password", System.getProperty("javasvn.ssh2.password")) : password;
        String string = port = port == null ? System.getProperty("svnkit.ssh2.port", System.getProperty("javasvn.ssh2.port")) : port;
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        int portNumber = -1;
        if (port != null) {
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (userName != null && password != null) {
            return new SVNSSHAuthentication(userName, password, portNumber, this.isAuthStorageEnabled());
        }
        if (userName != null && keyFile != null) {
            return new SVNSSHAuthentication(userName, new File(keyFile), passphrase, portNumber, this.isAuthStorageEnabled());
        }
        return null;
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean allowSave) {
        return new DumbAuthenticationProvider(userName, password, privateKey, passphrase, allowSave);
    }

    protected ISVNAuthenticationProvider createRuntimeAuthenticationProvider() {
        return new CacheAuthenticationProvider();
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir) {
        return new PersistentAuthenticationProvider(authDir);
    }

    private static String getOptionValue(String commandLine, String optionName) {
        if (commandLine == null || optionName == null) {
            return null;
        }
        StringTokenizer options = new StringTokenizer(commandLine, " \r\n\t");
        while (options.hasMoreTokens()) {
            String option = options.nextToken().trim();
            if (optionName.equals(option) && options.hasMoreTokens()) {
                return options.nextToken();
            }
            if (!option.startsWith(optionName)) continue;
            return option.substring(optionName.length());
        }
        return null;
    }

    private static String getGroupName(Map groups, String host) {
        for (String name : groups.keySet()) {
            String pattern = (String)groups.get(name);
            StringTokenizer tokens = new StringTokenizer(pattern, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!DefaultSVNOptions.matches(token, host)) continue;
                return name;
            }
        }
        return null;
    }

    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean forced) {
        this.myIsAuthenticationForced = forced;
    }

    public int getReadTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            String host = repository.getLocation().getHost();
            Map properties = this.getHostProperties(host);
            String timeout = (String)properties.get("http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    public int getConnectTimeout(SVNRepository repository) {
        String protocol = repository.getLocation().getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return 60000;
        }
        return 0;
    }

    private class CacheAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private CacheAuthenticationProvider() {
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            return (SVNAuthentication)DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().getData(kind, realm);
        }

        public void saveAuthentication(SVNAuthentication auth, String realm) {
            if (auth == null || realm == null) {
                return;
            }
            String kind = auth.getKind();
            DefaultSVNAuthenticationManager.this.getRuntimeAuthStorage().putData(kind, realm, auth);
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }

    protected class DumbAuthenticationProvider
    implements ISVNAuthenticationProvider {
        private String myUserName;
        private String myPassword;
        private boolean myIsStore;
        private String myPassphrase;
        private File myPrivateKey;

        public DumbAuthenticationProvider(String userName, String password, File privateKey, String passphrase, boolean store) {
            this.myUserName = userName;
            this.myPassword = password;
            this.myPrivateKey = privateKey;
            this.myPassphrase = passphrase;
            this.myIsStore = store;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            if (previousAuth == null) {
                if ("svn.ssh".equals(kind)) {
                    SVNSSHAuthentication sshAuth = DefaultSVNAuthenticationManager.this.getDefaultSSHAuthentication();
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        return sshAuth;
                    }
                    if (this.myPrivateKey != null) {
                        return new SVNSSHAuthentication(this.myUserName, this.myPrivateKey, this.myPassphrase, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore);
                    }
                    return new SVNSSHAuthentication(this.myUserName, this.myPassword, sshAuth != null ? sshAuth.getPortNumber() : -1, this.myIsStore);
                }
                if ("svn.simple".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName.trim())) {
                        return null;
                    }
                    return new SVNPasswordAuthentication(this.myUserName, this.myPassword, this.myIsStore);
                }
                if ("svn.username".equals(kind)) {
                    if (this.myUserName == null || "".equals(this.myUserName)) {
                        String userName = System.getProperty("svnkit.ssh2.author", System.getProperty("javasvn.ssh2.author"));
                        if (userName != null) {
                            return new SVNUserNameAuthentication(userName, this.myIsStore);
                        }
                        return null;
                    }
                    return new SVNUserNameAuthentication(this.myUserName, this.myIsStore);
                }
            }
            return null;
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }

    public static interface IPersistentAuthenticationProvider {
        public void saveAuthentication(SVNAuthentication var1, String var2, String var3) throws SVNException;
    }

    private class PersistentAuthenticationProvider
    implements ISVNAuthenticationProvider,
    IPersistentAuthenticationProvider {
        private File myDirectory;

        public PersistentAuthenticationProvider(File directory) {
            this.myDirectory = directory;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            block18: {
                if ("svn.ssl".equals(kind)) {
                    String host = url.getHost();
                    Map properties = DefaultSVNAuthenticationManager.this.getHostProperties(host);
                    String sslClientCert = (String)properties.get("ssl-client-cert-file");
                    String sslClientCertPassword = (String)properties.get("ssl-client-cert-password");
                    File clientCertFile = sslClientCert != null ? new File(sslClientCert) : null;
                    return new SVNSSLAuthentication(clientCertFile, sslClientCertPassword, authMayBeStored);
                }
                File dir = new File(this.myDirectory, kind);
                if (!dir.isDirectory()) {
                    return null;
                }
                String fileName = SVNFileUtil.computeChecksum(realm);
                File authFile = new File(dir, fileName);
                if (authFile.exists()) {
                    String userName;
                    SVNPasswordCipher cipher;
                    SVNProperties values;
                    block17: {
                        block16: {
                            String cipherType;
                            String storedRealm;
                            block15: {
                                SVNWCProperties props = new SVNWCProperties(authFile, "");
                                values = props.asMap();
                                storedRealm = values.getStringValue("svn:realmstring");
                                cipherType = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passtype"));
                                if (cipherType == null || SVNPasswordCipher.hasCipher(cipherType)) break block15;
                                return null;
                            }
                            cipher = SVNPasswordCipher.getInstance(cipherType);
                            if (storedRealm != null && storedRealm.equals(realm)) break block16;
                            return null;
                        }
                        userName = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("username"));
                        if (userName != null && !"".equals(userName.trim())) break block17;
                        return null;
                    }
                    try {
                        String password = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("password"));
                        password = cipher.decrypt(password);
                        String path = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("key"));
                        String passphrase = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passphrase"));
                        passphrase = cipher.decrypt(passphrase);
                        String port = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("port"));
                        String string = port = port == null ? "" + DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber() : port;
                        if ("svn.simple".equals(kind)) {
                            return new SVNPasswordAuthentication(userName, password, authMayBeStored);
                        }
                        if ("svn.ssh".equals(kind)) {
                            int portNumber;
                            try {
                                portNumber = Integer.parseInt(port);
                            }
                            catch (NumberFormatException nfe) {
                                portNumber = DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber();
                            }
                            if (path != null) {
                                return new SVNSSHAuthentication(userName, new File(path), passphrase, portNumber, authMayBeStored);
                            }
                            if (password != null) {
                                return new SVNSSHAuthentication(userName, password, portNumber, authMayBeStored);
                            }
                            break block18;
                        }
                        if ("svn.username".equals(kind)) {
                            return new SVNUserNameAuthentication(userName, authMayBeStored);
                        }
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public void saveAuthentication(SVNAuthentication auth, String kind, String realm) throws SVNException {
            File dir = new File(this.myDirectory, kind);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.isDirectory()) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", dir.getAbsolutePath());
                SVNErrorManager.error(error, SVNLogType.DEFAULT);
            }
            if ("".equals(auth.getUserName()) || auth.getUserName() == null) {
                return;
            }
            SVNHashMap values = new SVNHashMap();
            values.put("svn:realmstring", realm);
            values.put("username", auth.getUserName());
            boolean storePasswords = DefaultSVNAuthenticationManager.this.isStorePasswords();
            SVNPasswordCipher cipher = null;
            if (storePasswords) {
                String cipherType = SVNPasswordCipher.getDefaultCipherType();
                cipher = SVNPasswordCipher.getInstance(cipherType);
                if (cipherType != null) {
                    values.put("passtype", cipherType);
                }
            }
            if ("svn.simple".equals(kind) && storePasswords) {
                SVNPasswordAuthentication passwordAuth = (SVNPasswordAuthentication)auth;
                values.put("password", cipher.encrypt(passwordAuth.getPassword()));
            } else if ("svn.ssh".equals(kind)) {
                SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
                if (storePasswords) {
                    values.put("password", cipher.encrypt(sshAuth.getPassword()));
                }
                int port = sshAuth.getPortNumber();
                if (sshAuth.getPortNumber() < 0) {
                    port = DefaultSVNAuthenticationManager.this.getDefaultSSHPortNumber();
                }
                values.put("port", Integer.toString(port));
                if (sshAuth.getPrivateKeyFile() != null) {
                    String path = sshAuth.getPrivateKeyFile().getAbsolutePath();
                    if (storePasswords) {
                        values.put("passphrase", cipher.encrypt(sshAuth.getPassphrase()));
                    }
                    values.put("key", path);
                }
            }
            String fileName = SVNFileUtil.computeChecksum(realm);
            File authFile = new File(dir, fileName);
            SVNWCProperties props = new SVNWCProperties(authFile, "");
            try {
                if (values.equals(props.asMap())) {
                    return;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            props.delete();
            try {
                for (String name : values.keySet()) {
                    props.setPropertyValue(name, SVNPropertyValue.create((String)values.get(name)));
                }
                SVNFileUtil.setReadonly(props.getFile(), false);
            }
            catch (SVNException e) {
                props.delete();
                throw e;
            }
        }

        public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
            return 2;
        }
    }

    protected static final class SimpleProxyManager
    implements ISVNProxyManager {
        private String myProxyHost;
        private String myProxyPort;
        private String myProxyUser;
        private String myProxyPassword;

        public SimpleProxyManager(String host, String port, String user, String password) {
            this.myProxyHost = host;
            this.myProxyPort = port == null ? "3128" : port;
            this.myProxyUser = user;
            this.myProxyPassword = password;
        }

        public String getProxyHost() {
            return this.myProxyHost;
        }

        public int getProxyPort() {
            try {
                return Integer.parseInt(this.myProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                return 3128;
            }
        }

        public String getProxyUserName() {
            return this.myProxyUser;
        }

        public String getProxyPassword() {
            return this.myProxyPassword;
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    }
}

