/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNSSLTrustManager
implements X509TrustManager {
    private SVNURL myURL;
    private DefaultSVNAuthenticationManager myAuthManager;
    private X509Certificate[] myTrustedCerts;
    private String myRealm;
    private File myAuthDirectory;
    private boolean myIsUseKeyStore;
    private File[] myServerCertFiles;

    public DefaultSVNSSLTrustManager(File authDir, SVNURL url, File[] serverCertFiles, boolean useKeyStore, DefaultSVNAuthenticationManager authManager) {
        this.myURL = url;
        this.myAuthDirectory = authDir;
        this.myRealm = "https://" + url.getHost() + ":" + url.getPort();
        this.myAuthManager = authManager;
        this.myIsUseKeyStore = useKeyStore;
        this.myServerCertFiles = serverCertFiles;
    }

    /*
     * Exception decompiling
     */
    private void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public X509Certificate[] getAcceptedIssuers() {
        this.init();
        return this.myTrustedCerts;
    }

    public void checkClientTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] certs, String algorithm) throws CertificateException {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            String stored;
            String data = SVNBase64.byteArrayToBase64(certs[0].getEncoded());
            if (data.equals(stored = (String)this.myAuthManager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm))) {
                return;
            }
            stored = this.getStoredServerCertificate(this.myRealm);
            if (data.equals(stored)) {
                return;
            }
            ISVNAuthenticationProvider authProvider = this.myAuthManager.getAuthenticationProvider();
            int failures = SVNSSLUtil.getServerCertificateFailures(certs[0], this.myURL.getHost());
            if (authProvider != null) {
                boolean store = this.myAuthManager.isAuthStorageEnabled() || this.myAuthManager.isSSLStorageEnabled();
                int result = authProvider.acceptServerAuthentication(this.myURL, this.myRealm, certs[0], store);
                if (result == 2 && store) {
                    try {
                        this.storeServerCertificate(this.myRealm, data, failures);
                    }
                    catch (SVNException e) {
                        throw new SVNSSLUtil.CertificateNotTrustedException("svn: Server SSL ceritificate for '" + this.myRealm + "' cannot be saved");
                    }
                }
                if (result != 0) {
                    this.myAuthManager.getRuntimeAuthStorage().putData("svn.ssl.server", this.myRealm, data);
                    return;
                }
                throw new SVNSSLUtil.CertificateNotTrustedException("svn: Server SSL ceritificate for '" + this.myRealm + "' rejected");
            }
            return;
        }
    }

    private String getStoredServerCertificate(String realm) {
        SVNWCProperties props;
        block4: {
            File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
            if (!file.isFile()) {
                return null;
            }
            props = new SVNWCProperties(file, "");
            try {
                String storedRealm = props.getPropertyValue("svn:realmstring");
                if (realm.equals(storedRealm)) break block4;
                return null;
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return props.getPropertyValue("ascii_cert");
    }

    private void storeServerCertificate(String realm, String data, int failures) throws SVNException {
        this.myAuthDirectory.mkdirs();
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        SVNWCProperties props = new SVNWCProperties(file, "");
        props.delete();
        try {
            props.setPropertyValue("ascii_cert", data);
            props.setPropertyValue("svn:realmstring", realm);
            props.setPropertyValue("failures", Integer.toString(failures));
            SVNFileUtil.setReadonly(props.getFile(), false);
        }
        catch (SVNException e) {
            props.delete();
            throw e;
        }
    }

    public static X509Certificate loadCertificate(File pemFile) {
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(pemFile, SVNLogType.WC);
        }
        catch (SVNException e) {
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(is);
            return x509Certificate;
        }
        catch (CertificateException e) {
            return null;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }
}

