/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitter
implements ISVNCommitPathHandler {
    private Map myCommitItems;
    private Map myModifiedFiles;
    private Collection myTmpFiles;
    private String myRepositoryRoot;
    private SVNDeltaGenerator myDeltaGenerator;

    public SVNCommitter(Map commitItems, String reposRoot, Collection tmpFiles) {
        this.myCommitItems = commitItems;
        this.myModifiedFiles = new TreeMap();
        this.myTmpFiles = tmpFiles;
        this.myRepositoryRoot = reposRoot;
    }

    public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(commitPath);
        SVNWCAccess wcAccess = item.getWCAccess();
        wcAccess.checkCancelled();
        if (item.isCopied()) {
            SVNErrorMessage err;
            if (item.getCopyFromURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", item.getFile());
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (item.getRevision().getNumber() < 0L) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Commit item ''{0}'' has copy flag but an invalid revision", item.getFile());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        SVNEvent event = null;
        boolean closeDir = false;
        File file = null;
        if (item.getFile() != null) {
            file = item.getFile();
        } else if (item.getPath() != null) {
            file = new File(wcAccess.getAnchor(), item.getPath());
        }
        long rev = item.getRevision().getNumber();
        if (item.isAdded() && item.isDeleted()) {
            event = SVNEventFactory.createSVNEvent(file, item.getKind(), null, -1L, SVNEventAction.COMMIT_REPLACED, null, null, null);
            event.setPreviousRevision(rev);
        } else if (item.isAdded()) {
            String mimeType = null;
            if (item.getKind() == SVNNodeKind.FILE && file != null) {
                SVNAdminArea dir = item.getWCAccess().retrieve(file.getParentFile());
                mimeType = dir.getProperties(file.getName()).getStringPropertyValue("svn:mime-type");
            }
            event = SVNEventFactory.createSVNEvent(file, item.getKind(), mimeType, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
            event.setPreviousRevision(item.getCopyFromRevision() != null ? item.getCopyFromRevision().getNumber() : -1L);
            event.setPreviousURL(item.getCopyFromURL());
        } else if (item.isDeleted()) {
            event = SVNEventFactory.createSVNEvent(file, item.getKind(), null, -1L, SVNEventAction.COMMIT_DELETED, null, null, null);
            event.setPreviousRevision(rev);
        } else if (item.isContentsModified() || item.isPropertiesModified()) {
            event = SVNEventFactory.createSVNEvent(file, item.getKind(), null, -1L, SVNEventAction.COMMIT_MODIFIED, null, null, null);
            event.setPreviousRevision(rev);
        }
        if (event != null) {
            event.setURL(item.getURL());
            wcAccess.handleEvent(event, -1.0);
        }
        long cfRev = item.getCopyFromRevision().getNumber();
        if (item.isDeleted()) {
            commitEditor.deleteEntry(commitPath, rev);
        }
        boolean fileOpen = false;
        Map outgoingProperties = item.getOutgoingProperties();
        if (item.isAdded()) {
            String copyFromPath = this.getCopyFromPath(item.getCopyFromURL());
            if (item.getKind() == SVNNodeKind.FILE) {
                commitEditor.addFile(commitPath, copyFromPath, cfRev);
                fileOpen = true;
            } else {
                commitEditor.addDir(commitPath, copyFromPath, cfRev);
                closeDir = true;
            }
            if (outgoingProperties != null) {
                for (String propName : outgoingProperties.keySet()) {
                    SVNPropertyValue propValue = (SVNPropertyValue)outgoingProperties.get(propName);
                    if (item.getKind() == SVNNodeKind.FILE) {
                        commitEditor.changeFileProperty(commitPath, propName, propValue);
                        continue;
                    }
                    commitEditor.changeDirProperty(propName, propValue);
                }
                outgoingProperties = null;
            }
        }
        if (item.isPropertiesModified()) {
            if (item.getKind() == SVNNodeKind.FILE) {
                if (!fileOpen) {
                    commitEditor.openFile(commitPath, rev);
                }
                fileOpen = true;
            } else if (!item.isAdded()) {
                if ("".equals(commitPath)) {
                    commitEditor.openRoot(rev);
                } else {
                    commitEditor.openDir(commitPath, rev);
                }
                closeDir = true;
            }
            this.sendPropertiesDelta(commitPath, item, commitEditor);
            if (outgoingProperties != null) {
                for (String propName : outgoingProperties.keySet()) {
                    SVNPropertyValue propValue = (SVNPropertyValue)outgoingProperties.get(propName);
                    if (item.getKind() == SVNNodeKind.FILE) {
                        commitEditor.changeFileProperty(commitPath, propName, propValue);
                        continue;
                    }
                    commitEditor.changeDirProperty(propName, propValue);
                }
            }
        }
        if (item.isContentsModified() && item.getKind() == SVNNodeKind.FILE) {
            if (!fileOpen) {
                commitEditor.openFile(commitPath, rev);
            }
            this.myModifiedFiles.put(commitPath, item);
        } else if (fileOpen) {
            commitEditor.closeFile(commitPath, null);
        }
        return closeDir;
    }

    public void sendTextDeltas(ISVNEditor editor) throws SVNException {
        for (String path : this.myModifiedFiles.keySet()) {
            String newChecksum;
            block9: {
                SVNCommitItem item = (SVNCommitItem)this.myModifiedFiles.get(path);
                SVNWCAccess wcAccess = item.getWCAccess();
                wcAccess.checkCancelled();
                SVNEvent event = SVNEventFactory.createSVNEvent(new File(wcAccess.getAnchor(), item.getPath()), SVNNodeKind.FILE, null, -1L, SVNEventAction.COMMIT_DELTA_SENT, null, null, null);
                wcAccess.handleEvent(event, -1.0);
                SVNAdminArea dir = wcAccess.retrieve(item.getFile().getParentFile());
                String name = SVNPathUtil.tail(item.getPath());
                SVNEntry entry = dir.getEntry(name, false);
                File tmpFile = dir.getBaseFile(name, true);
                this.myTmpFiles.add(tmpFile);
                String checksum = null;
                if (!item.isAdded()) {
                    checksum = SVNFileUtil.computeChecksum(dir.getBaseFile(name, false));
                    String realChecksum = entry.getChecksum();
                    if (realChecksum != null && !realChecksum.equals(checksum)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{dir.getFile(name), realChecksum, checksum});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                editor.applyTextDelta(path, checksum);
                if (this.myDeltaGenerator == null) {
                    this.myDeltaGenerator = new SVNDeltaGenerator();
                }
                InputStream sourceIS = null;
                InputStream targetIS = null;
                OutputStream tmpBaseStream = null;
                File baseFile = dir.getBaseFile(name, false);
                newChecksum = null;
                try {
                    try {
                        sourceIS = !item.isAdded() && baseFile.exists() ? SVNFileUtil.openFileForReading(baseFile, SVNLogType.WC) : SVNFileUtil.DUMMY_IN;
                        targetIS = SVNTranslator.getTranslatedStream(dir, name, true, false);
                        tmpBaseStream = SVNFileUtil.openFileForWriting(tmpFile);
                        CopyingStream localStream = new CopyingStream(tmpBaseStream, targetIS);
                        newChecksum = this.myDeltaGenerator.sendDelta(path, sourceIS, 0L, localStream, editor, true);
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage err = svne.getErrorMessage().wrap("While preparing ''{0}'' for commit", dir.getFile(name));
                        SVNErrorManager.error(err, SVNLogType.WC);
                        SVNFileUtil.closeFile(sourceIS);
                        SVNFileUtil.closeFile(targetIS);
                        SVNFileUtil.closeFile(tmpBaseStream);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(sourceIS);
                    SVNFileUtil.closeFile(targetIS);
                    SVNFileUtil.closeFile(tmpBaseStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(sourceIS);
                SVNFileUtil.closeFile(targetIS);
                SVNFileUtil.closeFile(tmpBaseStream);
            }
            editor.closeFile(path, newChecksum);
        }
    }

    private void sendPropertiesDelta(String commitPath, SVNCommitItem item, ISVNEditor editor) throws SVNException {
        SVNProperties diff;
        String name;
        SVNAdminArea dir;
        SVNWCAccess wcAccess = item.getWCAccess();
        if (item.getKind() == SVNNodeKind.DIR) {
            dir = wcAccess.retrieve(item.getFile());
            name = "";
        } else {
            dir = wcAccess.retrieve(item.getFile().getParentFile());
            name = SVNPathUtil.tail(item.getPath());
        }
        if (!dir.hasPropModifications(name)) {
            return;
        }
        SVNEntry entry = dir.getEntry(name, false);
        boolean replaced = false;
        if (entry != null) {
            replaced = entry.isScheduledForReplacement();
        }
        SVNVersionedProperties props = dir.getProperties(name);
        SVNVersionedProperties baseProps = replaced ? null : dir.getBaseProperties(name);
        SVNProperties sVNProperties = diff = replaced ? props.asMap() : baseProps.compareTo(props).asMap();
        if (diff != null && !diff.isEmpty()) {
            File tmpPropsFile = dir.getPropertiesFile(name, true);
            SVNWCProperties tmpProps = new SVNWCProperties(tmpPropsFile, null);
            for (String propName : props.getPropertyNames(null)) {
                SVNPropertyValue propValue = props.getPropertyValue(propName);
                tmpProps.setPropertyValue(propName, propValue);
            }
            if (!tmpPropsFile.exists()) {
                SVNFileUtil.createEmptyFile(tmpPropsFile);
            }
            this.myTmpFiles.add(tmpPropsFile);
            for (String propName : diff.nameSet()) {
                SVNPropertyValue value = diff.getSVNPropertyValue(propName);
                if (item.getKind() == SVNNodeKind.FILE) {
                    editor.changeFileProperty(commitPath, propName, value);
                    continue;
                }
                editor.changeDirProperty(propName, value);
            }
        }
    }

    private String getCopyFromPath(SVNURL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (this.myRepositoryRoot.equals(path)) {
            return "/";
        }
        return path.substring(this.myRepositoryRoot.length());
    }

    public static SVNCommitInfo commit(Collection tmpFiles, Map commitItems, String repositoryRoot, ISVNEditor commitEditor) throws SVNException {
        SVNCommitter committer = new SVNCommitter(commitItems, repositoryRoot, tmpFiles);
        SVNCommitUtil.driveCommitEditor(committer, commitItems.keySet(), commitEditor, -1L);
        committer.sendTextDeltas(commitEditor);
        return commitEditor.closeEdit();
    }

    private class CopyingStream
    extends InputStream {
        private InputStream myInput;
        private OutputStream myOutput;

        public CopyingStream(OutputStream os, InputStream is) {
            this.myInput = is;
            this.myOutput = os;
        }

        public int read() throws IOException {
            int r = this.myInput.read();
            if (r != -1) {
                this.myOutput.write(r);
            }
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.myInput.read(b);
            if (r != -1) {
                this.myOutput.write(b, 0, r);
            }
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.myInput.read(b, off, len);
            if (r != -1) {
                this.myOutput.write(b, off, r);
            }
            return r;
        }
    }
}

