/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNExtendedMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCopyDriver;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExtendedMergeEditor;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNExtendedMergeDriver
extends SVNMergeDriver {
    private ISVNExtendedMergeCallback myExtendedMergeCallback;
    private SVNCopyDriver myCopyDriver;
    private SVNURL myPrimaryURL;
    private long myRevision1;
    private long myRevision2;
    private File myTempDirectory;
    private File myReportFile;
    private Set myPendingTargets;
    private SVNMergeRangeList myCurrentRemainingRanges;
    private Boolean myRecordMergeInfo;
    private SVNRepository myRepository;

    public SVNExtendedMergeDriver(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNExtendedMergeDriver(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public ISVNExtendedMergeCallback getExtendedMergeCallback() {
        return this.myExtendedMergeCallback;
    }

    public void setExtendedMergeCallback(ISVNExtendedMergeCallback extendedMergeCallback) {
        this.myExtendedMergeCallback = extendedMergeCallback;
    }

    private Set getPendingFiles() {
        if (this.myPendingTargets == null) {
            this.myPendingTargets = new SVNHashSet();
        }
        return this.myPendingTargets;
    }

    private File getReportFile() throws SVNException {
        if (this.myReportFile == null) {
            this.myReportFile = SVNFileUtil.createUniqueFile(this.getTempDirectory(), "svnkit", ".extmerge", false);
        }
        return this.myReportFile;
    }

    private void deleteReportFile() throws SVNException {
        if (this.myReportFile != null) {
            try {
                SVNFileUtil.deleteFile(this.myReportFile);
            }
            finally {
                this.myReportFile = null;
            }
        }
    }

    protected File getTempDirectory() {
        return this.myTempDirectory;
    }

    protected void setTempDirectory(File tempDirectory) {
        this.myTempDirectory = tempDirectory;
    }

    private boolean skipExtendedMerge() {
        return this.myExtendedMergeCallback == null;
    }

    private SVNRepository getRepository(SVNURL url) throws SVNException {
        if (url == null) {
            return null;
        }
        if (this.myRepository == null) {
            this.myRepository = this.createRepository(url, null, null, false);
        } else {
            this.myRepository.setLocation(url, false);
        }
        return this.myRepository;
    }

    protected SVNCopyDriver getCopyDriver() {
        if (this.myCopyDriver == null) {
            this.myCopyDriver = new SVNCopyDriver(this.getRepositoryPool(), this.getOptions());
            this.myCopyDriver.setWCAccess(this.myWCAccess);
        }
        return this.myCopyDriver;
    }

    protected void copy(SVNCopySource copySource, File dst, boolean save) throws SVNException {
        if (copySource == null || dst == null) {
            return;
        }
        SVNEntry entry = this.myWCAccess.getEntry(dst, false);
        if (entry != null) {
            this.doVirtualCopy(entry, copySource, save);
        } else {
            this.getCopyDriver().setupCopy(new SVNCopySource[]{copySource}, new SVNPath(dst.getAbsolutePath()), false, true, null, null, null, null, null);
        }
    }

    protected void doVirtualCopy(SVNEntry dstEntry, SVNCopySource copySource, boolean save) throws SVNException {
        dstEntry.setCopyFromURL(copySource.getURL().toString());
        long cfRevision = copySource.getRevision().getNumber();
        dstEntry.setCopyFromRevision(cfRevision);
        if (save) {
            SVNAdminArea dir = dstEntry.getAdminArea();
            dir.saveEntries(false);
        }
    }

    protected long getRevision(SVNCopySource copySource) throws SVNException {
        return this.getRevisionNumber(copySource.getRevision(), this.getRepository(copySource.getURL()), copySource.getFile());
    }

    protected SVNRemoteDiffEditor getMergeReportEditor(long defaultStart, long revision, SVNAdminArea adminArea, SVNDepth depth, SVNMergeCallback mergeCallback, SVNRemoteDiffEditor editor) throws SVNException {
        if (this.skipExtendedMerge()) {
            return super.getMergeReportEditor(defaultStart, revision, adminArea, depth, mergeCallback, editor);
        }
        if (editor == null) {
            editor = new SVNExtendedMergeEditor(this, this.getExtendedMergeCallback(), adminArea, adminArea.getRoot(), mergeCallback, this.myPrimaryURL, this.myRepository2, defaultStart, revision, this.myIsDryRun, depth, this, this);
        } else {
            editor.reset(defaultStart, revision);
        }
        File tmp = mergeCallback.createTempDirectory();
        this.setTempDirectory(tmp);
        return editor;
    }

    protected void addMergeSource(String mergeSource, SVNURL[] mergeSources, File target, SVNMergeRangeList remainingRanges, boolean adjustMergeInfo, SVNCopySource targetCopySource) throws SVNException {
        if (this.getPendingFiles().contains(target)) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: skip new additional target " + target.getAbsolutePath());
            return;
        }
        this.getPendingFiles().add(target);
        SVNURL sourceURL = this.myPrimaryURL.appendPath(mergeSource, false);
        mergeSources = this.getMergeSources(sourceURL, mergeSources);
        SVNURL url1 = mergeSources[0];
        SVNURL url2 = mergeSources[1];
        BufferedWriter writer = this.createWriter();
        SVNMergeTask mergeTask = new SVNMergeTask(url1, url2, target, remainingRanges, adjustMergeInfo, targetCopySource);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: " + mergeTask.toString());
        try {
            try {
                mergeTask.writeTo(writer);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), SVNLogType.DEFAULT);
                SVNFileUtil.closeFile(writer);
            }
        }
        finally {
            SVNFileUtil.closeFile(writer);
        }
    }

    protected boolean mergeInfoConflicts(SVNMergeRangeList rangeList, File path) {
        if (rangeList == null) {
            return false;
        }
        SVNMergeRange currentRange = new SVNMergeRange(Math.min(this.myRevision1, this.myRevision2), Math.max(this.myRevision1, this.myRevision2), false);
        SVNMergeRange[] ranges = rangeList.getRanges();
        int i = 0;
        while (i < ranges.length) {
            SVNMergeRange range = ranges[i];
            if (currentRange.intersects(range, false) && !range.contains(currentRange, false)) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: merge info conflict found on " + path.getAbsolutePath());
                return true;
            }
            ++i;
        }
        return false;
    }

    protected SVNMergeRangeList calculateRemainingRanges(File file, SVNURL sourceURL, SVNURL[] mergeSources) throws SVNException {
        if (this.skipExtendedMerge()) {
            return null;
        }
        SVNEntry entry = this.myWCAccess.getEntry(file, false);
        if (entry == null) {
            return null;
        }
        SVNMergeRangeList remainingRangeList = null;
        if (this.isHonorMergeInfo()) {
            SVNMergeDriver.MergePath mergeTarget = new SVNMergeDriver.MergePath(this);
            SVNRepository repository = this.getRepository(entry.getSVNURL());
            SVNURL sourceRoot = repository.getRepositoryRoot(true);
            boolean[] indirect = new boolean[1];
            Map[] fullMergeInfo = this.getFullMergeInfo(entry, indirect, SVNMergeInfoInheritance.INHERITED, repository, file, Math.max(this.myRevision1, this.myRevision2), Math.min(this.myRevision1, this.myRevision2));
            Map targetMergeInfo = fullMergeInfo[0];
            Map implicitMergeInfo = fullMergeInfo[1];
            mergeSources = this.getMergeSources(sourceURL, mergeSources);
            SVNURL url1 = mergeSources[0];
            SVNURL url2 = mergeSources[1];
            this.calculateRemainingRanges(null, mergeTarget, sourceRoot, url1, this.myRevision1, url2, this.myRevision2, targetMergeInfo, implicitMergeInfo, false, entry, repository);
            remainingRangeList = mergeTarget.myRemainingRanges;
        }
        return remainingRangeList;
    }

    private SVNURL[] getMergeSources(SVNURL sourceURL, SVNURL[] mergeSources) throws SVNException {
        if (mergeSources == null) {
            mergeSources = new SVNURL[2];
        }
        if (mergeSources[0] != null && mergeSources[1] != null) {
            return mergeSources;
        }
        SVNURL sourceCopiedFrom = this.getExtendedMergeCallback().transformLocation(sourceURL, Math.max(this.myRevision1, this.myRevision2), Math.min(this.myRevision1, this.myRevision2));
        if (sourceCopiedFrom != null) {
            mergeSources[0] = sourceCopiedFrom;
            mergeSources[1] = sourceURL;
        } else {
            mergeSources[0] = sourceURL;
            mergeSources[1] = sourceURL;
        }
        return mergeSources;
    }

    protected ISVNEntryHandler getMergeInfoEntryHandler(String mergeSrcPath, SVNURL sourceRootURL, long revision1, long revision2, SVNRepository repository, SVNDepth depth, List childrenWithMergeInfo) {
        if (this.skipExtendedMerge()) {
            return super.getMergeInfoEntryHandler(mergeSrcPath, sourceRootURL, revision1, revision2, repository, depth, childrenWithMergeInfo);
        }
        return new MergeInfoFetcherExt(mergeSrcPath, sourceRootURL, revision1, revision2, repository, depth, childrenWithMergeInfo);
    }

    protected void doDirectoryMerge(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNEntry parentEntry, SVNAdminArea adminArea, SVNDepth depth) throws SVNException {
        if (this.skipExtendedMerge()) {
            super.doDirectoryMerge(url1, revision1, url2, revision2, parentEntry, adminArea, depth);
            return;
        }
        try {
            try {
                super.doDirectoryMerge(url1, revision1, url2, revision2, parentEntry, adminArea, depth);
                this.doAdditionalMerge();
            }
            catch (Throwable th) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while processing extended merge: ''{0}''", new Object[]{th.getMessage()}, 0, th);
                SVNErrorManager.error(error, th, SVNLogType.DEFAULT);
                this.deleteReportFile();
                this.getPendingFiles().clear();
            }
        }
        finally {
            this.deleteReportFile();
            this.getPendingFiles().clear();
        }
    }

    protected SVNRemoteDiffEditor driveMergeReportEditor(File targetWCPath, SVNURL url1, long revision1, SVNURL url2, long revision2, List childrenWithMergeInfo, boolean isRollBack, SVNDepth depth, SVNAdminArea adminArea, SVNMergeCallback mergeCallback, SVNRemoteDiffEditor editor) throws SVNException {
        this.myPrimaryURL = revision1 > revision2 ? url1 : url2;
        this.myRevision1 = revision1;
        this.myRevision2 = revision2;
        return super.driveMergeReportEditor(targetWCPath, url1, revision1, url2, revision2, childrenWithMergeInfo, isRollBack, depth, adminArea, mergeCallback, editor);
    }

    protected void doAdditionalMerge() throws SVNException {
        SVNURL oldURL1 = this.myRepository1.getLocation();
        SVNURL oldURL2 = this.myRepository2.getLocation();
        BufferedReader reader = this.createReader();
        try {
            SVNMergeTask nextTask = this.readTask(reader);
            while (nextTask != null) {
                this.runMergeTask(nextTask, this.myRevision1, this.myRevision2);
                nextTask = this.readTask(reader);
            }
        }
        finally {
            SVNFileUtil.closeFile(reader);
            this.myRepository1.setLocation(oldURL1, false);
            this.myRepository2.setLocation(oldURL2, false);
            this.myRepository = null;
        }
    }

    private void runMergeTask(SVNMergeTask mergeTask, long revision1, long revision2) throws SVNException {
        boolean rollback = revision1 > revision2;
        SVNURL mergeSource = mergeTask.getMergeSource();
        SVNURL mergeSource2 = mergeTask.getMergeSource2();
        File mergeTarget = mergeTask.getMergeTarget();
        SVNMergeRangeList remainingRanges = mergeTask.getRemainingRanges();
        boolean updateWCMergeInfo = mergeTask.isUpdateWCMergeInfo();
        SVNCopySource copySource = mergeTask.getTargetCopySource();
        if (copySource != null) {
            this.copy(copySource, mergeTarget, true);
        }
        SVNURL mergeURL1 = !rollback ? mergeSource : mergeSource2;
        SVNURL mergeURL2 = !rollback ? mergeSource2 : mergeSource;
        this.myRepository1.setLocation(mergeURL1, false);
        this.myRepository2.setLocation(mergeURL2, false);
        SVNAdminArea targetArea = SVNExtendedMergeDriver.retrieve(this.myWCAccess, mergeTarget.getParentFile());
        this.myCurrentRemainingRanges = remainingRanges;
        this.myRecordMergeInfo = updateWCMergeInfo;
        try {
            this.doFileMerge(mergeURL1, revision1, mergeURL2, revision2, mergeTarget, targetArea, true);
        }
        finally {
            this.myCurrentRemainingRanges = null;
            this.myRecordMergeInfo = null;
        }
    }

    protected boolean isRecordMergeInfo() {
        boolean recordMergeInfo;
        boolean defaultOption = super.isRecordMergeInfo();
        if (this.skipExtendedMerge()) {
            return defaultOption;
        }
        boolean bl = recordMergeInfo = this.myRecordMergeInfo == null ? true : this.myRecordMergeInfo;
        return recordMergeInfo && defaultOption;
    }

    protected Object[] calculateRemainingRangeList(File targetFile, SVNEntry entry, SVNURL sourceRoot, boolean[] indirect, SVNURL url1, long revision1, SVNURL url2, long revision2, SVNMergeRange range) throws SVNException {
        if (this.skipExtendedMerge() || this.myCurrentRemainingRanges == null) {
            return super.calculateRemainingRangeList(targetFile, entry, sourceRoot, indirect, url1, revision1, url2, revision2, range);
        }
        Map targetMergeInfo = null;
        Map implicitMergeInfo = null;
        if (this.isHonorMergeInfo()) {
            this.myRepository1.setLocation(entry.getSVNURL(), false);
            Map[] fullMergeInfo = this.getFullMergeInfo(entry, indirect, SVNMergeInfoInheritance.INHERITED, this.myRepository1, targetFile, Math.max(revision1, revision2), Math.min(revision1, revision2));
            targetMergeInfo = fullMergeInfo[0];
            implicitMergeInfo = fullMergeInfo[1];
            this.myRepository1.setLocation(url1, false);
        }
        return new Object[]{this.myCurrentRemainingRanges, targetMergeInfo, implicitMergeInfo};
    }

    protected Map calculateImplicitMergeInfo(SVNRepository repos, SVNURL url, long[] targetRev, long start, long end, Map[] result) throws SVNException {
        if (this.skipExtendedMerge()) {
            return super.calculateImplicitMergeInfo(repos, url, targetRev, start, end, result);
        }
        Map implicitMergeInfo = null;
        boolean closeSession = false;
        SVNURL sessionURL = null;
        try {
            block12: {
                if (repos != null) {
                    sessionURL = this.ensureSessionURL(repos, url);
                } else {
                    repos = this.createRepository(url, null, null, false);
                    closeSession = true;
                }
                if (targetRev[0] < start) {
                    try {
                        this.getLocations(url, null, repos, SVNRevision.create(targetRev[0]), SVNRevision.create(start), SVNRevision.UNDEFINED);
                        targetRev[0] = start;
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage error = svne.getErrorMessage();
                        if (error.getErrorCode() != SVNErrorCode.FS_NOT_FOUND) break block12;
                        implicitMergeInfo = new TreeMap();
                    }
                }
            }
            if (implicitMergeInfo == null) {
                implicitMergeInfo = this.getHistoryAsMergeInfo(url, null, SVNRevision.create(targetRev[0]), start, end, repos, null);
            }
            if (sessionURL != null) {
                repos.setLocation(sessionURL, false);
            }
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
        return implicitMergeInfo;
    }

    private static SVNAdminArea retrieve(SVNWCAccess access, File target) throws SVNException {
        SVNAdminArea area = access.getAdminArea(target);
        if (area == null) {
            area = access.probeTry(target, true, 0);
        }
        return area;
    }

    protected SVNMergeTask readTask(BufferedReader reader) throws SVNException {
        String sourceLine;
        SVNCopySource copySource;
        boolean updateWCMergeInfo;
        SVNMergeRangeList remainingRanges;
        File target;
        SVNURL sourceURL2;
        SVNURL sourceURL;
        block4: {
            sourceURL = null;
            sourceURL2 = null;
            target = null;
            remainingRanges = null;
            updateWCMergeInfo = true;
            copySource = null;
            sourceLine = reader.readLine();
            if (sourceLine != null) break block4;
            return null;
        }
        try {
            sourceURL = SVNURL.parseURIEncoded(sourceLine);
            sourceURL2 = SVNURL.parseURIEncoded(reader.readLine());
            target = new File(reader.readLine());
            String mergeRangesRepresentation = reader.readLine();
            if (mergeRangesRepresentation != null && mergeRangesRepresentation.length() != 0) {
                SVNMergeRange[] ranges = SVNMergeInfoUtil.parseRevisionList(new StringBuffer(mergeRangesRepresentation), target.getPath());
                remainingRanges = new SVNMergeRangeList(ranges);
            }
            updateWCMergeInfo = Boolean.TRUE.toString().equals(reader.readLine());
            String path = reader.readLine();
            SVNRevision pegRevision = SVNRevision.parse(reader.readLine());
            SVNRevision revision = SVNRevision.parse(reader.readLine());
            reader.readLine();
            copySource = path.length() == 0 ? null : (SVNPathUtil.isURL(path) ? new SVNCopySource(pegRevision, revision, SVNURL.parseURIEncoded(path)) : new SVNCopySource(pegRevision, revision, new File(path)));
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), SVNLogType.DEFAULT);
        }
        return new SVNMergeTask(sourceURL, sourceURL2, target, remainingRanges, updateWCMergeInfo, copySource);
    }

    private BufferedReader createReader() throws SVNException {
        try {
            return new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.getReportFile()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(this.getReportFile())));
        }
    }

    private BufferedWriter createWriter() throws SVNException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new SVNCancellableOutputStream(SVNFileUtil.openFileForWriting(this.getReportFile(), true), this.getEventDispatcher()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new OutputStreamWriter(SVNFileUtil.openFileForWriting(this.getReportFile(), true)));
        }
    }

    private class MergeInfoFetcherExt
    extends SVNMergeDriver.MergeInfoFetcher {
        private MergeInfoFetcherExt(String mergeSrcPath, SVNURL sourceRootURL, long revision1, long revision2, SVNRepository repository, SVNDepth depth, List childrenWithMergeInfo) {
            super(SVNExtendedMergeDriver.this, mergeSrcPath, sourceRootURL, revision1, revision2, repository, depth, childrenWithMergeInfo);
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            SVNEntry parentEntry;
            SVNURL expectedURL;
            SVNURL entryURL = entry.getSVNURL();
            if (entryURL != null && !SVNExtendedMergeDriver.this.myTarget.equals(path) && !entryURL.equals(expectedURL = (parentEntry = SVNExtendedMergeDriver.this.myWCAccess.getVersionedEntry(path.getParentFile(), false)).getSVNURL().appendPath(SVNPathUtil.tail(path.getAbsolutePath().replace(File.separatorChar, '/')), false))) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is switched entry which is not allowed for this kind of merge", path);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            super.handleEntry(path, entry);
        }
    }

    private class SVNMergeTask {
        private SVNURL myMergeSource;
        private SVNURL myMergeSource2;
        private File myMergeTarget;
        private SVNMergeRangeList myRemainingRanges;
        private boolean myUpdateWCMergeInfo;
        private SVNCopySource myTargetCopySource;

        protected SVNMergeTask(SVNURL mergeSource, SVNURL mergeSource2, File mergeTarget, SVNMergeRangeList remainingRanges, boolean updateWCMergeInfo, SVNCopySource targetCopySource) {
            this.myMergeSource = mergeSource;
            this.myMergeSource2 = mergeSource2;
            this.myMergeTarget = mergeTarget;
            this.myRemainingRanges = remainingRanges;
            this.myUpdateWCMergeInfo = updateWCMergeInfo;
            this.myTargetCopySource = targetCopySource;
        }

        protected SVNURL getMergeSource() {
            return this.myMergeSource;
        }

        protected SVNURL getMergeSource2() {
            return this.myMergeSource2;
        }

        protected File getMergeTarget() {
            return this.myMergeTarget;
        }

        protected SVNMergeRangeList getRemainingRanges() {
            return this.myRemainingRanges;
        }

        protected boolean isUpdateWCMergeInfo() {
            return this.myUpdateWCMergeInfo;
        }

        protected SVNCopySource getTargetCopySource() {
            return this.myTargetCopySource;
        }

        protected void writeTo(BufferedWriter writer) throws IOException {
            writer.write(this.getMergeSource().toString());
            writer.newLine();
            writer.write(this.getMergeSource2().toString());
            writer.newLine();
            writer.write(this.getMergeTarget().getAbsolutePath());
            writer.newLine();
            if (this.getRemainingRanges() != null) {
                writer.write(this.getRemainingRanges().toString());
            }
            writer.newLine();
            writer.write(String.valueOf(this.isUpdateWCMergeInfo()));
            writer.newLine();
            SVNCopySource source = this.getTargetCopySource();
            if (source != null) {
                String path = source.getURL() == null ? source.getFile().getAbsolutePath() : source.getURL().toString();
                writer.write(path);
            }
            writer.newLine();
            if (source != null) {
                SVNRevision pegRevision = source.getPegRevision() == null ? SVNRevision.UNDEFINED : source.getPegRevision();
                writer.write(pegRevision.toString());
            }
            writer.newLine();
            if (source != null) {
                SVNRevision revision = source.getRevision() == null ? SVNRevision.UNDEFINED : source.getRevision();
                writer.write(revision.toString());
            }
            writer.newLine();
            writer.newLine();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("merge task: source from ");
            buffer.append(this.getMergeSource());
            buffer.append("; source to");
            buffer.append(this.getMergeSource2());
            buffer.append("; target ");
            buffer.append(this.getMergeTarget());
            buffer.append("; revision ranges ");
            if (this.getRemainingRanges() == null) {
                buffer.append("[NULL]");
            } else {
                buffer.append(this.getRemainingRanges().toString());
            }
            buffer.append("; copy source ");
            if (this.getTargetCopySource() != null) {
                buffer.append(this.getTargetCopySource().isURL() ? this.getTargetCopySource().getURL().toString() : this.getTargetCopySource().getFile().getAbsolutePath());
                buffer.append("@");
                buffer.append(this.getTargetCopySource().getPegRevision().toString());
                buffer.append(" revision ");
                buffer.append(this.getTargetCopySource().getRevision());
            } else {
                buffer.append("[NULL]");
            }
            return buffer.toString();
        }
    }
}

