/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea14Factory
extends SVNAdminAreaFactory {
    public static final int WC_FORMAT = 8;

    protected void doCreateVersionedDirectory(File path, String url, String rootURL, String uuid, long revNumber, SVNDepth depth) throws SVNException {
        SVNAdminArea14 adminArea = new SVNAdminArea14(path);
        ((SVNAdminArea)adminArea).createVersionedDirectory(path, url, rootURL, uuid, revNumber, true, depth);
    }

    protected SVNAdminArea doOpen(File path, int version) throws SVNException {
        if (version != this.getSupportedVersion()) {
            return null;
        }
        return new SVNAdminArea14(path);
    }

    protected SVNAdminArea doChangeWCFormat(SVNAdminArea adminArea) throws SVNException {
        if (adminArea == null || adminArea.getClass() == SVNAdminArea14.class) {
            return adminArea;
        }
        SVNAdminArea14 newestAdminArea = new SVNAdminArea14(adminArea.getRoot());
        newestAdminArea.setLocked(true);
        return newestAdminArea.formatWC(adminArea);
    }

    public int getSupportedVersion() {
        return 8;
    }

    protected int doCheckWC(File path, Level logLevel) throws SVNException {
        SVNErrorMessage err;
        String line;
        int formatVersion;
        File entriesFile;
        block10: {
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            entriesFile = new File(adminDir, "entries");
            formatVersion = -1;
            BufferedReader reader = null;
            line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(entriesFile, logLevel, SVNLogType.WC), "UTF-8"));
                line = reader.readLine();
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", new Object[]{entriesFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(reader);
                break block10;
            }
            catch (SVNException svne) {
                block11: {
                    block12: {
                        try {
                            SVNFileType type = SVNFileType.getType(path);
                            if (type == SVNFileType.DIRECTORY && entriesFile.exists()) break block11;
                            if (type != SVNFileType.NONE) break block12;
                            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' does not exist", path);
                            SVNErrorManager.error(err2, SVNLogType.WC);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(reader);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(reader);
                    return 0;
                }
                throw svne;
            }
            SVNFileUtil.closeFile(reader);
        }
        if (line == null || line.length() == 0) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", entriesFile);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", entriesFile);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return formatVersion;
    }

    protected int getVersion(File path) throws SVNException {
        SVNErrorMessage err;
        String line;
        int formatVersion;
        File entriesFile;
        block9: {
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            entriesFile = new File(adminDir, "entries");
            formatVersion = -1;
            BufferedReader reader = null;
            line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(entriesFile, Level.FINEST, SVNLogType.WC), "UTF-8"));
                line = reader.readLine();
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", new Object[]{entriesFile, e.getLocalizedMessage()});
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(reader);
                break block9;
            }
            catch (SVNException svne) {
                try {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
                    err.setChildErrorMessage(svne.getErrorMessage());
                    SVNErrorManager.error(err, svne, Level.FINEST, SVNLogType.WC);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(reader);
                    throw throwable;
                }
                SVNFileUtil.closeFile(reader);
                break block9;
            }
            SVNFileUtil.closeFile(reader);
        }
        if (line == null || line.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", entriesFile);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            err1.setChildErrorMessage(err2);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", entriesFile);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            err1.setChildErrorMessage(err);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        return formatVersion;
    }
}

