/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNRepositoryPool
implements ISVNRepositoryPool,
ISVNSession,
ISVNConnectionListener {
    public static final int RUNTIME_POOL = 1;
    public static final int INSTANCE_POOL = 2;
    public static final int NO_POOL = 4;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static Timer ourTimer;
    private static volatile int ourInstanceCount;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private Map myPool;
    private long myTimeout;
    private Map myInactiveRepositories = new SVNHashMap();
    private Timer myTimer;
    private boolean myIsKeepConnection;

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider) {
        this(authManager, tunnelProvider, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, long timeout, boolean keepConnection) {
        this.myAuthManager = authManager;
        this.myTunnelProvider = tunnelProvider;
        this.myDebugLog = SVNDebugLog.getDefaultLog();
        this.myTimeout = timeout > 0L ? timeout : 60000L;
        this.myIsKeepConnection = keepConnection;
        this.myTimeout = timeout;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer == null) {
                ourTimer = new Timer(true);
            }
            if (this.myIsKeepConnection) {
                this.myTimer = ourTimer;
                ourTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
            }
            ++ourInstanceCount;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, boolean keepConnections, int poolMode) {
        this(authManager, tunnelProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (this.myIsKeepConnection && this.myTimer == null && ourTimer != null) {
                this.myTimer = ourTimer;
                this.myTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            SVNRepository repos = null;
            Map pool = this.getPool();
            if (!mayReuse || pool == null) {
                repos = SVNRepositoryFactory.create(url, this);
                repos.setAuthenticationManager(this.myAuthManager);
                repos.setTunnelProvider(this.myTunnelProvider);
                repos.setDebugLog(this.myDebugLog);
                return repos;
            }
            repos = (SVNRepository)pool.get(url.getProtocol());
            if (repos != null) {
                repos.setLocation(url, false);
            } else {
                repos = SVNRepositoryFactory.create(url, this);
                if (this.myIsKeepConnection) {
                    repos.addConnectionListener(this);
                }
                pool.put(url.getProtocol(), repos);
            }
            repos.setAuthenticationManager(this.myAuthManager);
            repos.setTunnelProvider(this.myTunnelProvider);
            repos.setDebugLog(this.myDebugLog);
            return repos;
        }
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = authManager;
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setAuthenticationManager(this.myAuthManager);
        }
    }

    public boolean keepConnection(SVNRepository repository) {
        return this.myIsKeepConnection;
    }

    public synchronized void shutdownConnections(boolean shutdownAll) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.clear();
            this.myTimer = null;
        }
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.closeSession();
        }
        this.myPool = null;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (--ourInstanceCount <= 0) {
                ourInstanceCount = 0;
                DefaultSVNRepositoryPool.shutdownTimer();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownTimer() {
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer != null) {
                ourTimer.cancel();
                ourTimer = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void saveCommitMessage(SVNRepository repository, long revision, String message) {
    }

    public String getCommitMessage(SVNRepository repository, long revision) {
        return null;
    }

    public boolean hasCommitMessage(SVNRepository repository, long revision) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(SVNRepository repository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.put(repository, new Long(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened(SVNRepository repository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.remove(repository);
        }
    }

    public void setCanceller(ISVNCanceller canceller) {
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setCanceller(canceller);
        }
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log == null ? SVNDebugLog.getDefaultLog() : log;
        Map pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = (SVNRepository)pool.get(key);
            repository.setDebugLog(this.myDebugLog);
        }
    }

    private long getTimeout() {
        return this.myTimeout;
    }

    private Map getPool() {
        if (this.myPool == null) {
            this.myPool = new SVNHashMap();
        }
        return this.myPool;
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                boolean scheduled = false;
                try {
                    long currentTime = System.currentTimeMillis();
                    Map map = DefaultSVNRepositoryPool.this.myInactiveRepositories;
                    synchronized (map) {
                        Iterator repositories = DefaultSVNRepositoryPool.this.myInactiveRepositories.keySet().iterator();
                        while (repositories.hasNext()) {
                            SVNRepository repos = (SVNRepository)repositories.next();
                            long time = (Long)DefaultSVNRepositoryPool.this.myInactiveRepositories.get(repos);
                            if (currentTime - time < DefaultSVNRepositoryPool.this.getTimeout()) continue;
                            repositories.remove();
                            repos.closeSession();
                        }
                        if (DefaultSVNRepositoryPool.this.myTimer != null) {
                            DefaultSVNRepositoryPool.this.myTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
                            scheduled = true;
                        }
                    }
                }
                catch (Throwable th) {
                    SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, th);
                    if (scheduled || DefaultSVNRepositoryPool.this.myTimer == null) break block7;
                    DefaultSVNRepositoryPool.this.myTimer.schedule((TimerTask)new TimeoutTask(), 10000L);
                    scheduled = true;
                }
            }
        }
    }
}

