/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPathListHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNBasicClient
implements ISVNEventHandler {
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNOptions myOptions;
    private ISVNEventHandler myEventDispatcher;
    private List myPathPrefixesStack;
    private boolean myIsIgnoreExternals;
    private boolean myIsLeaveConflictsUnresolved;
    private ISVNDebugLog myDebugLog;
    private ISVNPathListHandler myPathListHandler;

    protected SVNBasicClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        this(new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager, (ISVNTunnelProvider)options, 0L, false), options);
    }

    protected SVNBasicClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        this.myRepositoryPool = repositoryPool;
        this.setOptions(options);
        this.myPathPrefixesStack = new LinkedList();
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
    }

    public void setIgnoreExternals(boolean ignore) {
        this.myIsIgnoreExternals = ignore;
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setLeaveConflictsUnresolved(boolean leave) {
        this.myIsLeaveConflictsUnresolved = leave;
    }

    public boolean isLeaveConflictsUnresolved() {
        return this.myIsLeaveConflictsUnresolved;
    }

    public void setEventHandler(ISVNEventHandler dispatcher) {
        this.myEventDispatcher = dispatcher;
    }

    public void setPathListHandler(ISVNPathListHandler handler) {
        this.myPathListHandler = handler;
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    public SVNURL getReposRoot(File path, SVNURL url, SVNRevision pegRevision, SVNAdminArea adminArea, SVNWCAccess access) throws SVNException {
        SVNURL reposRoot = null;
        if (path != null && (pegRevision == SVNRevision.WORKING || pegRevision == SVNRevision.BASE)) {
            if (access == null) {
                access = this.createWCAccess();
            }
            boolean needCleanUp = false;
            try {
                if (adminArea == null) {
                    adminArea = access.probeOpen(path, false, 0);
                    needCleanUp = true;
                }
                SVNEntry entry = access.getVersionedEntry(path, false);
                url = this.getEntryLocation(path, entry, null, SVNRevision.UNDEFINED);
                reposRoot = entry.getRepositoryRootURL();
            }
            finally {
                if (needCleanUp) {
                    access.closeAdminArea(path);
                }
            }
        }
        if (reposRoot == null) {
            SVNRepository repos = null;
            try {
                repos = this.createRepository(url, path, null, pegRevision, pegRevision, null);
                reposRoot = repos.getRepositoryRoot(true);
            }
            finally {
                if (repos != null) {
                    repos.closeSession();
                }
            }
        }
        return reposRoot;
    }

    protected void sleepForTimeStamp() {
        if (this.myPathPrefixesStack == null || this.myPathPrefixesStack.isEmpty()) {
            SVNFileUtil.sleepForTimestamp();
        }
    }

    protected SVNRepository createRepository(SVNURL url, File path, SVNWCAccess access, boolean mayReuse) throws SVNException {
        SVNEntry entry;
        String uuid = null;
        if (access != null && (entry = access.getEntry(path, false)) != null) {
            uuid = entry.getUUID();
        }
        return this.createRepository(url, uuid, mayReuse);
    }

    protected SVNRepository createRepository(SVNURL url, String uuid, boolean mayReuse) throws SVNException {
        String reposUUID;
        SVNRepository repository = null;
        repository = this.myRepositoryPool == null ? SVNRepositoryFactory.create(url, null) : this.myRepositoryPool.createRepository(url, mayReuse);
        if (uuid != null && !uuid.equals(reposUUID = repository.getRepositoryUUID(true))) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", new Object[]{reposUUID, uuid});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        repository.setDebugLog(this.getDebugLog());
        repository.setCanceller(this.getEventDispatcher());
        return repository;
    }

    protected ISVNRepositoryPool getRepositoryPool() {
        return this.myRepositoryPool;
    }

    protected void dispatchEvent(SVNEvent event) throws SVNException {
        this.dispatchEvent(event, -1.0);
    }

    protected void dispatchEvent(SVNEvent event, double progress) throws SVNException {
        if (this.myEventDispatcher != null) {
            try {
                this.myEventDispatcher.handleEvent(event, progress);
            }
            catch (SVNException e) {
                throw e;
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, th);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", new Object[]{th.getMessage()}, 0, th);
                SVNErrorManager.error(err, th, SVNLogType.DEFAULT);
            }
        }
    }

    public void setEventPathPrefix(String prefix) {
        if (prefix == null && !this.myPathPrefixesStack.isEmpty()) {
            this.myPathPrefixesStack.remove(this.myPathPrefixesStack.size() - 1);
        } else if (prefix != null) {
            this.myPathPrefixesStack.add(prefix);
        }
    }

    protected ISVNEventHandler getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected SVNWCAccess createWCAccess() {
        return this.createWCAccess(null);
    }

    protected SVNWCAccess createWCAccess(String pathPrefix) {
        ISVNEventHandler eventHandler = null;
        eventHandler = pathPrefix != null ? new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                SVNBasicClient.this.dispatchEvent(event, progress);
            }

            public void checkCancelled() throws SVNCancelException {
                SVNBasicClient.this.checkCancelled();
            }
        } : this;
        SVNWCAccess access = SVNWCAccess.newInstance(eventHandler);
        access.setOptions(this.myOptions);
        return access;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        this.dispatchEvent(event, progress);
    }

    public void handlePathListItem(File path) throws SVNException {
        if (this.myPathListHandler != null && path != null) {
            this.myPathListHandler.handlePathListItem(path);
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myEventDispatcher != null) {
            this.myEventDispatcher.checkCancelled();
        }
    }

    protected long getRevisionNumber(SVNRevision revision, SVNRepository repository, File path) throws SVNException {
        return this.getRevisionNumber(revision, null, repository, path);
    }

    protected long getRevisionNumber(SVNRevision revision, long[] latestRevisionNumber, SVNRepository repository, File path) throws SVNException {
        SVNErrorMessage err;
        if (repository == null && (revision == SVNRevision.HEAD || revision.getDate() != null)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (revision.getNumber() >= 0L) {
            return revision.getNumber();
        }
        if (revision.getDate() != null) {
            return repository.getDatedRevision(revision.getDate());
        }
        if (revision == SVNRevision.HEAD) {
            if (latestRevisionNumber != null && latestRevisionNumber.length > 0 && SVNRevision.isValidRevisionNumber(latestRevisionNumber[0])) {
                return latestRevisionNumber[0];
            }
            long latestRevision = repository.getLatestRevision();
            if (latestRevisionNumber != null && latestRevisionNumber.length > 0) {
                latestRevisionNumber[0] = latestRevision;
            }
            return latestRevision;
        }
        if (!revision.isValid()) {
            return -1L;
        }
        if (revision == SVNRevision.COMMITTED || revision == SVNRevision.WORKING || revision == SVNRevision.BASE || revision == SVNRevision.PREVIOUS) {
            if (path == null) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNWCAccess wcAccess = this.createWCAccess();
            wcAccess.probeOpen(path, false, 0);
            SVNEntry entry = null;
            try {
                entry = wcAccess.getVersionedEntry(path, false);
            }
            finally {
                wcAccess.close();
            }
            if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
                return entry.getRevision();
            }
            if (entry.getCommittedRevision() < 0L) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", path);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            return revision == SVNRevision.PREVIOUS ? entry.getCommittedRevision() - 1L : entry.getCommittedRevision();
        }
        err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", path != null ? path : repository.getLocation());
        SVNErrorManager.error(err, SVNLogType.WC);
        return -1L;
    }

    protected SVNRepository createRepository(SVNURL url, File path, SVNAdminArea area, SVNRevision pegRevision, SVNRevision revision, long[] pegRev) throws SVNException {
        SVNURL pathURL;
        if (url == null && (pathURL = this.getURL(path)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRevision startRevision = revision;
        SVNRevision[] resolvedRevisions = this.resolveRevisions(pegRevision, startRevision, url != null, true);
        pegRevision = resolvedRevisions[0];
        startRevision = resolvedRevisions[1];
        SVNRepositoryLocation[] locations = this.getLocations(url, path, null, pegRevision, startRevision, SVNRevision.UNDEFINED);
        url = locations[0].getURL();
        long actualRevision = locations[0].getRevisionNumber();
        SVNRepository repository = this.createRepository(url, area != null ? area.getRoot() : null, area != null ? area.getWCAccess() : null, true);
        if ((actualRevision = this.getRevisionNumber(SVNRevision.create(actualRevision), repository, path)) < 0L) {
            actualRevision = repository.getLatestRevision();
        }
        if (pegRev != null && pegRev.length > 0) {
            pegRev[0] = actualRevision;
        }
        return repository;
    }

    protected SVNRevision[] resolveRevisions(SVNRevision pegRevision, SVNRevision revision, boolean isURL, boolean noticeLocalModifications) {
        if (!pegRevision.isValid()) {
            pegRevision = isURL ? SVNRevision.HEAD : (noticeLocalModifications ? SVNRevision.WORKING : SVNRevision.BASE);
        }
        if (!revision.isValid()) {
            revision = pegRevision;
        }
        return new SVNRevision[]{pegRevision, revision};
    }

    protected void elideMergeInfo(SVNWCAccess access, File path, SVNEntry entry, File wcElisionLimitPath) throws SVNException {
        if (wcElisionLimitPath == null || !wcElisionLimitPath.equals(path)) {
            Map mergeInfo = null;
            Map targetMergeInfo = null;
            boolean[] inherited = new boolean[1];
            targetMergeInfo = this.getWCMergeInfo(path, entry, wcElisionLimitPath, SVNMergeInfoInheritance.INHERITED, false, inherited);
            if (inherited[0] || targetMergeInfo == null) {
                return;
            }
            mergeInfo = this.getWCMergeInfo(path, entry, wcElisionLimitPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false, inherited);
            if (mergeInfo == null && wcElisionLimitPath == null) {
                mergeInfo = this.getWCOrRepositoryMergeInfo(path, entry, SVNMergeInfoInheritance.NEAREST_ANCESTOR, inherited, true, null);
            }
            if (mergeInfo == null && wcElisionLimitPath != null) {
                return;
            }
            SVNMergeInfoUtil.elideMergeInfo(mergeInfo, targetMergeInfo, path, null, access);
        }
    }

    protected Map getReposMergeInfo(SVNRepository repository, String path, long revision, SVNMergeInfoInheritance inheritance, boolean squelchIncapable) throws SVNException {
        SVNMergeInfo mergeInfo;
        Map reposMergeInfo;
        block10: {
            SVNURL oldURL = this.ensureSessionURL(repository, null);
            reposMergeInfo = null;
            try {
                try {
                    reposMergeInfo = repository.getMergeInfo(new String[]{path}, revision, inheritance, false);
                }
                catch (SVNException svne) {
                    if (!squelchIncapable || svne.getErrorMessage().getErrorCode() != SVNErrorCode.UNSUPPORTED_FEATURE) {
                        throw svne;
                    }
                    if (oldURL != null) {
                        repository.setLocation(oldURL, false);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (oldURL != null) {
                    repository.setLocation(oldURL, false);
                }
                throw throwable;
            }
            if (oldURL != null) {
                repository.setLocation(oldURL, false);
            }
        }
        Map targetMergeInfo = null;
        if (reposMergeInfo != null && (mergeInfo = (SVNMergeInfo)reposMergeInfo.get(path)) != null) {
            targetMergeInfo = mergeInfo.getMergeSourcesToMergeLists();
        }
        return targetMergeInfo;
    }

    protected Map getWCOrRepositoryMergeInfo(File path, SVNEntry entry, SVNMergeInfoInheritance inherit, boolean[] indirect, boolean reposOnly, SVNRepository repository) throws SVNException {
        Map fileToProp;
        SVNPropertyValue mergeInfoProp;
        Map mergeInfo = null;
        long[] targetRev = new long[]{-1L};
        SVNURL url = this.getEntryLocation(path, entry, targetRev, SVNRevision.WORKING);
        long revision = targetRev[0];
        if (!reposOnly) {
            mergeInfo = this.getWCMergeInfo(path, entry, null, inherit, false, indirect);
        }
        if (mergeInfo == null && !entry.isScheduledForAddition() && (mergeInfoProp = (SVNPropertyValue)(fileToProp = SVNPropertiesManager.getWorkingCopyPropertyValues(path, entry, "svn:mergeinfo", SVNDepth.EMPTY, true)).get(path)) == null) {
            boolean closeRepository = false;
            Map reposMergeInfo = null;
            String repositoryPath = null;
            try {
                if (repository == null) {
                    repository = this.createRepository(url, null, null, false);
                    closeRepository = true;
                }
                repositoryPath = this.getPathRelativeToRoot(null, url, entry.getRepositoryRootURL(), null, repository);
                reposMergeInfo = this.getReposMergeInfo(repository, repositoryPath, revision, inherit, true);
            }
            finally {
                if (closeRepository) {
                    repository.closeSession();
                }
            }
            if (reposMergeInfo != null) {
                indirect[0] = true;
                mergeInfo = reposMergeInfo;
            }
        }
        return mergeInfo;
    }

    protected Map getWCMergeInfo(File path, SVNEntry entry, File limitPath, SVNMergeInfoInheritance inherit, boolean base, boolean[] inherited) throws SVNException {
        Map mergeInfo;
        Map wcMergeInfo;
        String walkPath;
        block19: {
            walkPath = "";
            wcMergeInfo = null;
            SVNWCAccess wcAccess = this.createWCAccess();
            mergeInfo = null;
            if (limitPath != null) {
                limitPath = new File(SVNPathUtil.validateFilePath(limitPath.getAbsolutePath())).getAbsoluteFile();
            }
            while (true) {
                if (inherit == SVNMergeInfoInheritance.NEAREST_ANCESTOR) {
                    wcMergeInfo = null;
                    inherit = SVNMergeInfoInheritance.INHERITED;
                } else {
                    wcMergeInfo = SVNPropertiesManager.parseMergeInfo(path, entry, base);
                }
                if (SVNWCManager.isEntrySwitched(path, entry)) {
                    break block19;
                }
                path = new File(SVNPathUtil.validateFilePath(path.getAbsolutePath())).getAbsoluteFile();
                if (wcMergeInfo != null || inherit == SVNMergeInfoInheritance.EXPLICIT || path.getParentFile() == null) break block19;
                if (limitPath != null && limitPath.equals(path)) {
                    break block19;
                }
                walkPath = SVNPathUtil.append(path.getName(), walkPath);
                path = path.getParentFile();
                try {
                    wcAccess.open(path, false, 0);
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        mergeInfo = wcMergeInfo;
                        inherited[0] = false;
                        Map map = mergeInfo;
                        wcAccess.close();
                        return map;
                    }
                    throw svne;
                }
                entry = wcAccess.getEntry(path, false);
                if (entry != null) {
                    continue;
                }
                break block19;
                break;
            }
            finally {
                wcAccess.close();
            }
        }
        inherited[0] = false;
        if (walkPath.length() == 0) {
            mergeInfo = wcMergeInfo;
        } else if (wcMergeInfo != null) {
            mergeInfo = SVNMergeInfoUtil.adjustMergeInfoSourcePaths(null, walkPath, wcMergeInfo);
            inherited[0] = true;
        } else {
            mergeInfo = null;
        }
        if (inherited[0]) {
            mergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(mergeInfo, null, -1L, -1L);
            SVNMergeInfoUtil.removeEmptyRangeLists(mergeInfo);
        }
        return mergeInfo;
    }

    protected long getPathLastChangeRevision(String relPath, long revision, SVNRepository repository) throws SVNException {
        final long[] rev = new long[]{-1L};
        repository.log(new String[]{relPath}, 1L, revision, false, true, 1L, false, null, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                rev[0] = logEntry.getRevision();
            }
        });
        return rev[0];
    }

    protected String getPathRelativeToRoot(File path, SVNURL url, SVNURL reposRootURL, SVNWCAccess wcAccess, SVNRepository repos) throws SVNException {
        if (path != null) {
            boolean cleanUp = false;
            try {
                if (wcAccess == null) {
                    wcAccess = this.createWCAccess();
                    wcAccess.probeOpen(path, false, 0);
                    cleanUp = true;
                }
                SVNEntry entry = wcAccess.getVersionedEntry(path, false);
                url = this.getEntryLocation(path, entry, null, SVNRevision.UNDEFINED);
                if (reposRootURL == null) {
                    reposRootURL = entry.getRepositoryRootURL();
                }
            }
            finally {
                if (cleanUp) {
                    wcAccess.closeAdminArea(path);
                }
            }
        }
        if (reposRootURL == null) {
            reposRootURL = repos.getRepositoryRoot(true);
        }
        String reposRootPath = reposRootURL.getPath();
        String absPath = url.getPath();
        if (!absPath.startsWith(reposRootPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", new Object[]{url, reposRootURL});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!(absPath = absPath.substring(reposRootPath.length())).startsWith("/")) {
            absPath = "/" + absPath;
        }
        return absPath;
    }

    protected SVNRepositoryLocation[] getLocations(SVNURL url, File path, SVNRepository repository, SVNRevision revision, SVNRevision start, SVNRevision end) throws SVNException {
        SVNErrorMessage err;
        Object source;
        long[] lArray;
        if (!revision.isValid() || !start.isValid()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION), SVNLogType.DEFAULT);
        }
        long pegRevisionNumber = -1L;
        long[] youngestRevNumber = new long[]{-1L};
        if (path != null) {
            SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
            try {
                wcAccess.openAnchor(path, false, 0);
                SVNEntry entry = wcAccess.getEntry(path, false);
                if (entry.getCopyFromURL() != null && revision == SVNRevision.WORKING) {
                    url = entry.getCopyFromSVNURL();
                    pegRevisionNumber = entry.getCopyFromRevision();
                    if (entry.getURL() == null || !entry.getURL().equals(entry.getCopyFromURL())) {
                        repository = null;
                    }
                } else if (entry.getURL() != null) {
                    url = entry.getSVNURL();
                } else {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            }
            finally {
                wcAccess.close();
            }
        }
        String repoPath = "";
        Map locations = null;
        SVNURL rootURL = null;
        if (repository == null) {
            repository = this.createRepository(url, null, null, true);
        } else {
            repoPath = SVNPathUtil.getPathAsChild(repository.getLocation().toString(), url.toString());
            if (repoPath == null) {
                repoPath = "";
            }
        }
        if (pegRevisionNumber < 0L) {
            pegRevisionNumber = this.getRevisionNumber(revision, youngestRevNumber, repository, path);
        }
        long startRevisionNumber = revision == start && revision == SVNRevision.HEAD ? pegRevisionNumber : this.getRevisionNumber(start, youngestRevNumber, repository, path);
        long endRevisionNumber = !end.isValid() ? startRevisionNumber : this.getRevisionNumber(end, youngestRevNumber, repository, path);
        if (endRevisionNumber == pegRevisionNumber && startRevisionNumber == pegRevisionNumber) {
            SVNRepositoryLocation[] result = new SVNRepositoryLocation[]{new SVNRepositoryLocation(url, startRevisionNumber), new SVNRepositoryLocation(url, endRevisionNumber)};
            return result;
        }
        rootURL = repository.getRepositoryRoot(true);
        if (startRevisionNumber == endRevisionNumber) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = startRevisionNumber;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = startRevisionNumber;
            lArray = lArray3;
            lArray3[1] = endRevisionNumber;
        }
        long[] revisionsRange = lArray;
        try {
            locations = repository.getLocations(repoPath, (Map)null, pegRevisionNumber, revisionsRange);
        }
        catch (SVNException e) {
            if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                locations = this.getLocations10(repository, pegRevisionNumber, startRevisionNumber, endRevisionNumber);
            }
            throw e;
        }
        SVNLocationEntry startPath = (SVNLocationEntry)locations.get(new Long(startRevisionNumber));
        SVNLocationEntry endPath = (SVNLocationEntry)locations.get(new Long(endRevisionNumber));
        if (startPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Unable to find repository location for ''{0}'' in revision ''{1}''", new Object[]{source, new Long(startRevisionNumber)});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (endPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "The location for ''{0}'' for revision {1} does not exist in the repository or refers to an unrelated object", new Object[]{source, new Long(endRevisionNumber)});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRepositoryLocation[] result = new SVNRepositoryLocation[2];
        SVNURL startURL = SVNURL.parseURIEncoded(SVNPathUtil.append(rootURL.toString(), SVNEncodingUtil.uriEncode(startPath.getPath())));
        result[0] = new SVNRepositoryLocation(startURL, startRevisionNumber);
        if (end.isValid()) {
            SVNURL endURL = SVNURL.parseURIEncoded(SVNPathUtil.append(rootURL.toString(), SVNEncodingUtil.uriEncode(endPath.getPath())));
            result[1] = new SVNRepositoryLocation(endURL, endRevisionNumber);
        }
        return result;
    }

    private Map getLocations10(SVNRepository repos, long pegRevision, long startRevision, long endRevision) throws SVNException {
        String endPath;
        String path = repos.getRepositoryPath("");
        SVNNodeKind kind = repos.checkPath("", pegRevision);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' doesn't exist at revision {1}", new Object[]{path, new Long(pegRevision)});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        long logStart = pegRevision;
        logStart = Math.max(startRevision, logStart);
        logStart = Math.max(endRevision, logStart);
        long logEnd = pegRevision;
        logStart = Math.min(startRevision, logStart);
        logStart = Math.min(endRevision, logStart);
        LocationsLogEntryHandler handler = new LocationsLogEntryHandler(path, startRevision, endRevision, pegRevision, kind, this.getEventDispatcher());
        repos.log(new String[]{""}, logStart, logEnd, true, false, handler);
        String pegPath = handler.myPegPath == null ? handler.myCurrentPath : handler.myPegPath;
        String startPath = handler.myStartPath == null ? handler.myCurrentPath : handler.myStartPath;
        String string = endPath = handler.myEndPath == null ? handler.myCurrentPath : handler.myEndPath;
        if (pegPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "path ''{0}'' in revision {1} is an unrelated object", new Object[]{path, new Long(logStart)});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNHashMap result = new SVNHashMap();
        result.put(new Long(startRevision), new SVNLocationEntry(-1L, startPath));
        result.put(new Long(endRevision), new SVNLocationEntry(-1L, endPath));
        return result;
    }

    private static String getPreviousLogPath(String path, SVNLogEntry logEntry, SVNNodeKind kind) throws SVNException {
        String prevPath = null;
        SVNLogEntryPath logPath = (SVNLogEntryPath)logEntry.getChangedPaths().get(path);
        if (logPath != null) {
            if (logPath.getType() != 'A' && logPath.getType() != 'R') {
                return logPath.getPath();
            }
            if (logPath.getCopyPath() != null) {
                return logPath.getCopyPath();
            }
            return null;
        }
        if (!logEntry.getChangedPaths().isEmpty()) {
            SVNHashMap sortedMap = new SVNHashMap();
            sortedMap.putAll(logEntry.getChangedPaths());
            ArrayList pathsList = new ArrayList(sortedMap.keySet());
            Collections.sort(pathsList, SVNPathUtil.PATH_COMPARATOR);
            Collections.reverse(pathsList);
            for (String p : pathsList) {
                SVNLogEntryPath lPath;
                if (!path.startsWith(String.valueOf(p) + "/") || (lPath = (SVNLogEntryPath)sortedMap.get(p)).getCopyPath() == null) continue;
                prevPath = SVNPathUtil.append(lPath.getCopyPath(), path.substring(p.length()));
                break;
            }
        }
        if (prevPath == null) {
            if (kind == SVNNodeKind.DIR) {
                prevPath = path;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Missing changed-path information for ''{0}'' in revision {1}", new Object[]{path, new Long(logEntry.getRevision())});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return prevPath;
    }

    protected SVNURL getURL(File path) throws SVNException {
        return this.deriveLocation(path, null, null, SVNRevision.UNDEFINED, null, null);
    }

    protected SVNURL deriveLocation(File path, SVNURL url, long[] pegRevisionNumber, SVNRevision pegRevision, SVNRepository repos, SVNWCAccess access) throws SVNException {
        if (path != null) {
            SVNEntry entry = null;
            if (access != null) {
                entry = access.getVersionedEntry(path, false);
            } else {
                SVNWCAccess wcAccess = this.createWCAccess();
                try {
                    wcAccess.probeOpen(path, false, 0);
                    entry = wcAccess.getVersionedEntry(path, false);
                }
                finally {
                    wcAccess.close();
                }
            }
            url = this.getEntryLocation(path, entry, pegRevisionNumber, pegRevision);
        }
        if (pegRevisionNumber != null && pegRevisionNumber.length > 0 && !SVNRevision.isValidRevisionNumber(pegRevisionNumber[0])) {
            boolean closeRepository = false;
            try {
                if (repos == null) {
                    repos = this.createRepository(url, null, null, false);
                    closeRepository = true;
                }
                pegRevisionNumber[0] = this.getRevisionNumber(pegRevision, null, repos, path);
            }
            finally {
                if (closeRepository) {
                    repos.closeSession();
                }
            }
        }
        return url;
    }

    protected SVNURL getEntryLocation(File path, SVNEntry entry, long[] revNum, SVNRevision pegRevision) throws SVNException {
        SVNURL url = null;
        if (entry.getCopyFromURL() != null && pegRevision == SVNRevision.WORKING) {
            url = entry.getCopyFromSVNURL();
            if (revNum != null && revNum.length > 0) {
                revNum[0] = entry.getCopyFromRevision();
            }
        } else if (entry.getURL() != null) {
            url = entry.getSVNURL();
            if (revNum != null && revNum.length > 0) {
                revNum[0] = entry.getRevision();
            }
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return url;
    }

    protected SVNURL ensureSessionURL(SVNRepository repository, SVNURL url) throws SVNException {
        SVNURL oldURL = repository.getLocation();
        if (url == null) {
            url = repository.getRepositoryRoot(true);
        }
        if (!url.equals(oldURL)) {
            repository.setLocation(url, false);
            return oldURL;
        }
        return null;
    }

    protected int getLevelsToLockFromDepth(SVNDepth depth) {
        return depth == SVNDepth.EMPTY || depth == SVNDepth.FILES ? 0 : (depth == SVNDepth.IMMEDIATES ? 1 : -1);
    }

    protected void setCommitItemAccess(SVNCommitItem item, SVNWCAccess access) {
        item.setWCAccess(access);
    }

    protected void setCommitItemProperty(SVNCommitItem item, String name, SVNPropertyValue value) {
        item.setProperty(name, value);
    }

    private static final class LocationsLogEntryHandler
    implements ISVNLogEntryHandler {
        private String myCurrentPath = null;
        private String myStartPath = null;
        private String myEndPath = null;
        private String myPegPath = null;
        private long myStartRevision;
        private long myEndRevision;
        private long myPegRevision;
        private SVNNodeKind myKind;
        private ISVNEventHandler myEventHandler;

        private LocationsLogEntryHandler(String path, long startRevision, long endRevision, long pegRevision, SVNNodeKind kind, ISVNEventHandler eventHandler) {
            this.myCurrentPath = path;
            this.myStartRevision = startRevision;
            this.myEndRevision = endRevision;
            this.myPegRevision = pegRevision;
            this.myEventHandler = eventHandler;
            this.myKind = kind;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.myEventHandler != null) {
                this.myEventHandler.checkCancelled();
            }
            if (logEntry.getChangedPaths() == null) {
                return;
            }
            if (this.myCurrentPath == null) {
                return;
            }
            if (this.myStartPath == null && logEntry.getRevision() <= this.myStartRevision) {
                this.myStartPath = this.myCurrentPath;
            }
            if (this.myEndPath == null && logEntry.getRevision() <= this.myEndRevision) {
                this.myEndPath = this.myCurrentPath;
            }
            if (this.myPegPath == null && logEntry.getRevision() <= this.myPegRevision) {
                this.myPegPath = this.myCurrentPath;
            }
            this.myCurrentPath = SVNBasicClient.getPreviousLogPath(this.myCurrentPath, logEntry, this.myKind);
        }
    }

    protected static class RepositoryReference {
        public String URL;
        public long Revision;

        public RepositoryReference(String url, long rev) {
            this.URL = url;
            this.Revision = rev;
        }
    }

    protected static class SVNRepositoryLocation {
        private SVNURL myURL;
        private long myRevision;

        public SVNRepositoryLocation(SVNURL url, long rev) {
            this.myURL = url;
            this.myRevision = rev;
        }

        public long getRevisionNumber() {
            return this.myRevision;
        }

        public SVNURL getURL() {
            return this.myURL;
        }
    }
}

