/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.QSequenceDifference;
import de.regnis.q.sequence.QSequenceDifferenceBlockShifter;
import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceDummyCanceller;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCache;
import de.regnis.q.sequence.line.QSequenceLineMemoryCache;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.QSequenceLineSystemTempDirectoryFactory;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMedia;
import de.regnis.q.sequence.media.QSequenceDiscardingMediaNoConfusionDectector;
import de.regnis.q.sequence.media.QSequenceMediaComparer;
import de.regnis.q.sequence.media.QSequenceMediaDummyIndexTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class QSequenceLineMedia
implements QSequenceCachableMedia,
QSequenceMediaComparer {
    public static final int FILE_SEGMENT_SIZE = 16384;
    public static final int SEGMENT_ENTRY_SIZE = 16;
    public static final int MEMORY_THRESHOLD = QSequenceLineMedia.parseMemoryTreshold(System.getProperty("q.sequence.memory-threshold", "1M"));
    public static final double SEARCH_DEPTH_EXPONENT = System.getProperty("q.sequence.search-depth-exponent") != null ? Math.max(0.1, Math.min(1.0, Double.parseDouble(System.getProperty("q.sequence.search-depth-exponent")))) : 0.5;
    private final QSequenceLineCache leftCache;
    private final QSequenceLineCache rightCache;

    public static QSequenceLineCache readLines(QSequenceLineRAData data) throws IOException {
        if (data.length() <= (long)MEMORY_THRESHOLD) {
            InputStream stream = data.read(0L, data.length());
            try {
                QSequenceLineMemoryCache qSequenceLineMemoryCache = QSequenceLineMemoryCache.read(stream, new QSequenceLineDummySimplifier());
                return qSequenceLineMemoryCache;
            }
            finally {
                stream.close();
            }
        }
        return QSequenceLineFileSystemCache.create(data, new QSequenceLineSystemTempDirectoryFactory(), MEMORY_THRESHOLD, 16384, new QSequenceLineDummySimplifier());
    }

    public static QSequenceLineResult createBlocks(QSequenceLineRAData leftData, QSequenceLineRAData rightData) throws IOException, QSequenceException {
        return QSequenceLineMedia.createBlocks(leftData, rightData, new QSequenceLineDummySimplifier());
    }

    public static QSequenceLineResult createBlocks(QSequenceLineRAData leftData, QSequenceLineRAData rightData, QSequenceLineSimplifier simplifier) throws IOException, QSequenceException {
        return QSequenceLineMedia.createBlocks(leftData, rightData, MEMORY_THRESHOLD, 16384, SEARCH_DEPTH_EXPONENT, new QSequenceLineSystemTempDirectoryFactory(), simplifier);
    }

    public static QSequenceLineResult createBlocks(QSequenceLineRAData leftData, QSequenceLineRAData rightData, int memoryThreshold, int fileSegmentSize, double searchDepthExponent, QSequenceLineTempDirectoryFactory tempDirectoryFactory, QSequenceLineSimplifier simplifier) throws IOException, QSequenceException {
        if (leftData.length() <= (long)memoryThreshold && rightData.length() <= (long)memoryThreshold) {
            InputStream leftStream = leftData.read(0L, leftData.length());
            InputStream rightStream = rightData.read(0L, rightData.length());
            try {
                QSequenceLineResult qSequenceLineResult = QSequenceLineMedia.createBlocksInMemory(leftStream, rightStream, searchDepthExponent, simplifier);
                return qSequenceLineResult;
            }
            finally {
                leftStream.close();
                rightStream.close();
            }
        }
        return QSequenceLineMedia.createBlocksInFilesystem(leftData, rightData, tempDirectoryFactory, searchDepthExponent, memoryThreshold, fileSegmentSize, simplifier);
    }

    static QSequenceLineResult createBlocksInMemory(InputStream leftStream, InputStream rightStream, double searchDepthExponent, QSequenceLineSimplifier simplifier) throws IOException, QSequenceException {
        QSequenceLineMemoryCache leftCache = QSequenceLineMemoryCache.read(leftStream, simplifier);
        QSequenceLineMemoryCache rightCache = QSequenceLineMemoryCache.read(rightStream, simplifier);
        QSequenceLineMedia lineMedia = new QSequenceLineMedia(leftCache, rightCache);
        QSequenceCachingMedia cachingMedia = new QSequenceCachingMedia(lineMedia, new QSequenceDummyCanceller());
        QSequenceDiscardingMedia discardingMedia = new QSequenceDiscardingMedia(cachingMedia, new QSequenceDiscardingMediaNoConfusionDectector(true), new QSequenceDummyCanceller());
        List blocks = new QSequenceDifference(discardingMedia, discardingMedia, QSequenceLineMedia.getSearchDepth(lineMedia, searchDepthExponent)).getBlocks();
        new QSequenceDifferenceBlockShifter(cachingMedia, cachingMedia).shiftBlocks(blocks);
        return new QSequenceLineResult(blocks, leftCache, rightCache);
    }

    static QSequenceLineResult createBlocksInFilesystem(QSequenceLineRAData leftData, QSequenceLineRAData rightData, QSequenceLineTempDirectoryFactory tempDirectoryFactory, double searchDepthExponent, int memoryThreshold, int fileSegmentSize, QSequenceLineSimplifier simplifier) throws IOException, QSequenceException {
        QSequenceLineFileSystemCache leftCache = QSequenceLineFileSystemCache.create(leftData, tempDirectoryFactory, memoryThreshold, fileSegmentSize, simplifier);
        QSequenceLineFileSystemCache rightCache = QSequenceLineFileSystemCache.create(rightData, tempDirectoryFactory, memoryThreshold, fileSegmentSize, simplifier);
        QSequenceLineMedia lineMedia = new QSequenceLineMedia(leftCache, rightCache);
        List blocks = new QSequenceDifference(lineMedia, new QSequenceMediaDummyIndexTransformer(lineMedia), QSequenceLineMedia.getSearchDepth(lineMedia, searchDepthExponent)).getBlocks();
        new QSequenceDifferenceBlockShifter(lineMedia, lineMedia).shiftBlocks(blocks);
        return new QSequenceLineResult(blocks, leftCache, rightCache);
    }

    public QSequenceLineMedia(QSequenceLineCache leftCache, QSequenceLineCache rightCache) {
        this.leftCache = leftCache;
        this.rightCache = rightCache;
    }

    public int getLeftLength() {
        return this.leftCache.getLineCount();
    }

    public int getRightLength() {
        return this.rightCache.getLineCount();
    }

    public Object getMediaLeftObject(int index) throws QSequenceException {
        try {
            return this.leftCache.getLine(index);
        }
        catch (IOException ex) {
            throw new QSequenceException(ex);
        }
    }

    public Object getMediaRightObject(int index) throws QSequenceException {
        try {
            return this.rightCache.getLine(index);
        }
        catch (IOException ex) {
            throw new QSequenceException(ex);
        }
    }

    public boolean equals(int leftIndex, int rightIndex) throws QSequenceException {
        block3: {
            try {
                int leftHash = this.leftCache.getLineHash(leftIndex);
                int rightHash = this.rightCache.getLineHash(rightIndex);
                if (leftHash == 0 || rightHash == 0 || leftHash == rightHash) break block3;
                return false;
            }
            catch (IOException ex) {
                throw new QSequenceException(ex);
            }
        }
        return this.leftCache.getLine(leftIndex).equals(this.rightCache.getLine(rightIndex));
    }

    public boolean equalsLeft(int left1, int left2) throws QSequenceException {
        try {
            return this.leftCache.getLine(left1).equals(this.leftCache.getLine(left2));
        }
        catch (IOException ex) {
            throw new QSequenceException(ex);
        }
    }

    public boolean equalsRight(int right1, int right2) throws QSequenceException {
        try {
            return this.rightCache.getLine(right1).equals(this.rightCache.getLine(right2));
        }
        catch (IOException ex) {
            throw new QSequenceException(ex);
        }
    }

    private static int getSearchDepth(QSequenceLineMedia lineMedia, double searchDepthExponent) {
        QSequenceAssert.assertTrue(searchDepthExponent >= 0.0 && searchDepthExponent <= 1.0);
        if (searchDepthExponent == 1.0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(256, (int)Math.pow(lineMedia.getLeftLength() + lineMedia.getRightLength(), searchDepthExponent));
    }

    private static int parseMemoryTreshold(String value) {
        if (value == null) {
            value = "1M";
        }
        value = value.toLowerCase();
        int factor = 1;
        if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
            factor = 0x100000;
        } else if (value.endsWith("mb")) {
            value = value.substring(0, value.length() - 2);
            factor = 0x100000;
        } else if (value.endsWith("k")) {
            value = value.substring(0, value.length() - 1);
            factor = 1024;
        } else if (value.endsWith("kb")) {
            value = value.substring(0, value.length() - 2);
            factor = 1024;
        }
        try {
            int amount = Integer.parseInt(value);
            amount = factor * amount;
            if (amount < 16384) {
                amount = 16384;
            }
            return amount;
        }
        catch (NumberFormatException e) {
            return QSequenceLineMedia.parseMemoryTreshold(null);
        }
    }
}

