/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import org.tmatesoft.svn.core.SVNMergeRangeList;

public class SVNMergeRange
implements Comparable {
    private long myStartRevision;
    private long myEndRevision;
    private boolean myIsInheritable;

    public SVNMergeRange(long startRevision, long endRevision, boolean isInheritable) {
        this.myStartRevision = startRevision;
        this.myEndRevision = endRevision;
        this.myIsInheritable = isInheritable;
    }

    public long getEndRevision() {
        return this.myEndRevision;
    }

    public long getStartRevision() {
        return this.myStartRevision;
    }

    public void setEndRevision(long endRevision) {
        this.myEndRevision = endRevision;
    }

    public void setStartRevision(long startRevision) {
        this.myStartRevision = startRevision;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o == null || o.getClass() != SVNMergeRange.class) {
            return 1;
        }
        SVNMergeRange range = (SVNMergeRange)o;
        if (range.myStartRevision == this.myStartRevision && range.myEndRevision == this.myEndRevision) {
            return 0;
        }
        if (range.myStartRevision == this.myStartRevision) {
            return this.myEndRevision < range.myEndRevision ? -1 : 1;
        }
        return this.myStartRevision < range.myStartRevision ? -1 : 1;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public SVNMergeRange combine(SVNMergeRange range, boolean considerInheritance) {
        if (this.canCombine(range, considerInheritance)) {
            this.myStartRevision = Math.min(this.myStartRevision, range.getStartRevision());
            this.myEndRevision = Math.max(this.myEndRevision, range.getEndRevision());
            this.myIsInheritable = this.myIsInheritable || range.myIsInheritable;
            return this;
        }
        return range;
    }

    public boolean canCombine(SVNMergeRange range, boolean considerInheritance) {
        return range != null && this.myStartRevision <= range.getEndRevision() && range.getStartRevision() <= this.myEndRevision && (!considerInheritance || considerInheritance && this.myIsInheritable == range.myIsInheritable);
    }

    public boolean contains(SVNMergeRange range, boolean considerInheritance) {
        return range != null && this.myStartRevision <= range.myStartRevision && range.myEndRevision <= this.myEndRevision && (!considerInheritance || !this.myIsInheritable == !range.myIsInheritable);
    }

    public boolean intersects(SVNMergeRange range, boolean considerInheritance) {
        return range != null && this.myStartRevision + 1L <= range.myEndRevision && range.myStartRevision + 1L <= this.myEndRevision && (!considerInheritance || !this.myIsInheritable == !range.myIsInheritable);
    }

    public SVNMergeRange swapEndPoints() {
        long tmp = this.myStartRevision;
        this.myStartRevision = this.myEndRevision;
        this.myEndRevision = tmp;
        return this;
    }

    public boolean isInheritable() {
        return this.myIsInheritable;
    }

    public void setInheritable(boolean isInheritable) {
        this.myIsInheritable = isInheritable;
    }

    public SVNMergeRange dup() {
        return new SVNMergeRange(this.myStartRevision, this.myEndRevision, this.myIsInheritable);
    }

    public String toString() {
        String output = "";
        output = this.myStartRevision == this.myEndRevision - 1L ? String.valueOf(output) + String.valueOf(this.myEndRevision) : String.valueOf(output) + String.valueOf(this.myStartRevision + 1L) + "-" + String.valueOf(this.myEndRevision);
        if (!this.isInheritable()) {
            output = String.valueOf(output) + SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING;
        }
        return output;
    }
}

