/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNativeNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

abstract class HTTPAuthentication {
    private Map myChallengeParameters;
    private String myUserName;
    private String myPassword;
    private static final String AUTH_METHODS_PROPERTY = "svnkit.http.methods";
    private static final String OLD_AUTH_METHODS_PROPERTY = "javasvn.http.methods";

    protected HTTPAuthentication(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPassword();
        }
    }

    protected HTTPAuthentication(String name, String password) {
        this.myUserName = name;
        this.myPassword = password;
    }

    protected HTTPAuthentication() {
    }

    public void setChallengeParameter(String name, String value) {
        Map params = this.getChallengeParameters();
        params.put(name, value);
    }

    public String getChallengeParameter(String name) {
        if (this.myChallengeParameters == null) {
            return null;
        }
        return (String)this.myChallengeParameters.get(name);
    }

    protected Map getChallengeParameters() {
        if (this.myChallengeParameters == null) {
            this.myChallengeParameters = new TreeMap();
        }
        return this.myChallengeParameters;
    }

    public void setCredentials(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPassword();
        }
    }

    public String getUserName() {
        return this.myUserName;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public void setUserName(String name) {
        this.myUserName = name;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public static HTTPAuthentication parseAuthParameters(Collection authHeaderValues, HTTPAuthentication prevResponse, String charset, Collection authTypes) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        HTTPAuthentication auth = null;
        String authHeader2 = null;
        authHeaderValues = HTTPAuthentication.sortSchemes(authHeaderValues, authTypes);
        for (String authHeader2 : authHeaderValues) {
            String source = authHeader2.trim();
            int index = source.indexOf(32);
            if (index <= 0 && !"NTLM".equalsIgnoreCase(source.substring(0, index = source.length())) && !"Negotiate".equalsIgnoreCase(source.substring(0, index))) continue;
            String method = source.substring(0, index);
            source = source.substring(index).trim();
            if ("Basic".equalsIgnoreCase(method)) {
                auth = new HTTPBasicAuthentication(charset);
                if (source.indexOf("realm=") < 0) break;
                source = source.substring(source.indexOf("realm=") + "realm=".length());
                if ((source = source.trim()).startsWith("\"")) {
                    source = source.substring(1);
                }
                if (source.endsWith("\"")) {
                    source = source.substring(0, source.length() - 1);
                }
                auth.setChallengeParameter("realm", source);
                break;
            }
            if ("Digest".equalsIgnoreCase(method)) {
                auth = new HTTPDigestAuthentication();
                char[] chars = source.toCharArray();
                int tokenIndex = 0;
                boolean parsingToken = true;
                String name = null;
                int quotesCount = 0;
                int i = 0;
                while (i < chars.length) {
                    if (parsingToken) {
                        if (chars[i] == '=') {
                            name = new String(chars, tokenIndex, i - tokenIndex);
                            name = name.trim();
                            tokenIndex = i + 1;
                            parsingToken = false;
                        }
                    } else if (chars[i] == '\"') {
                        quotesCount = quotesCount > 0 ? 0 : 1;
                    } else if (i + 1 >= chars.length || chars[i] == ',' && quotesCount == 0) {
                        String value = new String(chars, tokenIndex, i - tokenIndex);
                        if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                            value = value.substring(1);
                            value = value.substring(0, value.length() - 1);
                        }
                        auth.setChallengeParameter(name, value);
                        tokenIndex = i + 1;
                        parsingToken = true;
                    }
                    ++i;
                }
                HTTPDigestAuthentication digestAuth = (HTTPDigestAuthentication)auth;
                digestAuth.init();
                break;
            }
            if ("NTLM".equalsIgnoreCase(method)) {
                HTTPNTLMAuthentication ntlmAuth = null;
                if (source.length() == 0) {
                    if ("jna".equalsIgnoreCase(System.getProperty("svnkit.http.ntlm", "java"))) {
                        ntlmAuth = HTTPNativeNTLMAuthentication.newInstance(charset);
                    }
                    if (ntlmAuth != null) {
                        ntlmAuth.parseChallenge(null);
                    }
                    if (ntlmAuth == null) {
                        ntlmAuth = new HTTPNTLMAuthentication(charset);
                    }
                    ntlmAuth.setType1State();
                } else {
                    ntlmAuth = (HTTPNTLMAuthentication)prevResponse;
                    ntlmAuth.parseChallenge(source);
                    ntlmAuth.setType3State();
                }
                auth = ntlmAuth;
                break;
            }
            if (!"Negotiate".equalsIgnoreCase(method) || !HTTPNegotiateAuthentication.isSupported()) continue;
            HTTPNegotiateAuthentication negoAuth = null;
            if (source.length() == 0) {
                negoAuth = prevResponse instanceof HTTPNegotiateAuthentication ? new HTTPNegotiateAuthentication((HTTPNegotiateAuthentication)prevResponse) : new HTTPNegotiateAuthentication();
                negoAuth.respondTo(null);
            } else {
                negoAuth = (HTTPNegotiateAuthentication)prevResponse;
                negoAuth.respondTo(source);
            }
            auth = negoAuth;
            break;
        }
        if (auth == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", authHeader2);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (prevResponse != null) {
            auth.setUserName(prevResponse.getUserName());
            auth.setPassword(prevResponse.getPassword());
        }
        return auth;
    }

    public static boolean isSchemeSupportedByServer(String scheme, Collection authHeaderValues) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String authHeader2 = null;
        for (String authHeader2 : authHeaderValues) {
            String method;
            String source = authHeader2.trim();
            int index = source.indexOf(32);
            if (index <= 0) {
                index = source.length();
            }
            if (!(method = source.substring(0, index)).equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }

    private static Collection sortSchemes(Collection authHeaders, Collection authTypes) {
        String priorities = System.getProperty(AUTH_METHODS_PROPERTY, System.getProperty(OLD_AUTH_METHODS_PROPERTY));
        final ArrayList<String> schemes = new ArrayList<String>();
        if (authTypes != null && !authTypes.isEmpty()) {
            schemes.addAll(authTypes);
        } else if (priorities != null && !"".equals(priorities.trim())) {
            StringTokenizer tokens = new StringTokenizer(priorities, " ,");
            while (tokens.hasMoreTokens()) {
                String scheme = tokens.nextToken();
                if (schemes.contains(scheme)) continue;
                schemes.add(scheme);
            }
        } else {
            return authHeaders;
        }
        ArrayList ordered = new ArrayList(authHeaders);
        Collections.sort(ordered, new Comparator(){

            public int compare(Object o1, Object o2) {
                String header1 = (String)o1;
                String header2 = (String)o2;
                String scheme1 = HTTPAuthentication.getSchemeName(header1);
                String scheme2 = HTTPAuthentication.getSchemeName(header2);
                int index1 = schemes.indexOf(scheme1);
                int index2 = schemes.indexOf(scheme2);
                index1 = index1 < 0 ? Integer.MAX_VALUE : index1;
                int n = index2 = index2 < 0 ? Integer.MAX_VALUE : index2;
                if (index1 == index2) {
                    return 0;
                }
                return index1 > index2 ? 1 : -1;
            }
        });
        return ordered;
    }

    private static String getSchemeName(String header) {
        String source = header.trim();
        int index = source.indexOf(32);
        if (index <= 0) {
            index = source.length();
        }
        return source.substring(0, index);
    }

    public abstract String getAuthenticationScheme();

    public abstract String authenticate() throws SVNException;

    protected static byte[] getASCIIBytes(String data) {
        return HTTPAuthentication.getBytes(data, "US-ASCII");
    }

    protected static byte[] getBytes(String data, String charset) {
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }
}

