/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.text.ParseException;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVErrorHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPRequest;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPSSLKeyManager;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.SpoolFile;
import org.tmatesoft.svn.core.internal.util.ChunkedInputStream;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

class HTTPConnection
implements IHTTPConnection {
    private static final DefaultHandler DEFAULT_SAX_HANDLER = new DefaultHandler();
    private static EntityResolver NO_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    };
    private static final int requestAttempts;
    private static final int DEFAULT_HTTP_TIMEOUT = 3600000;
    private static SAXParserFactory ourSAXParserFactory;
    private byte[] myBuffer;
    private SAXParser mySAXParser;
    private SVNURL myHost;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Socket mySocket;
    private SVNRepository myRepository;
    private boolean myIsSecured;
    private boolean myIsProxied;
    private SVNAuthentication myLastValidAuth;
    private HTTPAuthentication myChallengeCredentials;
    private HTTPAuthentication myProxyAuthentication;
    private boolean myIsSpoolResponse;
    private TrustManager myTrustManager;
    private HTTPSSLKeyManager myKeyManager;
    private String myCharset;
    private boolean myIsSpoolAll;
    private File mySpoolDirectory;
    private long myNextRequestTimeout;

    static {
        String attemptsString = System.getProperty("svnkit.http.requestAttempts", "1");
        int attempts = 1;
        try {
            attempts = Integer.parseInt(attemptsString);
        }
        catch (NumberFormatException nfe) {
            attempts = 1;
        }
        if (attempts <= 0) {
            attempts = 1;
        }
        requestAttempts = attempts;
    }

    public HTTPConnection(SVNRepository repository, String charset, File spoolDirectory, boolean spoolAll) throws SVNException {
        this.myRepository = repository;
        this.myCharset = charset;
        this.myHost = repository.getLocation().setPath("", false);
        this.myIsSecured = "https".equalsIgnoreCase(this.myHost.getProtocol());
        this.myIsSpoolAll = spoolAll;
        this.mySpoolDirectory = spoolDirectory;
        this.myNextRequestTimeout = -1L;
    }

    public SVNURL getHost() {
        return this.myHost;
    }

    private void connect(HTTPSSLKeyManager keyManager, TrustManager trustManager) throws IOException, SVNException {
        SVNURL location = this.myRepository.getLocation();
        if (this.mySocket == null || SVNSocketFactory.isSocketStale(this.mySocket)) {
            int readTimeout;
            this.close();
            String host = location.getHost();
            int port = location.getPort();
            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
            ISVNProxyManager proxyAuth = authManager != null ? authManager.getProxyManager(location) : null;
            int connectTimeout = authManager != null ? authManager.getConnectTimeout(this.myRepository) : 0;
            int n = readTimeout = authManager != null ? authManager.getReadTimeout(this.myRepository) : 3600000;
            if (readTimeout < 0) {
                readTimeout = 3600000;
            }
            if (proxyAuth != null && proxyAuth.getProxyHost() != null) {
                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, "Using proxy " + proxyAuth.getProxyHost() + " (secured=" + this.myIsSecured + ")");
                this.mySocket = SVNSocketFactory.createPlainSocket(proxyAuth.getProxyHost(), proxyAuth.getProxyPort(), connectTimeout, readTimeout, this.myRepository.getCanceller());
                if (this.myProxyAuthentication == null) {
                    this.myProxyAuthentication = new HTTPBasicAuthentication(proxyAuth.getProxyUserName(), proxyAuth.getProxyPassword(), this.myCharset);
                }
                this.myIsProxied = true;
                if (this.myIsSecured) {
                    HTTPRequest connectRequest = new HTTPRequest(this.myCharset);
                    connectRequest.setConnection(this);
                    connectRequest.initCredentials(this.myProxyAuthentication, "CONNECT", String.valueOf(host) + ":" + port);
                    connectRequest.setProxyAuthentication(this.myProxyAuthentication.authenticate());
                    connectRequest.setForceProxyAuth(true);
                    connectRequest.dispatch("CONNECT", String.valueOf(host) + ":" + port, null, 0, 0, null);
                    HTTPStatus status = connectRequest.getStatus();
                    if (status.getCode() == 200) {
                        KeyManager[] keyManagerArray;
                        this.myInputStream = null;
                        this.myOutputStream = null;
                        if (keyManager != null) {
                            KeyManager[] keyManagerArray2 = new KeyManager[1];
                            keyManagerArray = keyManagerArray2;
                            keyManagerArray2[0] = keyManager;
                        } else {
                            keyManagerArray = new KeyManager[]{};
                        }
                        this.mySocket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, host, port, this.mySocket, readTimeout);
                        proxyAuth.acknowledgeProxyContext(true, null);
                        return;
                    }
                    SVNURL proxyURL = SVNURL.parseURIEncoded("http://" + proxyAuth.getProxyHost() + ":" + proxyAuth.getProxyPort());
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", new Object[]{"CONNECT", proxyURL});
                    proxyAuth.acknowledgeProxyContext(false, err);
                    SVNErrorManager.error(err, connectRequest.getErrorMessage(), SVNLogType.NETWORK);
                }
            } else {
                Socket socket;
                this.myIsProxied = false;
                this.myProxyAuthentication = null;
                if (this.myIsSecured) {
                    KeyManager[] keyManagerArray;
                    if (keyManager != null) {
                        KeyManager[] keyManagerArray3 = new KeyManager[1];
                        keyManagerArray = keyManagerArray3;
                        keyManagerArray3[0] = keyManager;
                    } else {
                        keyManagerArray = new KeyManager[]{};
                    }
                    socket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, host, port, connectTimeout, readTimeout, this.myRepository.getCanceller());
                } else {
                    socket = SVNSocketFactory.createPlainSocket(host, port, connectTimeout, readTimeout, this.myRepository.getCanceller());
                }
                this.mySocket = socket;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readHeader(HTTPRequest request) throws IOException {
        InputStream is = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.getInputStream());
        try {
            ParseException e2;
            block7: {
                String line;
                block6: {
                    try {
                        HTTPStatus status = HTTPParser.parseStatus(is, this.myCharset);
                        HTTPHeader header = HTTPHeader.parseHeader(is, this.myCharset);
                        request.setStatus(status);
                        request.setResponseHeader(header);
                        return;
                    }
                    catch (ParseException e2) {
                        line = HTTPParser.readLine(is, this.myCharset);
                        if (!true) break block6;
                        if (line == null) throw new IOException(e2.getMessage());
                        if (line.length() <= 0) break block7;
                    }
                }
                do {
                    line = HTTPParser.readLine(is, this.myCharset);
                    if (line == null) throw new IOException(e2.getMessage());
                } while (line.length() > 0);
            }
            throw new IOException(e2.getMessage());
        }
        finally {
            this.myRepository.getDebugLog().flushStream(is);
        }
    }

    public SVNErrorMessage readError(HTTPRequest request, String method, String path) {
        DAVErrorHandler errorHandler = new DAVErrorHandler();
        try {
            this.readData(request, method, path, (DefaultHandler)errorHandler);
        }
        catch (IOException e) {
            return null;
        }
        return errorHandler.getErrorMessage();
    }

    public void sendData(byte[] body) throws IOException {
        try {
            this.getOutputStream().write(body, 0, body.length);
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    public void sendData(InputStream source, long length) throws IOException {
        try {
            byte[] buffer = this.getBuffer();
            while (length > 0L) {
                int read = source.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                if (read > 0) {
                    length -= (long)read;
                    this.getOutputStream().write(buffer, 0, read);
                    continue;
                }
                if (read < 0) break;
            }
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    public SVNAuthentication getLastValidCredentials() {
        return this.myLastValidAuth;
    }

    public void clearAuthenticationCache() {
        this.myLastValidAuth = null;
        this.myTrustManager = null;
        this.myKeyManager = null;
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        byte[] buffer = null;
        if (body != null) {
            try {
                buffer = body.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                buffer = body.toString().getBytes();
            }
        }
        return this.request(method, path, header, buffer != null ? new ByteArrayInputStream(buffer) : null, ok1, ok2, dst, handler, context);
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    /*
     * Exception decompiling
     */
    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 12[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HTTPSSLKeyManager createKeyManager() {
        if (!this.myIsSecured) {
            return null;
        }
        SVNURL location = this.myRepository.getLocation();
        ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
        String sslRealm = "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + ">";
        return new HTTPSSLKeyManager(authManager, sslRealm, location);
    }

    public SVNErrorMessage readData(HTTPRequest request, OutputStream dst) throws IOException {
        InputStream stream = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        byte[] buffer = this.getBuffer();
        boolean willCloseConnection = false;
        try {
            try {
                int count;
                while ((count = stream.read(buffer)) >= 0) {
                    if (dst == null) continue;
                    dst.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                block13: {
                    SVNErrorMessage sVNErrorMessage;
                    block14: {
                        willCloseConnection = true;
                        if (e instanceof IOExceptionWrapper) {
                            IOExceptionWrapper wrappedException = (IOExceptionWrapper)e;
                            SVNErrorMessage sVNErrorMessage2 = wrappedException.getOriginalException().getErrorMessage();
                            if (!willCloseConnection) {
                                SVNFileUtil.closeFile(stream);
                            }
                            this.myRepository.getDebugLog().flushStream(stream);
                            return sVNErrorMessage2;
                        }
                        if (!(e.getCause() instanceof SVNException)) break block13;
                        sVNErrorMessage = ((SVNException)e.getCause()).getErrorMessage();
                        if (willCloseConnection) break block14;
                        SVNFileUtil.closeFile(stream);
                    }
                    this.myRepository.getDebugLog().flushStream(stream);
                    return sVNErrorMessage;
                }
                throw e;
            }
        }
        finally {
            if (!willCloseConnection) {
                SVNFileUtil.closeFile(stream);
            }
            this.myRepository.getDebugLog().flushStream(stream);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public SVNErrorMessage readData(HTTPRequest request, String method, String path, DefaultHandler handler) throws IOException {
        block24: {
            block27: {
                block25: {
                    is = null;
                    tmpFile = null;
                    err = null;
                    if (!this.myIsSpoolResponse && !this.myIsSpoolAll) ** GOTO lbl43
                    dst = null;
                    tmpFile = new SpoolFile(this.mySpoolDirectory);
                    dst = tmpFile.openForWriting();
                    dst = new SVNCancellableOutputStream(dst, this.myRepository.getCanceller());
                    err = this.readData(request, dst);
                    SVNFileUtil.closeFile(dst);
                    dst = null;
                    if (err == null) break block24;
                    var10_10 = err;
                    SVNFileUtil.closeFile(dst);
                    if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block25;
                    SVNFileUtil.closeFile(is);
                    break block27;
                }
                if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                    SVNFileUtil.closeFile(is);
                }
            }
            if (tmpFile != null) {
                try {
                    tmpFile.delete();
                }
                catch (SVNException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.myIsSpoolResponse = false;
            return var10_10;
        }
        try {
            block28: {
                is = tmpFile.openForReading();
                {
                    catch (Throwable var9_14) {
                        SVNFileUtil.closeFile(dst);
                        throw var9_14;
                    }
                }
                SVNFileUtil.closeFile(dst);
                break block28;
lbl43:
                // 1 sources

                is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
            }
            err = this.readData(is, method, path, handler);
        }
        catch (Throwable var11_15) {
            if (this.myIsSpoolResponse || this.myIsSpoolAll) {
                SVNFileUtil.closeFile(is);
            } else if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                SVNFileUtil.closeFile(is);
            }
            if (tmpFile != null) {
                try {
                    tmpFile.delete();
                }
                catch (SVNException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.myIsSpoolResponse = false;
            throw var11_15;
        }
        if (this.myIsSpoolResponse || this.myIsSpoolAll) {
            SVNFileUtil.closeFile(is);
        } else if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
            SVNFileUtil.closeFile(is);
        }
        if (tmpFile != null) {
            try {
                tmpFile.delete();
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.myIsSpoolResponse = false;
        return err;
    }

    /*
     * Exception decompiling
     */
    private SVNErrorMessage readData(InputStream is, String method, String path, DefaultHandler handler) throws FactoryConfigurationError, UnsupportedEncodingException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void skipData(HTTPRequest request) throws IOException {
        if (HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
            return;
        }
        InputStream is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        while (is.skip(2048L) > 0L) {
        }
    }

    public void close() {
        if (this.mySocket != null) {
            if (this.myInputStream != null) {
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySocket = null;
            this.myOutputStream = null;
            this.myInputStream = null;
        }
    }

    private byte[] getBuffer() {
        if (this.myBuffer == null) {
            this.myBuffer = new byte[32768];
        }
        return this.myBuffer;
    }

    private InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myInputStream = new BufferedInputStream(this.mySocket.getInputStream(), 2048);
        }
        return this.myInputStream;
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream(), 2048);
            this.myOutputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.myOutputStream);
        }
        return this.myOutputStream;
    }

    private void finishResponse(HTTPRequest request) {
        HTTPHeader header;
        if (this.myOutputStream != null) {
            try {
                this.myOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HTTPHeader hTTPHeader = header = request != null ? request.getResponseHeader() : null;
        if (HTTPConnection.hasToCloseConnection(header)) {
            this.close();
        }
    }

    private static boolean hasToCloseConnection(HTTPHeader header) {
        if (header == null) {
            return true;
        }
        String connectionHeader = header.getFirstHeaderValue("Connection");
        String proxyHeader = header.getFirstHeaderValue("Proxy-Connection");
        if (connectionHeader != null && connectionHeader.toLowerCase().indexOf("close") >= 0) {
            return true;
        }
        return proxyHeader != null && proxyHeader.toLowerCase().indexOf("close") >= 0;
    }

    private InputStream createInputStream(HTTPHeader readHeader, InputStream is) throws IOException {
        if ("chunked".equalsIgnoreCase(readHeader.getFirstHeaderValue("Transfer-Encoding"))) {
            is = new ChunkedInputStream(is, this.myCharset);
        } else if (readHeader.getFirstHeaderValue("Content-Length") != null) {
            String lengthStr = readHeader.getFirstHeaderValue("Content-Length");
            long length = 0L;
            try {
                length = Long.parseLong(lengthStr);
            }
            catch (NumberFormatException nfe) {
                length = 0L;
            }
            is = new FixedSizeInputStream(is, length);
        } else if (!HTTPConnection.hasToCloseConnection(readHeader)) {
            is = new FixedSizeInputStream(is, 0L);
            readHeader.setHeaderValue("Connection", "close");
        }
        if ("gzip".equals(readHeader.getFirstHeaderValue("Content-Encoding"))) {
            is = new GZIPInputStream(is);
        }
        return this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, is);
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws FactoryConfigurationError {
        if (ourSAXParserFactory == null) {
            ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
            SVNHashMap supportedFeatures = new SVNHashMap();
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                supportedFeatures.put("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                supportedFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                supportedFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            if (supportedFeatures.size() < 3) {
                ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
                for (String name : supportedFeatures.keySet()) {
                    try {
                        ourSAXParserFactory.setFeature(name, supportedFeatures.get(name) == Boolean.TRUE);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        // empty catch block
                    }
                }
            }
            ourSAXParserFactory.setNamespaceAware(true);
            ourSAXParserFactory.setValidating(false);
        }
        return ourSAXParserFactory;
    }

    public static SAXParserFactory createSAXParserFactory() {
        String legacy = System.getProperty("svnkit.sax.useDefault");
        if (legacy == null || !Boolean.valueOf(legacy).booleanValue()) {
            return SAXParserFactory.newInstance();
        }
        String[] parsers = new String[]{"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "org.apache.crimson.jaxp.SAXParserFactoryImpl"};
        int i = 0;
        while (i < parsers.length) {
            String className = parsers[i];
            ClassLoader loader = HTTPConnection.class.getClassLoader();
            try {
                Object factory;
                Class<?> clazz = null;
                clazz = loader != null ? loader.loadClass(className) : Class.forName(className);
                if (clazz != null && (factory = clazz.newInstance()) instanceof SAXParserFactory) {
                    return (SAXParserFactory)factory;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++i;
        }
        return SAXParserFactory.newInstance();
    }

    public void setSpoolResponse(boolean spoolResponse) {
        this.myIsSpoolResponse = spoolResponse;
    }
}

