/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPNegotiateAuthentication
extends HTTPAuthentication {
    private static final String NEGOTIATE_TYPE_PROPERTY = "svnkit.negotiate.type";
    private static final String NEGOTIATE_TYPE_SPNEGO = "spnego";
    private static final String NEGOTIATE_TYPE_KERBEROS = "krb";
    private static Map ourOids = new SVNHashMap();
    private static volatile Boolean ourIsNegotiateSupported;
    private GSSManager myGSSManager = GSSManager.getInstance();
    private GSSContext myGSSContext;
    private Oid mySpnegoOid;
    private Subject mySubject;
    private byte[] myToken;
    private int myTokenLength;

    static {
        try {
            ourOids.put(NEGOTIATE_TYPE_KERBEROS, new Oid("1.2.840.113554.1.2.2"));
        }
        catch (GSSException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
        try {
            ourOids.put(NEGOTIATE_TYPE_SPNEGO, new Oid("1.3.6.1.5.5.2"));
        }
        catch (GSSException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
    }

    private static Oid getDefaultOID() {
        Oid oid;
        String defaultOid = System.getProperty(NEGOTIATE_TYPE_PROPERTY, NEGOTIATE_TYPE_KERBEROS);
        if (defaultOid == null || "".equals(defaultOid)) {
            defaultOid = NEGOTIATE_TYPE_KERBEROS;
        }
        if ((oid = (Oid)ourOids.get(defaultOid)) != null) {
            return oid;
        }
        return (Oid)ourOids.get(NEGOTIATE_TYPE_KERBEROS);
    }

    public HTTPNegotiateAuthentication(HTTPNegotiateAuthentication prevAuth) {
        if (prevAuth != null) {
            this.mySubject = prevAuth.mySubject;
        }
    }

    public HTTPNegotiateAuthentication() {
        this((HTTPNegotiateAuthentication)null);
    }

    public static synchronized boolean isSupported() {
        if (ourIsNegotiateSupported == null) {
            Oid spnegoOid = HTTPNegotiateAuthentication.getDefaultOID();
            Oid[] supportedOids = GSSManager.getInstance().getMechs();
            int i = 0;
            while (i < supportedOids.length) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: supported OID: " + supportedOids[i]);
                ++i;
            }
            ourIsNegotiateSupported = Arrays.asList(GSSManager.getInstance().getMechs()).contains(spnegoOid);
        }
        return ourIsNegotiateSupported;
    }

    public String getAuthenticationScheme() {
        return "Negotiate";
    }

    private String getServerPrincipalName() {
        return "HTTP@" + this.getChallengeParameter("host");
    }

    public void respondTo(String challenge) {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, challenge: " + challenge);
        if (challenge == null) {
            this.myToken = new byte[0];
            this.myTokenLength = 0;
        } else {
            this.myToken = new byte[(challenge.length() * 3 + 3) / 4];
            this.myTokenLength = SVNBase64.base64ToByteArray(new StringBuffer(challenge), this.myToken);
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: respond to, token length: " + this.myTokenLength);
    }

    private void initializeSubject() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject");
        if (this.mySubject != null) {
            return;
        }
        try {
            LoginContext ctx = new LoginContext("com.sun.security.jgss.krb5.initiate", new SVNKitCallbackHandler());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, login context: " + ctx);
            ctx.login();
            this.mySubject = ctx.getSubject();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize subject, subject: " + this.mySubject);
        }
        catch (LoginException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
        }
    }

    private void initializeContext() throws GSSException {
        if (this.mySpnegoOid == null) {
            this.mySpnegoOid = HTTPNegotiateAuthentication.getDefaultOID();
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, OID: " + this.mySpnegoOid);
        GSSCredential credentials = this.myGSSManager.createCredential(1);
        GSSName serverName = this.myGSSManager.createName(this.getServerPrincipalName(), GSSName.NT_HOSTBASED_SERVICE);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, server name: " + serverName);
        this.myGSSContext = this.myGSSManager.createContext(serverName, this.mySpnegoOid, credentials, 0);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: initialize context, GSS Context: " + this.myGSSContext);
    }

    public String authenticate() throws SVNException {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: isStarted:" + this.isStarted());
        if (!this.isStarted()) {
            this.initializeSubject();
        }
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws SVNException {
                byte[] outtoken;
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: isStarted: " + HTTPNegotiateAuthentication.this.isStarted());
                if (!HTTPNegotiateAuthentication.this.isStarted()) {
                    try {
                        HTTPNegotiateAuthentication.this.initializeContext();
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: context initializaed");
                    }
                    catch (GSSException gsse) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                        return null;
                    }
                }
                try {
                    HTTPNegotiateAuthentication.this.myGSSContext.requestCredDeleg(true);
                    outtoken = HTTPNegotiateAuthentication.this.myGSSContext.initSecContext(HTTPNegotiateAuthentication.this.myToken, 0, HTTPNegotiateAuthentication.this.myTokenLength);
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: out token: " + outtoken);
                    if (outtoken != null) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: out token: " + SVNBase64.byteArrayToBase64(outtoken));
                    }
                }
                catch (GSSException gsse) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Negotiate authentication failed: ''{0}''", gsse.getMajorString());
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                    return null;
                }
                if (HTTPNegotiateAuthentication.this.myToken != null) {
                    return "Negotiate " + SVNBase64.byteArrayToBase64(outtoken);
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate action: myToken is null");
                return null;
            }
        };
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: subject:" + this.mySubject);
        if (this.mySubject != null) {
            try {
                String result = (String)Subject.doAs(this.mySubject, action);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result:" + result);
                return result;
            }
            catch (PrivilegedActionException e) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                Throwable cause = e.getCause();
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, cause);
                if (cause instanceof SVNException) {
                    throw (SVNException)cause;
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), SVNLogType.NETWORK);
            }
        }
        try {
            String result = (String)action.run();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: authenticate: result (2):" + result);
            return (String)action.run();
        }
        catch (Exception cause) {
            if (cause instanceof SVNException) {
                throw (SVNException)cause;
            }
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, cause), SVNLogType.NETWORK);
            return null;
        }
    }

    public boolean isStarted() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: isStarted: " + this.myGSSContext);
        return this.myGSSContext != null;
    }

    public boolean needsLogin() {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin");
        this.initializeSubject();
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "NEGOTIATE: needsLogin, mySubject: " + this.mySubject);
        return this.mySubject == null;
    }

    private class SVNKitCallbackHandler
    implements CallbackHandler {
        private SVNKitCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(HTTPNegotiateAuthentication.this.getUserName());
                } else if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(HTTPNegotiateAuthentication.this.getPassword() == null ? null : HTTPNegotiateAuthentication.this.getPassword().toCharArray());
                }
                ++i;
            }
        }
    }
}

