/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeInfoManager;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class FSLog {
    private static final int MAX_OPEN_HISTORIES = 128;
    private FSFS myFSFS;
    private String[] myPaths;
    private boolean myIsDescending;
    private boolean myIsDiscoverChangedPaths;
    private boolean myIsStrictNode;
    private boolean myIsIncludeMergedRevisions;
    private long myStartRevision;
    private long myEndRevision;
    private long myLimit;
    private ISVNLogEntryHandler myHandler;
    private SVNMergeInfoManager myMergeInfoManager;
    private String[] myRevPropNames;

    public FSLog(FSFS owner, String[] paths, long limit, long start, long end, boolean descending, boolean discoverChangedPaths, boolean strictNode, boolean includeMergedRevisions, String[] revPropNames, ISVNLogEntryHandler handler) {
        this.myFSFS = owner;
        this.myPaths = paths;
        this.myStartRevision = start;
        this.myEndRevision = end;
        this.myIsDescending = descending;
        this.myIsDiscoverChangedPaths = discoverChangedPaths;
        this.myIsStrictNode = strictNode;
        this.myIsIncludeMergedRevisions = includeMergedRevisions;
        this.myRevPropNames = revPropNames;
        this.myLimit = limit;
        this.myHandler = handler;
    }

    public void reset(FSFS owner, String[] paths, long limit, long start, long end, boolean descending, boolean discoverChangedPaths, boolean strictNode, boolean includeMergedRevisions, String[] revPropNames, ISVNLogEntryHandler handler) {
        this.myFSFS = owner;
        this.myPaths = paths;
        this.myStartRevision = start;
        this.myEndRevision = end;
        this.myIsDescending = descending;
        this.myIsDiscoverChangedPaths = discoverChangedPaths;
        this.myIsStrictNode = strictNode;
        this.myIsIncludeMergedRevisions = includeMergedRevisions;
        this.myRevPropNames = revPropNames;
        this.myLimit = limit;
        this.myHandler = handler;
    }

    public long runLog() throws SVNException {
        long count = 0L;
        if (!this.myIsIncludeMergedRevisions && this.myPaths.length == 1 && "/".equals(this.myPaths[0])) {
            count = this.myEndRevision - this.myStartRevision + 1L;
            if (this.myLimit > 0L && count > this.myLimit) {
                count = this.myLimit;
            }
            int i = 0;
            while ((long)i < count) {
                long rev = this.myStartRevision + (long)i;
                if (this.myIsDescending) {
                    rev = this.myEndRevision - (long)i;
                }
                this.sendLog(rev, false);
                ++i;
            }
            return count;
        }
        return this.doLogs(this.myPaths, this.myStartRevision, this.myEndRevision, this.myIsIncludeMergedRevisions, this.myIsDescending, this.myLimit);
    }

    private long doLogs(String[] paths, long startRevision, long endRevision, boolean includeMergedRevisions, boolean isDescendingOrder, long limit) throws SVNException {
        long sendCount = 0L;
        PathInfo[] histories = this.getPathHistories(paths, startRevision, endRevision, this.myIsStrictNode);
        LinkedList<Long> revisions = null;
        TreeMap<Long, Map> revMergeInfo = null;
        boolean anyHistoriesLeft = true;
        long currentRev = endRevision;
        while (anyHistoriesLeft) {
            boolean changed = false;
            anyHistoriesLeft = false;
            int i = 0;
            while (i < histories.length) {
                PathInfo info = histories[i];
                changed = info.checkHistory(currentRev, this.myIsStrictNode, startRevision, changed);
                if (!info.myIsDone) {
                    anyHistoriesLeft = true;
                }
                ++i;
            }
            if (changed) {
                boolean hasChildren = false;
                Map mergeInfo = null;
                if (includeMergedRevisions) {
                    LinkedList<String> currentPaths = new LinkedList<String>();
                    int i2 = 0;
                    while (i2 < histories.length) {
                        PathInfo info = histories[i2];
                        currentPaths.add(info.myPath);
                        ++i2;
                    }
                    mergeInfo = this.getCombinedMergeInfoChanges(currentPaths.toArray(new String[currentPaths.size()]), currentRev);
                    boolean bl = hasChildren = !mergeInfo.isEmpty();
                }
                if (isDescendingOrder) {
                    this.sendLog(currentRev, hasChildren);
                    ++sendCount;
                    if (hasChildren) {
                        this.handleMergedRevisions(mergeInfo);
                    }
                    if (limit > 0L && sendCount >= limit) {
                        break;
                    }
                } else {
                    if (revisions == null) {
                        revisions = new LinkedList<Long>();
                    }
                    revisions.addLast(new Long(currentRev));
                    if (mergeInfo != null) {
                        if (revMergeInfo == null) {
                            revMergeInfo = new TreeMap<Long, Map>();
                        }
                        revMergeInfo.put(new Long(currentRev), mergeInfo);
                    }
                }
            }
            currentRev = this.getNextHistoryRevision(histories);
        }
        if (revisions != null) {
            int i = 0;
            while (i < revisions.size()) {
                boolean hasChildren = false;
                Map mergeInfo = null;
                long rev = (Long)revisions.get(revisions.size() - i - 1);
                if (revMergeInfo != null) {
                    mergeInfo = (Map)revMergeInfo.get(new Long(rev));
                    hasChildren = mergeInfo != null && !mergeInfo.isEmpty();
                }
                this.sendLog(rev, hasChildren);
                if (hasChildren) {
                    this.handleMergedRevisions(mergeInfo);
                }
                if (limit > 0L && ++sendCount >= limit) break;
                ++i;
            }
        }
        return sendCount;
    }

    private long getNextHistoryRevision(PathInfo[] histories) {
        long nextRevision = -1L;
        int i = 0;
        while (i < histories.length) {
            PathInfo info = histories[i];
            if (!info.myIsDone && info.myHistoryRevision > nextRevision) {
                nextRevision = info.myHistoryRevision;
            }
            ++i;
        }
        return nextRevision;
    }

    private void sendLog(long revision, boolean hasChildren) throws SVNException {
        SVNLogEntry logEntry = this.fillLogEntry(revision);
        logEntry.setHasChildren(hasChildren);
        if (this.myHandler != null) {
            this.myHandler.handleLogEntry(logEntry);
        }
    }

    private SVNLogEntry fillLogEntry(long revision) throws SVNException {
        SVNProperties entryRevProps;
        Map changedPaths;
        block11: {
            Date date;
            SVNProperties revisionProps;
            boolean censorRevProps;
            block12: {
                block13: {
                    changedPaths = null;
                    entryRevProps = null;
                    boolean getRevProps = true;
                    censorRevProps = false;
                    if (revision > 0L && this.myIsDiscoverChangedPaths) {
                        FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
                        changedPaths = root.detectChanged();
                    }
                    if (!getRevProps || (revisionProps = this.myFSFS.getRevisionProperties(revision)) == null) break block11;
                    String author = revisionProps.getStringValue("svn:author");
                    String datestamp = revisionProps.getStringValue("svn:date");
                    Date date2 = date = datestamp != null ? SVNDate.parseDateString(datestamp) : null;
                    if (this.myRevPropNames != null && this.myRevPropNames.length != 0) break block12;
                    if (!censorRevProps) break block13;
                    entryRevProps = new SVNProperties();
                    if (author != null) {
                        entryRevProps.put("svn:author", author);
                    }
                    if (date != null) {
                        entryRevProps.put("svn:date", SVNDate.formatDate(date));
                    }
                    break block11;
                }
                entryRevProps = revisionProps;
                if (date == null) break block11;
                entryRevProps.put("svn:date", SVNDate.formatDate(date));
                break block11;
            }
            int i = 0;
            while (i < this.myRevPropNames.length) {
                String propName = this.myRevPropNames[i];
                SVNPropertyValue propVal = revisionProps.getSVNPropertyValue(propName);
                if (!censorRevProps || "svn:author".equals(propName) || "svn:date".equals(propName)) {
                    if (entryRevProps == null) {
                        entryRevProps = new SVNProperties();
                    }
                    if ("svn:date".equals(propName) && date != null) {
                        entryRevProps.put(propName, SVNDate.formatDate(date));
                    } else if (propVal != null) {
                        entryRevProps.put(propName, propVal);
                    }
                }
                ++i;
            }
        }
        if (changedPaths == null) {
            changedPaths = new SVNHashMap();
        }
        if (entryRevProps == null) {
            entryRevProps = new SVNProperties();
        }
        SVNLogEntry entry = new SVNLogEntry(changedPaths, revision, entryRevProps, false);
        return entry;
    }

    private void handleMergedRevisions(Map mergeInfo) throws SVNException {
        if (mergeInfo == null || mergeInfo.isEmpty()) {
            return;
        }
        LinkedList combinedList = this.combineMergeInfoPathLists(mergeInfo);
        int i = combinedList.size() - 1;
        while (i >= 0) {
            block5: {
                PathListRange pathListRange = (PathListRange)combinedList.get(i);
                try {
                    this.doLogs(pathListRange.myPaths, pathListRange.myRange.getStartRevision(), pathListRange.myRange.getEndRevision(), true, true, 0L);
                }
                catch (SVNException svne) {
                    SVNErrorCode errCode = svne.getErrorMessage().getErrorCode();
                    if (errCode == SVNErrorCode.FS_NOT_FOUND || errCode == SVNErrorCode.FS_NO_SUCH_REVISION) break block5;
                    throw svne;
                }
            }
            --i;
        }
        if (this.myHandler != null) {
            this.myHandler.handleLogEntry(SVNLogEntry.EMPTY_ENTRY);
        }
    }

    private PathInfo[] getPathHistories(String[] paths, long start, long end, boolean strictNodeHistory) throws SVNException {
        PathInfo[] histories = new PathInfo[paths.length];
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(end);
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            PathInfo pathHistory = new PathInfo();
            pathHistory.myPath = path;
            pathHistory.myHistoryRevision = end;
            pathHistory.myIsDone = false;
            pathHistory.myIsFirstTime = true;
            if (i < 128) {
                pathHistory.myHistory = root.getNodeHistory(path);
            }
            histories[i] = pathHistory.getHistory(strictNodeHistory, start);
            ++i;
        }
        return histories;
    }

    private Map getCombinedMergeInfoChanges(String[] paths, long revision) throws SVNException {
        if (revision == 0L) {
            return new TreeMap();
        }
        if (paths == null || paths.length == 0) {
            return new TreeMap();
        }
        Map result = new SVNHashMap();
        SVNHashMap addedMergeInfoCatalog = new SVNHashMap();
        SVNHashMap deletedMergeInfoCatalog = new SVNHashMap();
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
        this.collectChangedMergeInfo(addedMergeInfoCatalog, deletedMergeInfoCatalog, revision);
        int i = 0;
        while (i < paths.length) {
            block16: {
                String path = paths[i];
                if (!deletedMergeInfoCatalog.containsKey(path)) {
                    long[] appearedRevision = new long[]{-1L};
                    SVNLocationEntry prevLocation = null;
                    try {
                        prevLocation = this.myFSFS.getPreviousLocation(path, revision, appearedRevision);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                            throw e;
                        }
                        break block16;
                    }
                    String prevPath = null;
                    long prevRevision = -1L;
                    if (prevLocation == null || prevLocation.getPath() == null || prevLocation.getRevision() < 0L || appearedRevision[0] != revision) {
                        prevPath = path;
                        prevRevision = revision - 1L;
                    } else if (prevLocation != null) {
                        prevPath = prevLocation.getPath();
                        prevRevision = prevLocation.getRevision();
                    }
                    FSRevisionRoot prevRoot = this.myFSFS.createRevisionRoot(prevRevision);
                    String[] queryPaths = new String[]{prevPath};
                    Map catalog = null;
                    try {
                        catalog = this.getMergeInfoManager().getMergeInfo(queryPaths, prevRoot, SVNMergeInfoInheritance.INHERITED, false);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                            throw e;
                        }
                        break block16;
                    }
                    SVNMergeInfo prevMergeinfo = (SVNMergeInfo)catalog.get(prevPath);
                    queryPaths = new String[]{path};
                    catalog = this.getMergeInfoManager().getMergeInfo(queryPaths, root, SVNMergeInfoInheritance.INHERITED, false);
                    SVNMergeInfo mergeInfo = (SVNMergeInfo)catalog.get(path);
                    SVNHashMap deleted = new SVNHashMap();
                    SVNHashMap added = new SVNHashMap();
                    SVNMergeInfoUtil.diffMergeInfo(deleted, added, prevMergeinfo != null ? prevMergeinfo.getMergeSourcesToMergeLists() : null, mergeInfo != null ? mergeInfo.getMergeSourcesToMergeLists() : null, false);
                    result = SVNMergeInfoUtil.mergeMergeInfos(result, SVNMergeInfoUtil.mergeMergeInfos(deleted, added));
                }
            }
            ++i;
        }
        block5: for (String changedPath : addedMergeInfoCatalog.keySet()) {
            Map addedMergeInfo = (Map)addedMergeInfoCatalog.get(changedPath);
            int i2 = 0;
            while (i2 < paths.length) {
                String path = paths[i2];
                if (SVNPathUtil.isAncestor(path, changedPath)) {
                    Map deletedMergeInfo = (Map)deletedMergeInfoCatalog.get(changedPath);
                    result = SVNMergeInfoUtil.mergeMergeInfos(result, deletedMergeInfo);
                    result = SVNMergeInfoUtil.mergeMergeInfos(result, addedMergeInfo);
                    continue block5;
                }
                ++i2;
            }
        }
        return result;
    }

    private void collectChangedMergeInfo(Map addedMergeInfo, Map deletedMergeInfo, long revision) throws SVNException {
        if (revision == 0L) {
            return;
        }
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
        Map changedPaths = root.getChangedPaths();
        if (changedPaths == null || changedPaths.isEmpty()) {
            return;
        }
        for (String changedPath : changedPaths.keySet()) {
            SVNMergeInfo tmpMergeInfo;
            Map tmpCatalog;
            String[] queryPaths;
            SVNProperties props;
            FSPathChange change = (FSPathChange)changedPaths.get(changedPath);
            if (!change.arePropertiesModified()) continue;
            FSPathChangeKind changeKind = change.getChangeKind();
            String basePath = null;
            long baseRevision = -1L;
            String mergeInfoValue = null;
            String previousMergeInfoValue = null;
            if (changeKind == FSPathChangeKind.FS_PATH_CHANGE_ADD || changeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
                String copyFromPath = change.getCopyPath();
                long copyFromRev = change.getCopyRevision();
                if (copyFromPath != null && copyFromRev >= 0L) {
                    basePath = copyFromPath;
                    baseRevision = copyFromRev;
                }
            } else {
                if (changeKind != FSPathChangeKind.FS_PATH_CHANGE_MODIFY) continue;
                long[] appearedRevision = new long[]{-1L};
                SVNLocationEntry prevLocation = this.myFSFS.getPreviousLocation(changedPath, revision, appearedRevision);
                if (prevLocation == null || prevLocation.getPath() == null || prevLocation.getRevision() < 0L || appearedRevision[0] != prevLocation.getRevision()) {
                    basePath = changedPath;
                    baseRevision = revision - 1L;
                } else {
                    basePath = prevLocation.getPath();
                    baseRevision = prevLocation.getRevision();
                }
            }
            FSRevisionRoot baseRoot = null;
            if (basePath != null && baseRevision >= 0L) {
                baseRoot = this.myFSFS.createRevisionRoot(baseRevision);
                SVNProperties props2 = this.myFSFS.getProperties(baseRoot.getRevisionNode(basePath));
                previousMergeInfoValue = props2.getStringValue("svn:mergeinfo");
            }
            if ((props = this.myFSFS.getProperties(root.getRevisionNode(changedPath))) != null) {
                mergeInfoValue = props.getStringValue("svn:mergeinfo");
            }
            if (mergeInfoValue == null && previousMergeInfoValue == null) continue;
            if (previousMergeInfoValue != null && mergeInfoValue == null) {
                queryPaths = new String[]{changedPath};
                tmpCatalog = this.getMergeInfoManager().getMergeInfo(queryPaths, root, SVNMergeInfoInheritance.INHERITED, false);
                tmpMergeInfo = (SVNMergeInfo)tmpCatalog.get(changedPath);
                if (tmpMergeInfo != null) {
                    mergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(tmpMergeInfo.getMergeSourcesToMergeLists(), null);
                }
            } else if (mergeInfoValue != null && previousMergeInfoValue == null && basePath != null && SVNRevision.isValidRevisionNumber(baseRevision)) {
                queryPaths = new String[]{basePath};
                tmpCatalog = this.getMergeInfoManager().getMergeInfo(queryPaths, baseRoot, SVNMergeInfoInheritance.INHERITED, false);
                tmpMergeInfo = (SVNMergeInfo)tmpCatalog.get(basePath);
                if (tmpMergeInfo != null) {
                    previousMergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(tmpMergeInfo.getMergeSourcesToMergeLists(), null);
                }
            }
            if (!(previousMergeInfoValue != null && mergeInfoValue == null || previousMergeInfoValue == null && mergeInfoValue != null) && (previousMergeInfoValue == null || mergeInfoValue == null || previousMergeInfoValue.equals(mergeInfoValue))) continue;
            Map mergeInfo = null;
            Map previousMergeInfo = null;
            if (mergeInfoValue != null) {
                mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoValue), null);
            }
            if (previousMergeInfoValue != null) {
                previousMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(previousMergeInfoValue), null);
            }
            SVNHashMap added = new SVNHashMap();
            SVNHashMap deleted = new SVNHashMap();
            SVNMergeInfoUtil.diffMergeInfo(deleted, added, previousMergeInfo, mergeInfo, false);
            addedMergeInfo.put(changedPath, added);
            deletedMergeInfo.put(changedPath, deleted);
        }
    }

    private LinkedList combineMergeInfoPathLists(Map mergeInfo) {
        LinkedList<RangeListPath> rangeListPaths = new LinkedList<RangeListPath>();
        for (String path : mergeInfo.keySet()) {
            SVNMergeRangeList changes = (SVNMergeRangeList)mergeInfo.get(path);
            RangeListPath rangeListPath = new RangeListPath();
            rangeListPath.myPath = path;
            rangeListPath.myRangeList = changes.dup();
            SVNMergeRange[] rangesArray = rangeListPath.myRangeList.getRanges();
            int i = 0;
            while (i < rangesArray.length) {
                SVNMergeRange range = rangesArray[i];
                range.setStartRevision(range.getStartRevision() + 1L);
                ++i;
            }
            rangeListPaths.add(rangeListPath);
        }
        LinkedList<PathListRange> combinedList = new LinkedList<PathListRange>();
        Comparator rangeListPathsComparator = new Comparator(){

            public int compare(Object arg1, Object arg2) {
                RangeListPath rangeListPath1 = (RangeListPath)arg1;
                RangeListPath rangeListPath2 = (RangeListPath)arg2;
                SVNMergeRange[] ranges1 = rangeListPath1.myRangeList.getRanges();
                SVNMergeRange[] ranges2 = rangeListPath2.myRangeList.getRanges();
                SVNMergeRange range1 = ranges1[0];
                SVNMergeRange range2 = ranges2[0];
                if (range1.getStartRevision() < range2.getStartRevision()) {
                    return -1;
                }
                if (range1.getStartRevision() > range2.getStartRevision()) {
                    return 1;
                }
                if (range1.getEndRevision() < range2.getEndRevision()) {
                    return -1;
                }
                if (range1.getEndRevision() > range2.getEndRevision()) {
                    return 1;
                }
                return 0;
            }
        };
        while (rangeListPaths.size() > 1) {
            RangeListPath rp;
            long youngest;
            RangeListPath rangeListPath;
            Collections.sort(rangeListPaths, rangeListPathsComparator);
            RangeListPath firstRLP = rangeListPath = (RangeListPath)rangeListPaths.get(0);
            long nextYoungest = youngest = rangeListPath.myRangeList.getRanges()[0].getStartRevision();
            int numRevs = 1;
            while (nextYoungest == youngest) {
                if (numRevs == rangeListPaths.size()) {
                    ++numRevs;
                    break;
                }
                rangeListPath = (RangeListPath)rangeListPaths.get(numRevs);
                nextYoungest = rangeListPath.myRangeList.getRanges()[0].getStartRevision();
                ++numRevs;
            }
            --numRevs;
            long youngestEnd = firstRLP.myRangeList.getRanges()[0].getEndRevision();
            long tail = nextYoungest - 1L;
            if (nextYoungest == youngest || youngestEnd < nextYoungest) {
                tail = youngestEnd;
            }
            PathListRange pathListRange = new PathListRange();
            pathListRange.myRange = new SVNMergeRange(youngest, tail, false);
            LinkedList<String> paths = new LinkedList<String>();
            int i = 0;
            while (i < numRevs) {
                rp = (RangeListPath)rangeListPaths.get(i);
                paths.add(rp.myPath);
                ++i;
            }
            pathListRange.myPaths = paths.toArray(new String[paths.size()]);
            combinedList.add(pathListRange);
            i = 0;
            while (i < numRevs) {
                rp = (RangeListPath)rangeListPaths.get(i);
                SVNMergeRange range = rp.myRangeList.getRanges()[0];
                range.setStartRevision(tail + 1L);
                if (range.getStartRevision() > range.getEndRevision()) {
                    if (rp.myRangeList.getSize() == 1) {
                        rangeListPaths.remove(0);
                        --i;
                        --numRevs;
                    } else {
                        SVNMergeRange[] ranges = new SVNMergeRange[rp.myRangeList.getSize() - 1];
                        System.arraycopy(rp.myRangeList.getRanges(), 1, ranges, 0, ranges.length);
                        rp.myRangeList = new SVNMergeRangeList(ranges);
                    }
                }
                ++i;
            }
        }
        if (!rangeListPaths.isEmpty()) {
            RangeListPath firstRangeListPath = (RangeListPath)rangeListPaths.get(0);
            while (!firstRangeListPath.myRangeList.isEmpty()) {
                PathListRange pathListRange = new PathListRange();
                pathListRange.myPaths = new String[]{firstRangeListPath.myPath};
                pathListRange.myRange = firstRangeListPath.myRangeList.getRanges()[0];
                SVNMergeRange[] ranges = new SVNMergeRange[firstRangeListPath.myRangeList.getSize() - 1];
                System.arraycopy(firstRangeListPath.myRangeList.getRanges(), 1, ranges, 0, ranges.length);
                firstRangeListPath.myRangeList = new SVNMergeRangeList(ranges);
                combinedList.add(pathListRange);
            }
        }
        return combinedList;
    }

    private SVNMergeInfoManager getMergeInfoManager() {
        if (this.myMergeInfoManager == null) {
            this.myMergeInfoManager = new SVNMergeInfoManager();
        }
        return this.myMergeInfoManager;
    }

    private class PathInfo {
        FSNodeHistory myHistory;
        boolean myIsDone;
        boolean myIsFirstTime;
        long myHistoryRevision;
        String myPath;

        private PathInfo() {
        }

        public PathInfo getHistory(boolean strictNodeHistory, long start) throws SVNException {
            FSNodeHistory history = null;
            if (this.myHistory != null) {
                this.myHistory = history = this.myHistory.getPreviousHistory(!strictNodeHistory);
            } else {
                FSRevisionRoot historyRoot = FSLog.this.myFSFS.createRevisionRoot(this.myHistoryRevision);
                history = historyRoot.getNodeHistory(this.myPath);
                history = history.getPreviousHistory(!strictNodeHistory);
                if (this.myIsFirstTime) {
                    this.myIsFirstTime = false;
                } else if (history != null) {
                    history = history.getPreviousHistory(!strictNodeHistory);
                }
            }
            if (history == null) {
                this.myIsDone = true;
                return this;
            }
            this.myPath = history.getHistoryEntry().getPath();
            this.myHistoryRevision = history.getHistoryEntry().getRevision();
            if (this.myHistoryRevision < start) {
                this.myIsDone = true;
            }
            return this;
        }

        public boolean checkHistory(long currentRevision, boolean strictNodeHistory, long start, boolean changed) throws SVNException {
            if (this.myIsDone) {
                return changed;
            }
            if (this.myHistoryRevision < currentRevision) {
                return changed;
            }
            changed = true;
            this.getHistory(strictNodeHistory, start);
            return changed;
        }
    }

    private class PathListRange {
        String[] myPaths;
        SVNMergeRange myRange;

        private PathListRange() {
        }
    }

    private class RangeListPath {
        String myPath;
        SVNMergeRangeList myRangeList;

        private RangeListPath() {
        }
    }
}

