/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoUtil {
    public static Map filterCatalogByRanges(Map catalog, long youngestRev, long oldestRev) {
        TreeMap<String, Map> filteredCatalog = new TreeMap<String, Map>();
        for (String path : catalog.keySet()) {
            Map mergeInfo = (Map)catalog.get(path);
            Map filteredMergeInfo = SVNMergeInfoUtil.filterMergeInfoByRanges(mergeInfo, youngestRev, oldestRev);
            if (filteredMergeInfo.isEmpty()) continue;
            filteredCatalog.put(path, filteredMergeInfo);
        }
        return filteredCatalog;
    }

    public static Map filterMergeInfoByRanges(Map mergeInfo, long youngestRev, long oldestRev) {
        TreeMap<String, SVNMergeRangeList> filteredMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        if (mergeInfo != null) {
            SVNMergeRange range = new SVNMergeRange(oldestRev, youngestRev, true);
            SVNMergeRangeList filterRangeList = new SVNMergeRangeList(range);
            for (String path : mergeInfo.keySet()) {
                SVNMergeRangeList newRangeList;
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(path);
                if (rangeList.isEmpty() || (newRangeList = filterRangeList.intersect(rangeList, false)).isEmpty()) continue;
                filteredMergeInfo.put(path, newRangeList);
            }
        }
        return filteredMergeInfo;
    }

    public static long[] getRangeEndPoints(Map mergeInfo) {
        long[] rangePoints = new long[]{-1L, -1L};
        if (mergeInfo != null) {
            for (String path : mergeInfo.keySet()) {
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(path);
                if (rangeList.isEmpty()) continue;
                SVNMergeRange[] ranges = rangeList.getRanges();
                SVNMergeRange range = ranges[ranges.length - 1];
                if (!SVNRevision.isValidRevisionNumber(rangePoints[0]) || range.getEndRevision() > rangePoints[0]) {
                    rangePoints[0] = range.getEndRevision();
                }
                range = ranges[0];
                if (SVNRevision.isValidRevisionNumber(rangePoints[1]) && rangePoints[1] <= range.getStartRevision()) continue;
                rangePoints[1] = range.getStartRevision();
            }
        }
        return rangePoints;
    }

    public static Map elideMergeInfoCatalog(Map mergeInfoCatalog) throws SVNException {
        TreeMap adjustedMergeInfoCatalog = new TreeMap();
        Iterator pathsIter = mergeInfoCatalog.keySet().iterator();
        while (pathsIter.hasNext()) {
            String path;
            String adjustedPath = path = (String)pathsIter.next();
            if (path.startsWith("/")) {
                adjustedPath = path.substring(1);
            }
            adjustedMergeInfoCatalog.put(adjustedPath, mergeInfoCatalog.get(path));
        }
        mergeInfoCatalog = adjustedMergeInfoCatalog;
        ElideMergeInfoCatalogHandler handler = new ElideMergeInfoCatalogHandler(mergeInfoCatalog);
        ElideMergeInfoEditor editor = new ElideMergeInfoEditor(mergeInfoCatalog);
        SVNCommitUtil.driveCommitEditor(handler, mergeInfoCatalog.keySet(), editor, -1L);
        List elidablePaths = handler.getElidablePaths();
        for (String elidablePath : elidablePaths) {
            mergeInfoCatalog.remove(elidablePath);
        }
        adjustedMergeInfoCatalog = new TreeMap();
        Iterator pathsIter2 = mergeInfoCatalog.keySet().iterator();
        while (pathsIter2.hasNext()) {
            String path;
            String adjustedPath = path = (String)pathsIter2.next();
            if (!path.startsWith("/")) {
                adjustedPath = "/" + adjustedPath;
            }
            adjustedMergeInfoCatalog.put(adjustedPath, mergeInfoCatalog.get(path));
        }
        return adjustedMergeInfoCatalog;
    }

    public static Map adjustMergeInfoSourcePaths(Map mergeInfo, String walkPath, Map wcMergeInfo) {
        mergeInfo = mergeInfo == null ? new TreeMap() : mergeInfo;
        for (String srcMergePath : wcMergeInfo.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)wcMergeInfo.get(srcMergePath);
            mergeInfo.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(srcMergePath, walkPath)), rangeList);
        }
        return mergeInfo;
    }

    public static boolean removeEmptyRangeLists(Map mergeInfo) {
        boolean removedSomeRanges = false;
        if (mergeInfo != null) {
            Iterator mergeInfoIter = mergeInfo.entrySet().iterator();
            while (mergeInfoIter.hasNext()) {
                Map.Entry mergeInfoEntry = mergeInfoIter.next();
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfoEntry.getValue();
                if (!rangeList.isEmpty()) continue;
                mergeInfoIter.remove();
                removedSomeRanges = true;
            }
        }
        return removedSomeRanges;
    }

    public static Map mergeMergeInfos(Map originalSrcsToRangeLists, Map changedSrcsToRangeLists) throws SVNException {
        originalSrcsToRangeLists = originalSrcsToRangeLists == null ? new TreeMap() : originalSrcsToRangeLists;
        changedSrcsToRangeLists = changedSrcsToRangeLists == null ? Collections.EMPTY_MAP : changedSrcsToRangeLists;
        String[] paths1 = originalSrcsToRangeLists.keySet().toArray(new String[originalSrcsToRangeLists.size()]);
        String[] paths2 = changedSrcsToRangeLists.keySet().toArray(new String[changedSrcsToRangeLists.size()]);
        int i = 0;
        int j = 0;
        while (i < paths1.length && j < paths2.length) {
            String path1 = paths1[i];
            String path2 = paths2[j];
            int res = path1.compareTo(path2);
            if (res == 0) {
                SVNMergeRangeList rangeList1 = (SVNMergeRangeList)originalSrcsToRangeLists.get(path1);
                SVNMergeRangeList rangeList2 = (SVNMergeRangeList)changedSrcsToRangeLists.get(path2);
                rangeList1 = rangeList1.merge(rangeList2);
                originalSrcsToRangeLists.put(path1, rangeList1);
                ++i;
                ++j;
                continue;
            }
            if (res < 0) {
                ++i;
                continue;
            }
            originalSrcsToRangeLists.put(path2, changedSrcsToRangeLists.get(path2));
            ++j;
        }
        while (j < paths2.length) {
            String path = paths2[j];
            originalSrcsToRangeLists.put(path, changedSrcsToRangeLists.get(path));
            ++j;
        }
        return originalSrcsToRangeLists;
    }

    public static String combineMergeInfoProperties(String propValue1, String propValue2) throws SVNException {
        Map srcsToRanges1 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue1), null);
        Map srcsToRanges2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue2), null);
        srcsToRanges1 = SVNMergeInfoUtil.mergeMergeInfos(srcsToRanges1, srcsToRanges2);
        return SVNMergeInfoUtil.formatMergeInfoToString(srcsToRanges1, null);
    }

    public static String combineForkedMergeInfoProperties(String fromPropValue, String workingPropValue, String toPropValue) throws SVNException {
        Map leftDeleted = new TreeMap();
        Map leftAdded = new TreeMap();
        Map fromMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(fromPropValue), null);
        SVNMergeInfoUtil.diffMergeInfoProperties(leftDeleted, leftAdded, null, fromMergeInfo, workingPropValue, null);
        TreeMap rightDeleted = new TreeMap();
        TreeMap rightAdded = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfoProperties(rightDeleted, rightAdded, fromPropValue, null, toPropValue, null);
        leftDeleted = SVNMergeInfoUtil.mergeMergeInfos(leftDeleted, rightDeleted);
        leftAdded = SVNMergeInfoUtil.mergeMergeInfos(leftAdded, rightAdded);
        fromMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(fromMergeInfo, leftAdded);
        Map result = SVNMergeInfoUtil.removeMergeInfo(leftDeleted, fromMergeInfo);
        return SVNMergeInfoUtil.formatMergeInfoToString(result, null);
    }

    public static void diffMergeInfoProperties(Map deleted, Map added, String fromPropValue, Map fromMergeInfo, String toPropValue, Map toMergeInfo) throws SVNException {
        if (fromPropValue != null && fromPropValue.equals(toPropValue)) {
            return;
        }
        fromMergeInfo = fromMergeInfo == null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(fromPropValue), null) : fromMergeInfo;
        toMergeInfo = toMergeInfo == null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(toPropValue), null) : toMergeInfo;
        SVNMergeInfoUtil.diffMergeInfo(deleted, added, fromMergeInfo, toMergeInfo, true);
    }

    public static void diffMergeInfo(Map deleted, Map added, Map from, Map to, boolean considerInheritance) {
        from = from == null ? Collections.EMPTY_MAP : from;
        Map map = to = to == null ? Collections.EMPTY_MAP : to;
        if (!from.isEmpty() && to.isEmpty()) {
            SVNMergeInfoUtil.dupMergeInfo(from, deleted);
        } else if (from.isEmpty() && !to.isEmpty()) {
            SVNMergeInfoUtil.dupMergeInfo(to, added);
        } else if (!from.isEmpty() && !to.isEmpty()) {
            SVNMergeInfoUtil.walkMergeInfoHashForDiff(deleted, added, from, to, considerInheritance);
        }
    }

    public static Map dupCatalog(Map catalog) {
        TreeMap<String, Map> newMergeInfoCatalog = new TreeMap<String, Map>();
        for (String path : catalog.keySet()) {
            Map mergeInfo = (Map)catalog.get(path);
            Map mergeInfoCopy = SVNMergeInfoUtil.dupMergeInfo(mergeInfo, null);
            newMergeInfoCatalog.put(path, mergeInfoCopy);
        }
        return newMergeInfoCatalog;
    }

    public static Map dupMergeInfo(Map srcsToRangeLists, Map target) {
        if (srcsToRangeLists == null) {
            return null;
        }
        target = target == null ? new TreeMap() : target;
        for (String path : srcsToRangeLists.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)srcsToRangeLists.get(path);
            target.put(path, rangeList.dup());
        }
        return target;
    }

    /*
     * Exception decompiling
     */
    public static Map parseMergeInfo(StringBuffer mergeInfo, Map srcPathsToRangeLists) throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String formatMergeInfoCatalogToString(Map catalog, String keyPrefix, String valuePrefix) {
        StringBuffer buffer = null;
        if (catalog != null && !catalog.isEmpty()) {
            buffer = new StringBuffer();
            for (String path1 : catalog.keySet()) {
                if (path1.startsWith("/")) {
                    path1 = path1.substring(1);
                }
                Map mergeInfo = (Map)catalog.get(path1);
                if (keyPrefix != null) {
                    buffer.append(keyPrefix);
                }
                buffer.append(path1);
                buffer.append('\n');
                buffer.append(SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, valuePrefix != null ? valuePrefix : ""));
                buffer.append('\n');
            }
        }
        return buffer != null ? buffer.toString() : "\n";
    }

    public static String[] formatMergeInfoToArray(Map srcsToRangeLists, String prefix) {
        srcsToRangeLists = srcsToRangeLists == null ? Collections.EMPTY_MAP : srcsToRangeLists;
        String[] pathRanges = new String[srcsToRangeLists.size()];
        int k = 0;
        for (String path : srcsToRangeLists.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)srcsToRangeLists.get(path);
            String output = String.valueOf(prefix != null ? prefix : "") + (path.startsWith("/") ? "" : "/") + path + ':' + rangeList;
            pathRanges[k++] = output;
        }
        return pathRanges;
    }

    public static String formatMergeInfoToString(Map srcsToRangeLists, String prefix) {
        String[] infosArray = SVNMergeInfoUtil.formatMergeInfoToArray(srcsToRangeLists, prefix);
        String result = "";
        int i = 0;
        while (i < infosArray.length) {
            result = String.valueOf(result) + infosArray[i];
            if (i < infosArray.length - 1) {
                result = String.valueOf(result) + '\n';
            }
            ++i;
        }
        return result;
    }

    public static boolean shouldElideMergeInfo(Map parentMergeInfo, Map childMergeInfo, String pathSuffix) {
        boolean elides = false;
        if (childMergeInfo != null) {
            if (childMergeInfo.isEmpty()) {
                if (parentMergeInfo == null || parentMergeInfo.isEmpty()) {
                    elides = true;
                }
            } else if (parentMergeInfo != null && !parentMergeInfo.isEmpty()) {
                TreeMap pathTweakedMergeInfo = parentMergeInfo;
                if (pathSuffix != null) {
                    pathTweakedMergeInfo = new TreeMap();
                    for (String mergeSrcPath : parentMergeInfo.keySet()) {
                        pathTweakedMergeInfo.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(mergeSrcPath, pathSuffix)), parentMergeInfo.get(mergeSrcPath));
                    }
                }
                elides = SVNMergeInfoUtil.mergeInfoEquals(pathTweakedMergeInfo, childMergeInfo, true);
            }
        }
        return elides;
    }

    public static void elideMergeInfo(Map parentMergeInfo, Map childMergeInfo, File path, String pathSuffix, SVNWCAccess access) throws SVNException {
        boolean elides = SVNMergeInfoUtil.shouldElideMergeInfo(parentMergeInfo, childMergeInfo, pathSuffix);
        if (elides) {
            SVNPropertiesManager.setProperty(access, path, "svn:mergeinfo", null, true);
        }
    }

    public static boolean mergeInfoEquals(Map mergeInfo1, Map mergeInfo2, boolean considerInheritance) {
        mergeInfo1 = mergeInfo1 == null ? Collections.EMPTY_MAP : mergeInfo1;
        Map map = mergeInfo2 = mergeInfo2 == null ? Collections.EMPTY_MAP : mergeInfo2;
        if (mergeInfo1.size() == mergeInfo2.size()) {
            SVNHashMap deleted = new SVNHashMap();
            SVNHashMap added = new SVNHashMap();
            SVNMergeInfoUtil.diffMergeInfo(deleted, added, mergeInfo1, mergeInfo2, considerInheritance);
            return deleted.isEmpty() && added.isEmpty();
        }
        return false;
    }

    public static String[] findMergeSources(long revision, Map mergeInfo) {
        LinkedList<String> mergeSources = new LinkedList<String>();
        for (String path : mergeInfo.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(path);
            if (!rangeList.includes(revision)) continue;
            mergeSources.add(path);
        }
        return mergeSources.toArray(new String[mergeSources.size()]);
    }

    public static Map getInheritableMergeInfo(Map mergeInfo, String path, long startRev, long endRev) {
        TreeMap<String, SVNMergeRangeList> inheritableMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        if (mergeInfo != null) {
            for (String mergeSrcPath : mergeInfo.keySet()) {
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(mergeSrcPath);
                SVNMergeRangeList inheritableRangeList = null;
                inheritableRangeList = path == null || path.equals(mergeSrcPath) ? rangeList.getInheritableRangeList(startRev, endRev) : rangeList.dup();
                if (inheritableRangeList.isEmpty()) continue;
                inheritableMergeInfo.put(mergeSrcPath, inheritableRangeList);
            }
        }
        return inheritableMergeInfo;
    }

    public static Map removeMergeInfo(Map eraser, Map whiteBoard) {
        return SVNMergeInfoUtil.removeMergeInfo(eraser, whiteBoard, true);
    }

    public static Map removeMergeInfo(Map eraser, Map whiteBoard, boolean considerInheritance) {
        TreeMap mergeInfo = new TreeMap();
        SVNMergeInfoUtil.walkMergeInfoHashForDiff(mergeInfo, null, whiteBoard, eraser, considerInheritance);
        return mergeInfo;
    }

    public static Map intersectMergeInfo(Map mergeInfo1, Map mergeInfo2) {
        return SVNMergeInfoUtil.intersectMergeInfo(mergeInfo1, mergeInfo2, true);
    }

    public static Map intersectMergeInfo(Map mergeInfo1, Map mergeInfo2, boolean considerInheritance) {
        TreeMap<String, SVNMergeRangeList> mergeInfo = new TreeMap<String, SVNMergeRangeList>();
        for (String path : mergeInfo1.keySet()) {
            SVNMergeRangeList rangeList1 = (SVNMergeRangeList)mergeInfo1.get(path);
            SVNMergeRangeList rangeList2 = (SVNMergeRangeList)mergeInfo2.get(path);
            if (rangeList2 == null || (rangeList2 = rangeList2.intersect(rangeList1, considerInheritance)).isEmpty()) continue;
            mergeInfo.put(path, rangeList2.dup());
        }
        return mergeInfo;
    }

    public static SVNMergeRange[] parseRevisionList(StringBuffer mergeInfo, String path) throws SVNException {
        SVNErrorMessage err;
        LinkedList<SVNMergeRange> ranges = new LinkedList<SVNMergeRange>();
        while (mergeInfo.length() > 0 && mergeInfo.charAt(0) != '\n' && Character.isWhitespace(mergeInfo.charAt(0))) {
            mergeInfo = mergeInfo.deleteCharAt(0);
        }
        if (mergeInfo.length() == 0 || mergeInfo.charAt(0) == '\n') {
            err = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Mergeinfo for ''{0}'' maps to an empty revision range", path);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        while (mergeInfo.length() > 0 && mergeInfo.charAt(0) != '\n') {
            long startRev = SVNMergeInfoUtil.parseRevision(mergeInfo);
            if (mergeInfo.length() > 0 && mergeInfo.charAt(0) != '\n' && mergeInfo.charAt(0) != '-' && mergeInfo.charAt(0) != ',' && mergeInfo.charAt(0) != '*') {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in revision list", new Character(mergeInfo.charAt(0)));
                SVNErrorManager.error(err2, SVNLogType.DEFAULT);
            }
            SVNMergeRange range = new SVNMergeRange(startRev - 1L, startRev, true);
            if (mergeInfo.length() > 0 && mergeInfo.charAt(0) == '-') {
                SVNErrorMessage err3;
                long endRev = SVNMergeInfoUtil.parseRevision(mergeInfo = mergeInfo.deleteCharAt(0));
                if (startRev > endRev) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Unable to parse reversed revision range ''{0}-{1}''", new Object[]{new Long(startRev), new Long(endRev)});
                    SVNErrorManager.error(err3, SVNLogType.DEFAULT);
                } else if (startRev == endRev) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Unable to parse revision range ''{0}-{1}'' with same start and end revisions", new Object[]{new Long(startRev), new Long(endRev)});
                    SVNErrorManager.error(err3, SVNLogType.DEFAULT);
                }
                range.setEndRevision(endRev);
            }
            if (mergeInfo.length() == 0 || mergeInfo.charAt(0) == '\n') {
                ranges.add(range);
                return ranges.toArray(new SVNMergeRange[ranges.size()]);
            }
            if (mergeInfo.length() > 0 && mergeInfo.charAt(0) == ',') {
                ranges.add(range);
                mergeInfo = mergeInfo.deleteCharAt(0);
                continue;
            }
            if (mergeInfo.length() > 0 && mergeInfo.charAt(0) == '*') {
                range.setInheritable(false);
                mergeInfo = mergeInfo.deleteCharAt(0);
                if (mergeInfo.length() == 0 || mergeInfo.charAt(0) == ',' || mergeInfo.charAt(0) == '\n') {
                    ranges.add(range);
                    if (mergeInfo.length() > 0 && mergeInfo.charAt(0) == ',') {
                        mergeInfo = mergeInfo.deleteCharAt(0);
                        continue;
                    }
                    return ranges.toArray(new SVNMergeRange[ranges.size()]);
                }
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in range list", mergeInfo.length() > 0 ? String.valueOf(mergeInfo.charAt(0)) : "");
                SVNErrorManager.error(err4, SVNLogType.DEFAULT);
                continue;
            }
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in range list", mergeInfo.length() > 0 ? String.valueOf(mergeInfo.charAt(0)) : "");
            SVNErrorManager.error(err5, SVNLogType.DEFAULT);
        }
        if (mergeInfo.length() == 0 || mergeInfo.charAt(0) != '\n') {
            err = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Range list parsing ended before hitting newline");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        return ranges.toArray(new SVNMergeRange[ranges.size()]);
    }

    public static SVNMergeRangeList[] diffMergeRangeLists(SVNMergeRangeList fromRangeList, SVNMergeRangeList toRangeList, boolean considerInheritance) {
        SVNMergeRangeList deletedRangeList = fromRangeList.diff(toRangeList, considerInheritance);
        SVNMergeRangeList addedRangeList = toRangeList.diff(fromRangeList, considerInheritance);
        return new SVNMergeRangeList[]{deletedRangeList, addedRangeList};
    }

    private static long parseRevision(StringBuffer mergeInfo) throws SVNException {
        int ind = 0;
        while (ind < mergeInfo.length() && Character.isDigit(mergeInfo.charAt(ind))) {
            ++ind;
        }
        if (ind == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Invalid revision number found parsing ''{0}''", mergeInfo.toString());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        String numberStr = mergeInfo.substring(0, ind);
        long rev = -1L;
        try {
            rev = Long.parseLong(numberStr);
        }
        catch (NumberFormatException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Invalid revision number found parsing ''{0}''", mergeInfo.toString());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (rev < 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Negative revision number found parsing ''{0}''", mergeInfo.toString());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        mergeInfo = mergeInfo.delete(0, ind);
        return rev;
    }

    private static void walkMergeInfoHashForDiff(Map deleted, Map added, Map from, Map to, boolean considerInheritance) {
        for (String path : from.keySet()) {
            SVNMergeRangeList fromRangeList = (SVNMergeRangeList)from.get(path);
            SVNMergeRangeList toRangeList = (SVNMergeRangeList)to.get(path);
            if (toRangeList != null) {
                SVNMergeRangeList[] rangeListDiff = SVNMergeInfoUtil.diffMergeRangeLists(fromRangeList, toRangeList, considerInheritance);
                SVNMergeRangeList deletedRangeList = rangeListDiff[0];
                SVNMergeRangeList addedRangeList = rangeListDiff[1];
                if (deleted != null && deletedRangeList.getSize() > 0) {
                    deleted.put(path, deletedRangeList);
                }
                if (added == null || addedRangeList.getSize() <= 0) continue;
                added.put(path, addedRangeList);
                continue;
            }
            if (deleted == null) continue;
            deleted.put(path, fromRangeList.dup());
        }
        if (added == null) {
            return;
        }
        for (String path : to.keySet()) {
            SVNMergeRangeList toRangeList = (SVNMergeRangeList)to.get(path);
            if (from.containsKey(path)) continue;
            added.put(path, toRangeList.dup());
        }
    }

    private static class ElideMergeInfoCatalogHandler
    implements ISVNCommitPathHandler {
        private Map myMergeInfoCatalog;
        private List myElidablePaths;

        public ElideMergeInfoCatalogHandler(Map mergeInfoCatalog) {
            this.myMergeInfoCatalog = mergeInfoCatalog;
            this.myElidablePaths = new LinkedList();
        }

        public boolean handleCommitPath(String path, ISVNEditor editor) throws SVNException {
            boolean elides;
            ElideMergeInfoEditor elideEditor = (ElideMergeInfoEditor)editor;
            String inheritedMergeInfoPath = elideEditor.getInheritedMergeInfoPath();
            if (inheritedMergeInfoPath == null || "/".equals(path)) {
                return false;
            }
            String pathSuffix = SVNPathUtil.getPathAsChild(inheritedMergeInfoPath, path);
            if (pathSuffix == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "path suffix is null");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (elides = SVNMergeInfoUtil.shouldElideMergeInfo((Map)this.myMergeInfoCatalog.get(inheritedMergeInfoPath), (Map)this.myMergeInfoCatalog.get(path), pathSuffix)) {
                this.myElidablePaths.add(path);
            }
            return false;
        }

        public List getElidablePaths() {
            return this.myElidablePaths;
        }
    }

    private static class ElideMergeInfoEditor
    implements ISVNEditor {
        private Map myMergeInfoCatalog;
        private ElideMergeInfoCatalogDirBaton myCurrentDirBaton;

        public ElideMergeInfoEditor(Map mergeInfoCatalog) {
            this.myMergeInfoCatalog = mergeInfoCatalog;
        }

        public void abortEdit() throws SVNException {
        }

        public void absentDir(String path) throws SVNException {
        }

        public void absentFile(String path) throws SVNException {
        }

        public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        }

        public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        }

        public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        }

        public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        }

        public void closeDir() throws SVNException {
        }

        public SVNCommitInfo closeEdit() throws SVNException {
            return null;
        }

        public void closeFile(String path, String textChecksum) throws SVNException {
        }

        public void deleteEntry(String path, long revision) throws SVNException {
        }

        public void openDir(String path, long revision) throws SVNException {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            ElideMergeInfoCatalogDirBaton dirBaton = new ElideMergeInfoCatalogDirBaton();
            if (this.myMergeInfoCatalog.get(path) != null) {
                dirBaton.myInheritedMergeInfoPath = path;
            } else {
                dirBaton.myInheritedMergeInfoPath = this.myCurrentDirBaton.myInheritedMergeInfoPath;
            }
            this.myCurrentDirBaton = dirBaton;
        }

        public void openFile(String path, long revision) throws SVNException {
        }

        public void openRoot(long revision) throws SVNException {
            this.myCurrentDirBaton = new ElideMergeInfoCatalogDirBaton();
        }

        public void targetRevision(long revision) throws SVNException {
        }

        public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        }

        public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
            return SVNFileUtil.DUMMY_OUT;
        }

        public void textDeltaEnd(String path) throws SVNException {
        }

        public String getInheritedMergeInfoPath() {
            return this.myCurrentDirBaton.myInheritedMergeInfoPath;
        }

        private class ElideMergeInfoCatalogDirBaton {
            private String myInheritedMergeInfoPath;

            private ElideMergeInfoCatalogDirBaton() {
            }
        }
    }
}

