/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNSSLTrustManager
implements X509TrustManager {
    private SVNURL myURL;
    private DefaultSVNAuthenticationManager myAuthManager;
    private X509Certificate[] myTrustedCerts;
    private String myRealm;
    private File myAuthDirectory;
    private boolean myIsUseKeyStore;
    private File[] myServerCertFiles;
    private X509TrustManager[] myDefaultTrustManagers;

    public DefaultSVNSSLTrustManager(File authDir, SVNURL url, File[] serverCertFiles, boolean useKeyStore, DefaultSVNAuthenticationManager authManager) {
        this.myURL = url;
        this.myAuthDirectory = authDir;
        this.myRealm = "https://" + url.getHost() + ":" + url.getPort();
        this.myAuthManager = authManager;
        this.myIsUseKeyStore = useKeyStore;
        this.myServerCertFiles = serverCertFiles;
    }

    private X509TrustManager[] getDefaultTrustManagers() {
        if (this.myDefaultTrustManagers == null && this.myIsUseKeyStore) {
            this.myDefaultTrustManagers = this.initDefaultTrustManagers();
        }
        return this.myDefaultTrustManagers;
    }

    private X509TrustManager[] initDefaultTrustManagers() {
        TrustManager[] trustManagers;
        block7: {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmf.init((KeyStore)null);
            trustManagers = tmf.getTrustManagers();
            if (trustManagers != null && trustManagers.length != 0) break block7;
            return null;
        }
        try {
            ArrayList<TrustManager> x509TrustManagers = new ArrayList<TrustManager>();
            int i = 0;
            while (i < trustManagers.length) {
                TrustManager trustManager = trustManagers[i];
                if (trustManager instanceof X509TrustManager) {
                    x509TrustManagers.add(trustManager);
                }
                ++i;
            }
            return x509TrustManagers.toArray(new X509TrustManager[x509TrustManagers.size()]);
        }
        catch (NoSuchAlgorithmException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.FINEST);
        }
        catch (NoSuchProviderException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.FINEST);
        }
        catch (KeyStoreException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.FINEST);
        }
        return null;
    }

    private void init() {
        if (this.myTrustedCerts != null) {
            return;
        }
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < this.myServerCertFiles.length) {
            X509Certificate cert = DefaultSVNSSLTrustManager.loadCertificate(this.myServerCertFiles[i]);
            if (cert != null) {
                trustedCerts.add(cert);
            }
            ++i;
        }
        X509TrustManager[] trustManagers = this.getDefaultTrustManagers();
        int i2 = 0;
        while (trustManagers != null && i2 < trustManagers.length) {
            X509TrustManager trustManager = trustManagers[i2];
            X509Certificate[] acceptedCerts = trustManager.getAcceptedIssuers();
            int c = 0;
            while (acceptedCerts != null && c < acceptedCerts.length) {
                X509Certificate cert = acceptedCerts[c];
                trustedCerts.add(cert);
                ++c;
            }
            ++i2;
        }
        this.myTrustedCerts = trustedCerts.toArray(new X509Certificate[trustedCerts.size()]);
    }

    public X509Certificate[] getAcceptedIssuers() {
        this.init();
        return this.myTrustedCerts;
    }

    public void checkClientTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] certs, String algorithm) throws CertificateException {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            String stored;
            String data = SVNBase64.byteArrayToBase64(certs[0].getEncoded());
            if (data.equals(stored = (String)this.myAuthManager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm))) {
                return;
            }
            stored = this.getStoredServerCertificate(this.myRealm);
            if (data.equals(stored)) {
                return;
            }
            ISVNAuthenticationProvider authProvider = this.myAuthManager.getAuthenticationProvider();
            int failures = SVNSSLUtil.getServerCertificateFailures(certs[0], this.myURL.getHost());
            if (authProvider != null) {
                boolean store = this.myAuthManager.isAuthStorageEnabled(this.myURL) || this.myAuthManager.isSSLStorageEnabled();
                boolean trustServer = this.checkServerTrustedByDefault(certs, algorithm);
                int result = trustServer ? 2 : authProvider.acceptServerAuthentication(this.myURL, this.myRealm, certs[0], store);
                if (result == 2 && store) {
                    try {
                        this.storeServerCertificate(this.myRealm, data, failures);
                    }
                    catch (SVNException e) {
                        SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, e);
                    }
                }
                if (result != 0) {
                    this.myAuthManager.getRuntimeAuthStorage().putData("svn.ssl.server", this.myRealm, data);
                    return;
                }
                throw new SVNSSLUtil.CertificateNotTrustedException("svn: Server SSL certificate for '" + this.myRealm + "' rejected");
            }
        }
    }

    private boolean checkServerTrustedByDefault(X509Certificate[] certs, String algorithm) {
        X509TrustManager[] trustManagers = this.getDefaultTrustManagers();
        if (trustManagers == null) {
            return false;
        }
        int i = 0;
        while (i < trustManagers.length) {
            X509TrustManager trustManager = trustManagers[i];
            boolean trusted = true;
            try {
                trustManager.checkServerTrusted(certs, algorithm);
            }
            catch (CertificateException e) {
                trusted = false;
            }
            if (trusted) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getStoredServerCertificate(String realm) {
        SVNWCProperties props;
        block4: {
            File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
            if (!file.isFile()) {
                return null;
            }
            props = new SVNWCProperties(file, "");
            try {
                String storedRealm = props.getPropertyValue("svn:realmstring");
                if (realm.equals(storedRealm)) break block4;
                return null;
            }
            catch (SVNException sVNException) {
                return null;
            }
        }
        return props.getPropertyValue("ascii_cert");
    }

    private void storeServerCertificate(String realm, String data, int failures) throws SVNException {
        this.myAuthDirectory.mkdirs();
        File file = new File(this.myAuthDirectory, SVNFileUtil.computeChecksum(realm));
        SVNHashMap map = new SVNHashMap();
        map.put("ascii_cert", data);
        map.put("svn:realmstring", realm);
        map.put("failures", Integer.toString(failures));
        SVNFileUtil.deleteFile(file);
        File tmpFile = SVNFileUtil.createUniqueFile(this.myAuthDirectory, "auth", ".tmp", true);
        try {
            SVNWCProperties.setProperties(SVNProperties.wrap(map), file, tmpFile, "END");
        }
        finally {
            SVNFileUtil.deleteFile(tmpFile);
        }
    }

    public static X509Certificate loadCertificate(File pemFile) {
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(pemFile, SVNLogType.WC);
        }
        catch (SVNException e) {
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(is);
            return x509Certificate;
        }
        catch (CertificateException e) {
            return null;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }
}

