/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFileType {
    public static final SVNFileType UNKNOWN = new SVNFileType(0);
    public static final SVNFileType NONE = new SVNFileType(1);
    public static final SVNFileType FILE = new SVNFileType(2);
    public static final SVNFileType SYMLINK = new SVNFileType(3);
    public static final SVNFileType DIRECTORY = new SVNFileType(4);
    private static final boolean ourFastSymlinkResoution = !"false".equalsIgnoreCase(System.getProperty("svnkit.fastSymlinkResolution", System.getProperty("javasvn.fastSymlinkResolution")));
    private static final boolean ourCanonPathCacheUsed = !"false".equalsIgnoreCase(System.getProperty("sun.io.useCanonCaches"));
    private static boolean ourDetectSymlinks = !"false".equalsIgnoreCase(System.getProperty("svnkit.symlinks", System.getProperty("javasvn.symlinks", "true")));
    private static final Set ADMIN_FILE_PARENTS = new SVNHashSet();
    private int myType;

    static {
        ADMIN_FILE_PARENTS.add("text-base");
        ADMIN_FILE_PARENTS.add("prop-base");
        ADMIN_FILE_PARENTS.add("props");
        ADMIN_FILE_PARENTS.add("wcprops");
        ADMIN_FILE_PARENTS.add("tmp");
    }

    private SVNFileType(int type) {
        this.myType = type;
    }

    public String toString() {
        switch (this.myType) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "none";
            }
            case 2: {
                return "file";
            }
            case 3: {
                return "symlink";
            }
            case 4: {
                return "directory";
            }
        }
        return Integer.toString(this.myType);
    }

    public static synchronized void setSymlinkSupportEnabled(boolean enabled) {
        ourDetectSymlinks = enabled;
    }

    public static synchronized boolean isSymlinkSupportEnabled() {
        return ourDetectSymlinks;
    }

    public static SVNFileType getType(File file) {
        SVNFileType ft;
        boolean detectSymlinks = SVNFileType.isSymlinkSupportEnabled();
        if (file == null) {
            return UNKNOWN;
        }
        if ((SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isOSX || SVNFileUtil.isSolaris) && detectSymlinks && (ft = SVNJNAUtil.getFileType(file)) != null) {
            return ft;
        }
        if (detectSymlinks && SVNFileUtil.symlinksSupported() && !SVNFileType.isAdminFile(file)) {
            if (ourCanonPathCacheUsed && !ourFastSymlinkResoution && SVNFileType.isSymlink(file)) {
                return SYMLINK;
            }
            if (!ourCanonPathCacheUsed || ourFastSymlinkResoution) {
                if (!file.exists()) {
                    File[] children = file.getParentFile() != null ? SVNFileListUtil.listFiles(file.getParentFile()) : null;
                    int i = 0;
                    while (children != null && i < children.length) {
                        File child = children[i];
                        if (child.getName().equals(file.getName()) && SVNFileType.isSymlink(file)) {
                            return SYMLINK;
                        }
                        ++i;
                    }
                } else {
                    String canonicalPath;
                    String absolutePath = file.getAbsolutePath();
                    try {
                        canonicalPath = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        canonicalPath = file.getAbsolutePath();
                    }
                    if (!absolutePath.equals(canonicalPath) && SVNFileType.isSymlink(file)) {
                        return SYMLINK;
                    }
                }
            }
        }
        if (file.isFile()) {
            return FILE;
        }
        if (file.isDirectory()) {
            return DIRECTORY;
        }
        if (!file.exists()) {
            return NONE;
        }
        return UNKNOWN;
    }

    public static boolean equals(SVNFileType type, SVNNodeKind nodeKind) {
        if (nodeKind == SVNNodeKind.DIR) {
            return type == DIRECTORY;
        }
        if (nodeKind == SVNNodeKind.FILE) {
            return type == FILE || type == SYMLINK;
        }
        if (nodeKind == SVNNodeKind.NONE) {
            return type == NONE;
        }
        if (nodeKind == SVNNodeKind.UNKNOWN) {
            return type == UNKNOWN;
        }
        return false;
    }

    private static boolean isAdminFile(File file) {
        String adminDir;
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        return path.lastIndexOf(String.valueOf(adminDir = "/" + SVNFileUtil.getAdminDirectoryName()) + "/") > 0 || path.endsWith(adminDir);
    }

    private static boolean isSymlink(File file) {
        String line = null;
        try {
            line = SVNFileUtil.execCommand(new String[]{SVNFileUtil.LS_COMMAND, "-ld", file.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, th);
        }
        return line != null && line.startsWith("l");
    }

    public int getID() {
        return this.myType;
    }

    public boolean isFile() {
        return this == FILE || this == SYMLINK;
    }

    public static SVNNodeKind getNodeKind(SVNFileType type) {
        if (type == null || type == NONE || type == UNKNOWN) {
            return SVNNodeKind.NONE;
        }
        if (type == DIRECTORY) {
            return SVNNodeKind.DIR;
        }
        return SVNNodeKind.FILE;
    }
}

