/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNPropertyComparator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCProperties {
    public static final String SVN_HASH_TERMINATOR = "END";
    private File myFile;
    private String myPath;

    public SVNWCProperties(File properitesFile, String path) {
        this.myFile = properitesFile;
        this.myPath = path;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getPath() {
        return this.myPath;
    }

    public Collection properties(Collection target) throws SVNException {
        Collection collection = target = target == null ? new TreeSet() : target;
        if (this.isEmpty()) {
            return target;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            try {
                while (SVNWCProperties.readProperty('K', is, nameOS)) {
                    target.add(new String(nameOS.toByteArray(), "UTF-8"));
                    nameOS.reset();
                    SVNWCProperties.readProperty('V', is, null);
                }
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(is);
            }
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return target;
    }

    public SVNProperties asMap() throws SVNException {
        SVNProperties result = new SVNProperties();
        if (this.isEmpty()) {
            return result;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            try {
                while (SVNWCProperties.readProperty('K', is, nameOS)) {
                    String name = new String(nameOS.toByteArray(), "UTF-8");
                    nameOS.reset();
                    SVNWCProperties.readProperty('V', is, nameOS);
                    byte[] value = nameOS.toByteArray();
                    result.put(name, value);
                    nameOS.reset();
                }
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read properties file ''{0}'': {1}", new Object[]{this.getFile(), e.getLocalizedMessage()});
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(is);
            }
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return result;
    }

    public boolean compareTo(SVNWCProperties properties, ISVNPropertyComparator comparator) throws SVNException {
        boolean equals = true;
        Collection props1 = this.properties(null);
        Collection props2 = properties.properties(null);
        TreeSet tmp = new TreeSet(props1);
        tmp.removeAll(props2);
        for (String missing : tmp) {
            comparator.propertyDeleted(missing);
            equals = false;
        }
        tmp = new TreeSet(props2);
        tmp.removeAll(props1);
        File tmpFile = null;
        File tmpFile1 = null;
        File tmpFile2 = null;
        OutputStream os = null;
        InputStream is = null;
        InputStream is1 = null;
        InputStream is2 = null;
        for (String added : tmp) {
            try {
                tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
                os = SVNFileUtil.openFileForWriting(tmpFile);
                properties.getPropertyValue(added, os);
                SVNFileUtil.closeFile(os);
                is = SVNFileUtil.openFileForReading(tmpFile, SVNLogType.WC);
                comparator.propertyAdded(added, is, (int)tmpFile.length());
                equals = false;
                SVNFileUtil.closeFile(is);
            }
            catch (Throwable throwable) {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                tmpFile = null;
                is = null;
                os = null;
                throw throwable;
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            tmpFile = null;
            is = null;
            os = null;
        }
        props2.retainAll(props1);
        for (String changed : props2) {
            try {
                try {
                    tmpFile1 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp1", true);
                    tmpFile2 = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp2", true);
                    os = SVNFileUtil.openFileForWriting(tmpFile1);
                    this.getPropertyValue(changed, os);
                    os.close();
                    os = SVNFileUtil.openFileForWriting(tmpFile2);
                    properties.getPropertyValue(changed, os);
                    os.close();
                    if (tmpFile2.length() != tmpFile1.length()) {
                        is = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                        comparator.propertyChanged(changed, is, (int)tmpFile2.length());
                        equals = false;
                        SVNFileUtil.closeFile(is);
                    } else {
                        is1 = SVNFileUtil.openFileForReading(tmpFile1, SVNLogType.WC);
                        is2 = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                        boolean differs = false;
                        int i = 0;
                        while ((long)i < tmpFile1.length()) {
                            if (is1.read() != is2.read()) {
                                differs = true;
                                break;
                            }
                            ++i;
                        }
                        SVNFileUtil.closeFile(is1);
                        SVNFileUtil.closeFile(is2);
                        if (differs) {
                            is2 = SVNFileUtil.openFileForReading(tmpFile2, SVNLogType.WC);
                            comparator.propertyChanged(changed, is2, (int)tmpFile2.length());
                            equals = false;
                            SVNFileUtil.closeFile(is2);
                        }
                    }
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.WC);
                    if (tmpFile2 != null) {
                        tmpFile2.delete();
                    }
                    if (tmpFile1 != null) {
                        tmpFile1.delete();
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    SVNFileUtil.closeFile(is1);
                    SVNFileUtil.closeFile(is2);
                    os = null;
                    tmpFile2 = null;
                    tmpFile1 = null;
                    is2 = null;
                    is1 = null;
                    is = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (tmpFile2 != null) {
                    tmpFile2.delete();
                }
                if (tmpFile1 != null) {
                    tmpFile1.delete();
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                os = null;
                tmpFile2 = null;
                tmpFile1 = null;
                is2 = null;
                is1 = null;
                is = null;
                throw throwable;
            }
            if (tmpFile2 != null) {
                tmpFile2.delete();
            }
            if (tmpFile1 != null) {
                tmpFile1.delete();
            }
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
            os = null;
            tmpFile2 = null;
            tmpFile1 = null;
            is2 = null;
            is1 = null;
            is = null;
        }
        return equals;
    }

    public String getPropertyValue(String name) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if ((os = (ByteArrayOutputStream)this.getPropertyValue(name, os)) != null && os.size() >= 0) {
            byte[] bytes = os.toByteArray();
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(bytes);
            }
        }
        return null;
    }

    public OutputStream getPropertyValue(String name, OutputStream os) throws SVNException {
        if (this.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream nameOS = new ByteArrayOutputStream();
        InputStream is = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
        try {
            while (SVNWCProperties.readProperty('K', is, nameOS)) {
                String currentName = new String(nameOS.toByteArray(), "UTF-8");
                nameOS.reset();
                if (currentName.equals(name)) {
                    SVNWCProperties.readProperty('V', is, os);
                    OutputStream outputStream = os;
                    return outputStream;
                }
                try {
                    SVNWCProperties.readProperty('V', is, null);
                    continue;
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.WC);
                }
                break;
            }
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return null;
    }

    public void setPropertyValue(String name, SVNPropertyValue value) throws SVNException {
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        int length = bytes != null && bytes.length >= 0 ? bytes.length : -1;
        this.setPropertyValue(name, bytes != null ? new ByteArrayInputStream(bytes) : null, length);
    }

    public void setPropertyValue(String name, InputStream is, int length) throws SVNException {
        InputStream src = null;
        OutputStream dst = null;
        File tmpFile = null;
        boolean empty = false;
        try {
            tmpFile = SVNFileUtil.createUniqueFile(this.getFile().getParentFile(), this.getFile().getName(), ".tmp", true);
            if (!this.isEmpty()) {
                src = SVNFileUtil.openFileForReading(this.getFile(), SVNLogType.WC);
            }
            empty = !SVNWCProperties.copyProperties(src, dst = SVNFileUtil.openFileForWriting(tmpFile), name, is, length);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(src);
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(src);
        SVNFileUtil.closeFile(dst);
        if (tmpFile != null) {
            if (!empty) {
                SVNFileUtil.rename(tmpFile, this.getFile());
                SVNFileUtil.setReadonly(this.getFile(), true);
            } else {
                SVNFileUtil.deleteFile(tmpFile);
                SVNFileUtil.deleteFile(this.getFile());
            }
        }
    }

    public void setProperties(SVNProperties properties) throws SVNException {
        if (properties != null) {
            for (String name : properties.nameSet()) {
                SVNPropertyValue value = properties.getSVNPropertyValue(name);
                this.setPropertyValue(name, value);
            }
        }
    }

    public SVNProperties compareTo(SVNWCProperties properties) throws SVNException {
        final SVNProperties locallyChangedProperties = new SVNProperties();
        this.compareTo(properties, new ISVNPropertyComparator(){

            public void propertyAdded(String name, InputStream value, int length) {
                this.propertyChanged(name, value, length);
            }

            public void propertyChanged(String name, InputStream newValue, int length) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(length);
                int i = 0;
                while (i < length) {
                    try {
                        os.write(newValue.read());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                byte[] bytes = os.toByteArray();
                try {
                    locallyChangedProperties.put(name, new String(bytes, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    locallyChangedProperties.put(name, new String(bytes));
                }
            }

            public void propertyDeleted(String name) {
                locallyChangedProperties.put(name, (SVNPropertyValue)null);
            }
        });
        return locallyChangedProperties;
    }

    public static void setProperties(SVNProperties namesToValues, File target, File tmpFile, String terminator) throws SVNException {
        OutputStream dst = null;
        try {
            if (tmpFile != null) {
                tmpFile.getParentFile().mkdirs();
            } else {
                target.getParentFile().mkdirs();
            }
            dst = SVNFileUtil.openFileForWriting(tmpFile != null ? tmpFile : target);
            SVNWCProperties.setProperties(namesToValues, dst, terminator);
        }
        catch (Throwable throwable) {
            SVNFileUtil.closeFile(dst);
            throw throwable;
        }
        SVNFileUtil.closeFile(dst);
        if (tmpFile != null && target != null) {
            target.getParentFile().mkdirs();
            SVNFileUtil.rename(tmpFile, target);
        }
        if (target != null) {
            SVNFileUtil.setReadonly(target, true);
        }
    }

    public static void setProperties(SVNProperties namesToValues, OutputStream target, String terminator) throws SVNException {
        try {
            Object[] keys = namesToValues.nameSet().toArray();
            Arrays.sort(keys);
            int i = 0;
            while (i < keys.length) {
                String propertyName = (String)keys[i];
                SVNWCProperties.writeProperty(target, 'K', propertyName.getBytes("UTF-8"));
                SVNWCProperties.writeProperty(target, 'V', SVNPropertyValue.getPropertyAsBytes(namesToValues.getSVNPropertyValue(propertyName)));
                ++i;
            }
            if (terminator != null) {
                target.write(terminator.getBytes("UTF-8"));
                target.write(10);
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    public static void appendProperty(String name, SVNPropertyValue value, OutputStream target) throws SVNException {
        if (name == null || value == null) {
            return;
        }
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        try {
            SVNWCProperties.writeProperty(target, 'K', name.getBytes("UTF-8"));
            SVNWCProperties.writeProperty(target, 'V', bytes);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    public static void appendPropertyDeleted(String name, OutputStream target) throws SVNException {
        if (name == null) {
            return;
        }
        try {
            SVNWCProperties.writeProperty(target, 'D', name.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.WC);
        }
    }

    private static boolean copyProperties(InputStream is, OutputStream os, String name, InputStream value, int length) throws SVNException {
        int propCount = 0;
        try {
            if (is != null) {
                int l = 0;
                while ((l = SVNWCProperties.readLength(is, 'K')) > 0) {
                    byte[] nameBytes = new byte[l];
                    SVNFileUtil.readIntoBuffer(is, nameBytes, 0, nameBytes.length);
                    is.read();
                    if (name.equals(new String(nameBytes, "UTF-8"))) {
                        SVNWCProperties.readProperty('V', is, null);
                        continue;
                    }
                    SVNWCProperties.writeProperty(os, 'K', nameBytes);
                    l = SVNWCProperties.readLength(is, 'V');
                    SVNWCProperties.writeProperty(os, 'V', is, l);
                    is.read();
                    ++propCount;
                }
            }
            if (value != null && length >= 0) {
                byte[] nameBytes = name.getBytes("UTF-8");
                SVNWCProperties.writeProperty(os, 'K', nameBytes);
                SVNWCProperties.writeProperty(os, 'V', value, length);
                ++propCount;
            }
            if (propCount > 0) {
                os.write(new byte[]{69, 78, 68, 10});
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        return propCount > 0;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean readProperty(char type, InputStream is, OutputStream os) throws IOException {
        length = SVNWCProperties.readLength(is, type);
        if (length < 0) {
            return false;
        }
        if (os == null) ** GOTO lbl12
        value = new byte[length];
        r = SVNFileUtil.readIntoBuffer(is, value, 0, value.length);
        if (r >= 0) {
            os.write(value, 0, r);
        } else {
            return false;
lbl-1000:
            // 1 sources

            {
                length = (int)((long)length - is.skip(length));
lbl12:
                // 2 sources

                ** while (length > 0)
            }
        }
lbl13:
        // 2 sources

        return is.read() == 10;
    }

    private static void writeProperty(OutputStream os, char type, byte[] value) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(value.length).getBytes("UTF-8"));
        os.write(10);
        os.write(value);
        os.write(10);
    }

    private static void writeProperty(OutputStream os, char type, InputStream value, int length) throws IOException {
        os.write((byte)type);
        os.write(32);
        os.write(Integer.toString(length).getBytes("UTF-8"));
        os.write(10);
        int i = 0;
        while (i < length) {
            int r = value.read();
            os.write(r);
            ++i;
        }
        os.write(10);
    }

    private static int readLength(InputStream is, char type) throws IOException {
        byte[] buffer = new byte[255];
        int r = SVNFileUtil.readIntoBuffer(is, buffer, 0, 4);
        if (r != 4) {
            throw new IOException("invalid properties file format");
        }
        if (buffer[0] == 69 && buffer[1] == 78 && buffer[2] == 68 && buffer[3] == 10) {
            return -1;
        }
        if (buffer[0] == type && buffer[1] == 32) {
            int i = 4;
            if (buffer[3] != 10) {
                while (true) {
                    int b;
                    if ((b = is.read()) < 0) {
                        throw new IOException("invalid properties file format");
                    }
                    if (b != 10) {
                        buffer[i] = (byte)(0xFF & b);
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                i = 3;
            }
            String length = new String(buffer, 2, i - 2, "UTF-8");
            return Integer.parseInt(length.trim());
        }
        throw new IOException("invalid properties file format");
    }

    public boolean isEmpty() {
        return !this.getFile().exists() || this.getFile().length() <= 4L;
    }
}

