/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNChecksumOutputStream
extends OutputStream {
    public static final String MD5_ALGORITHM = "MD5";
    private OutputStream myTarget;
    private MessageDigest myDigest;
    private byte[] myDigestResult;
    private boolean myCloseTarget;

    public SVNChecksumOutputStream(OutputStream target, String algorithm, boolean closeTarget) {
        this.myTarget = target;
        this.myCloseTarget = closeTarget;
        algorithm = algorithm == null ? MD5_ALGORITHM : algorithm;
        try {
            this.myDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void write(int b) throws IOException {
        this.myDigest.update((byte)(b & 0xFF));
        this.myTarget.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.myDigest.update(b);
        }
        this.myTarget.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b != null) {
            this.myDigest.update(b, off, len);
        }
        this.myTarget.write(b, off, len);
    }

    public void close() throws IOException {
        if (this.myDigestResult == null) {
            this.myDigestResult = this.myDigest.digest();
        }
        if (this.myCloseTarget) {
            this.myTarget.close();
        }
    }

    public String getDigest() {
        if (this.myDigestResult == null) {
            this.myDigestResult = this.myDigest.digest();
        }
        return SVNFileUtil.toHexDigest(this.myDigestResult);
    }
}

