/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNCharsetInputStream;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTranslator {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static String transalteString(String str, byte[] eol, Map keywords, boolean repair, boolean expand) throws SVNException {
        ByteArrayOutputStream bufferOS;
        block5: {
            bufferOS = new ByteArrayOutputStream();
            OutputStream resultOS = null;
            try {
                try {
                    resultOS = SVNTranslator.getTranslatingOutputStream(bufferOS, null, eol, repair, keywords, expand);
                    resultOS.write(str.getBytes());
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "error while translating a string");
                    SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                    SVNFileUtil.closeFile(resultOS);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(resultOS);
                throw throwable;
            }
            SVNFileUtil.closeFile(resultOS);
        }
        return new String(bufferOS.toByteArray());
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, srcPath, dstPath, false, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), customEOLStyle, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean safelyEncode, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, null, safelyEncode, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, src, dst, customEOLStyle, false, expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, String customEOLStyle, boolean safelyEncode, boolean expand) throws SVNException {
        ISVNOptions options = adminArea.getWCAccess().getOptions();
        SVNVersionedProperties props = adminArea.getProperties(name);
        String keywords = props.getStringPropertyValue("svn:keywords");
        String charset = SVNTranslator.getCharset(props.getStringPropertyValue("svnkit:charset"), adminArea.getFile(name).getPath(), options);
        String eolStyle = null;
        eolStyle = customEOLStyle != null ? customEOLStyle : props.getStringPropertyValue("svn:eol-style");
        boolean special = props.getPropertyValue("svn:special") != null;
        Map keywordsMap = null;
        if (keywords != null) {
            if (expand) {
                SVNEntry entry = adminArea.getVersionedEntry(name, true);
                String url = entry.getURL();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
            } else {
                keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
            }
        }
        byte[] eols = !expand ? SVNTranslator.getBaseEOL(eolStyle) : SVNTranslator.getEOL(eolStyle, options);
        if (expand && charset != null && safelyEncode) {
            File tmp = SVNAdminUtil.createTmpFile(adminArea, name, ".tmp", true);
            SVNTranslator.translate(src, tmp, charset, eols, keywordsMap, special, false);
            SVNTranslator.translate(tmp, dst, charset, eols, keywordsMap, special, true);
            SVNFileUtil.deleteFile(tmp);
        } else {
            SVNTranslator.translate(src, dst, charset, eols, keywordsMap, special, expand);
        }
    }

    public static void translate(File src, File dst, String charset, byte[] eol, Map keywords, boolean special, boolean expand) throws SVNException {
        if (src == null || dst == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS), SVNLogType.DEFAULT);
            return;
        }
        if (src.equals(dst)) {
            return;
        }
        if (special) {
            if (SVNFileType.getType(dst) != SVNFileType.NONE) {
                dst.delete();
            }
            if (!SVNFileUtil.symlinksSupported()) {
                SVNFileUtil.copyFile(src, dst, true);
            } else if (expand) {
                SVNFileUtil.createSymlink(dst, src);
            } else {
                SVNFileUtil.detranslateSymlink(src, dst);
            }
            return;
        }
        if ((charset == null || SVNProperty.isUTF8(charset)) && eol == null && (keywords == null || keywords.isEmpty())) {
            SVNFileUtil.copyFile(src, dst, false);
            return;
        }
        OutputStream os = SVNFileUtil.openFileForWriting(dst);
        OutputStream tos = SVNTranslator.getTranslatingOutputStream(os, charset, eol, true, keywords, expand);
        InputStream is = SVNFileUtil.openFileForReading(src, SVNLogType.WC);
        try {
            try {
                SVNTranslator.copy(is, tos);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                SVNFileUtil.closeFile(tos);
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
            }
        }
        finally {
            SVNFileUtil.closeFile(tos);
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
    }

    public static InputStream getTranslatedStream(SVNAdminArea adminArea, String name, boolean translateToNormalForm, boolean repairEOL) throws SVNException {
        boolean translationRequired;
        ISVNOptions options = adminArea.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(adminArea.getProperties(name).getStringPropertyValue("svnkit:charset"), adminArea.getFile(name).getPath(), options);
        String eolStyle = adminArea.getProperties(name).getStringPropertyValue("svn:eol-style");
        String keywords = adminArea.getProperties(name).getStringPropertyValue("svn:keywords");
        boolean special = adminArea.getProperties(name).getPropertyValue("svn:special") != null;
        File src = adminArea.getFile(name);
        if (special) {
            ByteArrayOutputStream os;
            block12: {
                String linkPath;
                if (!SVNFileUtil.symlinksSupported()) {
                    return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
                }
                if (SVNFileType.getType(src) != SVNFileType.SYMLINK) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", src);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                if ((linkPath = SVNFileUtil.getSymlinkName(src)) == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", src);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                os = new ByteArrayOutputStream();
                try {
                    try {
                        os.write("link ".getBytes("UTF-8"));
                        os.write(linkPath.getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                        SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                        SVNFileUtil.closeFile(os);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(os);
                    throw throwable;
                }
                SVNFileUtil.closeFile(os);
            }
            return new ByteArrayInputStream(os.toByteArray());
        }
        boolean bl = translationRequired = special || keywords != null || eolStyle != null || charset != null;
        if (translationRequired) {
            byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
            if (translateToNormalForm) {
                if (eolStyle != null && eol == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                Map keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
                boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || repairEOL;
                return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, repair, keywordsMap, false);
            }
            SVNEntry entry = adminArea.getVersionedEntry(name, false);
            String url = entry.getURL();
            String author = entry.getAuthor();
            String date = entry.getCommittedDate();
            String rev = Long.toString(entry.getCommittedRevision());
            Map keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
            return SVNTranslator.getTranslatingInputStream(SVNFileUtil.openFileForReading(src, SVNLogType.WC), charset, eol, true, keywordsMap, true);
        }
        return SVNFileUtil.openFileForReading(src, SVNLogType.WC);
    }

    public static File getTranslatedFile(SVNAdminArea dir, String name, File src, boolean forceEOLRepair, boolean useGlobalTmp, boolean forceCopy, boolean toNormalFormat) throws SVNException {
        ISVNOptions options = dir.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(dir.getProperties(name).getStringPropertyValue("svnkit:charset"), dir.getFile(name).getPath(), options);
        String eolStyle = dir.getProperties(name).getStringPropertyValue("svn:eol-style");
        String keywords = dir.getProperties(name).getStringPropertyValue("svn:keywords");
        boolean special = dir.getProperties(name).getPropertyValue("svn:special") != null;
        boolean needsTranslation = charset != null || eolStyle != null || keywords != null || special;
        File result = null;
        if (!needsTranslation && !forceCopy) {
            result = src;
        } else {
            result = useGlobalTmp ? SVNFileUtil.createTempFile("svndiff", ".tmp") : SVNAdminUtil.createTmpFile(dir, name, ".tmp", true);
            if (toNormalFormat) {
                SVNTranslator.translateToNormalForm(src, result, charset, eolStyle, forceEOLRepair, keywords, special);
            } else {
                SVNEntry entry = dir.getVersionedEntry(name, false);
                String url = entry.getURL();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                Map keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
                SVNTranslator.copyAndTranslate(src, result, charset, SVNTranslator.getEOL(eolStyle, options), keywordsMap, special, true, true);
            }
        }
        return result;
    }

    public static File maybeUpdateTargetEOLs(SVNAdminArea dir, File target, SVNProperties propDiff) throws SVNException {
        String eolStyle = null;
        if (propDiff != null && propDiff.containsName("svn:eol-style") && propDiff.getStringValue("svn:eol-style") != null) {
            eolStyle = propDiff.getStringValue("svn:eol-style");
            ISVNOptions options = dir.getWCAccess().getOptions();
            byte[] eol = SVNTranslator.getEOL(eolStyle, options);
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.copyAndTranslate(target, tmpFile, null, eol, null, false, false, true);
            return tmpFile;
        }
        return target;
    }

    public static File detranslateWorkingCopy(SVNAdminArea dir, String name, SVNProperties propDiff, boolean force) throws SVNException {
        boolean isRemoteBinary;
        SVNVersionedProperties props = dir.getProperties(name);
        boolean isLocalBinary = SVNProperty.isBinaryMimeType(props.getStringPropertyValue("svn:mime-type"));
        String charsetProp = null;
        String eolStyle = null;
        String keywords = null;
        boolean isSpecial = false;
        boolean isRemoteHasBinary = propDiff != null && propDiff.containsName("svn:mime-type");
        boolean isRemoteBinaryRemoved = isRemoteHasBinary && !SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        boolean bl = isRemoteBinary = isRemoteHasBinary && SVNProperty.isBinaryMimeType(propDiff.getStringValue("svn:mime-type"));
        if (!isLocalBinary && isRemoteBinary) {
            isSpecial = props.getPropertyValue("svn:special") != null;
            keywords = props.getStringPropertyValue("svn:keywords");
            charsetProp = props.getStringPropertyValue("svnkit:charset");
        } else if (!isLocalBinary || isRemoteBinaryRemoved) {
            boolean bl2 = isSpecial = props.getPropertyValue("svn:special") != null;
            if (!isSpecial) {
                if (propDiff != null && propDiff.getStringValue("svn:eol-style") != null) {
                    eolStyle = propDiff.getStringValue("svn:eol-style");
                } else if (!isLocalBinary) {
                    eolStyle = props.getStringPropertyValue("svn:eol-style");
                }
                if (propDiff != null && propDiff.getStringValue("svnkit:charset") != null) {
                    charsetProp = propDiff.getStringValue("svnkit:charset");
                } else if (!isLocalBinary) {
                    charsetProp = props.getStringPropertyValue("svnkit:charset");
                }
                if (!isLocalBinary) {
                    keywords = props.getStringPropertyValue("svn:keywords");
                }
            }
        }
        File detranslatedFile = null;
        ISVNOptions options = dir.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(charsetProp, dir.getFile(name).getPath(), options);
        if (force || charset != null || keywords != null || eolStyle != null || isSpecial) {
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            SVNTranslator.translateToNormalForm(dir.getFile(name), tmpFile, charset, eolStyle, true, keywords, isSpecial);
            detranslatedFile = tmpFile;
        } else {
            detranslatedFile = dir.getFile(name);
        }
        return detranslatedFile;
    }

    private static void translateToNormalForm(File source, File destination, String charset, String eolStyle, boolean alwaysRepairEOLs, String keywords, boolean isSpecial) throws SVNException {
        byte[] eol = SVNTranslator.getBaseEOL(eolStyle);
        if (eolStyle != null && eol == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        Map keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
        boolean repair = eolStyle != null && eol != null && !"native".equals(eolStyle) || alwaysRepairEOLs;
        SVNTranslator.copyAndTranslate(source, destination, charset, eol, keywordsMap, isSpecial, false, repair);
    }

    private static void copyAndTranslate(File source, File destination, String charset, byte[] eol, Map keywords, boolean special, boolean expand, boolean repair) throws SVNException {
        block24: {
            boolean isSpecialPath = false;
            if (SVNFileUtil.symlinksSupported()) {
                SVNFileType type = SVNFileType.getType(source);
                boolean bl = isSpecialPath = type == SVNFileType.SYMLINK;
            }
            if (special || isSpecialPath) {
                if (destination.exists()) {
                    destination.delete();
                }
                if (!SVNFileUtil.symlinksSupported()) {
                    SVNFileUtil.copyFile(source, destination, true);
                } else if (expand) {
                    SVNFileUtil.createSymlink(destination, source);
                } else {
                    SVNFileUtil.detranslateSymlink(source, destination);
                }
                return;
            }
            if (charset == null && eol == null && (keywords == null || keywords.isEmpty())) {
                SVNFileUtil.copyFile(source, destination, false);
                return;
            }
            OutputStream dst = null;
            InputStream src = null;
            OutputStream translatingStream = null;
            try {
                try {
                    dst = SVNFileUtil.openFileForWriting(destination);
                    src = SVNFileUtil.openFileForReading(source, SVNLogType.WC);
                    translatingStream = SVNTranslator.getTranslatingOutputStream(dst, charset, eol, repair, keywords, expand);
                    SVNTranslator.copy(src, translatingStream);
                }
                catch (IOExceptionWrapper ew) {
                    if (ew.getOriginalException().getErrorMessage().getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL, "File ''{0}'' has inconsistent newlines", source);
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                    throw ew.getOriginalException();
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                    if (dst != null) {
                        try {
                            dst.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    SVNFileUtil.closeFile(src);
                    SVNFileUtil.closeFile(translatingStream);
                    SVNFileUtil.closeFile(dst);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (dst != null) {
                    try {
                        dst.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SVNFileUtil.closeFile(src);
                SVNFileUtil.closeFile(translatingStream);
                SVNFileUtil.closeFile(dst);
                throw throwable;
            }
            if (dst != null) {
                try {
                    dst.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            SVNFileUtil.closeFile(src);
            SVNFileUtil.closeFile(translatingStream);
            SVNFileUtil.closeFile(dst);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean checkNewLines(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        byte[] buffer = new byte[8192];
        int read;
        while ((read = src.read(buffer)) >= 0) {
            if (read == 0) continue;
            dst.write(buffer, 0, read);
        }
        return;
    }

    public static OutputStream getTranslatingOutputStream(OutputStream out, String charset, byte[] eol, boolean repair, Map keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        if (expand) {
            out = new SVNCharsetOutputStream(out, UTF8_CHARSET, Charset.forName(charset));
            return new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        }
        out = new SVNTranslatorOutputStream(out, eol, repair, keywords, expand);
        return new SVNCharsetOutputStream(out, Charset.forName(charset), UTF8_CHARSET);
    }

    public static InputStream getTranslatingInputStream(InputStream in, String charset, byte[] eol, boolean repair, Map keywords, boolean expand) {
        if (charset == null || SVNProperty.isUTF8(charset)) {
            return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
        }
        if (expand) {
            in = new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
            return new SVNCharsetInputStream(in, UTF8_CHARSET, Charset.forName(charset));
        }
        in = new SVNCharsetInputStream(in, Charset.forName(charset), UTF8_CHARSET);
        return new SVNTranslatorInputStream(in, eol, repair, keywords, expand);
    }

    public static Map computeKeywords(String keywords, String u, String a, String d, String r, ISVNOptions options) {
        if (keywords == null) {
            return Collections.EMPTY_MAP;
        }
        boolean expand = u != null;
        byte[] date = null;
        byte[] idDate = null;
        byte[] url = null;
        byte[] rev = null;
        byte[] author = null;
        byte[] name = null;
        byte[] id = null;
        byte[] header = null;
        SVNDate jDate = d == null ? null : SVNDate.parseDate(d);
        SVNHashMap map = new SVNHashMap();
        try {
            StringTokenizer tokens = new StringTokenizer(keywords, " \t\n\b\r\f");
            while (tokens.hasMoreTokens()) {
                ByteArrayOutputStream bos;
                String token = tokens.nextToken();
                if ("LastChangedDate".equalsIgnoreCase(token) || "Date".equalsIgnoreCase(token)) {
                    date = expand && date == null ? SVNDate.formatHumanDate(jDate, options).getBytes("UTF-8") : date;
                    map.put("LastChangedDate", date);
                    map.put("Date", date);
                    continue;
                }
                if ("LastChangedRevision".equalsIgnoreCase(token) || "Revision".equalsIgnoreCase(token) || "Rev".equalsIgnoreCase(token)) {
                    rev = expand && rev == null ? r.getBytes("UTF-8") : rev;
                    map.put("LastChangedRevision", rev);
                    map.put("Revision", rev);
                    map.put("Rev", rev);
                    continue;
                }
                if ("LastChangedBy".equalsIgnoreCase(token) || "Author".equalsIgnoreCase(token)) {
                    author = expand && author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    map.put("LastChangedBy", author);
                    map.put("Author", author);
                    continue;
                }
                if ("HeadURL".equalsIgnoreCase(token) || "URL".equalsIgnoreCase(token)) {
                    url = expand && url == null ? SVNEncodingUtil.uriDecode(u).getBytes("UTF-8") : url;
                    map.put("HeadURL", url);
                    map.put("URL", url);
                    continue;
                }
                if ("Id".equalsIgnoreCase(token)) {
                    if (expand && header == null) {
                        rev = rev == null ? r.getBytes("UTF-8") : rev;
                        idDate = idDate == null ? SVNDate.formatShortDate(jDate).getBytes("UTF-8") : idDate;
                        byte[] byArray = name = name == null ? SVNEncodingUtil.uriDecode(SVNPathUtil.tail(u)).getBytes("UTF-8") : name;
                        author = author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                        bos = new ByteArrayOutputStream();
                        bos.write(name);
                        bos.write(32);
                        bos.write(rev);
                        bos.write(32);
                        bos.write(idDate);
                        bos.write(32);
                        bos.write(author);
                        bos.close();
                        id = bos.toByteArray();
                    }
                    map.put("Id", (byte[])(expand ? id : null));
                    continue;
                }
                if (!"Header".equalsIgnoreCase(token)) continue;
                if (expand && header == null) {
                    rev = rev == null ? r.getBytes("UTF-8") : rev;
                    url = expand && url == null ? SVNEncodingUtil.uriDecode(u).getBytes("UTF-8") : url;
                    byte[] byArray = idDate = idDate == null ? SVNDate.formatShortDate(jDate).getBytes("UTF-8") : idDate;
                    author = author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    bos = new ByteArrayOutputStream();
                    bos.write(url);
                    bos.write(32);
                    bos.write(rev);
                    bos.write(32);
                    bos.write(idDate);
                    bos.write(32);
                    bos.write(author);
                    bos.close();
                    header = bos.toByteArray();
                }
                map.put("Header", (byte[])(expand ? header : null));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    public static byte[] getEOL(String eolStyle, ISVNOptions options) {
        if ("native".equals(eolStyle)) {
            return options.getNativeEOL();
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static byte[] getBaseEOL(String eolStyle) {
        if ("native".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CR".equals(eolStyle)) {
            return SVNProperty.EOL_CR_BYTES;
        }
        if ("LF".equals(eolStyle)) {
            return SVNProperty.EOL_LF_BYTES;
        }
        if ("CRLF".equals(eolStyle)) {
            return SVNProperty.EOL_CRLF_BYTES;
        }
        return null;
    }

    public static String getCharset(String charset, String path, ISVNOptions options) throws SVNException {
        if ("native".equals(charset)) {
            charset = options.getNativeCharset();
        }
        boolean isSupported = true;
        try {
            isSupported = charset == null || Charset.isSupported(charset);
        }
        catch (IllegalCharsetNameException e) {
            isSupported = false;
        }
        if (!isSupported) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Charset ''{0}'' is not supported on this computer; change svnkit:charset property value or remove that property for file ''{1}''", new Object[]{charset, path}), SVNLogType.DEFAULT);
        }
        return charset;
    }
}

