/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNProperties13;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNXMLAdminArea
extends SVNAdminArea {
    public static final int WC_FORMAT = 4;
    private static final String THIS_DIR = "";
    private static final Set BOOLEAN_PROPERTIES = new SVNHashSet();
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();
    private File myLockFile = new File(this.getAdminDirectory(), "lock");
    private File myEntriesFile = new File(this.getAdminDirectory(), "entries");

    static {
        BOOLEAN_PROPERTIES.add("svn:entry:copied");
        BOOLEAN_PROPERTIES.add("svn:entry:deleted");
        BOOLEAN_PROPERTIES.add("svn:entry:absent");
        BOOLEAN_PROPERTIES.add("svn:entry:incomplete");
        INAPPLICABLE_PROPERTIES.add("svn:entry:cachable-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:present-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:has-prop-mods");
        INAPPLICABLE_PROPERTIES.add("svn:entry:working-size");
        INAPPLICABLE_PROPERTIES.add("svn:entry:depth");
        INAPPLICABLE_PROPERTIES.add("svn:entry:has-props");
        INAPPLICABLE_PROPERTIES.add("svn:entry:keep-local");
        INAPPLICABLE_PROPERTIES.add("svn:entry:changelist");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }

    public SVNXMLAdminArea(File dir) {
        super(dir);
    }

    private void saveProperties(SVNLog log) throws SVNException {
        Map propsCache = this.getPropertiesStorage(false);
        if (propsCache == null || propsCache.isEmpty()) {
            return;
        }
        SVNProperties command = new SVNProperties();
        for (String name : propsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
            dstPath = String.valueOf(this.getAdminDirectory().getName()) + "/" + dstPath;
            if (props.isEmpty()) {
                command.put("name", dstPath);
                log.addCommand("rm", command, false);
            } else {
                String tmpPath = "tmp/";
                tmpPath = String.valueOf(tmpPath) + (this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work");
                File tmpFile = this.getAdminFile(tmpPath);
                String srcPath = String.valueOf(this.getAdminDirectory().getName()) + "/" + tmpPath;
                SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, srcPath);
                tmpProps.setProperties(props.asMap());
                command.put("name", srcPath);
                command.put("dest", dstPath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", dstPath);
                log.addCommand("readonly", command, false);
            }
            props.setModified(false);
            command.clear();
        }
    }

    private void saveBaseProperties(SVNLog log) throws SVNException {
        Map basePropsCache = this.getBasePropertiesStorage(false);
        if (basePropsCache == null || basePropsCache.isEmpty()) {
            return;
        }
        SVNProperties command = new SVNProperties();
        for (String name : basePropsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)basePropsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base";
            dstPath = String.valueOf(this.getAdminDirectory().getName()) + "/" + dstPath;
            if (props.isEmpty()) {
                command.put("name", dstPath);
                log.addCommand("rm", command, false);
            } else {
                String tmpPath = "tmp/";
                tmpPath = String.valueOf(tmpPath) + (this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
                File tmpFile = this.getAdminFile(tmpPath);
                String srcPath = String.valueOf(this.getAdminDirectory().getName()) + "/" + tmpPath;
                SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, srcPath);
                tmpProps.setProperties(props.asMap());
                command.put("name", srcPath);
                command.put("dest", dstPath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", dstPath);
                log.addCommand("readonly", command, false);
            }
            props.setModified(false);
            command.clear();
        }
    }

    public void saveWCProperties(boolean close) throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(false);
        if (wcPropsCache == null) {
            return;
        }
        for (String name : wcPropsCache.keySet()) {
            SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(name);
            if (!props.isModified()) continue;
            String dstPath = this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work";
            File dstFile = this.getAdminFile(dstPath);
            if (props.isEmpty()) {
                SVNFileUtil.deleteFile(dstFile);
            } else {
                String tmpPath = "tmp/";
                tmpPath = String.valueOf(tmpPath) + (this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work");
                File tmpFile = this.getAdminFile(tmpPath);
                SVNWCProperties.setProperties(props.asMap(), dstFile, tmpFile, "END");
            }
            props.setModified(false);
        }
        if (close) {
            this.closeWCProperties();
        }
    }

    public SVNVersionedProperties getBaseProperties(String name) throws SVNException {
        Map basePropsCache = this.getBasePropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)basePropsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties baseProps = null;
        try {
            baseProps = this.readBaseProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        props = new SVNProperties13(baseProps);
        basePropsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getRevertProperties(String name) throws SVNException {
        Map revertPropsCache = this.getRevertPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)revertPropsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties revertProps = null;
        try {
            revertProps = this.readRevertProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        props = new SVNProperties13(revertProps);
        revertPropsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getProperties(String name) throws SVNException {
        Map propsCache = this.getPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)propsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties properties = null;
        try {
            properties = this.readProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        props = new SVNProperties13(properties);
        propsCache.put(name, props);
        return props;
    }

    public SVNVersionedProperties getWCProperties(String name) throws SVNException {
        Map wcPropsCache = this.getWCPropertiesStorage(true);
        SVNVersionedProperties props = (SVNVersionedProperties)wcPropsCache.get(name);
        if (props != null) {
            return props;
        }
        SVNProperties properties = null;
        try {
            properties = this.readWCProperties(name);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Failed to load properties from disk");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        props = new SVNProperties13(properties);
        wcPropsCache.put(name, props);
        return props;
    }

    private SVNProperties readProperties(String name) throws SVNException {
        File propertiesFile = this.getPropertiesFile(name, false);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
        return props.asMap();
    }

    private SVNProperties readBaseProperties(String name) throws SVNException {
        File propertiesFile = this.getBasePropertiesFile(name, false);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
        return props.asMap();
    }

    private SVNProperties readRevertProperties(String name) throws SVNException {
        File propertiesFile = this.getRevertPropertiesFile(name, false);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, null);
        return props.asMap();
    }

    private SVNProperties readWCProperties(String name) throws SVNException {
        String path = this.getThisDirName().equals(name) ? "dir-wcprops" : "wcprops/" + name + ".svn-work";
        File propertiesFile = this.getAdminFile(path);
        SVNWCProperties props = new SVNWCProperties(propertiesFile, String.valueOf(this.getAdminDirectory().getName()) + "/" + path);
        return props.asMap();
    }

    public void saveEntries(boolean close) throws SVNException {
        if (this.myEntries != null) {
            File tmpFile;
            block9: {
                SVNEntry rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
                if (rootEntry == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No default entry in directory ''{0}''", this.getRoot());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                String reposURL = rootEntry.getRepositoryRoot();
                String url = rootEntry.getURL();
                if (reposURL != null && !SVNPathUtil.isAncestor(reposURL, url)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Entry ''{0}'' has inconsistent repository root and url", this.getThisDirName());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                tmpFile = new File(this.getAdminDirectory(), "tmp/entries");
                OutputStreamWriter os = null;
                try {
                    try {
                        os = new OutputStreamWriter(SVNFileUtil.openFileForWriting(tmpFile), "UTF-8");
                        this.writeEntries(os);
                    }
                    catch (IOException e) {
                        SVNFileUtil.closeFile(os);
                        SVNFileUtil.deleteFile(tmpFile);
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write entries file ''{0}'': {1}", new Object[]{this.myEntriesFile, e.getLocalizedMessage()});
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                        SVNFileUtil.closeFile(os);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(os);
                    throw throwable;
                }
                SVNFileUtil.closeFile(os);
            }
            SVNFileUtil.rename(tmpFile, this.myEntriesFile);
            SVNFileUtil.setReadonly(this.myEntriesFile, true);
            if (close) {
                this.myEntries = null;
            }
        }
    }

    public void saveVersionedProperties(SVNLog log, boolean close) throws SVNException {
        this.saveProperties(log);
        this.saveBaseProperties(log);
        if (close) {
            this.myBaseProperties = null;
            this.myProperties = null;
        }
    }

    public void installProperties(String name, SVNProperties baseProps, SVNProperties workingProps, SVNLog log, boolean writeBaseProps, boolean close) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNNodeKind kind = name.equals(this.getThisDirName()) ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        String dstPath = SVNAdminUtil.getPropPath(name, kind, false);
        if (!workingProps.isEmpty()) {
            String tmpPath = SVNAdminUtil.getPropPath(name, kind, true);
            File tmpFile = this.getFile(tmpPath);
            SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, tmpPath);
            if (!workingProps.isEmpty()) {
                tmpProps.setProperties(workingProps);
            } else {
                SVNFileUtil.createEmptyFile(tmpFile);
            }
            command.put("name", tmpPath);
            command.put("dest", dstPath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", dstPath);
            log.addCommand("readonly", command, false);
        } else {
            command.put("name", dstPath);
            log.addCommand("rm", command, false);
        }
        command.clear();
        if (writeBaseProps) {
            String basePath = SVNAdminUtil.getPropBasePath(name, kind, false);
            if (!baseProps.isEmpty()) {
                String tmpPath = SVNAdminUtil.getPropBasePath(name, kind, true);
                File tmpFile = this.getFile(tmpPath);
                SVNWCProperties tmpProps = new SVNWCProperties(tmpFile, tmpPath);
                tmpProps.setProperties(baseProps);
                command.put("name", tmpPath);
                command.put("dest", basePath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", basePath);
                log.addCommand("readonly", command, false);
            } else {
                command.put("name", basePath);
                log.addCommand("rm", command, false);
            }
        }
        if (close) {
            this.myBaseProperties = null;
            this.myProperties = null;
        }
    }

    /*
     * Exception decompiling
     */
    protected Map fetchEntries() throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getThisDirName() {
        return THIS_DIR;
    }

    protected void writeEntries(Writer writer) throws IOException, SVNException {
        SVNEntry rootEntry = (SVNEntry)this.myEntries.get(this.getThisDirName());
        Map rootEntryAttrs = rootEntry.asMap();
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        writer.write("<wc-entries\n");
        writer.write("   xmlns=\"svn:\">\n");
        ArrayList entryNames = new ArrayList(this.myEntries.keySet());
        Collections.sort(entryNames);
        for (String name : entryNames) {
            SVNEntry entry = (SVNEntry)this.myEntries.get(name);
            Map entryAttrs = entry.asMap();
            writer.write("<entry");
            for (String propName : entryAttrs.keySet()) {
                Object expectedValue;
                Object value;
                if (!this.isEntryPropertyApplicable(propName) || !((value = entryAttrs.get(propName)) instanceof String)) continue;
                String propValue = (String)value;
                if (BOOLEAN_PROPERTIES.contains(propName) && !Boolean.TRUE.toString().equals(propValue) || !this.getThisDirName().equals(name) && (!"dir".equals(entryAttrs.get("svn:entry:kind")) ? propValue.equals(expectedValue = "svn:entry:url".equals(propName) ? SVNPathUtil.append((String)rootEntryAttrs.get(propName), SVNEncodingUtil.uriEncode(name)) : ("svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) ? rootEntryAttrs.get(propName) : ("svn:entry:repos".equals(propName) ? rootEntryAttrs.get(propName) : null))) : "svn:entry:uuid".equals(propName) || "svn:entry:revision".equals(propName) || "svn:entry:url".equals(propName) || "svn:entry:repos".equals(propName))) continue;
                if (propName == null || !propName.startsWith("svn:entry:")) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "attempt to write invalid entry property: " + propName + "=" + propValue);
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, new Exception());
                    continue;
                }
                propName = propName.substring("svn:entry:".length());
                propValue = SVNEncodingUtil.xmlEncodeAttr(propValue);
                writer.write("\n   ");
                writer.write(propName);
                writer.write("=\"");
                writer.write(propValue);
                writer.write("\"");
            }
            writer.write("/>\n");
            writer.flush();
        }
        writer.write("</wc-entries>\n");
        writer.flush();
    }

    public boolean hasPropModifications(String name) throws SVNException {
        SVNVersionedProperties m2;
        String realTimestamp;
        boolean propEmtpy;
        File baseFile;
        File propFile;
        if (this.getThisDirName().equals(name)) {
            propFile = this.getAdminFile("dir-props");
            baseFile = this.getAdminFile("dir-prop-base");
        } else {
            propFile = this.getAdminFile("props/" + name + ".svn-work");
            baseFile = this.getAdminFile("prop-base/" + name + ".svn-base");
        }
        SVNEntry entry = this.getEntry(name, true);
        long propLength = propFile.length();
        boolean bl = propEmtpy = propLength <= 4L;
        if (entry.isScheduledForReplacement()) {
            return !propEmtpy;
        }
        if (propEmtpy) {
            boolean baseEmtpy;
            boolean bl2 = baseEmtpy = baseFile.length() <= 4L;
            if (baseEmtpy) {
                return !propEmtpy;
            }
            return true;
        }
        if (propLength != baseFile.length()) {
            return true;
        }
        String fullRealTimestamp = realTimestamp = SVNDate.formatDate(new Date(propFile.lastModified()));
        realTimestamp = realTimestamp.substring(0, 23);
        String timeStamp = entry.getPropTime();
        if (timeStamp != null && realTimestamp.equals(timeStamp = timeStamp.substring(0, 23))) {
            return false;
        }
        SVNVersionedProperties m1 = this.getProperties(name);
        if (m1.equals(m2 = this.getBaseProperties(name))) {
            if (this.isLocked()) {
                entry.setPropTime(fullRealTimestamp);
                this.saveEntries(false);
            }
            return false;
        }
        return true;
    }

    public boolean hasTextModifications(String name, boolean forceComparison) throws SVNException {
        boolean equals;
        File versionedFile;
        SVNEntry entry;
        block11: {
            long tstamp;
            String textTime;
            long textTimeAsLong;
            SVNFileType fType = SVNFileType.getType(this.getFile(name));
            if (fType == SVNFileType.DIRECTORY || fType == SVNFileType.NONE) {
                return false;
            }
            entry = this.getEntry(name, true);
            if (entry.isDirectory()) {
                return false;
            }
            if (!forceComparison && (textTimeAsLong = SVNFileUtil.roundTimeStamp(SVNDate.parseDateAsMilliseconds(textTime = entry.getTextTime()))) == (tstamp = SVNFileUtil.roundTimeStamp(this.getFile(name).lastModified()))) {
                return false;
            }
            File baseFile = this.getBaseFile(name, false);
            if (!baseFile.isFile()) {
                return true;
            }
            File baseTmpFile = SVNFileUtil.createUniqueFile(this.getRoot(), SVNFileUtil.getBasePath(this.getBaseFile(name, true)), ".tmp", true);
            versionedFile = this.getFile(name);
            SVNTranslator.translate((SVNAdminArea)this, name, name, SVNFileUtil.getBasePath(baseTmpFile), false);
            equals = true;
            try {
                try {
                    String checksum;
                    MessageDigest digest = forceComparison ? MessageDigest.getInstance("MD5") : null;
                    equals = SVNFileUtil.compareFiles(baseFile, baseTmpFile, digest);
                    if (forceComparison && !(checksum = SVNFileUtil.toHexDigest(digest)).equals(entry.getChecksum())) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch indicates corrupt text base: ''{0}''\n   expected: {1}\n     actual: {2}\n", new Object[]{baseFile, entry.getChecksum(), checksum});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {1}", e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.WC);
                    baseTmpFile.delete();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                baseTmpFile.delete();
                throw throwable;
            }
            baseTmpFile.delete();
        }
        if (equals && this.isLocked()) {
            entry.setTextTime(SVNDate.formatDate(new Date(versionedFile.lastModified())));
            this.saveEntries(false);
        }
        return !equals;
    }

    public boolean hasProperties(String entryName) throws SVNException {
        File baseFile;
        File propFile;
        if (this.getThisDirName().equals(entryName)) {
            propFile = this.getAdminFile("dir-props");
            baseFile = this.getAdminFile("dir-prop-base");
        } else {
            propFile = this.getAdminFile("props/" + entryName + ".svn-work");
            baseFile = this.getAdminFile("prop-base/" + entryName + ".svn-base");
        }
        SVNWCProperties baseProps = new SVNWCProperties(baseFile, null);
        if (baseProps.isEmpty()) {
            SVNWCProperties props = new SVNWCProperties(propFile, null);
            return !props.isEmpty();
        }
        return true;
    }

    public boolean lock(boolean stealLock) throws SVNException {
        if (!this.isVersioned()) {
            return false;
        }
        if (this.myLockFile.isFile()) {
            if (stealLock) {
                this.setLocked(true);
                return true;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean created = false;
        try {
            created = this.myLockFile.createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", new Object[]{this.getRoot(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        if (!created) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", this.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", this.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        this.setLocked(true);
        return created;
    }

    boolean innerLock() throws SVNException {
        if (this.myLockFile.isFile()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked; try performing ''cleanup''", this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean created = false;
        try {
            created = this.myLockFile.createNewFile();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}'': {1}", new Object[]{this.getRoot(), e.getLocalizedMessage()});
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        if (!created) {
            if (this.myLockFile.isFile()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' is locked; try performing 'cleanup'", this.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Cannot lock working copy ''{0}''", this.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return created;
    }

    public boolean unlock() throws SVNException {
        if (!this.myLockFile.exists()) {
            return true;
        }
        boolean killMe = this.getAdminFile("KILLME").exists();
        if (killMe) {
            return false;
        }
        File[] logs = SVNFileListUtil.listFiles(this.getAdminDirectory());
        int i = 0;
        while (logs != null && i < logs.length) {
            File log = logs[i];
            if ("log".equals(log.getName()) || log.getName().startsWith("log.")) {
                return false;
            }
            ++i;
        }
        boolean deleted = SVNFileUtil.deleteFile(this.myLockFile);
        if (!deleted) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Failed to unlock working copy ''{0}''", this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return deleted;
    }

    public boolean isVersioned() {
        if (this.getAdminDirectory().isDirectory() && this.myEntriesFile.canRead()) {
            try {
                if (this.getEntry(this.getThisDirName(), false) != null) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return false;
    }

    public SVNAdminArea createVersionedDirectory(File dir, String url, String rootURL, String uuid, long revNumber, boolean createMyself, SVNDepth depth) throws SVNException {
        dir = createMyself ? this.getRoot() : dir;
        dir.mkdirs();
        File adminDir = createMyself ? this.getAdminDirectory() : new File(dir, SVNFileUtil.getAdminDirectoryName());
        adminDir.mkdir();
        SVNFileUtil.setHidden(adminDir, true);
        File lockFile = createMyself ? this.myLockFile : new File(adminDir, "lock");
        SVNFileUtil.createEmptyFile(lockFile);
        SVNAdminUtil.createReadmeFile(adminDir);
        SVNFileUtil.createEmptyFile(createMyself ? this.getAdminFile("empty-file") : new File(adminDir, "empty-file"));
        File[] tmp = new File[]{createMyself ? this.getAdminFile("tmp") : new File(adminDir, "tmp"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "props") : new File(adminDir, "tmp" + File.separatorChar + "props"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "prop-base") : new File(adminDir, "tmp" + File.separatorChar + "prop-base"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "text-base") : new File(adminDir, "tmp" + File.separatorChar + "text-base"), createMyself ? this.getAdminFile("tmp" + File.separatorChar + "wcprops") : new File(adminDir, "tmp" + File.separatorChar + "wcprops"), createMyself ? this.getAdminFile("props") : new File(adminDir, "props"), createMyself ? this.getAdminFile("prop-base") : new File(adminDir, "prop-base"), createMyself ? this.getAdminFile("text-base") : new File(adminDir, "text-base"), createMyself ? this.getAdminFile("wcprops") : new File(adminDir, "wcprops")};
        int i = 0;
        while (i < tmp.length) {
            tmp[i].mkdir();
            ++i;
        }
        SVNAdminUtil.createFormatFile(adminDir);
        SVNXMLAdminArea adminArea = createMyself ? this : new SVNXMLAdminArea(dir);
        adminArea.setLocked(true);
        SVNEntry rootEntry = adminArea.getEntry(((SVNAdminArea)adminArea).getThisDirName(), true);
        if (rootEntry == null) {
            rootEntry = adminArea.addEntry(((SVNAdminArea)adminArea).getThisDirName());
        }
        if (url != null) {
            rootEntry.setURL(url);
        }
        rootEntry.setRepositoryRoot(rootURL);
        rootEntry.setRevision(revNumber);
        rootEntry.setKind(SVNNodeKind.DIR);
        if (uuid != null) {
            rootEntry.setUUID(uuid);
        }
        if (revNumber > 0L) {
            rootEntry.setIncomplete(true);
        }
        ((SVNAdminArea)adminArea).saveEntries(false);
        SVNFileUtil.deleteFile(lockFile);
        return adminArea;
    }

    public boolean isLocked() {
        if (!this.myWasLocked) {
            return false;
        }
        return this.myLockFile.isFile();
    }

    public int getFormatVersion() {
        return 4;
    }

    protected SVNVersionedProperties formatBaseProperties(SVNProperties srcProperties) {
        SVNProperties filteredProperties = new SVNProperties(srcProperties);
        filteredProperties.remove("svn:mergeinfo");
        return new SVNProperties13(srcProperties);
    }

    protected SVNVersionedProperties formatProperties(SVNEntry entry, SVNProperties srcProperties) {
        SVNProperties filteredProperties = new SVNProperties(srcProperties);
        filteredProperties.remove("svn:mergeinfo");
        return new SVNProperties13(filteredProperties);
    }

    public void handleKillMe() throws SVNException {
        boolean killMe = this.isKillMe();
        if (killMe) {
            boolean isWCRoot;
            SVNWCAccess access;
            File dir;
            long dirRevision;
            block5: {
                SVNEntry entry = this.getEntry(this.getThisDirName(), false);
                dirRevision = entry != null ? entry.getRevision() : -1L;
                dir = this.getRoot();
                access = this.getWCAccess();
                isWCRoot = access.isWCRoot(this.getRoot());
                try {
                    this.removeFromRevisionControl(this.getThisDirName(), true, false);
                }
                catch (SVNException svne) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, svne);
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) break block5;
                    throw svne;
                }
            }
            if (isWCRoot) {
                return;
            }
            SVNAdminArea parentArea = access.retrieve(dir.getParentFile());
            SVNEntry parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
            if (dirRevision > parentEntry.getRevision()) {
                SVNEntry entryInParent = parentArea.addEntry(dir.getName());
                entryInParent.setDeleted(true);
                entryInParent.setKind(SVNNodeKind.DIR);
                entryInParent.setRevision(dirRevision);
                parentArea.saveEntries(false);
            }
        }
    }

    public void postCommit(String fileName, long revisionNumber, boolean implicit, boolean rerun, SVNErrorCode errorCode) throws SVNException {
        long propTime;
        long textTime;
        block58: {
            File tmpFile;
            SVNFileType fileType;
            SVNEntry entry = this.getEntry(fileName, true);
            if (entry == null || !this.getThisDirName().equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Log command for directory ''{0}'' is mislocated", this.getRoot());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!implicit && entry.isScheduledForDeletion()) {
                if (this.getThisDirName().equals(fileName)) {
                    entry.setRevision(revisionNumber);
                    entry.setKind(SVNNodeKind.DIR);
                    File killMe = this.getAdminFile("KILLME");
                    if (rerun && killMe.isFile()) {
                        return;
                    }
                    if (killMe.getParentFile().isDirectory()) {
                        try {
                            killMe.createNewFile();
                        }
                        catch (IOException e) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create file ''{0}'': {1}", new Object[]{killMe, e.getLocalizedMessage()});
                            SVNErrorManager.error(err, e, SVNLogType.WC);
                        }
                    }
                } else {
                    this.removeFromRevisionControl(fileName, false, false);
                    SVNEntry parentEntry = this.getEntry(this.getThisDirName(), true);
                    if (revisionNumber > parentEntry.getRevision()) {
                        SVNEntry fileEntry = this.addEntry(fileName);
                        fileEntry.setKind(SVNNodeKind.FILE);
                        fileEntry.setDeleted(true);
                        fileEntry.setRevision(revisionNumber);
                    }
                }
                return;
            }
            if (!implicit && entry.isScheduledForReplacement() && this.getThisDirName().equals(fileName)) {
                Iterator ents = this.entries(true);
                while (ents.hasNext()) {
                    SVNEntry currentEntry = (SVNEntry)ents.next();
                    if (!currentEntry.isScheduledForDeletion() || currentEntry.getKind() != SVNNodeKind.FILE && currentEntry.getKind() != SVNNodeKind.DIR) continue;
                    this.removeFromRevisionControl(currentEntry.getName(), false, false);
                }
            }
            textTime = 0L;
            if (!(implicit || this.getThisDirName().equals(fileName) || (fileType = SVNFileType.getType(tmpFile = this.getBaseFile(fileName, true))) != SVNFileType.FILE && fileType != SVNFileType.SYMLINK)) {
                File workingFile;
                boolean modified;
                block56: {
                    modified = false;
                    workingFile = this.getFile(fileName);
                    File tmpFile2 = SVNFileUtil.createUniqueFile(tmpFile.getParentFile(), fileName, ".tmp", true);
                    try {
                        try {
                            String tmpFile2Path = SVNFileUtil.getBasePath(tmpFile2);
                            SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, tmpFile2Path, false);
                            modified = !SVNFileUtil.compareFiles(tmpFile, tmpFile2, null);
                        }
                        catch (SVNException svne) {
                            SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error comparing ''{0}'' and ''{1}''", new Object[]{workingFile, tmpFile});
                            SVNErrorManager.error(err, svne, SVNLogType.WC);
                            tmpFile2.delete();
                            break block56;
                        }
                    }
                    catch (Throwable throwable) {
                        tmpFile2.delete();
                        throw throwable;
                    }
                    tmpFile2.delete();
                }
                long l = textTime = modified ? tmpFile.lastModified() : workingFile.lastModified();
            }
            if (!implicit && entry.isScheduledForReplacement()) {
                SVNFileUtil.deleteFile(this.getBasePropertiesFile(fileName, false));
            }
            propTime = 0L;
            boolean setReadWrite = false;
            boolean setNotExecutable = false;
            SVNVersionedProperties baseProps = this.getBaseProperties(fileName);
            SVNVersionedProperties wcProps = this.getProperties(fileName);
            File tmpPropsFile = this.getPropertiesFile(fileName, true);
            File wcPropsFile = this.getPropertiesFile(fileName, false);
            File basePropertiesFile = this.getBasePropertiesFile(fileName, false);
            SVNFileType tmpPropsType = SVNFileType.getType(tmpPropsFile);
            if (tmpPropsType == SVNFileType.FILE) {
                SVNWCProperties working = new SVNWCProperties(wcPropsFile, null);
                SVNWCProperties workingTmp = new SVNWCProperties(tmpPropsFile, null);
                SVNProperties pDiff = working.compareTo(workingTmp);
                boolean equals = pDiff == null || pDiff.isEmpty();
                long l = propTime = equals ? wcPropsFile.lastModified() : tmpPropsFile.lastModified();
                if (!this.getThisDirName().equals(fileName)) {
                    SVNVersionedProperties propDiff = baseProps.compareTo(wcProps);
                    setReadWrite = propDiff != null && propDiff.containsProperty("svn:needs-lock") && propDiff.getPropertyValue("svn:needs-lock") == null;
                    setNotExecutable = propDiff != null && propDiff.containsProperty("svn:executable") && propDiff.getPropertyValue("svn:executable") == null;
                }
                try {
                    if (!tmpPropsFile.exists() || tmpPropsFile.length() <= 4L) {
                        SVNFileUtil.deleteFile(basePropertiesFile);
                    }
                    SVNFileUtil.copyFile(tmpPropsFile, basePropertiesFile, true);
                    SVNFileUtil.setReadonly(basePropertiesFile, true);
                }
                finally {
                    SVNFileUtil.deleteFile(tmpPropsFile);
                }
            } else if (entry.getPropTime() == null && !wcProps.isEmpty()) {
                propTime = wcPropsFile.lastModified();
            }
            if (!this.getThisDirName().equals(fileName) && !implicit) {
                File tmpFile2 = this.getBaseFile(fileName, true);
                File baseFile = this.getBaseFile(fileName, false);
                File wcFile = this.getFile(fileName);
                File tmpFile22 = null;
                try {
                    try {
                        boolean needsExecutable;
                        boolean special;
                        tmpFile22 = SVNFileUtil.createUniqueFile(tmpFile2.getParentFile(), fileName, ".tmp", false);
                        boolean overwritten = false;
                        SVNFileType fileType2 = SVNFileType.getType(tmpFile2);
                        boolean bl = special = this.getProperties(fileName).getPropertyValue("svn:special") != null;
                        if (!SVNFileUtil.symlinksSupported() || !special) {
                            if (fileType2 == SVNFileType.FILE) {
                                SVNTranslator.translate((SVNAdminArea)this, fileName, SVNFileUtil.getBasePath(tmpFile2), SVNFileUtil.getBasePath(tmpFile22), true);
                            } else {
                                SVNTranslator.translate((SVNAdminArea)this, fileName, fileName, SVNFileUtil.getBasePath(tmpFile22), true);
                            }
                            if (!SVNFileUtil.compareFiles(tmpFile22, wcFile, null)) {
                                SVNFileUtil.copyFile(tmpFile22, wcFile, true);
                                overwritten = true;
                            }
                        }
                        boolean needsReadonly = this.getProperties(fileName).getPropertyValue("svn:needs-lock") != null && entry.getLockToken() == null;
                        boolean bl2 = needsExecutable = this.getProperties(fileName).getPropertyValue("svn:executable") != null;
                        if (needsReadonly) {
                            SVNFileUtil.setReadonly(wcFile, true);
                            overwritten = true;
                        }
                        if (needsExecutable) {
                            SVNFileUtil.setExecutable(wcFile, true);
                            overwritten = true;
                        }
                        if (fileType2 == SVNFileType.FILE) {
                            SVNFileUtil.rename(tmpFile2, baseFile);
                        }
                        if (setReadWrite) {
                            SVNFileUtil.setReadonly(wcFile, false);
                            overwritten = true;
                        }
                        if (setNotExecutable) {
                            SVNFileUtil.setExecutable(wcFile, false);
                            overwritten = true;
                        }
                        if (overwritten) {
                            textTime = wcFile.lastModified();
                        }
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error replacing text-base of ''{0}''", fileName);
                        SVNErrorManager.error(err, svne, SVNLogType.WC);
                        tmpFile22.delete();
                        tmpFile2.delete();
                        break block58;
                    }
                }
                catch (Throwable throwable) {
                    tmpFile22.delete();
                    tmpFile2.delete();
                    throw throwable;
                }
                tmpFile22.delete();
                tmpFile2.delete();
            }
        }
        SVNHashMap entryAttrs = new SVNHashMap();
        entryAttrs.put("svn:entry:revision", SVNProperty.toString(revisionNumber));
        entryAttrs.put("svn:entry:kind", this.getThisDirName().equals(fileName) ? "dir" : "file");
        if (!implicit) {
            entryAttrs.put("svn:entry:schedule", null);
        }
        entryAttrs.put("svn:entry:copied", SVNProperty.toString(false));
        entryAttrs.put("svn:entry:deleted", SVNProperty.toString(false));
        if (textTime != 0L && !implicit) {
            entryAttrs.put("svn:entry:text-time", SVNDate.formatDate(new Date(textTime)));
        }
        if (propTime != 0L && !implicit) {
            entryAttrs.put("svn:entry:prop-time", SVNDate.formatDate(new Date(propTime)));
        }
        entryAttrs.put("svn:entry:conflict-new", null);
        entryAttrs.put("svn:entry:conflict-old", null);
        entryAttrs.put("svn:entry:conflict-wrk", null);
        entryAttrs.put("svn:entry:prop-reject-file", null);
        entryAttrs.put("svn:entry:copyfrom-rev", null);
        entryAttrs.put("svn:entry:copyfrom-url", null);
        try {
            this.modifyEntry(fileName, entryAttrs, false, true);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", fileName);
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        if (!this.getThisDirName().equals(fileName)) {
            return;
        }
        File dirFile = this.getRoot();
        if (this.getWCAccess().isWCRoot(this.getRoot())) {
            return;
        }
        boolean unassociated = false;
        SVNAdminArea parentArea = null;
        try {
            parentArea = this.getWCAccess().retrieve(dirFile.getParentFile());
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                parentArea = this.getWCAccess().open(dirFile.getParentFile(), true, false, 0);
                unassociated = true;
            }
            throw svne;
        }
        SVNEntry entryInParent = parentArea.getEntry(dirFile.getName(), false);
        if (entryInParent != null) {
            entryAttrs.clear();
            if (!implicit) {
                entryAttrs.put("svn:entry:schedule", null);
            }
            entryAttrs.put("svn:entry:copied", SVNProperty.toString(false));
            entryAttrs.put("svn:entry:copyfrom-rev", null);
            entryAttrs.put("svn:entry:copyfrom-url", null);
            entryAttrs.put("svn:entry:deleted", SVNProperty.toString(false));
            try {
                parentArea.modifyEntry(entryInParent.getName(), entryAttrs, true, true);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(errorCode, "Error modifying entry of ''{0}''", fileName);
                SVNErrorManager.error(err, svne, SVNLogType.WC);
            }
        }
        parentArea.saveEntries(false);
        if (unassociated) {
            this.getWCAccess().closeAdminArea(dirFile.getParentFile());
        }
    }

    public boolean hasTreeConflict(String name) throws SVNException {
        return false;
    }

    public SVNTreeConflictDescription getTreeConflict(String name) throws SVNException {
        return null;
    }

    public void addTreeConflict(SVNTreeConflictDescription conflict) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    public SVNTreeConflictDescription deleteTreeConflict(String name) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
        return null;
    }

    public void setFileExternalLocation(String name, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNURL reposRootURL) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This feature is not supported in version {0} of working copy format", String.valueOf(this.getFormatVersion()));
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null && !INAPPLICABLE_PROPERTIES.contains(propName);
    }

    protected boolean readExtraOptions(BufferedReader reader, Map entryAttrs) throws SVNException, IOException {
        return false;
    }

    protected int writeExtraOptions(Writer writer, String entryName, Map entryAttrs, int emptyFields) throws SVNException, IOException {
        return emptyFields;
    }
}

