/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;

public class SVNWCUtil {
    private static final String ECLIPSE_AUTH_MANAGER_CLASSNAME = "org.tmatesoft.svn.core.internal.wc.EclipseSVNAuthenticationManager";
    private static Boolean ourIsEclipse;

    public static File getDefaultConfigurationDirectory() {
        if (SVNFileUtil.isWindows && !SVNFileUtil.isOS2) {
            return new File(SVNFileUtil.getApplicationDataPath(), "Subversion");
        }
        if (SVNFileUtil.isOpenVMS) {
            return new File("/sys$login", ".subversion").getAbsoluteFile();
        }
        return new File(System.getProperty("user.home"), ".subversion");
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), null, null);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir) {
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, null, null, null, null, true, false);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(String userName, String password) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, userName, password);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password) {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(configDir, true);
        boolean store = options.isAuthStorageEnabled();
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, userName, password, store);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password, boolean storeAuth) {
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, userName, password, null, null, storeAuth, storeAuth);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password, File privateKey, String passphrase, boolean storeAuth, boolean saveSSL) {
        if (SVNWCUtil.isEclipse()) {
            try {
                Constructor<?> method;
                Class<?> managerClass;
                ClassLoader loader = SVNWCUtil.class.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if ((managerClass = loader.loadClass(ECLIPSE_AUTH_MANAGER_CLASSNAME)) != null && (method = managerClass.getConstructor(File.class, Boolean.TYPE, String.class, String.class, File.class, String.class)) != null) {
                    return (ISVNAuthenticationManager)method.newInstance(configDir, storeAuth ? Boolean.TRUE : Boolean.FALSE, userName, password, privateKey, passphrase);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new DefaultSVNAuthenticationManager(configDir, storeAuth, saveSSL, userName, password, privateKey, passphrase);
    }

    public static DefaultSVNOptions createDefaultOptions(File dir, boolean readonly) {
        return new DefaultSVNOptions(dir, readonly);
    }

    public static DefaultSVNOptions createDefaultOptions(boolean readonly) {
        return new DefaultSVNOptions(null, readonly);
    }

    public static boolean isVersionedDirectory(File dir) {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            try {
                wcAccess.open(dir, false, false, false, 0, Level.FINEST);
            }
            catch (SVNException sVNException) {
                try {
                    wcAccess.close();
                }
                catch (SVNException sVNException2) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                wcAccess.close();
            }
            catch (SVNException sVNException) {}
        }
        return true;
    }

    public static boolean isWorkingCopyRoot(File versionedDir) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            wcAccess.open(versionedDir, false, false, false, 0, Level.FINEST);
            boolean bl = wcAccess.isWCRoot(versionedDir);
            return bl;
        }
        catch (SVNException e) {
            return false;
        }
        finally {
            wcAccess.close();
        }
    }

    public static boolean isWorkingCopyRoot(File versionedDir, boolean externalIsRoot) throws SVNException {
        if (SVNWCUtil.isWorkingCopyRoot(versionedDir)) {
            if (!externalIsRoot) {
                return true;
            }
            File root = SVNWCUtil.getWorkingCopyRoot(versionedDir, false);
            return root.equals(versionedDir);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getWorkingCopyRoot(File versionedDir, boolean stopOnExtenrals) throws SVNException {
        block14: {
            if ((versionedDir = versionedDir.getAbsoluteFile()) == null) return null;
            if (!SVNWCUtil.isVersionedDirectory(versionedDir)) {
                if (versionedDir.getParentFile() == null) return null;
                if (!SVNWCUtil.isVersionedDirectory(versionedDir.getParentFile())) {
                    return null;
                }
            }
            if ((parent = versionedDir.getParentFile()) == null) {
                return versionedDir;
            }
            if (SVNWCUtil.isWorkingCopyRoot(versionedDir) == false) return SVNWCUtil.getWorkingCopyRoot(parent, stopOnExtenrals);
            if (stopOnExtenrals) {
                return versionedDir;
            }
            parentRoot = SVNWCUtil.getWorkingCopyRoot(parent, stopOnExtenrals);
            if (parentRoot != null) ** GOTO lbl45
            return versionedDir;
lbl-1000:
            // 1 sources

            {
                block15: {
                    parentAccess = SVNWCAccess.newInstance(null);
                    try {
                        dir = parentAccess.open(parent, false, 0);
                        props = dir.getProperties(dir.getThisDirName());
                        externalsProperty = props.getStringPropertyValue("svn:externals");
                        externals = externalsProperty != null ? SVNExternal.parseExternals(dir.getRoot().getAbsolutePath(), externalsProperty) : new SVNExternal[]{};
                        i = 0;
                        while (i < externals.length) {
                            external = externals[i];
                            externalFile = new File(parent, external.getPath());
                            if (externalFile.equals(versionedDir)) {
                                var13_13 = parentRoot;
                                break block14;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable var12_14) {
                        parentAccess.close();
                        throw var12_14;
                    }
                    {
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            parentAccess.close();
                            break block15;
                            break;
                        }
                    }
                    parentAccess.close();
                }
                if (parent.equals(parentRoot)) {
                    return versionedDir;
                }
                parent = parent.getParentFile();
lbl45:
                // 2 sources

                ** while (parent != null)
            }
lbl46:
            // 1 sources

            return versionedDir;
        }
        parentAccess.close();
        return var13_13;
    }

    private static boolean isEclipse() {
        if (ourIsEclipse == null) {
            try {
                Class<?> platform;
                Method isRunning;
                Object result;
                ClassLoader loader = SVNWCUtil.class.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if ((result = (isRunning = (platform = loader.loadClass("org.eclipse.core.runtime.Platform")).getMethod("isRunning", new Class[0])).invoke(null, new Object[0])) != null && Boolean.TRUE.equals(result)) {
                    ourIsEclipse = Boolean.TRUE;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ourIsEclipse = Boolean.FALSE;
        }
        return ourIsEclipse;
    }
}

