/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.util.LinkedList;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLLogHandler
extends AbstractXMLHandler
implements ISVNLogEntryHandler {
    public static final String COPYFROM_REV_ATTR = "copyfrom-rev";
    public static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    public static final String ACTION_ATTR = "action";
    public static final String REVISION_ATTR = "revision";
    public static final String MSG_TAG = "msg";
    public static final String PATH_TAG = "path";
    public static final String PATHS_TAG = "paths";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String LOGENTRY_TAG = "logentry";
    public static final String LOG_TAG = "log";
    private boolean myIsOmitLogMessage;
    private LinkedList myMergeStack;

    public SVNXMLLogHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLLogHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        super(contentHandler, log);
    }

    public String getHeaderName() {
        return LOG_TAG;
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        try {
            this.sendToHandler(logEntry);
        }
        catch (SAXException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
    }

    public void setOmitLogMessage(boolean omitLogMessage) {
        this.myIsOmitLogMessage = omitLogMessage;
    }

    /*
     * Unable to fully structure code
     */
    private void sendToHandler(SVNLogEntry logEntry) throws SAXException {
        block10: {
            if (logEntry.getRevision() == 0L && logEntry.getMessage() == null) {
                return;
            }
            this.addAttribute("revision", String.valueOf(logEntry.getRevision()));
            this.openTag("logentry");
            if (logEntry.getAuthor() != null) {
                this.addTag("author", logEntry.getAuthor());
            }
            if (logEntry.getDate() != null && logEntry.getDate().getTime() != 0L) {
                this.addTag("date", SVNDate.formatDate(logEntry.getDate()));
            }
            if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
                this.openTag("paths");
                for (String key : logEntry.getChangedPaths().keySet()) {
                    path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                    this.addAttribute("action", String.valueOf(path.getType()));
                    if (path.getCopyPath() != null) {
                        this.addAttribute("copyfrom-path", path.getCopyPath());
                        this.addAttribute("copyfrom-rev", String.valueOf(path.getCopyRevision()));
                    }
                    this.addTag("path", path.getPath());
                }
                this.closeTag("paths");
            }
            if (!this.myIsOmitLogMessage) {
                message = logEntry.getMessage();
                message = message == null ? "" : message;
                this.addTag("msg", message);
            }
            if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
                v0 = frame = (MergeFrame)this.myMergeStack.getLast();
                MergeFrame.access$1(v0, MergeFrame.access$0(v0) - 1L);
            }
            if (!logEntry.hasChildren()) ** GOTO lbl37
            frame = new MergeFrame();
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList<E>();
            }
            this.myMergeStack.addLast(frame);
            break block10;
            while (MergeFrame.access$0(frame = (MergeFrame)this.myMergeStack.getLast()) == 0L) {
                this.closeTag("logentry");
                this.myMergeStack.removeLast();
lbl37:
                // 2 sources

                if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) continue;
            }
            this.closeTag("logentry");
        }
    }

    private class MergeFrame {
        private long myNumberOfChildrenRemaining;

        private MergeFrame() {
        }

        static /* synthetic */ long access$0(MergeFrame mergeFrame) {
            return mergeFrame.myNumberOfChildrenRemaining;
        }

        static /* synthetic */ void access$1(MergeFrame mergeFrame, long l) {
            mergeFrame.myNumberOfChildrenRemaining = l;
        }
    }
}

