/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetAlterTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetSchema
implements ISqlJetSchema {
    private static String AUTOINDEX = "sqlite_autoindex_%s_%d";
    private static final String CANT_DELETE_IMPLICIT_INDEX = "Can't delete implicit index \"%s\"";
    private static final String CREATE_TABLE_SQLITE_SEQUENCE = "CREATE TABLE sqlite_sequence(name,seq)";
    private static final String SQLITE_SEQUENCE = "SQLITE_SEQUENCE";
    private static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_TABLE_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.INTKEY, SqlJetBtreeTableCreateFlags.LEAFDATA);
    private static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_INDEX_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.ZERODATA);
    private static final String TABLE_TYPE = "table";
    private static final String INDEX_TYPE = "index";
    private final ISqlJetDbHandle db;
    private final ISqlJetBtree btree;
    private final Map<String, ISqlJetTableDef> tableDefs = new TreeMap<String, ISqlJetTableDef>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ISqlJetIndexDef> indexDefs = new TreeMap<String, ISqlJetIndexDef>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, ISqlJetVirtualTableDef> virtualTableDefs = new TreeMap<String, ISqlJetVirtualTableDef>(String.CASE_INSENSITIVE_ORDER);

    public SqlJetSchema(ISqlJetDbHandle db, ISqlJetBtree btree) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.init();
    }

    private ISqlJetBtreeSchemaTable openSchemaTable(boolean write) throws SqlJetException {
        return new SqlJetBtreeSchemaTable(this.btree, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SqlJetException {
        if (this.db.getOptions().getSchemaVersion() == 0) {
            return;
        }
        ISqlJetBtreeSchemaTable table = this.openSchemaTable(false);
        try {
            table.lock();
            try {
                this.readShema(table);
            }
            finally {
                table.unlock();
            }
        }
        finally {
            table.close();
        }
    }

    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    public ISqlJetBtree getBtree() {
        return this.btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTableNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.tableDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetTableDef getTable(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.tableDefs.get(name);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getIndexNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.indexDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetIndexDef getIndex(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.indexDefs.get(name);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ISqlJetIndexDef> getIndexes(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            HashSet<ISqlJetIndexDef> result = new HashSet<ISqlJetIndexDef>();
            for (ISqlJetIndexDef index : this.indexDefs.values()) {
                if (!index.getTableName().equals(tableName)) continue;
                result.add(index);
            }
            Set<ISqlJetIndexDef> set = Collections.unmodifiableSet(result);
            return set;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getVirtualTableNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.virtualTableDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISqlJetVirtualTableDef getVirtualTable(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.virtualTableDefs.get(name);
            return iSqlJetVirtualTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void readShema(ISqlJetBtreeSchemaTable table) throws SqlJetException {
        table.first();
        while (!table.eof()) {
            String name;
            String type = table.getTypeField();
            if (null != type && null != (name = table.getNameField())) {
                int page = table.getPageField();
                if (TABLE_TYPE.equals(type)) {
                    String sql = table.getSqlField();
                    CommonTree ast = (CommonTree)this.parseTable(sql).getTree();
                    if (!this.isCreateVirtualTable(ast)) {
                        SqlJetTableDef tableDef = new SqlJetTableDef(ast, page);
                        if (!name.equals(tableDef.getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        tableDef.setRowId(table.getRowId());
                        this.tableDefs.put(name, tableDef);
                    } else {
                        SqlJetVirtualTableDef virtualTableDef = new SqlJetVirtualTableDef(ast, page);
                        if (!name.equals(virtualTableDef.getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        virtualTableDef.setRowId(table.getRowId());
                        this.virtualTableDefs.put(name, virtualTableDef);
                    }
                } else if (INDEX_TYPE.equals(type)) {
                    String tableName = table.getTableField();
                    if (null == type) {
                        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                    }
                    String sql = table.getSqlField();
                    if (null != sql) {
                        CommonTree ast = (CommonTree)this.parseIndex(sql).getTree();
                        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, page);
                        if (!name.equals(indexDef.getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (!tableName.equals(indexDef.getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        indexDef.setRowId(table.getRowId());
                        this.indexDefs.put(name, indexDef);
                    } else {
                        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(name, tableName, page);
                        indexDef.setRowId(table.getRowId());
                        this.indexDefs.put(name, indexDef);
                    }
                }
            }
            table.next();
        }
    }

    private boolean isCreateVirtualTable(CommonTree ast) {
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        for (int i = 0; i < optionsNode.getChildCount(); ++i) {
            CommonTree optionNode = (CommonTree)optionsNode.getChild(i);
            if (!"virtual".equalsIgnoreCase(optionNode.getText())) continue;
            return true;
        }
        return false;
    }

    private RuleReturnScope parseTable(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return parser.schema_create_table_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private ParserRuleReturnScope parseIndex(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return parser.create_index_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.db.getMutex().enter();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Tables:\n");
            for (ISqlJetTableDef tableDef : this.tableDefs.values()) {
                buffer.append(tableDef.toString());
                buffer.append('\n');
            }
            buffer.append("Indexes:\n");
            for (ISqlJetIndexDef indexDef : this.indexDefs.values()) {
                buffer.append(indexDef.toString());
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef createTable(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.createTableSafe(sql);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTableDef createTableSafe(String sql) throws SqlJetException {
        RuleReturnScope parseTable = this.parseTable(sql);
        CommonTree ast = (CommonTree)parseTable.getTree();
        if (this.isCreateVirtualTable(ast)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetTableDef tableDef = new SqlJetTableDef(ast, 0);
        if (null == tableDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = tableDef.getName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.tableDefs.containsKey(tableName)) {
            if (tableDef.isKeepExisting()) {
                return this.tableDefs.get(tableName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table \"" + tableName + "\" exists already");
        }
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        if (null == columns || 0 == columns.size()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String createTableSql = this.getCreateTableSql(parseTable);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetTableDef sqlJetTableDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_TABLE_FLAGS);
                long rowId = schemaTable.insertRecord(TABLE_TYPE, tableName, tableName, page, createTableSql);
                this.addConstraints(schemaTable, tableDef);
                tableDef.setPage(page);
                tableDef.setRowId(rowId);
                this.tableDefs.put(tableName, tableDef);
                sqlJetTableDef = tableDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetTableDef;
        }
        finally {
            schemaTable.close();
        }
    }

    private String getCreateTableSql(RuleReturnScope parseTable) {
        return String.format("CREATE TABLE %s", this.getCoreSQL(parseTable));
    }

    private String getCreateIndexSql(RuleReturnScope parseIndex) {
        return String.format("CREATE INDEX %s", this.getCoreSQL(parseIndex));
    }

    private String getCreateVirtualTableSql(RuleReturnScope parseTable) {
        return String.format("CREATE VIRTUAL TABLE %s", this.getCoreSQL(parseTable));
    }

    private String getCoreSQL(RuleReturnScope parsedSQL) {
        CommonTree ast = (CommonTree)parsedSQL.getTree();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(1)).getToken();
        CharStream inputStream = nameToken.getInputStream();
        CommonToken stopToken = (CommonToken)parsedSQL.getStop();
        return inputStream.substring(nameToken.getStartIndex(), stopToken.getStopIndex());
    }

    private String generateAutoIndexName(String tableName, int i) {
        return String.format(AUTOINDEX, tableName, i);
    }

    private void addConstraints(ISqlJetBtreeSchemaTable schemaTable, SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName();
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        int i = 0;
        for (ISqlJetColumnDef column : columns) {
            List<ISqlJetColumnConstraint> constraints = column.getConstraints();
            if (null == constraints) continue;
            for (ISqlJetColumnConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetColumnPrimaryKey) {
                    ISqlJetColumnPrimaryKey pk = (ISqlJetColumnPrimaryKey)constraint;
                    if (!column.hasExactlyIntegerType()) {
                        if (pk.isAutoincremented()) {
                            throw new SqlJetException(SqlJetErrorCode.ERROR, "AUTOINCREMENT is allowed only for INTEGER PRIMARY KEY fields");
                        }
                        this.createAutoIndex(schemaTable, tableName, this.generateAutoIndexName(tableName, ++i));
                        continue;
                    }
                    if (!pk.isAutoincremented()) continue;
                    this.checkSequenceTable();
                    continue;
                }
                if (!(constraint instanceof ISqlJetColumnUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, this.generateAutoIndexName(tableName, ++i));
            }
        }
        List<ISqlJetTableConstraint> constraints = tableDef.getConstraints();
        if (null != constraints) {
            for (ISqlJetTableConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetTablePrimaryKey) {
                    boolean b = false;
                    ISqlJetTablePrimaryKey pk = (ISqlJetTablePrimaryKey)constraint;
                    if (pk.getColumns().size() == 1) {
                        String n = pk.getColumns().get(0);
                        ISqlJetColumnDef c = tableDef.getColumn(n);
                        boolean bl = b = c != null && c.hasExactlyIntegerType();
                    }
                    if (b) continue;
                    this.createAutoIndex(schemaTable, tableName, this.generateAutoIndexName(tableName, ++i));
                    continue;
                }
                if (!(constraint instanceof ISqlJetTableUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, this.generateAutoIndexName(tableName, ++i));
            }
        }
    }

    private void checkSequenceTable() throws SqlJetException {
        if (!this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            this.createTableSafe(CREATE_TABLE_SQLITE_SEQUENCE);
        }
    }

    public ISqlJetBtreeDataTable openSequenceTable() throws SqlJetException {
        if (this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            return new SqlJetBtreeDataTable(this.btree, SQLITE_SEQUENCE, true);
        }
        return null;
    }

    private void createAutoIndex(ISqlJetBtreeSchemaTable schemaTable, String tableName, String autoIndexName) throws SqlJetException {
        int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(autoIndexName, tableName, page);
        indexDef.setRowId(schemaTable.insertRecord(INDEX_TYPE, autoIndexName, tableName, page, null));
        this.indexDefs.put(autoIndexName, indexDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef createIndex(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexSafe(sql);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetIndexDef createIndexSafe(String sql) throws SqlJetException {
        ParserRuleReturnScope parseIndex = this.parseIndex(sql);
        CommonTree ast = (CommonTree)parseIndex.getTree();
        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, 0);
        if (null == indexDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String indexName = indexDef.getName();
        if ("".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.indexDefs.containsKey(indexName)) {
            if (indexDef.isKeepExisting()) {
                return this.indexDefs.get(indexName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + indexName + "\" exists already");
        }
        if (null == indexDef.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = indexDef.getTableName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        List<ISqlJetIndexedColumn> columns = indexDef.getColumns();
        if (null == columns) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetTableDef tableDef = this.getTable(tableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        for (ISqlJetIndexedColumn column : columns) {
            if (null == column.getName()) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            String columnName = column.getName();
            if ("".equals(columnName)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            if (null != tableDef.getColumn(columnName)) continue;
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Column \"" + columnName + "\" not found in table \"" + tableName + "\"");
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        String createIndexSQL = this.getCreateIndexSql((RuleReturnScope)parseIndex);
        try {
            SqlJetIndexDef sqlJetIndexDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
                long rowId = schemaTable.insertRecord(INDEX_TYPE, indexName, tableName, page, createIndexSQL);
                indexDef.setPage(page);
                indexDef.setRowId(rowId);
                this.indexDefs.put(indexName, indexDef);
                SqlJetBtreeIndexTable indexTable = new SqlJetBtreeIndexTable(this.btree, indexDef.getName(), true);
                try {
                    indexTable.reindex(this);
                }
                finally {
                    indexTable.close();
                }
                sqlJetIndexDef = indexDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetIndexDef;
        }
        finally {
            schemaTable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropTableSafe(tableName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableSafe(String tableName) throws SqlJetException {
        if (null == tableName || "".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name must be not empty");
        }
        if (!this.tableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table not found: " + tableName);
        }
        SqlJetTableDef tableDef = (SqlJetTableDef)this.tableDefs.get(tableName);
        this.dropTableIndexes(tableDef);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!schemaTable.goToRow(tableDef.getRowId()) || !TABLE_TYPE.equals(schemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String n = schemaTable.getNameField();
                if (null == n || !tableName.equals(n)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = tableDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved != 0) {
            this.movePage(page, moved);
        }
        this.tableDefs.remove(tableName);
    }

    private void dropTableIndexes(SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName();
        Iterator<Map.Entry<String, ISqlJetIndexDef>> iterator = this.indexDefs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ISqlJetIndexDef> indexDefEntry = iterator.next();
            String indexName = indexDefEntry.getKey();
            ISqlJetIndexDef indexDef = indexDefEntry.getValue();
            if (!indexDef.getTableName().equals(tableName) || !this.doDropIndex(indexName, true, false)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDropIndex(String indexName, boolean allowAutoIndex, boolean throwIfFial) throws SqlJetException {
        if (!this.indexDefs.containsKey(indexName)) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        SqlJetBaseIndexDef indexDef = (SqlJetBaseIndexDef)this.indexDefs.get(indexName);
        if (!allowAutoIndex && indexDef.isImplicit()) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                if (!schemaTable.goToRow(indexDef.getRowId()) || !INDEX_TYPE.equals(schemaTable.getTypeField())) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                String n = schemaTable.getNameField();
                if (null == n || !indexName.equals(n)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!allowAutoIndex && schemaTable.isNull(4)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
                    }
                    boolean bl = false;
                    return bl;
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = indexDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved == 0) return true;
        this.movePage(page, moved);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePage(int page, int moved) throws SqlJetException {
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                schemaTable.first();
                while (true) {
                    if (!schemaTable.eof()) {
                        long pageField = schemaTable.getPageField();
                        if (pageField == (long)moved) {
                            String nameField = schemaTable.getNameField();
                            schemaTable.updateRecord(schemaTable.getRowId(), schemaTable.getTypeField(), nameField, schemaTable.getTableField(), page, schemaTable.getSqlField());
                            ISqlJetIndexDef index = this.getIndex(nameField);
                            if (index != null) {
                                if (index instanceof SqlJetBaseIndexDef) {
                                    ((SqlJetBaseIndexDef)index).setPage(page);
                                }
                            } else {
                                ISqlJetTableDef table = this.getTable(nameField);
                                if (table != null && table instanceof SqlJetTableDef) {
                                    ((SqlJetTableDef)table).setPage(page);
                                }
                            }
                            return;
                        }
                        schemaTable.next();
                        continue;
                    }
                    break;
                }
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String indexName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropIndexSafe(indexName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void dropIndexSafe(String indexName) throws SqlJetException {
        if (null == indexName || "".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index name must be not empty");
        }
        if (!this.indexDefs.containsKey(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + indexName);
        }
        if (this.doDropIndex(indexName, false, true)) {
            this.db.getOptions().changeSchemaVersion();
            this.indexDefs.remove(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTableDef alterTableSafe(SqlJetAlterTableDef alterTableDef) throws SqlJetException {
        assert (null != alterTableDef);
        String tableName = alterTableDef.getTableName();
        String newTableName = alterTableDef.getNewTableName();
        ISqlJetColumnDef newColumnDef = alterTableDef.getNewColumnDef();
        if (null == tableName) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name isn't defined");
        }
        if (null == newTableName && null == newColumnDef) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Not defined any altering");
        }
        boolean renameTable = false;
        if (null != newTableName) {
            renameTable = true;
        } else {
            newTableName = tableName;
        }
        if (renameTable && this.tableDefs.containsKey(newTableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" already exists", newTableName));
        }
        SqlJetTableDef tableDef = (SqlJetTableDef)this.tableDefs.get(tableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" not found", tableName));
        }
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        if (null != newColumnDef) {
            String fieldName = newColumnDef.getName();
            if (tableDef.getColumn(fieldName) != null) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Field \"%s\" already exists in table \"%s\"", fieldName, tableName));
            }
            List<ISqlJetColumnConstraint> constraints = newColumnDef.getConstraints();
            if (null != constraints && 0 != constraints.size()) {
                boolean notNull = false;
                boolean defaultValue = false;
                for (ISqlJetColumnConstraint constraint : constraints) {
                    if (constraint instanceof ISqlJetColumnNotNull) {
                        notNull = true;
                        continue;
                    }
                    if (constraint instanceof ISqlJetColumnDefault) {
                        defaultValue = true;
                        continue;
                    }
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Invalid constraint: %s", constraint.toString()));
                }
                if (notNull && !defaultValue) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "NOT NULL requires to have DEFAULT value");
                }
            }
            columns = new ArrayList<ISqlJetColumnDef>(columns);
            columns.add(newColumnDef);
        }
        int page = tableDef.getPage();
        long rowId = tableDef.getRowId();
        SqlJetTableDef alterDef = new SqlJetTableDef(newTableName, null, tableDef.isTemporary(), false, columns, tableDef.getConstraints(), page, rowId);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetTableDef sqlJetTableDef;
            schemaTable.lock();
            try {
                if (!schemaTable.goToRow(rowId)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String typeField = schemaTable.getTypeField();
                String nameField = schemaTable.getNameField();
                String tableField = schemaTable.getTableField();
                int pageField = schemaTable.getPageField();
                if (null == typeField || !TABLE_TYPE.equals(typeField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == nameField || !tableName.equals(nameField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == tableField || !tableName.equals(tableField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == pageField || pageField != page) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String alteredSql = this.getTableAlteredSql(schemaTable.getSqlField(), alterTableDef);
                this.db.getOptions().changeSchemaVersion();
                schemaTable.insertRecord(TABLE_TYPE, newTableName, newTableName, page, alteredSql);
                if (renameTable && !tableName.equals(newTableName)) {
                    this.renameTablesIndices(schemaTable, tableName, newTableName, this.getAlterTableName(alterTableDef));
                }
                this.tableDefs.remove(tableName);
                this.tableDefs.put(newTableName, alterDef);
                sqlJetTableDef = alterDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetTableDef;
        }
        finally {
            schemaTable.close();
        }
    }

    private String getAlterTableName(SqlJetAlterTableDef alterTableDef) {
        ParserRuleReturnScope parsedSql = alterTableDef.getParsedSql();
        CommonTree ast = (CommonTree)parsedSql.getTree();
        CommonToken stopToken = (CommonToken)parsedSql.getStop();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(ast.getChildCount() - 1)).getToken();
        CharStream inputStream = nameToken.getInputStream();
        return inputStream.substring(nameToken.getStartIndex(), stopToken.getStopIndex());
    }

    private String getTableAlteredSql(String sql, SqlJetAlterTableDef alterTableDef) throws SqlJetException {
        RuleReturnScope parsedSQL = this.parseTable(sql);
        CommonTree ast = (CommonTree)parsedSQL.getTree();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(1)).getToken();
        CharStream inputStream = nameToken.getInputStream();
        CommonToken stopToken = (CommonToken)parsedSQL.getStop();
        StringBuilder b = new StringBuilder();
        if (alterTableDef.getNewTableName() != null) {
            b.append(inputStream.substring(0, nameToken.getStartIndex() - 1));
            b.append(this.getAlterTableName(alterTableDef));
            b.append(inputStream.substring(nameToken.getStopIndex() + 1, stopToken.getStopIndex()));
        } else if (alterTableDef.getNewColumnDef() != null) {
            b.append(inputStream.substring(0, stopToken.getStartIndex() - 1));
            b.append(",").append(this.getAlterTableName(alterTableDef));
            b.append(inputStream.substring(stopToken.getStartIndex(), stopToken.getStopIndex()));
        } else {
            throw new SqlJetException("Wrong ALTER TABLE statement");
        }
        return b.toString();
    }

    private void renameTablesIndices(ISqlJetBtreeSchemaTable schemaTable, String tableName, String newTableName, String alterTableName) throws SqlJetException {
        Set<ISqlJetIndexDef> indexes = this.getIndexes(tableName);
        if (null == indexes || 0 == indexes.size()) {
            return;
        }
        int i = 0;
        for (ISqlJetIndexDef index : indexes) {
            if (index instanceof SqlJetBaseIndexDef) {
                SqlJetBaseIndexDef indexDef = (SqlJetBaseIndexDef)index;
                String indexName = indexDef.getName();
                long rowId = indexDef.getRowId();
                int page = indexDef.getPage();
                if (!schemaTable.goToRow(rowId)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String typeField = schemaTable.getTypeField();
                String nameField = schemaTable.getNameField();
                String tableField = schemaTable.getTableField();
                int pageField = schemaTable.getPageField();
                if (null == typeField || !INDEX_TYPE.equals(typeField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == nameField || !indexName.equals(nameField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == tableField || !tableName.equals(tableField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == pageField || pageField != page) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                indexDef.setTableName(newTableName);
                String newIndexName = indexName;
                String alteredIndexSql = null;
                if (index.isImplicit()) {
                    newIndexName = this.generateAutoIndexName(tableName, ++i);
                    indexDef.setName(newIndexName);
                    this.indexDefs.remove(indexName);
                    this.indexDefs.put(newIndexName, indexDef);
                } else {
                    alteredIndexSql = this.getAlteredIndexSql(schemaTable.getSqlField(), alterTableName);
                }
                schemaTable.insertRecord(INDEX_TYPE, newIndexName, newTableName, page, alteredIndexSql);
                continue;
            }
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
    }

    private String getAlteredIndexSql(String sql, String alterTableName) throws SqlJetException {
        ParserRuleReturnScope parsedSQL = this.parseIndex(sql);
        CommonTree ast = (CommonTree)parsedSQL.getTree();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(2)).getToken();
        CharStream inputStream = nameToken.getInputStream();
        CommonToken stopToken = (CommonToken)parsedSQL.getStop();
        StringBuilder b = new StringBuilder();
        b.append(inputStream.substring(0, nameToken.getStartIndex() - 1));
        b.append(alterTableName);
        b.append(inputStream.substring(nameToken.getStopIndex() + 1, stopToken.getStopIndex()));
        return b.toString();
    }

    private ParserRuleReturnScope parseSqlStatement(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return parser.sql_stmt_itself();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef alterTable(String sql) throws SqlJetException {
        SqlJetAlterTableDef alterTableDef = new SqlJetAlterTableDef(this.parseSqlStatement(sql));
        if (null == alterTableDef) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.alterTableSafe(alterTableDef);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetVirtualTableDef createVirtualTable(String sql, int page) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.createVirtualTableSafe(sql, page);
            return iSqlJetVirtualTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetVirtualTableDef createVirtualTableSafe(String sql, int page) throws SqlJetException {
        RuleReturnScope parseTable = this.parseTable(sql);
        CommonTree ast = (CommonTree)parseTable.getTree();
        if (!this.isCreateVirtualTable(ast)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetVirtualTableDef tableDef = new SqlJetVirtualTableDef(ast, 0);
        if (null == tableDef.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = tableDef.getTableName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.virtualTableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Virtual table \"" + tableName + "\" exists already");
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        String createVirtualTableSQL = this.getCreateVirtualTableSql(parseTable);
        try {
            SqlJetVirtualTableDef sqlJetVirtualTableDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long rowId = schemaTable.insertRecord(TABLE_TYPE, tableName, tableName, page, createVirtualTableSQL);
                tableDef.setPage(page);
                tableDef.setRowId(rowId);
                this.virtualTableDefs.put(tableName, tableDef);
                sqlJetVirtualTableDef = tableDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetVirtualTableDef;
        }
        finally {
            schemaTable.close();
        }
    }
}

